/*
 * Decompiled with CFR 0.152.
 */
package android.support.v7.widget;

import android.content.Context;
import android.os.Build;
import android.util.AttributeSet;
import android.view.View;

abstract class ViewGroup
extends android.view.ViewGroup {
    protected static final int MEASURED_STATE_TOO_SMALL = 0x1000000;
    protected static final int MEASURED_STATE_MASK = -16777216;

    public ViewGroup(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
    }

    public static int resolveSizeAndState(int size, int measureSpec, int childMeasuredState) {
        if (Build.VERSION.SDK_INT >= 11) {
            return View.resolveSizeAndState((int)size, (int)measureSpec, (int)childMeasuredState);
        }
        int result = size;
        int specMode = View.MeasureSpec.getMode((int)measureSpec);
        int specSize = View.MeasureSpec.getSize((int)measureSpec);
        switch (specMode) {
            case 0: {
                result = size;
                break;
            }
            case -2147483648: {
                if (specSize < size) {
                    result = specSize | 0x1000000;
                    break;
                }
                result = size;
                break;
            }
            case 0x40000000: {
                result = specSize;
            }
        }
        return result | childMeasuredState & 0xFF000000;
    }

    protected static boolean isLayoutRtl(View view) {
        return false;
    }
}

