/*
    This file is part of SUPPL - the supplemental library for DOS
    Copyright (C) 1996-2000 Steffen Kaiser

    This library is free software; you can redistribute it and/or
    modify it under the terms of the GNU Library General Public
    License as published by the Free Software Foundation; either
    version 2 of the License, or (at your option) any later version.

    This library is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
    Library General Public License for more details.

    You should have received a copy of the GNU Library General Public
    License along with this library; if not, write to the Free
    Software Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
*/
/* $RCSfile: CFGIVB.C $
   $Locker: ska $	$Name:  $	$State: Exp $

	int cfgValBoolean(const char * const name, int dflt);

	Return the data of the value of the specified name parsed as boolean.
	If name == NULL, the currently scanned value is processed.

	Return:
		dflt: on error
		else: the parsed value

ob: cfgValBoolean
su: inifile/2
sh: Return a value as boolean
lo: Return the data of the specified value parsed as boolean.\par
	If \para{name} == NULL, the current value is processed.
va: dflt: on error
	\item else: parsed value
re: cfgValInteger
fi: cfgivb.c
in:

*/

#include "initsupl.loc"

#ifndef _MICROC_
#endif
#include "inifile.loc"
#include "str.h"

#include "suppldbg.h"

#ifdef RCS_Version
static char const rcsid[] = 
	"$Id: CFGIVB.C 1.4 2001/02/27 01:27:46 ska Exp ska $";
#endif

int cfgValBoolean(const char * const name, int const dflt)
{	int num;

	DBG_ENTER("cfgValBoolean", Suppl_inifile2)
	DBG_ARGUMENTS( ("name=\"%s\", dflt=%d", name, dflt) )

	chkHeap
	if(cfgi_parseVal(name) == 0)
		switch(strbool(I(data))) {
		case 0:	DBG_RETURN_I( 0)		/* false */
		case 1:	DBG_RETURN_I( 1)		/* true */
		case -2:	/* single word, but no known */
			/* try a number */
			if(strnum(I(data), &num, 0) == 0)	/* success */
				DBG_RETURN_I( !!num)
		}

	chkHeap
	DBG_RETURN_I( dflt)
}
