/*
 * Decompiled with CFR 0.152.
 */
package oracle.net.ns;

import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import oracle.net.jdbc.nl.NLException;
import oracle.net.jdbc.nl.NVFactory;
import oracle.net.jdbc.nl.NVNavigator;
import oracle.net.jdbc.nl.NVPair;
import oracle.net.ns.AcceptPacket;
import oracle.net.ns.ConnectPacket;
import oracle.net.ns.DataPacket;
import oracle.net.ns.MarkerPacket;
import oracle.net.ns.NSProtocol;
import oracle.net.ns.NetException;
import oracle.net.ns.NetInputStream;
import oracle.net.ns.NetOutputStream;
import oracle.net.ns.Packet;
import oracle.net.ns.RedirectPacket;
import oracle.net.ns.RefusePacket;
import oracle.net.ns.SessionAtts;
import oracle.net.nt.ConnOption;

public class NSProtocolStream
extends NSProtocol {
    private MarkerPacket mkPkt;
    private DataPacket probePacket;
    private Packet packet;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Thu_Apr_04_15:06:58_PDT_2013";
    public static final boolean TRACE = false;

    public NSProtocolStream() {
        this.sAtts = new SessionAtts(this, 0x200000, 0x200000, false, false);
        this.sAtts.connected = false;
    }

    @Override
    void negotiateConnection(NVFactory nVFactory, NVNavigator nVNavigator, boolean bl, boolean bl2) throws IOException, NetException {
        RefusePacket refusePacket;
        RedirectPacket redirectPacket;
        AcceptPacket acceptPacket;
        ConnectPacket connectPacket;
        NVPair nVPair = null;
        String string = null;
        block11: while (true) {
            IOException iOException = null;
            connectPacket = new ConnectPacket(this.sAtts, !bl, bl2);
            this.packet = new Packet(this.sAtts, this.sAtts.getSDU());
            try {
                connectPacket.send();
                this.packet.receive();
            }
            catch (InterruptedIOException interruptedIOException) {
                throw interruptedIOException;
            }
            catch (IOException iOException2) {
                this.packet.type = 4;
                iOException = iOException2;
            }
            switch (this.packet.type) {
                case 2: {
                    acceptPacket = new AcceptPacket(this.packet);
                    break block11;
                }
                case 5: {
                    String string2;
                    redirectPacket = new RedirectPacket(this.packet);
                    ConnOption connOption = this.sAtts.cOption;
                    this.addrRes.connection_redirected = true;
                    this.sAtts.cOption.nt.disconnect();
                    String string3 = string2 = redirectPacket.getData();
                    String string4 = null;
                    if ((redirectPacket.flags & 2) == 2 && string2.indexOf(0) != -1) {
                        string3 = string2.substring(0, string2.indexOf(0));
                        this.sAtts.redirecting = true;
                        string4 = string2.substring(string2.indexOf(0) + 1, string2.length());
                    }
                    this.sAtts = this.establishConnection(string3);
                    this.sAtts.cOption.restoreFromOrigCoption(connOption);
                    if (!this.sAtts.redirecting) continue block11;
                    this.sAtts.cOption.conn_data.setLength(0);
                    this.sAtts.cOption.conn_data.append(string4);
                    break;
                }
                case 4: {
                    refusePacket = new RefusePacket(this.packet);
                    this.sAtts.cOption.nt.disconnect();
                    this.sAtts.cOption = null;
                    this.establishConnection(null);
                    if (this.sAtts.cOption != null) continue block11;
                    if (iOException != null) {
                        throw iOException;
                    }
                    try {
                        NVPair nVPair2;
                        nVPair = nVNavigator.findNVPairRecurse(nVFactory.createNVPair(refusePacket.getData()), "ERROR");
                        if (nVPair != null && (nVPair2 = nVNavigator.findNVPairRecurse(nVPair, "CODE")) != null) {
                            string = nVPair2.valueToString();
                        }
                    }
                    catch (NLException nLException) {
                        System.err.println(nLException.getMessage());
                    }
                    throw new NetException(string == null ? 206 : Integer.parseInt(string), "");
                }
                case 11: {
                    if ((this.packet.flags & 8) != 8) continue block11;
                    this.sAtts.renegotiateSSLSession();
                    break;
                }
                default: {
                    this.sAtts.cOption.nt.disconnect();
                    throw new NetException(205);
                }
            }
        }
        this.setNetStreams();
        this.packet = null;
        connectPacket = null;
        acceptPacket = null;
        redirectPacket = null;
        refusePacket = null;
    }

    @Override
    public void writeZeroCopyIO(byte[] byArray, int n2, int n3) throws IOException, NetException {
        NetOutputStream netOutputStream = this.getNetOutputStream();
        netOutputStream.writeZeroCopyIO(byArray, n2, n3);
    }

    @Override
    public boolean readZeroCopyIO(byte[] byArray, int n2, int[] nArray) throws IOException, NetException {
        NetInputStream netInputStream = this.getNetInputStream();
        boolean bl = netInputStream.readZeroCopyIO(byArray, n2, nArray);
        return bl;
    }

    @Override
    public void disconnect() throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        IOException iOException = null;
        try {
            this.sAtts.nsOutputStream.close();
        }
        catch (IOException iOException2) {
            iOException = iOException2;
        }
        this.sAtts.connected = false;
        this.sAtts.cOption.nt.disconnect();
        if (iOException != null) {
            throw iOException;
        }
    }

    @Override
    public void sendReset() throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        this.sendMarker(2);
        while (this.sAtts.onBreakReset) {
            Packet packet = ((NetInputStream)this.sAtts.getInputStream()).getCurrentPacket();
            packet.receive();
            if (packet.type != 12) continue;
            this.mkPkt = new MarkerPacket(packet);
            if (this.mkPkt.data != 2) continue;
            this.sAtts.onBreakReset = false;
        }
        this.mkPkt = null;
    }

    @Override
    public NetInputStream getNetInputStream() throws NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        return this.sAtts.nsInputStream;
    }

    @Override
    public InputStream getInputStream() throws NetException {
        return this.getNetInputStream();
    }

    @Override
    public NetOutputStream getNetOutputStream() throws NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        return this.sAtts.nsOutputStream;
    }

    @Override
    public OutputStream getOutputStream() throws NetException {
        return this.getNetOutputStream();
    }

    @Override
    void initializeSessionAttributes() throws NetException, IOException {
        this.sAtts.ntInputStream = this.sAtts.cOption.nt.getInputStream();
        this.sAtts.ntOutputStream = this.sAtts.cOption.nt.getOutputStream();
        this.sAtts.dataEOF = false;
        if (this.sAtts.attemptingReconnect) {
            this.sAtts.nsOutputStream.reinitialize(this.sAtts);
            this.sAtts.nsInputStream.reinitialize(this.sAtts);
            if (this.mkPkt != null) {
                this.mkPkt.reinitialize(this.sAtts);
            }
        } else {
            this.sAtts.nsOutputStream = new NetOutputStream(this.sAtts, 255);
            this.sAtts.nsInputStream = new NetInputStream(this.sAtts);
        }
    }

    private void setNetStreams() throws NetException, IOException {
        this.sAtts.nsOutputStream = new NetOutputStream(this.sAtts);
        this.sAtts.nsInputStream = new NetInputStream(this.sAtts);
    }

    @Override
    protected void sendMarker(int n2) throws IOException, NetException {
        if (!this.sAtts.connected) {
            throw new NetException(200);
        }
        this.mkPkt = new MarkerPacket(this.sAtts, n2);
        this.mkPkt.send();
        this.mkPkt = null;
    }

    @Override
    void sendProbePacket() throws IOException {
        if (this.probePacket == null) {
            this.probePacket = new DataPacket(this.sAtts, 26);
        } else {
            this.probePacket.reinitialize(this.sAtts);
        }
        this.probePacket.send();
    }
}

