/*
 * Decompiled with CFR 0.152.
 */
package edu.harvard.hul.ois.jhove.module.jpeg2000;

import edu.harvard.hul.ois.jhove.ErrorMessage;
import edu.harvard.hul.ois.jhove.Message;
import edu.harvard.hul.ois.jhove.ModuleBase;
import edu.harvard.hul.ois.jhove.Property;
import edu.harvard.hul.ois.jhove.PropertyArity;
import edu.harvard.hul.ois.jhove.PropertyType;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MainOrTile;
import edu.harvard.hul.ois.jhove.module.jpeg2000.MarkerSegment;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.ArrayList;

public class QCDMarkerSegment
extends MarkerSegment {
    @Override
    protected boolean process(int n) throws IOException {
        int[] nArray;
        int n2 = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module);
        int n3 = n2 & 0x1F;
        switch (n3) {
            case 0: {
                int n4;
                int n5 = n - 1;
                nArray = new int[n5];
                for (n4 = 0; n4 < n5; ++n4) {
                    nArray[n4] = ModuleBase.readUnsignedByte((DataInputStream)this._dstream, (ModuleBase)this._module);
                }
                break;
            }
            case 1: 
            case 2: {
                int n4;
                int n6 = (n - 1) / 2;
                nArray = new int[n6];
                for (n4 = 0; n4 < n6; ++n4) {
                    nArray[n4] = this._module.readUnsignedShort(this._dstream);
                }
                break;
            }
            default: {
                this._repInfo.setMessage((Message)new ErrorMessage("Unrecognized quantization type in QCD marker segment"));
                return false;
            }
        }
        ArrayList<Property> arrayList = new ArrayList<Property>(2);
        arrayList.add(new Property("QuantizationStyle", PropertyType.INTEGER, (Object)new Integer(n2)));
        arrayList.add(new Property("StepValue", PropertyType.INTEGER, PropertyArity.ARRAY, (Object)nArray));
        MainOrTile mainOrTile = this.getMainOrTile();
        mainOrTile.setQCDProperty(new Property("QuantizationDefault", PropertyType.PROPERTY, PropertyArity.LIST, arrayList));
        return true;
    }
}

