/*###############################################################################
# Linux Management Providers (LMP), OpenDRIM_RecordLogPackage provider package
# Copyright (C) 2007 Ilsoo Byun, ETRI <widepis@etri.re.kr, widepis@empal.com>
# 
# This program is being developed under the "OpenDRIM" project.
# The "OpenDRIM" project web page: http://opendrim.sourceforge.net
# The "OpenDRIM" project mailing list: opendrim@googlegroups.com
# 
# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation; version 2
# of the License.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#################################################################################

#################################################################################
# To contributors, please leave your contact information in this section
# AND comment your changes in the source code.
# 
# Modified by 2008 Guillaume BOTTEX, ETRI <guillaumebottex@etri.re.kr, guillaumebottex@gmail.com>
###############################################################################*/

#ifndef OPENDRIM_LOGENTRY_H_
#define OPENDRIM_LOGENTRY_H_

#include <Instance.h>

const static char* OpenDRIM_LogEntry_classnames[] = {"OpenDRIM_LogEntry"};
static string OpenDRIM_LogEntry_NAMESPACE = _NAMESPACE;

class OpenDRIM_LogEntry {

public:
	
	string Caption;
	bool Caption_isNULL;
	
	string Description;
	bool Description_isNULL;
	
	string ElementName;
	bool ElementName_isNULL;
	
	string RecordFormat;
	bool RecordFormat_isNULL;
	
	string RecordData;
	bool RecordData_isNULL;
	
	string Locale;
	bool Locale_isNULL;
	
	string InstanceID;
	bool InstanceID_isNULL;
	
	string LogInstanceID;
	bool LogInstanceID_isNULL;
	
	string LogName;
	bool LogName_isNULL;
	
	string RecordID;
	bool RecordID_isNULL;
	
	string CreationTimeStamp;
	bool CreationTimeStamp_isNULL;
	
	OpenDRIM_LogEntry() {
		Caption_isNULL = true;
		Description_isNULL = true;
		ElementName_isNULL = true;
		RecordFormat_isNULL = true;
		RecordData_isNULL = true;
		Locale_isNULL = true;
		InstanceID_isNULL = true;
		LogInstanceID_isNULL = true;
		LogName_isNULL = true;
		RecordID_isNULL = true;
		CreationTimeStamp_isNULL = true;
	}
	
	~OpenDRIM_LogEntry() {}
	
	string getKeys() const {
		return CF_toLowCase(".InstanceID=\"" + CF_quoteString(InstanceID) + "\"");
	}

	int getCaption(string& value) const {
		if (Caption_isNULL==true)
			return NOT_FOUND;
		value = Caption;
		return OK;
	}
	
	int setCaption(const string& newValue) {
		Caption = newValue;
		Caption_isNULL = false;
		return OK;
	}

	int getDescription(string& value) const {
		if (Description_isNULL==true)
			return NOT_FOUND;
		value = Description;
		return OK;
	}
	
	int setDescription(const string& newValue) {
		Description = newValue;
		Description_isNULL = false;
		return OK;
	}

	int getElementName(string& value) const {
		if (ElementName_isNULL==true)
			return NOT_FOUND;
		value = ElementName;
		return OK;
	}
	
	int setElementName(const string& newValue) {
		ElementName = newValue;
		ElementName_isNULL = false;
		return OK;
	}

	int getRecordFormat(string& value) const {
		if (RecordFormat_isNULL==true)
			return NOT_FOUND;
		value = RecordFormat;
		return OK;
	}
	
	int setRecordFormat(const string& newValue) {
		RecordFormat = newValue;
		RecordFormat_isNULL = false;
		return OK;
	}

	int getRecordData(string& value) const {
		if (RecordData_isNULL==true)
			return NOT_FOUND;
		value = RecordData;
		return OK;
	}
	
	int setRecordData(const string& newValue) {
		RecordData = newValue;
		RecordData_isNULL = false;
		return OK;
	}

	int getLocale(string& value) const {
		if (Locale_isNULL==true)
			return NOT_FOUND;
		value = Locale;
		return OK;
	}
	
	int setLocale(const string& newValue) {
		Locale = newValue;
		Locale_isNULL = false;
		return OK;
	}

	int getInstanceID(string& value) const {
		if (InstanceID_isNULL==true)
			return NOT_FOUND;
		value = InstanceID;
		return OK;
	}
	
	int setInstanceID(const string& newValue) {
		InstanceID = newValue;
		InstanceID_isNULL = false;
		return OK;
	}

	int getLogInstanceID(string& value) const {
		if (LogInstanceID_isNULL==true)
			return NOT_FOUND;
		value = LogInstanceID;
		return OK;
	}
	
	int setLogInstanceID(const string& newValue) {
		LogInstanceID = newValue;
		LogInstanceID_isNULL = false;
		return OK;
	}

	int getLogName(string& value) const {
		if (LogName_isNULL==true)
			return NOT_FOUND;
		value = LogName;
		return OK;
	}
	
	int setLogName(const string& newValue) {
		LogName = newValue;
		LogName_isNULL = false;
		return OK;
	}

	int getRecordID(string& value) const {
		if (RecordID_isNULL==true)
			return NOT_FOUND;
		value = RecordID;
		return OK;
	}
	
	int setRecordID(const string& newValue) {
		RecordID = newValue;
		RecordID_isNULL = false;
		return OK;
	}

	int getCreationTimeStamp(string& value) const {
		if (CreationTimeStamp_isNULL==true)
			return NOT_FOUND;
		value = CreationTimeStamp;
		return OK;
	}
	
	int setCreationTimeStamp(const string& newValue) {
		CreationTimeStamp = newValue;
		CreationTimeStamp_isNULL = false;
		return OK;
	}

};

#endif /*OPENDRIM_LOGENTRY_H_*/
