#!/bin/sh
set -o nounset

oneTimeSetUp() {
	# Load the ./play.it library
	. lib/libplayit2.sh
}

# Prevent missing winetricks wrapper inclusion in Unreal Engine 4 WINE launchers.
test_unrealengine4_winetricks_wrapper() {
	## Override the function returning a default list of winetricks verbs,
	## so only the non-default Direct3D rendering would require the winetricks wrapper.
	unrealengine4_wine_winetricks_verbs_default() { return 0; }
	
	local UNREALENGINE4_NAME='VotV'
	assertTrue \
		'Failed to include the required winetricks wrapper in the generated launcher for an Unreal Engine 4 game.' \
		'wine_launcher APP_MAIN | grep --silent "winetricks_wrapper()"'
}
