/*
 * Decompiled with CFR 0.152.
 */
package org.apache.derby.impl.sql;

import java.io.IOException;
import java.io.ObjectInput;
import java.io.ObjectOutput;
import org.apache.derby.iapi.services.io.Formatable;
import org.apache.derby.iapi.services.io.FormatableHashtable;
import org.apache.derby.iapi.sql.ResultColumnDescriptor;
import org.apache.derby.iapi.types.DataTypeDescriptor;

public final class GenericColumnDescriptor
implements ResultColumnDescriptor,
Formatable {
    private String name;
    private String schemaName;
    private String tableName;
    private int columnPos;
    private DataTypeDescriptor type;
    private boolean isAutoincrement;
    private boolean updatableByCursor;

    public GenericColumnDescriptor() {
    }

    public GenericColumnDescriptor(String string, DataTypeDescriptor dataTypeDescriptor) {
        this.name = string;
        this.type = dataTypeDescriptor;
    }

    public GenericColumnDescriptor(ResultColumnDescriptor resultColumnDescriptor) {
        this.name = resultColumnDescriptor.getName();
        this.tableName = resultColumnDescriptor.getSourceTableName();
        this.schemaName = resultColumnDescriptor.getSourceSchemaName();
        this.columnPos = resultColumnDescriptor.getColumnPosition();
        this.type = resultColumnDescriptor.getType();
        this.isAutoincrement = resultColumnDescriptor.isAutoincrement();
        this.updatableByCursor = resultColumnDescriptor.updatableByCursor();
    }

    public DataTypeDescriptor getType() {
        return this.type;
    }

    public String getName() {
        return this.name;
    }

    public String getSourceSchemaName() {
        return this.schemaName;
    }

    public String getSourceTableName() {
        return this.tableName;
    }

    public int getColumnPosition() {
        return this.columnPos;
    }

    public boolean isAutoincrement() {
        return this.isAutoincrement;
    }

    public boolean updatableByCursor() {
        return this.updatableByCursor;
    }

    public void writeExternal(ObjectOutput objectOutput) throws IOException {
        FormatableHashtable formatableHashtable = new FormatableHashtable();
        formatableHashtable.put("name", this.name);
        formatableHashtable.put("tableName", this.tableName);
        formatableHashtable.put("schemaName", this.schemaName);
        formatableHashtable.putInt("columnPos", this.columnPos);
        formatableHashtable.put("type", this.type);
        formatableHashtable.putBoolean("isAutoincrement", this.isAutoincrement);
        formatableHashtable.putBoolean("updatableByCursor", this.updatableByCursor);
        objectOutput.writeObject(formatableHashtable);
    }

    public void readExternal(ObjectInput objectInput) throws IOException, ClassNotFoundException {
        FormatableHashtable formatableHashtable = (FormatableHashtable)objectInput.readObject();
        this.name = (String)formatableHashtable.get("name");
        this.tableName = (String)formatableHashtable.get("tableName");
        this.schemaName = (String)formatableHashtable.get("schemaName");
        this.columnPos = formatableHashtable.getInt("columnPos");
        this.type = (DataTypeDescriptor)formatableHashtable.get("type");
        this.isAutoincrement = formatableHashtable.getBoolean("isAutoincrement");
        this.updatableByCursor = formatableHashtable.getBoolean("updatableByCursor");
    }

    public int getTypeFormatId() {
        return 383;
    }

    public String toString() {
        return "";
    }
}

