/*
 * Decompiled with CFR 0.152.
 */
package net.sf.saxon.instruct;

import javax.xml.transform.TransformerException;
import net.sf.saxon.Controller;
import net.sf.saxon.expr.Binding;
import net.sf.saxon.expr.XPathContext;
import net.sf.saxon.instruct.Bindery;
import net.sf.saxon.instruct.GeneralVariable;
import net.sf.saxon.instruct.InstructionDetails;
import net.sf.saxon.trace.TraceListener;
import net.sf.saxon.type.AnyItemType;
import net.sf.saxon.value.SequenceType;
import net.sf.saxon.value.Value;
import net.sf.saxon.xpath.XPathException;

public abstract class DefiningVariable
extends GeneralVariable
implements Binding {
    private int slotNumber;
    private SequenceType requiredType;
    private String variableName;
    protected boolean anyTypeAllowed;

    public int getSlotNumber() {
        return this.slotNumber;
    }

    public void setSlotNumber(int n) {
        this.slotNumber = n;
    }

    public SequenceType getRequiredType() {
        return this.requiredType;
    }

    public void setRequiredType(SequenceType sequenceType) {
        this.requiredType = sequenceType;
        this.anyTypeAllowed = sequenceType.getCardinality() == 1792 && sequenceType.getPrimaryType() instanceof AnyItemType;
    }

    public void setVariableName(String string) {
        this.variableName = string;
    }

    public String getVariableName() {
        return this.variableName;
    }

    public Value evaluateVariable(XPathContext xPathContext) throws XPathException {
        Controller controller = xPathContext.getController();
        Bindery bindery = controller.getBindery();
        if (this.isGlobal()) {
            Value value = bindery.evaluateGlobalVariable(this);
            if (value == null) {
                try {
                    bindery.setExecuting(this, true);
                    Object[] objectArray = controller.saveContext();
                    controller.setGlobalContext();
                    if (controller.isTracing()) {
                        TraceListener traceListener = controller.getTraceListener();
                        InstructionDetails instructionDetails = this.getInstructionDetails(controller);
                        traceListener.enter(instructionDetails);
                        this.process(controller.newXPathContext());
                        traceListener.leave(instructionDetails);
                    } else {
                        this.process(controller.newXPathContext());
                    }
                    controller.restoreContext(objectArray);
                    bindery.setExecuting(this, false);
                    value = bindery.evaluateGlobalVariable(this);
                }
                catch (TransformerException transformerException) {
                    if (transformerException instanceof XPathException.Circularity) {
                        throw new XPathException.Dynamic("Circular definition of variable " + this.getVariableName());
                    }
                    if (transformerException instanceof XPathException) {
                        throw (XPathException)transformerException;
                    }
                    throw new XPathException.Dynamic(transformerException);
                }
                if (value == null) {
                    throw new XPathException.Dynamic("Variable " + this.getVariableName() + " is undefined");
                }
            }
            return value;
        }
        return xPathContext.evaluateLocalVariable(this.slotNumber);
    }
}

