/*
 * Decompiled with CFR 0.152.
 */
package serp.bytecode;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import serp.bytecode.ClassInstruction;
import serp.bytecode.Code;
import serp.bytecode.Instruction;
import serp.bytecode.visitor.BCVisitor;

public class MultiANewArrayInstruction
extends ClassInstruction {
    private int _dims = -1;

    MultiANewArrayInstruction(Code owner) {
        super(owner, 197);
    }

    @Override
    int getLength() {
        return super.getLength() + 1;
    }

    @Override
    public int getStackChange() {
        return -this._dims + 1;
    }

    public int getDimensions() {
        return this._dims;
    }

    public MultiANewArrayInstruction setDimensions(int dims) {
        this._dims = dims;
        return this;
    }

    @Override
    public boolean equalsInstruction(Instruction other) {
        if (other == this) {
            return true;
        }
        if (!(other instanceof MultiANewArrayInstruction)) {
            return false;
        }
        if (!super.equalsInstruction(other)) {
            return false;
        }
        MultiANewArrayInstruction ins = (MultiANewArrayInstruction)other;
        int dims = this.getDimensions();
        int otherDims = ins.getDimensions();
        return dims == -1 || otherDims == -1 || dims == otherDims;
    }

    @Override
    public void acceptVisit(BCVisitor visit) {
        visit.enterMultiANewArrayInstruction(this);
        visit.exitMultiANewArrayInstruction(this);
    }

    @Override
    void read(Instruction orig) {
        super.read(orig);
        this._dims = ((MultiANewArrayInstruction)orig).getDimensions();
    }

    @Override
    void read(DataInput in) throws IOException {
        super.read(in);
        this._dims = in.readUnsignedByte();
    }

    @Override
    void write(DataOutput out) throws IOException {
        super.write(out);
        out.writeByte(this._dims);
    }
}

