// This file is part of PUMA.
// Copyright (C) 1999-2003  The PUMA developer team.
//                                                                
// This program is free software;  you can redistribute it and/or 
// modify it under the terms of the GNU General Public License as 
// published by the Free Software Foundation; either version 2 of 
// the License, or (at your option) any later version.            
//                                                                
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of 
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the  
// GNU General Public License for more details.                   
//                                                                
// You should have received a copy of the GNU General Public      
// License along with this program; if not, write to the Free     
// Software Foundation, Inc., 59 Temple Place, Suite 330, Boston, 
// MA  02111-1307  USA                                            

#include "Puma/FileUnit.h"
#include "Puma/ErrorStream.h"
#include "Puma/SysCall.h"
#include "Puma/StrCol.h"
#include "Puma/Project.h"
#include <string.h>
#include <stdlib.h>

namespace Puma {


// File belongs to given project?
bool FileUnit::belongsTo (Project &p) {
  // same project yields same status, of course
  if (_project == &p)
    return _isBelow;
  
  _project = &p;
  _isBelow = p.isBelow (Unit::name ());
  return _isBelow;
}


void FileUnit::setLocation (const char *location) {
  if (_lastLocation) delete[] _lastLocation;
  _lastLocation = StrCol::dup(location);
//  _lastLocation = new char[strlen (location) + 1];
//  strcpy (_lastLocation, location);
}


void FileUnit::name (const char *n) {
  Unit::name (n);
  if (_absolutePath) 
    delete[] _absolutePath;
  _absolutePath = resolvePath (n);
  if (! _absolutePath) 
    _absolutePath = n ? StrCol::dup (n) : (char*)0;
}


char *FileUnit::resolvePath (const char *n) {
  char link_buf[4096];

  char *link = SysCall::readlink (n, link_buf, sizeof (link_buf));
  
  // no link return simple absolute path
  if (! link) return absolutePath (n);
  
  // an absolute link, resolve this file/link again
  if (link[0] == '/') return resolvePath (link);
  
  // relative name, concatenate directory with link and resolve
  char name_buf[4096];
  strcpy (name_buf, n);
  char *delim = strrchr (name_buf, (int)'/');
  if (!delim) {
    strcpy (name_buf, link);
  } else {
    *(delim + 1) = '\0';
    strcat (name_buf, link);
  }
  return resolvePath (name_buf);
}


char* FileUnit::absolutePath (const char* n) {
  if (! n) return (char*) 0;

  Filename result;
  if (!SysCall::canonical (n, result))
    return 0;
    
  return StrCol::dup (result.name ());
  
//  // 1. Remember where we are.
//  char oldcwd_buf[4096];
//  char* oldcwd = SysCall::getcwd (oldcwd_buf, sizeof (oldcwd_buf));
//  if (! oldcwd) return (char*) 0; // Fatal system error!
//
//  // 2. Get the name of the file (without any directory component).
//        char* path = StrCol::dup (n);                
//  char* filename = strrchr (path, '/');
//  if (filename) {
//    char* ptr = filename;
//    filename = StrCol::dup (++filename);
//    *ptr = '\0';
//  } else {
//    filename = StrCol::dup (path);
//    *path = '\0';
//  }
// 
//  // 3. Change to the file's directory.
//  if (strlen (path))
//    if (! SysCall::chdir (path)) { // Error! Corrupted path?
//      delete[] path; 
//      delete[] filename;
//      return (char*) 0;
//    }
//  
//  // 4. Get the absolute path of the 
//  //    current working directory.
//  char cwd_buf[4096];
//  char *cwd = SysCall::getcwd (cwd_buf, sizeof (cwd_buf));
//  if (! cwd) { // Fatal system error!
//    delete[] path; 
//    delete[] filename;
//    return (char*) 0;
//  }
//
//  // 5. Change to the old working directory.
//  SysCall::chdir (oldcwd);
//  
//  // 6. Create the >>absolute<< name.
//  char *name = new char[strlen (cwd) + strlen (filename) + 5];
//  if (cwd[strlen (cwd) - 1] == '/')
//    sprintf (name, "%s%s", cwd, filename);
//  else 
//    sprintf (name, "%s/%s", cwd, filename);
//    
//  delete[] path; 
//  delete[] filename;
//  return name;
}


} // namespace Puma
