//  ************************************************************************************************
//
//  BornAgain: simulate and fit reflection and scattering
//
//! @file      Sample/StandardSamples/MultiLayerWithNCRoughnessBuilder.h
//! @brief     Defines class MultiLayerWithNCRoughnessBuilder.
//!
//! @homepage  http://www.bornagainproject.org
//! @license   GNU General Public License v3 or higher (see COPYING)
//! @copyright Forschungszentrum Jülich GmbH 2018
//! @authors   Scientific Computing Group at MLZ (see CITATION, AUTHORS)
//
//  ************************************************************************************************

#ifdef SWIG
#error no need to expose this header to Swig
#endif // SWIG
#ifndef BORNAGAIN_SAMPLE_STANDARDSAMPLES_MULTILAYERWITHNCROUGHNESSBUILDER_H
#define BORNAGAIN_SAMPLE_STANDARDSAMPLES_MULTILAYERWITHNCROUGHNESSBUILDER_H

class MultiLayer;

#include "Sample/StandardSamples/MultiLayerWithRoughnessBuilder.h"

//! Builds sample: layers with correlated roughness.

namespace ExemplarySamples {

MultiLayer* createMultiLayerWithNCRoughness();

} // namespace ExemplarySamples

#endif // BORNAGAIN_SAMPLE_STANDARDSAMPLES_MULTILAYERWITHNCROUGHNESSBUILDER_H
