/*
  This file contains docstrings for use in the Python bindings.
  Do not edit! They were automatically extracted by pybind11_mkdoc and cleaned by CamiTK's clean-docstring.py script.
*/

#define MKD_EXPAND(x)                                      x
#define MKD_COUNT(_1, _2, _3, _4, _5, _6, _7, COUNT, ...)  COUNT
#define MKD_VA_SIZE(...)                                   MKD_EXPAND(MKD_COUNT(__VA_ARGS__, 7, 6, 5, 4, 3, 2, 1, 0))
#define MKD_CAT1(a, b)                                     a ## b
#define MKD_CAT2(a, b)                                     MKD_CAT1(a, b)
#define MKD_DOC1(n1)                                       mkd_doc_##n1
#define MKD_DOC2(n1, n2)                                   mkd_doc_##n1##_##n2
#define MKD_DOC3(n1, n2, n3)                               mkd_doc_##n1##_##n2##_##n3
#define MKD_DOC4(n1, n2, n3, n4)                           mkd_doc_##n1##_##n2##_##n3##_##n4
#define MKD_DOC5(n1, n2, n3, n4, n5)                       mkd_doc_##n1##_##n2##_##n3##_##n4##_##n5
#define MKD_DOC7(n1, n2, n3, n4, n5, n6, n7)               mkd_doc_##n1##_##n2##_##n3##_##n4##_##n5##_##n6##_##n7
#define DOC(...)                                           MKD_EXPAND(MKD_EXPAND(MKD_CAT2(MKD_DOC, MKD_VA_SIZE(__VA_ARGS__)))(__VA_ARGS__))

#if defined(__GNUG__)
#pragma GCC diagnostic push
#pragma GCC diagnostic ignored "-Wunused-variable"
#endif


/* Cleaned docstrings for exported CamiTK core classes */
static const char *mkd_doc_camitk_module =        
R"doc(
CamiTK Python Bindings
========================

This module provides Python bindings for CamiTK core functionalities.
It allows one to access core classes and methods from Action Python scripts.

**NOTE**

    This module is intended to be used within CamiTK Application context.
    It is meant to be used in Action Python scripts from inside a CamiTK application Python interpreter, and not as a standalone library.

**Available classes and functions**

- Action: Action class is an abstract class that enables you to build a action (generally an algorithm that works on specific data, i.
- Application: The generic/default application.
- Component: A Component represents something that could be included in the explorer view, the interactive 3D viewer, and that could have or not a contextual popup menu (open by a right click in the explorer), a property dialog (to change some properties) Thus, a Component inherits from many abstract classes.
- ComponentExtension: This class describes what is a generic Component extension.
- Core: Core class specifies the basic static information for the CamiTK API.
- ExtensionManager: This class is used to manage all plugins loaded by the application.
- FrameOfReference: FrameOfReference is only a label for an abstract coordinate system.
- HotPlugAction: An Action that can be created on the fly.
- ImageComponent: The manager of the Image Volume data.
- InterfaceBitMap: This class describes what are the methods to implement for a BitMap.
- InterfaceFrame: This class describes the methods to implement in order to manage a Component position in space.
- InterfaceGeometry: This class describes what are the methods to implement for a Geometry (rendering parameters, input/output, filters, picking parameters.
- InterfaceNode: This class describe what are the methods to implement for a hierarchical tree node.
- InterfacePersistence: Interface for all objects that should be serialized by the PersistenceManager.
- InterfaceProperty: This class describes what are the methods to implement in order to manage dynamic properties.
- Log: This class is a log utility.
- MeshComponent: Basic component to manage any kind of mesh.
- Property: This class describes a property that can be used in components and actions or any class that needs to be passed to ObjectController.
- Transformation: Transformation represents a geometrical transformation between two FrameOfReferences  It supports linear and non-linear transforms stored in a vtkTransform (linear) or any vtkAbstractTransform (non-linear)  It has a direction (from a FrameOfReference to another FrameOfReference)  Its constructor is private as Transformation objects must only be created through TransformationManager::getTransformationManager() (although it is possible to instantiate your own TransformationManager if you know what you're doing!)  .
- TransformationManager: TransformationManager manages frames of reference and transformations for a CamiTK Application  This class is the entry point to using FrameOfReference and Transformation system.



)doc";
/* ----------------------------------------
   Docstrings for Action
---------------------------------------- */

static const char *mkd_doc_camitk_Action = R"doc(Action class is an abstract class that enables you to build a action
(generally an algorithm that works on specific data, i.e. a specific
component).

To write an new action extension, at least two classes have to be
reimplemented to enable the action: ActionExtension + Action. All the
plugin mechanism is simplified thanks to CamiTK extension files (a
JSON file containing all the information to generate the glue between
your code and CamiTK).

## Overview

This is the list of attributes you need to consider when creating a
new action - name: name of the action; - description: tag used to
describe the action (also used for tooltip and whatsThis of the
corresponding QAction); - componentClassName: the name of the
component class on which this action can be applied or "" (default)
for generic actions. It determines on which type of component your
action can be applied. Generic actions are action that have an empty
component class name. Therefore generic actions can be called to
generate/synthetize data or initialize resources. - family: families
of actions allows one to group different actions of the same kind
under one name; - tags: tags is a list of words used to define an
action. These words can be used to find an action. - gui: either
"Default Action GUI" (the action uses a default widget, instance of
ActionWidget), "No GUI" or "Custom GUI" (you need to create the
action's gui widget) - notEmbedded: this boolean defines if the gui
widget is embedded in a given parent widget / action widget container
(true by default) or not - icon: the icon used for the visually
distinguish the action (used by the corresponding QAction)

.. note::
    An Action has a corresponding QAction, see getQAction(), that
    makes it easy to trigger an action from any Qt GUI (menus,
    toolbar, push buttons...). You can also call your action
    programmatically from any other code.

If the component class name is not empty, the action is using the
currently selected components of the given type (class name). If the
component class name is empty, the action does not need any input.

## Using CamiTK extension file

Using CamiTK extension file simplifies the creation and modification
of actions. When using a CamiTK extension file, the extension
generator will generate a initial .cpp file that you just have to fill
in with your source code.

These are the five methods you need to consider for customization: -
`init()` is called when the action is loaded by the extension manager
(i.e., when the action is instantiated). This is where all instance
wide initialization should be done - `process()` is called when the
user presses the "Apply" button. This is the main code for the action,
where things are done - `targetDefined()` is called when the target of
the action are defined (i.e., when the action is triggered). It is
generally used to update the action GUI - `parameterChanged()` is
called when a parameter value has changed. Similarly to
`targetDefined()` it can be used to update the action GUI - (optional)
`getUI()` if the developer wants to have a custom GUI, this is where
she/he should instantiate the corresponding widget(s)

You can call refreshApplication() in order to force the viewers to
refresh.

## Action Parameters

Action parameters are automatically created from the CamiTK extension
files. Each parameter is defined as a Qt dynamic property. In your C++
code it is strongly recommended to use: - getParameterValue("My
Parameter") to get the value as a QVariant (you can they use
toString(), toBool(), toDouble()... depending on the type of "My
Parameter") - setParameterValue("My Parameter", newValue) to set the
value of a parameter programmatically (newValue must be a QVariant or
of type that can be converted to a QVariant) -
getParameterValueAsString("My Parameter") to get a string
representation of the value of "My Parameter"

## Default GUI, Custom GUI or no GUI?

An Action generally is used to wrap an algorithm in CamiTK. If this
algorithm has parameters, it is very easy to get these parameters
accessible to the user through the ActionWidget. These parameters are
in fact defined as Qt dynamic properties.

The default widget is an instance of ActionWidget. If ActionWidget
does not correspond to what you need, just declare your action as
having a Custom Widget You will then need to create a new class
inheriting from QWidget, or directly from ActionWidget.

These are the use cases for using the default behaviour (i.e. an
instance of ActionWidget): - your action has some parameters and you
need the user to review the default or modify their values before the
action is applied, - or your action has no parameters but you still
want the user to be applied only if/when the user click on an apply
button.

ActionWidget should be good enough in most of the cases. The default
widget contains a description, a reminder of the current target
component names, and an ObjectController with an Apply/Revert buttons
that allows you to edit/modify properties. Use
setDefaultWidgetButtonVisibility() to change the visibility of the
Apply/Revert buttons and setDefaultWidgetApplyButtonText() to change
the apply button text.

When an action has no GUI triggering the action will directly call
process()

.. note::
    The recommended architecture is for the action widget to call the
    action's apply method. The widget should only manage user
    interaction.

## Underlying triggering and applying an action mechanism

Two steps have to be considered when using an action: - Step 1,
trigger(): the action is either directly applied (if it does not have
any GUI) or it's GUI is shown (using getWidget()) - Step 2, apply():
only the action algorithm is applied, i.e., the data are processed

The targets can have changed between the time the action is first
triggered and the time the action is applied. getWidget() is always
called when the targets are updated. Therefore whenever getWidget() is
called, you should make sure to update the the action GUI
consequently. getTargets() is always updated in trigger() and
available.

.. note::
    trigger() and apply() are public slots. They can be called either
    directly (classic C++ method invocation) or by connecting them to
    a QWidget signal.

When an action is triggered (e.g., by right clicking in the context
menu), the following algorithm applies, see trigger(): - 1. Prepare
targetComponents (available with getTargets()): only select the
compatible components from the selected components - 2. If the action
is embedded, get the widget and show it in a parent/container (if
parent is not specified, show it in the action viewer) - 3. If the
action in not embedded, show it as a dialog - 4. If the action does
not have any widget, directly call apply()

This means that, if there is a widget, the action algorithm is
controlled by the action widget, i.e. apply() is not called by
trigger() but should be called by one of the action widget's button.

If ActionWidget is not what your need, a typical getUI() method should
use the lazy instantiation pattern to instantiate
MyVerySpecialActionWidget the first time it is called, and call the
MyVerySpecialActionWidget instance's updateTargets() method for any
subsequent calls. Something like:

```
QWidget *MyAction::getUI() {
    // build or update the widget
    if (!myWidget)
        myWidget = new MyVerySpecialActionWidget(this);
    else
        // MyVerySpecialActionWidget should have an update() method
        myWidget->update();

    return myWidget;
 }
```

But of course you can also use any kind of widget you like.
ActionWidget is just defining a default widget for an action. If your
action does not have any GUI/parameters, add a getWidget() and return
nullptr.

By default the properties/parameters are automatically updated when
the user change the default widget, they are updated only when the
user click on the apply button of the default widget. The
setAutoUpdateProperties(true) to automatically called. Use
parameterChanged() to perform some action when a parameter was changed
byt the user.

By default the action's widget is embedded. If you do not want to
embed your action's widget, modify the "notEmbedded" parameter. When
embedded, the parent widget has to be given at triggered time (i.e.
getUI() is called during trigger). If there is no parent given for an
embedded action, then the action is embedded in the ActionViewer by
default.

The method apply() must be implemented in your Action.

.. note::
    at any moment, the selected components on which the action needs
    to be applied are available by getTargets(). targetComponents is
    filtered so that it only contains compatible components (i.e.,
    instances of getComponent()).

.. note::
    About registering your action in the history of the application.
    Consider registering your action within the application's history
    once applied. The history of action features a stack of processed
    action. The application's history of actions allows one to export
    the saved actions as an XML file for scripting or replaying it. To
    do so, implement the apply() method in your code, then launch the
    method applyAndRegister(), which simply wraps the apply() method
    with the preProcess() and postProcess() methods. You may also
    connect a SIGNAL to it, as the applyAndRegister() method is a Qt
    SLOT.

## Creating a pipeline of actions

A pipeline of actions is a state machine where each state stands for
an action with inputs and output components. The transitions between
the states are done by processing the state's action (i.e. by calling
the corresponding action's apply() method). Interpreting an pipeline
of action is simpler than simply executing the action since the user
doesn't need to manually set the inputs and outputs of each action (it
is done automatically). If you are willing to write such a pipeline,
simply implements the apply() method of each of your action and called
the applyInPipeline() (instead of simply apply()). The method
applyInPipeline() performs some pre- and post-processing around the
method apply(). It has to be used within a pipeline (a chain of
actions) where setInputComponents() and getOutputComponents() are
needed. preProcessInPipeline() only selects the right components, and
postProcess() sets output components and record history.

See also:
    RenderingOption For a simple example of an embedded action

See also:
    RigidTransform For a simple example of a non-embedded action

See also:
    ChangeColor For a simple example of an action with no widget (but
    with a GUI))doc";

static const char *mkd_doc_camitk_Action_Action = R"doc(Default Constructor: the ActionExtension is needed)doc";

static const char *mkd_doc_camitk_Action_ApplyStatus = R"doc(\enum ApplyStatus describes what happened during the application of an
algorithm (i.e. results of the apply method))doc";

static const char *mkd_doc_camitk_Action_actionWidget = R"doc(the action widget)doc";

static const char *mkd_doc_camitk_Action_addParameter = R"doc(Add a new parameter to the action, using the CamiTK property class. If
the parameter already exist, it will just change its value.

.. note::
    The action takes ownership of the Property instance.

Returns:
    false if the Qt Meta Object property was added by this method
    (otherwise the property was already defined and true is returned
    if it was successfully updated))doc";

static const char *mkd_doc_camitk_Action_addTag = R"doc(add a tag to the tags list of this action)doc";

static const char *mkd_doc_camitk_Action_aliveBeforeComponents = R"doc(List of alive component before the application of the action (to be
compared with the list after and deduce outputComponents).)doc";

static const char *mkd_doc_camitk_Action_apply = R"doc(This method is called when the action has to be applied on the target
list (get the target lists using getTargets()) It calls the algorithm
of your action on the target list of components

.. note::
    it should never be empty! \note if you wish to call your action
    and register it within the application history, prefer using the

See also:
    Action::applyAndRegister() method

Returns:
    The status of the apply method.)doc";

static const char *mkd_doc_camitk_Action_applyAndRegister = R"doc(This method is called whenever the action has to be applied on the
target list (like the apply()) method AND registered within the
application history of actions.

.. note::
    This is the default behaviour of applying and action. The
    application's history of actions allows one to export the saved
    actions as an XML file for scripting or replaying it.

Returns:
    The status of the apply method.)doc";

static const char *mkd_doc_camitk_Action_applyInPipeline = R"doc(@name Pipeline execution of the Action @{ This method encapsulates the
apply() method. It has to be called within a pipeline (a chain of
actions), where a script or another program calls setInputComponents()
and/or getOutputComponents. It is not needed in the case of graphical
interface which trigger the Action's widget and applies the action on
selected components. When there is no GUI, preProcessInPipeline() and
postProcessInPipeline() methods select the right component(s). As the
method apply() is called between preProcessInPipeline() and
postProcessInPipeline(), the returned value is the returned value of
apply().)doc";

static const char *mkd_doc_camitk_Action_autoUpdateProperties = R"doc(Should the properties/parameters of this action be automatically
updated when the user change something in the GUI)doc";

static const char *mkd_doc_camitk_Action_componentClassName = R"doc(the name of the component class that can be used by this action)doc";

static const char *mkd_doc_camitk_Action_defaultWidgetApplyButtonText = R"doc(apply button text)doc";

static const char *mkd_doc_camitk_Action_defaultWidgetButtonVisibility = R"doc(default widget button visibility)doc";

static const char *mkd_doc_camitk_Action_description = R"doc(the description of the action)doc";

static const char *mkd_doc_camitk_Action_extension = R"doc(the extension in which this action is declared and registered)doc";

static const char *mkd_doc_camitk_Action_family = R"doc(the name of the family in which this action is associated)doc";

static const char *mkd_doc_camitk_Action_fromVariant = R"doc(Load data from a QVariant to initialize the current object)doc";

static const char *mkd_doc_camitk_Action_getAutoUpdateProperties = R"doc(@name Property management @{ auto update properties)doc";

static const char *mkd_doc_camitk_Action_getComponentClassName = R"doc(the name of the component class that can be used by this action)doc";

static const char *mkd_doc_camitk_Action_getDescription = R"doc(the description of the action)doc";

static const char *mkd_doc_camitk_Action_getEmbedded = R"doc(argument use to know if the widget is embedded or not)doc";

static const char *mkd_doc_camitk_Action_getExtension = R"doc(get the extension as const)doc";

static const char *mkd_doc_camitk_Action_getExtensionName = R"doc(the name of the extension in the family in which this action is
associated)doc";

static const char *mkd_doc_camitk_Action_getFamily = R"doc(the name of the family in which this action is associated)doc";

static const char *mkd_doc_camitk_Action_getIcon = R"doc(the icon to personalize the action (no icon by default))doc";

static const char *mkd_doc_camitk_Action_getName = R"doc(get the name of the action)doc";

static const char *mkd_doc_camitk_Action_getOutputComponent = R"doc(Returns the output Components in case of only one Component.)doc";

static const char *mkd_doc_camitk_Action_getOutputComponents = R"doc(Returns the output Component(s))doc";

static const char *mkd_doc_camitk_Action_getParameterValue = R"doc(get the parameter QVariant (same as property(const char*)) but check
if it exists first. If the parameter was not declared using
addParameter, this methods prints an error message and returns an
invalid QVariant)doc";

static const char *mkd_doc_camitk_Action_getParameterValueAsString = R"doc(utility method to get the parameter value as a QString (useful to
print the value to log for instance) This method uses Property class
to translate the value to a QString)doc";

static const char *mkd_doc_camitk_Action_getProperty = R"doc(Get a Property given its name

Parameter ``name``:
    the property name

Returns:
    nullptr if the name does not match any property name

See also:
    Property)doc";

static const char *mkd_doc_camitk_Action_getQAction = R"doc(@name Generic action getters These methods can not be redefined in
subclasses. @{ Get the corresponding QAction. The corresponding
QAction has its triggered() signal connected to the trigger() slot of
the action. It shares the action icon (as the QAction's icon) and name
(as the QAction's text). It also use the descriptions of the action
for the tooltip/whatsThis text.

To add a shortcut, simply call getQAction()->setShortcut(..) in the
action constructor. To make this shortcut available for any windows of
the application, call
getQAction()->setShortcutContext(Qt::ApplicationShortcut);

Override this method if your action can be toggled on/off (for
instance an action that modifies the visibility of a component). This
method is called in the Component class to build the component's
action menu.)doc";

static const char *mkd_doc_camitk_Action_getStatusAsString = R"doc(Returns:
    the QString equivalent of the given status)doc";

static const char *mkd_doc_camitk_Action_getTag = R"doc(the name of the tag called this action)doc";

static const char *mkd_doc_camitk_Action_getTargets = R"doc(the currently selected and valid (regarding the component property)
components, for which this action is called)doc";

static const char *mkd_doc_camitk_Action_getUuid = R"doc(Get the unique ID of the action)doc";

static const char *mkd_doc_camitk_Action_getWidget = R"doc(@name Method specific to an action. @{ This method has to be redefined
in your Action only if: - you do not have any widget to control your
action (i.e. getWidget() will have to return nullptr), - you do not
use the default ActionWidget but another one.

In the second case, it is strongly recommended to have a code similar
to this:

```
QWidget *MyAction::getWidget() {
   // build or update the widget
   if (!myWidget)
       myWidget = new MyVerySpecialActionWidget(this);
   else
       // MyVerySpecialActionWidget should have an update() method
       myWidget->update();

   return myWidget;
}
```

The update() method in MyVerySpecialActionWidget is used in case the
selection has changed since the last time the widget was shown (a
change in the selection often means the targets or the parameter
values have changed, the UI should be refreshed as well).)doc";

static const char *mkd_doc_camitk_Action_historyItem = R"doc(The @class{HistoryItem} associated to this action.)doc";

static const char *mkd_doc_camitk_Action_icon = R"doc(the Action pixmap icon)doc";

static const char *mkd_doc_camitk_Action_isEmbedded = R"doc(is the widget embedded or not)doc";

static const char *mkd_doc_camitk_Action_name = R"doc(the name of the action)doc";

static const char *mkd_doc_camitk_Action_outputComponents = R"doc(List returned by getOutputComponents())doc";

static const char *mkd_doc_camitk_Action_parameterMap = R"doc(list of CamiTK property decorating the dynamic properties (action
parameters))doc";

static const char *mkd_doc_camitk_Action_postProcess = R"doc(Register the action in the history. The history item registered
features the input and output components, which are deduced with the
preProcess() and postProcess() functions.)doc";

static const char *mkd_doc_camitk_Action_postProcessInPipeline = R"doc(Set the right output component list so that the method
getOutputComponents() can be called. Also, register the action in the
history.)doc";

static const char *mkd_doc_camitk_Action_preProcess = R"doc(Save the number of top level components loaded in memory before
applying the action. This allows one to deduce the number of created /
deleted components launching the action.)doc";

static const char *mkd_doc_camitk_Action_preProcessInPipeline = R"doc(Selects the right component(s) (the one that has been set by
setInputComponents() ), so that the apply method uses the right
component(s) through getTargets(). If setInputComponents where not
called, does not select any component.)doc";

static const char *mkd_doc_camitk_Action_qAction = R"doc(the corresponding QAction)doc";

static const char *mkd_doc_camitk_Action_refreshApplication = R"doc(convenient method to call from the user code to refresh all the
application This is equivalent to call Application::refresh())doc";

static const char *mkd_doc_camitk_Action_setAutoUpdateProperties = R"doc(are the properties to be updated every time the user makes a change in
the widget (default is false)?)doc";

static const char *mkd_doc_camitk_Action_setComponentClassName = R"doc(set the name of the component class that can be used by this action)doc";

static const char *mkd_doc_camitk_Action_setDefaultWidgetApplyButtonText = R"doc(modify the "Apply" button text)doc";

static const char *mkd_doc_camitk_Action_setDefaultWidgetButtonVisibility = R"doc(if false then the apply/revert buttons are shown)doc";

static const char *mkd_doc_camitk_Action_setDescription = R"doc(the description of the action)doc";

static const char *mkd_doc_camitk_Action_setEmbedded = R"doc(set the embedded property (an action is embedded by default, unless
specified otherwise by explicitly calling this method with false))doc";

static const char *mkd_doc_camitk_Action_setFamily = R"doc(the name of the family in which this action is associated)doc";

static const char *mkd_doc_camitk_Action_setIcon = R"doc(set the Pixmap)doc";

static const char *mkd_doc_camitk_Action_setInputComponent = R"doc(Specify the input Components in case of only one Component.)doc";

static const char *mkd_doc_camitk_Action_setInputComponents = R"doc(Specify the input Component(s) Only applyInPipeline() should be called
with this method (maybe apply), but not trigger() as its first
intruction is to clear the target components list !!!)doc";

static const char *mkd_doc_camitk_Action_setName = R"doc(@name Generic action attributes setters These methods can not be
redefined in subclasses but have to be used to ensure name/description
uniqueness among CamiTK.

@{ set the name of the action class)doc";

static const char *mkd_doc_camitk_Action_setParameterValue = R"doc(set the parameter QVariant value (same as setProperty(const char*,
newValue)) but check if it exists first. If the parameter was not
declared using addParameter, this methods prints an error message and
returns false)doc";

static const char *mkd_doc_camitk_Action_setUuid = R"doc(Set the unique ID of the action

.. warning::
    This value can only be set once, to avoid the UUID changing for an
    object

Returns:
    The returns true if the value was set, false if it was not
    (meaning it already has a valid value))doc";

static const char *mkd_doc_camitk_Action_tags = R"doc(the name of the tag called this action)doc";

static const char *mkd_doc_camitk_Action_targetComponents = R"doc(The list of valid (regarding the component property) components for
which this action is called. This list is private (use getTargets() in
subclasses). This list may by filled - either by the trigger() method
which takes the currently selected and valid components (the method
trigger() then calls the apply method or the apply() method can be
called by the action's widget - or by the setInputComponent(Component
*)/setInputComponents(ComponentList) methods, but then the method
applyInPipeline() should be called (and not directly the apply()
method).)doc";

static const char *mkd_doc_camitk_Action_toVariant = R"doc(* @name InterfacePersistence Customized InterfacePersistence methods
to support geometry data (e.g. color)

@{ Convert all data from the object to a QVariant (usually a
QVariantMap))doc";

static const char *mkd_doc_camitk_Action_topLevelSelectedComponents = R"doc(The list of top level selected components before running the action
This list is used to deduce the number of top level components,
modified through applying the action)doc";

static const char *mkd_doc_camitk_Action_trigger = R"doc(This method triggers the action. The parent widget is used if the
action is embedded, see class description for more information about
the algorithm. This method cannot be redefined in inherited class.)doc";

static const char *mkd_doc_camitk_Action_updateTargets = R"doc(update the target list using the currently selected components)doc";


/* ----------------------------------------
   Docstrings for Application
---------------------------------------- */

static const char *mkd_doc_camitk_Application = R"doc(The generic/default application. Once this class is instantiated in
the main, everything is setup. The constructor can take the command
line arguments. It can also be asked not to load the extensions
automatically,see Application().

If you do not have a specific MainWindow extension, then the default
CamiTK MainWindow is used, see setMainWindow().

This class manages all application-level instances, structures and
all. This explains the number of _static_ methods in this class.

It manages: - the registered/loaded action extensions and all the
actions - the registered/loaded component extensions and all the
component instances - the registered/loaded viewer extensions and all
the viewer instances - the refresh mechanism - the current selection
(selected components) - the recently opened documents - the
application language/internationalization settings - the
opening/closing/saving of components - the main window - the history
of applied actions (including saving it as a CamitK SCXML document) -
some application level settings)doc";

static const char *mkd_doc_camitk_Application_Application = R"doc(Initializes the window system and constructs a CamiTK application
object with argc command line arguments in argv. The first parameter
is the name of the application (used as a identifier in the settings,
for example)

The second and third parameters comes from the command line (see
QApplication API documentation). This constructor inits all the CamiTK
context: - application wide settings - autoload (or not, depending on
the last parameter) of the extension

.. note::
    that you have to call init before doing anything!

Parameter ``name``:
    the name of the application, it will be used to save specific
    configuration for example.

Parameter ``argc``:
    the number of command line arguments

Parameter ``argv``:
    the values of the command line arguments

Parameter ``autoloadExtension``:
    if true, all the plugins are loaded

Parameter ``registerFileExtension``:
    if true, the application will prompt the user at first run if
    she/he wants to register file formats handled by loaded components
    with this application for opening (only valid for windows).

Parameter ``useSplashScreen``:
    if true a splash screen is instantiated to show status message
    during launch

.. note::
    registerFileExtension is only valid on Windows platform.)doc";

static const char *mkd_doc_camitk_Application_addComponent = R"doc(register a new component either in the full component list, or in the
full list and in the top-level list.

.. note::
    do not call this method from anywhere BUT the Component class
    destructor; Component is a friend class.)doc";

static const char *mkd_doc_camitk_Application_addHistoryItem = R"doc(@name Actions pipeline history @{ Add the history item to the
application history. The item is added to the history stack of actions
used in a pipeline

See also:
    removeLastHistoryItem() To pop back an action from the history use

Parameter ``item``:
    the item to add to the history)doc";

static const char *mkd_doc_camitk_Application_addRecentDocument = R"doc(Add a document to the list of recent documents (e.g. when a document
was opened) and update lastUsedDirectory)doc";

static const char *mkd_doc_camitk_Application_applyMainWindowPropertyValues = R"doc(Apply main window specific settings once it is set or instantiated
(e.g. stylesheet))doc";

static const char *mkd_doc_camitk_Application_applyPropertyValues = R"doc(Apply all the property values to update the model (e.g., use the
logLevel to modify the actual log level of the application logger))doc";

static const char *mkd_doc_camitk_Application_clearSelectedComponents = R"doc(clear all the selection, i.e call setSelected(false) for all the
previously selected components and clear the list.)doc";

static const char *mkd_doc_camitk_Application_close = R"doc(Close a Component: if it has been changed, ask the user for more
information, then if everything is ok, delete it.

Parameter ``component``:
    the Component to close.

Parameter ``blockRefresh``:
    do not refresh the main window after closing the component

Returns:
    true if the closing was made, false if the user cancelled the
    operation or a saving problem occurs)doc";

static const char *mkd_doc_camitk_Application_createProperties = R"doc(@name Property management @{

Create all the application properties and add them to the qApp)doc";

static const char *mkd_doc_camitk_Application_eventFilter = R"doc(Event filter of this class instance to watch its properties instances.
Each time a property has dynamically changed, this method is called.)doc";

static const char *mkd_doc_camitk_Application_exec = R"doc(Overriden from QApplication: Enters the main event loop and waits
until exit() is called, then returns the value that was set to exit()
(which is 0 if exit() is called via quit()).

It is necessary to call this function to start event handling. The
main event loop receives events from the window system and dispatches
these to the application widgets.

Generally, no user interaction can take place before calling exec().
As a special case, modal widgets like QMessageBox can be used before
calling exec(), because modal widgets call exec() to start a local
event loop.

To make your application perform idle processing, i.e., executing a
special function whenever there are no pending events, use a QTimer
with 0 timeout. More advanced idle processing schemes can be achieved
using processEvents().)doc";

static const char *mkd_doc_camitk_Application_getAction = R"doc(get a registered action given its name)doc";

static const char *mkd_doc_camitk_Application_getActionMap = R"doc(@name Actions management @{ As actions are mainly
sort/compared/process by name, an internal QMap associates all the
contains all the registered actions with their name (key) This is the
private (intern) method.

The action extension map is updated by loadExtension, unloadExtension
and autoloadExtensions.

This method follows the "construct on first use" idiom/design-pattern.
It therefore avoids the infamous "static initialization order fiasco",
see http://www.parashift.com/c++-faq/ctors.html)doc";

static const char *mkd_doc_camitk_Application_getActions_1 = R"doc(get all the actions registered in the application (note: the returned
ActionList is guaranteed to be sorted by action name and to contain no
duplicates))doc";

static const char *mkd_doc_camitk_Application_getActions_2 = R"doc(get all the actions that can be applied on a given component (note:
the returned ActionList is guaranteed to be sorted by action name and
to contain no duplicates))doc";

static const char *mkd_doc_camitk_Application_getActions_3 = R"doc(Get all the actions that can be applied on any components of the given
list of components (note: the returned ActionList is guaranteed to be
sorted by action name and to contain no duplicates))doc";

static const char *mkd_doc_camitk_Application_getActions_4 = R"doc(get all the actions that of a given tag (note: the returned ActionList
is guaranteed to be sorted by action name and to contain no
duplicates))doc";

static const char *mkd_doc_camitk_Application_getAllComponentList = R"doc(get the current application wide list of all Components. This is the
private (intern) method. This holds all the components at any level
(full component list), top-level or under. This method follows the
"construct on first use" idiom/design-pattern. It therefore avoids the
infamous "static initialization order fiasco", see
http://www.parashift.com/c++-faq/ctors.html)doc";

static const char *mkd_doc_camitk_Application_getAllComponents = R"doc(get the current application wide list of all Components. This is the
public method (return a const, the component list is private and
cannot be modified externally).)doc";

static const char *mkd_doc_camitk_Application_getHistory = R"doc(@name Actions pipeline history @{ get the history of actions stored.

This methods returns the singleton stack of actions stored in a
pipeline as their are applied during the execution of the application.

This is the private (intern) method. This history is updated (push(),
pop()) by addHistoryItem() and removeHistoryItem() This method follows
the "construct on first use" idiom/design-pattern. It therefore avoids
the infamous "static initialization order fiasco", see
http://www.parashift.com/c++-faq/ctors.html)doc";

static const char *mkd_doc_camitk_Application_getLastUsedDirectory = R"doc(Get the last used directory (e.g. the directory of the last opened
document))doc";

static const char *mkd_doc_camitk_Application_getMainWindow = R"doc(get the main window \note if there is no MainWindow when this method
is first called, then this method makes sure there is a MainWindow by
and force the creation of a default MainWindow (direct instance of the
MainWindow class))doc";

static const char *mkd_doc_camitk_Application_getMaxRecentDocuments = R"doc(get the maximal number of recent documents stored)doc";

static const char *mkd_doc_camitk_Application_getName = R"doc(get the application name)doc";

static const char *mkd_doc_camitk_Application_getNewViewer = R"doc(instantiate a new viewer of the given name and given class name
(Viewer inheriting class). \note this method does not register the
viewer automatically. Please call registerViewer(..) to add it to the
list of registered viewers.)doc";

static const char *mkd_doc_camitk_Application_getPropertyObject = R"doc(@name Property management @{

Get the property object of the application. Note that every time a
property is changed, the Application is notified, update its settings
and take the new property values into account.

See also:
    eventFilter())doc";

static const char *mkd_doc_camitk_Application_getRecentDocuments = R"doc(Get the list of recent documents)doc";

static const char *mkd_doc_camitk_Application_getSelectedComponentList = R"doc(get the currently selected Components. This is the private (intern)
method. the current selection (selected Components can at any level).
This method follows the "construct on first use" idiom/design-pattern.
It therefore avoids the infamous "static initialization order fiasco",
see http://www.parashift.com/c++-faq/ctors.html)doc";

static const char *mkd_doc_camitk_Application_getSelectedComponents = R"doc(@name Selection management

@{ get the currently selected Components. This is the public method
(return a const, the selected component list is private and cannot be
modified externally).)doc";

static const char *mkd_doc_camitk_Application_getSelectedLanguage = R"doc(@name Application resources management @{

Returns for the current CamiTK application, the selected language
(stored in its .ini configuration file))doc";

static const char *mkd_doc_camitk_Application_getSettings = R"doc(Get the Core wide settings. This is the preferred methods for
accessing and writing the settings for your specific needs, although
you can use any kind of settings you like, using this allow you to
store all settings in one place for all Core needs. This settings are
stored in the user scope, using the INI format (i.e. no registers !),
the organisation name is TIMC-IMAG and the application name is equal
to Core::version(). Check the QSettings API documentation to know
exactly where is the settings file or call
Application::getSettings().fileName()

The recommended method is to use one section for each Core area. Use
the beginGroup("my area")/endGroup() to define specific settings area.

.. note::
    for each beginGroup you use, you HAVE TO use an endGroup(),
    otherwise the settings state integrity is not guaranteed!)doc";

static const char *mkd_doc_camitk_Application_getTopLevelComponentList = R"doc(@name Components management @{ get the current application wide list
of instantiated top-level Components. This is the private (intern)
method. The top-level component list is updated by the Component class
top-level constructor. This method follows the "construct on first
use" idiom/design-pattern. It therefore avoids the infamous "static
initialization order fiasco", see
http://www.parashift.com/c++-faq/ctors.html)doc";

static const char *mkd_doc_camitk_Application_getTopLevelComponents = R"doc(get the current application wide list of instantiated top-level
Components. This is the public method (return a const, the top-level
component list is private and cannot be modified externally).)doc";

static const char *mkd_doc_camitk_Application_getTriggeredAction = R"doc(get the currently triggered action)doc";

static const char *mkd_doc_camitk_Application_getUniqueComponentName = R"doc(Get a unique name from the given name in the given componentList. By
default, it will check the given name against all current top level
component names.

For example getUniqueComponentName("Mesh", getTopLevelComponents())
may return "Mesh (3)" if there is already a component name "Mesh" and
"Mesh (2)")doc";

static const char *mkd_doc_camitk_Application_getViewer = R"doc(get the pointer to a registered viewer given its name)doc";

static const char *mkd_doc_camitk_Application_getViewerExtension = R"doc(return the viewer extension that manages the given viewer)doc";

static const char *mkd_doc_camitk_Application_getViewerMap = R"doc(@name viewer management @{ As viewers are mainly sort/compared/process
by name, an internal QMap associates all the registered viewers with
their name (key). This is the private (intern) method.

This is the private (intern) method.

The viewer extension map is updated by loadExtension, unloadExtension
and autoloadExtensions.

This method follows the "construct on first use" idiom/design-pattern.
It therefore avoids the infamous "static initialization order fiasco",
see http://www.parashift.com/c++-faq/ctors.html)doc";

static const char *mkd_doc_camitk_Application_getViewers_1 = R"doc(get all the viewers registered in the application (note: the returned
ViewerList is guaranteed to be sorted by viewer name and to not
contain any duplicate))doc";

static const char *mkd_doc_camitk_Application_getViewers_2 = R"doc(get the viewers that can manage/display the given component (note: the
returned ViewerList is guaranteed to be sorted by viewer name and to
contain no duplicates))doc";

static const char *mkd_doc_camitk_Application_hasModified = R"doc(Return true if at least one of the opened components has been
modified, false otherwise.)doc";

static const char *mkd_doc_camitk_Application_initResources = R"doc(Init the application resources by loading the language associated .qml
file)doc";

static const char *mkd_doc_camitk_Application_isAlive_1 = R"doc(does this Component still exist? (components can be deleted))doc";

static const char *mkd_doc_camitk_Application_isAlive_2 = R"doc(does this Action still exist? (HotPlugAction can be unloaded))doc";

static const char *mkd_doc_camitk_Application_loadWorkspace = R"doc(load a camitk file and its content into the application)doc";

static const char *mkd_doc_camitk_Application_notify = R"doc(reimplemented from QApplication to catch all exception from external
libs used in CEP (e.g. from ITK) and avoid crashes...)doc";

static const char *mkd_doc_camitk_Application_open = R"doc(load the filename and returns the corresponding top level Component
(returns nullptr if an error occurs)

.. note::
    this method opens the filename and created the associated TOP
    LEVEL component If you wish to open a subcomponent (not top level
    then), prefer directly calling its public constructor.

Parameter ``fileName``:
    file that contains the component

Parameter ``blockRefresh``:
    do not refresh the main window after closing the component)doc";

static const char *mkd_doc_camitk_Application_openDirectory = R"doc(load a directory and returns the corresponding Component (returns
nullptr if an error occurs)

Parameter ``dirName``:
    the name of the directory to open

Parameter ``pluginName``:
    the name of the plugin to use)doc";

static const char *mkd_doc_camitk_Application_quitting = R"doc(@})doc";

static const char *mkd_doc_camitk_Application_refresh = R"doc(refresh the main window (this will call the refresh method of all
viewers))doc";

static const char *mkd_doc_camitk_Application_registerAllActions = R"doc(register all actions from the given ActionExtension

Returns:
    the number of actions effectively registered (in case an action's
    name is already registered it won't be a second time))doc";

static const char *mkd_doc_camitk_Application_registerAllViewers = R"doc(register all viewers from the given ViewerExtension

Returns:
    the number of viewers effectively registered (in case a viewer's
    name is already registered by another viewer extension, it won't
    be registered a second time))doc";

static const char *mkd_doc_camitk_Application_registerViewer = R"doc(register a viewer in the viewer list (therefore allowing it to be
refreshed by the main window automatically)doc";

static const char *mkd_doc_camitk_Application_removeComponent = R"doc(unregister a Component. This method remove top-level component and
other level component

.. note::
    do not call this method from anywhere BUT the Component class
    destructor Component is a friend class.)doc";

static const char *mkd_doc_camitk_Application_removeLastHistoryItem = R"doc(Remove the last pushed actions in the history of the current pipeline.

See also:
    addHistoryItem() To push back the item use)doc";

static const char *mkd_doc_camitk_Application_resetProgressBar = R"doc(Resets the progress bar if it exists. See example of use for
ProgressFunction for more detailed explanation.)doc";

static const char *mkd_doc_camitk_Application_restart = R"doc(ask the user and if ok restart the application for the given reason)doc";

static const char *mkd_doc_camitk_Application_save = R"doc(save a component to its file (as given by component->getFileName()).

.. note::
    the component's file name has to be set prior to call this method.

This method look for the proper loaded ComponentExtension, and call
its save(Component*) method)doc";

static const char *mkd_doc_camitk_Application_saveHistoryAsSCXML = R"doc(Save the history as an SCXML file, stored using

See also:
    addHistoryItem() method. This file can be interpreted by the
    camitk actionstatemachine executable)doc";

static const char *mkd_doc_camitk_Application_saveWorkspace = R"doc(save the current workspace to a .camitk file.

This method uses PersistenceManager to save the workspace)doc";

static const char *mkd_doc_camitk_Application_setLastUsedDirectory = R"doc(set (force) the last used directory)doc";

static const char *mkd_doc_camitk_Application_setMainWindow = R"doc(set the main window. You need to call this method in order to use a
customized CamiTK MainWindow instead of the default one. This method
has to be called **after** init().

It allows you to set the main window using your application extension
instance.

.. note::
    Application takes ownership of the MainWindow pointer and deletes
    it at the appropriate time.

Parameter ``mw``:
    The instance of main window you want to use for your application
    (if nullptr a new instance of the MainWindow class is created)

Parameter ``redirect``:
    Start redirection to the application console)doc";

static const char *mkd_doc_camitk_Application_setProgressBarValue = R"doc(set the progress bar value, value should be in [0..100]. Attempting to
change the current value to one outside the minimum-maximum range has
no effect on the current value.

Consider using vtkProgressFunction())doc";

static const char *mkd_doc_camitk_Application_setSelected = R"doc(insert/remove one specific Component to the selection (at the end).
The selected component list is a QList, because the selection order is
important (QList is order, QSet is not). But it does not make any
sense to have two times the same Component instance so if isSelected
is true we have to "manually" check that it is not already in the list

.. note::
    do not call this method from anywhere BUT the Component
    setSelected method; Component is a friend class.

Parameter ``component``:
    the component to insert/remove from the selection

Parameter ``isSelected``:
    if true then insert if not already in the selection, otherwise
    remove)doc";

static const char *mkd_doc_camitk_Application_setTriggeredAction = R"doc(set the currently triggered action This is used by Action::trigger(..)
to refresh all the viewer (the viewers interested by the fact an
action was triggered can then update what they need to))doc";

static const char *mkd_doc_camitk_Application_showStatusBarMessage = R"doc(Set a message to the status bar. By default there is no timeout
(default), i.e. the given message remains displayed until this method
is called again (or the status bar is cleared otherwise).

Parameter ``msg``:
    the message to display in the status bar.

Parameter ``timeout``:
    number of milli-seconds (timeout) before the status bar is cleared
    (default = 0, i.e. until next call))doc";

static const char *mkd_doc_camitk_Application_sort_1 = R"doc(sort an ActionSet by action's name)doc";

static const char *mkd_doc_camitk_Application_sort_2 = R"doc(sort an ViewerSet by viewer's name)doc";

static const char *mkd_doc_camitk_Application_unregisterAllActions = R"doc(unregister all actions from the given ActionExtension

Returns:
    the number of actions effectively unregistered)doc";

static const char *mkd_doc_camitk_Application_unregisterAllViewers = R"doc(unregister all viewers from the given ViewerExtension

Returns:
    the number of viewer effectively unregistered)doc";

static const char *mkd_doc_camitk_Application_vtkProgressFunction = R"doc(Observer function to be called by vtkFilters and to update progress
bar Example of use:

```
Application::showStatusBarMessage("Applying my vtk filter");
Application::resetProgressBar();
vtkSmartPointer<vtkCallbackCommand> progressCallback = vtkSmartPointer<vtkCallbackCommand>::New();
progressCallback->SetCallback(&Application::vtkProgressFunction);
myVtkFilter->AddObserver(vtkCommand::ProgressEvent, progressCallback);
Application::resetProgressBar();
Application::showStatusBarMessage("");
```)doc";


/* ----------------------------------------
   Docstrings for Component
---------------------------------------- */

static const char *mkd_doc_camitk_Component = R"doc(A Component represents something that could be included in the
explorer view, the interactive 3D viewer, and that could have or not a
contextual popup menu (open by a right click in the explorer), a
property dialog (to change some properties) Thus, a Component inherits
from many abstract classes. A Component can only have one implemented
representation.

For CAMITK core developers: This class uses the Object Adapter Design
Pattern (aka delegate pattern) to delegates all InterfaceGeometry and
InterfaceBitMap to respectively myGeometry:Geometry and
mySlice:InterfaceBitMap It handles the InterfaceNode without
delegation. Considering this Design Pattern, Component is the Adaptor
and Geometry and InterfaceBitMap are the Adaptee classes.

This class has some static member to manage all the currently
instantiated Components as well as the currently selected Components.

Actions generally use setPointSet() (for InterfaceGeometry) and
setOriginalVolume (for InterfaceBitMap) to do some data processing and
directly modify the low-level Vtk data. It is thus very **important**
to rewrite these methods in your Component subclass to takes the
actions' modification into account in your low-level data.

Dynamic properties: if your Component defines some dynamic properties,
you might want to override propertyValueChanged() in order to update
the internal state of your object when a dynamic property's value has
been changed.

See also:
    ObjComponent for a good example

It extensively uses Qt Meta-Object system (concepts and
implementation). see http://doc.qt.nokia.com/latest/metaobjects.html)doc";

static const char *mkd_doc_camitk_Component_Component_1 = R"doc(Component constructor for top-level component (please use the other
constructor for sub-level components). parentComponent is set to
nullptr (=> isTopLevel() will return true).

Parameter ``file``:
    the file to get the data from

Parameter ``name``:
    the Component name

Parameter ``rep``:
    the representation concretely implemented by this Component
    (default=NO_REPRESENTATION)

Parameter ``createDefaultFrame``:
    Whether the component should create its frame (should be set to
    false only if the frame is created/set in another way))doc";

static const char *mkd_doc_camitk_Component_Component_2 = R"doc(Component constructor for a Component that is a child of another
Component You should not use this constructor for a top-level
component. This method may throw an AbortException if a problem
occurs.

Parameter ``parentComponent``:
    the parent Component

Parameter ``name``:
    the Component name

Parameter ``rep``:
    the representation implemented by this Component
    (default=NO_REPRESENTATION)

Parameter ``createDefaultFrame``:
    Whether the component should create its frame (should be set to
    false only if the frame is created/set in another way)

Throws:
    AbortException if parentComponent is nullptr.)doc";

static const char *mkd_doc_camitk_Component_Representation = R"doc(\enum Representation The different representation that can be
implemented to represent this Component in the InteractiveViewer. use
getRepresentation() to get the information about a specific Component.

.. note::
    the representation cannot be nullptr; if a Component does not have
    any representation, then getRepresentation() should return
    NO_REPRESENTATION (default).)doc";

static const char *mkd_doc_camitk_Component_actionsMenu = R"doc(the action menu for this component)doc";

static const char *mkd_doc_camitk_Component_addProperty = R"doc(Add a new CamiTK property to the component. If the property already
exist, it will just change its value.

.. note::
    The component takes ownership of the Property instance.

Returns:
    false if the Qt Meta Object property was added by this method
    (otherwise the property was already defined and true is returned
    if it was successfully updated))doc";

static const char *mkd_doc_camitk_Component_cellPicked = R"doc(an inherited class can redefine this method something specific.
Default behaviour: do nothing.)doc";

static const char *mkd_doc_camitk_Component_childrenComponent = R"doc(The explorer sub items)doc";

static const char *mkd_doc_camitk_Component_doubleClicked = R"doc(This method is called each time the InterfaceNode is double clicked by
the user. It returns false by default. You must overload this method
in Components to change its behaviour.)doc";

static const char *mkd_doc_camitk_Component_event = R"doc(Overriden from QObject, this one is only intercepting signal for
dynamic property changed (see constructor).)doc";

static const char *mkd_doc_camitk_Component_frameActors = R"doc(The frameActor representing the FrameOfReference axes (for each viewer
by name))doc";

static const char *mkd_doc_camitk_Component_frameOfReference = R"doc(The FrameOfReference in which this component's data is represented)doc";

static const char *mkd_doc_camitk_Component_frameVisibilities = R"doc(The visibility of the frameActors)doc";

static const char *mkd_doc_camitk_Component_fromVariant = R"doc(Load data from a QVariant to initialize the current object)doc";

static const char *mkd_doc_camitk_Component_getActionMenu = R"doc(Get a QMenu that contains all the action that can be applied to this
component.)doc";

static const char *mkd_doc_camitk_Component_getActor = R"doc(@name InterfaceGeometry All the implemented InterfaceGeometry methods
(delegated or not, see also Component.cpp)

@{)doc";

static const char *mkd_doc_camitk_Component_getActorColor = R"doc(see Component.cpp)doc";

static const char *mkd_doc_camitk_Component_getAllFrames = R"doc(Get all FrameOfReference owned by this object @arg
includeChildrenFrames Include the frames of this object's children
along with its own

Returns:
    A multimap that associates each FrameOfReference to the objects
    that own it)doc";

static const char *mkd_doc_camitk_Component_getAllTransformations = R"doc(Get all Transformation owned by this object @arg
includeChildrenTransformations Include the Transformation of this
object's children along with its own

Returns:
    A multimap that associates each Transformation to the objects that
    own it)doc";

static const char *mkd_doc_camitk_Component_getBoundingRadius = R"doc(compute the object's bounding sphere radius,

See also:
    Component.cpp

Returns:
    the bounding radius of the Geometry or -1 if there is no Geometry)doc";

static const char *mkd_doc_camitk_Component_getBounds = R"doc(compute the object's bounding box [xmin,xmax, ymin,ymax, zmin,zmax],
see Component.cpp)doc";

static const char *mkd_doc_camitk_Component_getDataPort = R"doc(@name InterfaceGeometry All the implemented InterfaceGeometry methods
(delegated or not, see also Component.cpp)

@{)doc";

static const char *mkd_doc_camitk_Component_getFileName = R"doc(get the file name where the data have to be stored/were stored)doc";

static const char *mkd_doc_camitk_Component_getFrame = R"doc(Get the pointer to this object's FrameOfReference. \note Please use
TransformationManager::getFrameOfReferenceOwnership(FrameOfReference*))doc";

static const char *mkd_doc_camitk_Component_getFrameAxisActor = R"doc(get the Frame Actor for a viewer)doc";

static const char *mkd_doc_camitk_Component_getFrameVisibility = R"doc(get the visibility of the Frame axis actor in the named viewer)doc";

static const char *mkd_doc_camitk_Component_getHierarchy = R"doc(@name InterfaceProperty All the implemented InterfaceProperty methods

@{ Get the inheritance hierarchy of this Component instance as a list
of QString)doc";

static const char *mkd_doc_camitk_Component_getImageData = R"doc(@name InterfaceBitMap All the implemented InterfaceBitMap methods

@{)doc";

static const char *mkd_doc_camitk_Component_getIndexOfPropertyExplorerTab = R"doc(Get the index of the tab in the ProperlyExplorer to select for
display. The ProperlyExplorer may features several tabs of widget.
This method allows one to select the one to select for display in a given
context.

Returns:
    the index to select in the tab of the ProperlyExplorer.

See also:
    PropertyExplorer)doc";

static const char *mkd_doc_camitk_Component_getModified = R"doc(set the modified flag)doc";

static const char *mkd_doc_camitk_Component_getNumberOfColors = R"doc(@name InterfaceBitMap All the implemented InterfaceBitMap methods

@{)doc";

static const char *mkd_doc_camitk_Component_getNumberOfPropertyWidget = R"doc(get the number of alternative property widgets

See also:
    PropertyExplorer)doc";

static const char *mkd_doc_camitk_Component_getNumberOfSlices = R"doc(see Component.cpp)doc";

static const char *mkd_doc_camitk_Component_getParentComponent = R"doc(get the parent component)doc";

static const char *mkd_doc_camitk_Component_getPickPlaneActor = R"doc(@name InterfaceBitMap All the implemented InterfaceBitMap methods

@{)doc";

static const char *mkd_doc_camitk_Component_getPixelActor = R"doc(@name InterfaceBitMap All the implemented InterfaceBitMap methods

@{)doc";

static const char *mkd_doc_camitk_Component_getPointSet = R"doc(@name InterfaceGeometry All the implemented InterfaceGeometry methods
(delegated or not, see also Component.cpp)

@{)doc";

static const char *mkd_doc_camitk_Component_getPopupMenu = R"doc(get the popup menu to display (always return nullptr, overwrite this
method if you want to give here you own popup))doc";

static const char *mkd_doc_camitk_Component_getProperty = R"doc(Get a Property given its name

Parameter ``name``:
    the property name

Returns:
    nullptr if the name does not match any property name

See also:
    Property)doc";

static const char *mkd_doc_camitk_Component_getPropertyObject = R"doc(Get the property object that could be understood by PropertyEditor.
Returns this as any Component instance can manage its list of dynamic
properties (and Component inherits from InterfaceProperty ). You can
also have a separate class to manage your Component properties. In
this case, just override this method and return the corresponding
instance.

See also:
    PropertyExplorer

See also:
    ObjectController)doc";

static const char *mkd_doc_camitk_Component_getPropertyValue = R"doc(get the property QVariant (same as property(const char*)) but check if
it exists first. If the property was not declared using addProperty,
this methods prints an error message and returns an invalid QVariant)doc";

static const char *mkd_doc_camitk_Component_getPropertyWidgetAt = R"doc(Get the ith alternative property widget

See also:
    PropertyExplorer)doc";

static const char *mkd_doc_camitk_Component_getRenderingModes = R"doc(see Component.cpp)doc";

static const char *mkd_doc_camitk_Component_getRepresentation = R"doc(return the type of representation concretely implemented by this
Component in the InteractiveViewer.

.. note::
    if a Component does not have any representation, then
    getRepresentation() returns NO_REPRESENTATION (default).)doc";

static const char *mkd_doc_camitk_Component_getSlice = R"doc(see Component.cpp)doc";

static const char *mkd_doc_camitk_Component_getTopLevelComponent = R"doc(get the top-level component)doc";

static const char *mkd_doc_camitk_Component_getUuid = R"doc(Get the unique ID of the component)doc";

static const char *mkd_doc_camitk_Component_getVisibility = R"doc(get the visibility inside the viewer of the given name)doc";

static const char *mkd_doc_camitk_Component_inItalic = R"doc(A component name is not displayed in italic by default. You must
redefine this method in you inherited Component to change this
behaviour.)doc";

static const char *mkd_doc_camitk_Component_indexOfPropertyExplorerTab = R"doc(The PropertyExplorer tab index to select once refreshed)doc";

static const char *mkd_doc_camitk_Component_init = R"doc(method called in constructors for general initialization)doc";

static const char *mkd_doc_camitk_Component_initRepresentation = R"doc(instantiate the concrete representation (either InterfaceGeometry or
InterfaceBitMap) if needed. This method has to instantiate Slice
(mySlice) or Geometry (myGeometry) that does all the work for this
Component, i.e. the adaptee handler. Generally this method should be
called in the Component constructor.)doc";

static const char *mkd_doc_camitk_Component_interfaceNodeModifiedFlag = R"doc(the InterfaceNode modification flag, if set to true, this means
something changed in value linked to the Node interface)doc";

static const char *mkd_doc_camitk_Component_isInstanceOf = R"doc(Assert that a Component instance really inherits from a given
className)doc";

static const char *mkd_doc_camitk_Component_isSelected = R"doc(Check if this data component is selected)doc";

static const char *mkd_doc_camitk_Component_isSelectedFlag = R"doc(tells if this particular Component is selected or not)doc";

static const char *mkd_doc_camitk_Component_isTopLevel = R"doc(return true if this component is a top-level component)doc";

static const char *mkd_doc_camitk_Component_modifiedFlag = R"doc(the modification flag (could be extended to manage a undo/redo list))doc";

static const char *mkd_doc_camitk_Component_myFileName = R"doc(the file name from which the Component is loaded)doc";

static const char *mkd_doc_camitk_Component_myGeometry = R"doc(myGeometry is the 3d representation of this Component, the Component
delegates all InterfaceGeometry activity to myGeometry (delegation
pattern))doc";

static const char *mkd_doc_camitk_Component_myParentNode = R"doc(who is the boss? The Component!)doc";

static const char *mkd_doc_camitk_Component_myService = R"doc(the service implemented to be represented in the InteractiveViewer)doc";

static const char *mkd_doc_camitk_Component_mySlice = R"doc(mySlice is the slice representation of this data component, the
Component delegates all InterfaceBitMap activity to mySlice
(delegation pattern))doc";

static const char *mkd_doc_camitk_Component_myViewers = R"doc(Name of the viewers where this Component would like to be viewed in)doc";

static const char *mkd_doc_camitk_Component_pixelPicked = R"doc(@name InterfaceBitMap All the implemented InterfaceBitMap methods

@{)doc";

static const char *mkd_doc_camitk_Component_pointPicked = R"doc(an inherited class can redefine this method something specific.
Default behaviour: do nothing.)doc";

static const char *mkd_doc_camitk_Component_propertyMap = R"doc(list of CamiTK property decorating the dynamic properties)doc";

static const char *mkd_doc_camitk_Component_propertyValueChanged = R"doc(This method is called when a dynamic property value has been modified.
If you override this method, do not forget to call the superclass
method for the properties not managed locally in order to properly
manage all inherited dynamic properties. This method is called when a
dynamic property has been updated.

Use getPropertyValue(name) to get the current (updated) value of the
dynamic property.

Parameter ``name``:
    the name of the dynamic property)doc";

static const char *mkd_doc_camitk_Component_refresh = R"doc(refresh all the viewer that are currently displaying this Component At
the end the InterfaceNode modification flag is reset.)doc";

static const char *mkd_doc_camitk_Component_removeChild = R"doc(@name InterfaceNode All the implemented InterfaceNode methods

@{ remove a child node. This method automatically update the
parentComponent of the given InterfaceNode (it is set to nullptr).)doc";

static const char *mkd_doc_camitk_Component_resetFrame = R"doc(Reset this object's FrameOfReference, that is call setFrame with a
newly created frame of reference.

.. note::
    you can reimplement this method if you need to manage more than
    this frame of reference (

See also:
    ImageComponent::setFrameFrom()))doc";

static const char *mkd_doc_camitk_Component_setArbitraryTransform = R"doc(@name InterfaceBitMap All the implemented InterfaceBitMap methods

@{)doc";

static const char *mkd_doc_camitk_Component_setColorMode = R"doc(@name InterfaceGeometry All the implemented InterfaceGeometry methods
(delegated or not, see also Component.cpp)

@{)doc";

static const char *mkd_doc_camitk_Component_setDataConnection = R"doc(@name InterfaceGeometry All the implemented InterfaceGeometry methods
(delegated or not, see also Component.cpp)

@{)doc";

static const char *mkd_doc_camitk_Component_setFileName = R"doc(set the file name where the data have to be stored)doc";

static const char *mkd_doc_camitk_Component_setFrame = R"doc(Set the FrameOfReference of this object. Note that this methods will
take ownership of the given frame thanks to the shared_ptr.)doc";

static const char *mkd_doc_camitk_Component_setFrameFrom = R"doc(Modify this object's frame using the given object's frame.

.. note::
    you can reimplement this method if you need to manage more than
    this frame of reference (

See also:
    ImageComponent::setFrameFrom()))doc";

static const char *mkd_doc_camitk_Component_setFrameVisibility = R"doc(set the visibility of the Frame axis actor)doc";

static const char *mkd_doc_camitk_Component_setIndexOfPropertyExplorerTab = R"doc(Set the index of the tab in the ProperlyExplorer to select for
display. The ProperlyExplorer may features several tabs of widget.
This method allows one to select the one to select for display in a given
context.

Parameter ``index``:
    the index to select in the tab of the ProperlyExplorer.

See also:
    PropertyExplorer)doc";

static const char *mkd_doc_camitk_Component_setModified = R"doc(set the modified flag)doc";

static const char *mkd_doc_camitk_Component_setOriginalVolume = R"doc(@name InterfaceBitMap All the implemented InterfaceBitMap methods

@{)doc";

static const char *mkd_doc_camitk_Component_setParent = R"doc(set the parent Component. This method automatically remove this
Component from its previous parent (if it already had one parent
Component))doc";

static const char *mkd_doc_camitk_Component_setPixelRealPosition = R"doc(@name InterfaceBitMap All the implemented InterfaceBitMap methods

@{)doc";

static const char *mkd_doc_camitk_Component_setPointData = R"doc(@name InterfaceGeometry All the implemented InterfaceGeometry methods
(delegated or not, see also Component.cpp)

@{)doc";

static const char *mkd_doc_camitk_Component_setPointSet = R"doc(@name InterfaceGeometry All the implemented InterfaceGeometry methods
(delegated or not, see also Component.cpp)

@{)doc";

static const char *mkd_doc_camitk_Component_setPropertyValue = R"doc(set the property QVariant value (same as setProperty(const char*,
newValue)) but check if it exists first. If the property was not
declared using addProperty, this methods prints an error message and
returns false)doc";

static const char *mkd_doc_camitk_Component_setSelected = R"doc(Update the selection flag.

Parameter ``b``:
    the value of the flag (true means "is selected")

Parameter ``recursive``:
    if true (default), also updates the children Component selection
    flags.)doc";

static const char *mkd_doc_camitk_Component_setSlice = R"doc(@name InterfaceBitMap All the implemented InterfaceBitMap methods

@{)doc";

static const char *mkd_doc_camitk_Component_setUuid = R"doc(Set the unique ID of the component

.. warning::
    This value can only be set once, to avoid the UUID changing for an
    object

Returns:
    The returns true if the value was set, false if it was not
    (meaning it already has a valid value))doc";

static const char *mkd_doc_camitk_Component_setVisibility = R"doc(set the visibility inside the viewer of the given name (the viewer
needs to be a registered viewer))doc";

static const char *mkd_doc_camitk_Component_toVariant = R"doc(* @name InterfacePersistence All the implemented InterfacePersistence
methods

@{ Convert all data from the object to a QVariant (usually a
QVariantMap))doc";

static const char *mkd_doc_camitk_Component_updateLabel = R"doc(@name InterfaceGeometry All the implemented InterfaceGeometry methods
(delegated or not, see also Component.cpp)

@{)doc";

static const char *mkd_doc_camitk_Component_updatePickPlane = R"doc(@name InterfaceBitMap All the implemented InterfaceBitMap methods

@{)doc";

static const char *mkd_doc_camitk_Component_visibilityMenu = R"doc(the sub menu that shows the visibility of this component in the
viewers)doc";


/* ----------------------------------------
   Docstrings for ComponentExtension
---------------------------------------- */

static const char *mkd_doc_camitk_ComponentExtension = R"doc(This class describes what is a generic Component extension. To add a
ComponentExtension to CamiTK core, write a new class that inherits
from this class.

There are two types of component extension: the classical one manages
(mime type) file extension, the other one manages all files in a given
directory (e.g. Dicom images). For the latter you have to redefine
hasDataDirectory().

The following methods HAVE to be redefined in your subclass: - getName
- getDescription - getFileExtensions - open

The following methods can be redefined: - save: saving from a
Component to one of the managed format - hasDataDirectory: for
directory type extension)doc";

static const char *mkd_doc_camitk_ComponentExtension_ComponentExtension = R"doc(protected constructor, \note never directly instantiate a
ComponentExtension, use loadExtension(...) instead!)doc";

static const char *mkd_doc_camitk_ComponentExtension_autoload = R"doc(the autoload state)doc";

static const char *mkd_doc_camitk_ComponentExtension_dynamicLibraryFileName = R"doc(the shared lib (.so, .dll or .dylib) used to instantiate the
ComponentExtension subclass instance)doc";

static const char *mkd_doc_camitk_ComponentExtension_getDescription = R"doc(get the plugin description)doc";

static const char *mkd_doc_camitk_ComponentExtension_getFileExtensions = R"doc(get the list of managed extensions (each file with an extension in the
list can be loaded by this Component))doc";

static const char *mkd_doc_camitk_ComponentExtension_getLocation = R"doc(get the file path (location of the .dll/.so/.dylib) of this plugin)doc";

static const char *mkd_doc_camitk_ComponentExtension_getName = R"doc(@name ComponentExtension plugin interface methods @{ get the plugin
name)doc";

static const char *mkd_doc_camitk_ComponentExtension_hasDataDirectory = R"doc(return true if this component manages directory instead of individual
files (e.g. Dicom series are stored in directories, not files))doc";

static const char *mkd_doc_camitk_ComponentExtension_initResources = R"doc(Load, for the selected langage (asked to the Application), the
associated .qm file)doc";

static const char *mkd_doc_camitk_ComponentExtension_open = R"doc(get a new instance from data stored in a file (this is the most
important method to redefine in your subclass)

This method may throw an AbortException if a problem occurs.

.. note::
    The parameter is a filename with an absolute path (from Qt's
    QFileInfo::absoluteFilePath method): On Unix (including Mac OS)
    this will always begin with the root, '/', directory. On Windows
    this will always begin 'D:/' where D is a drive letter, except for
    network shares that are not mapped to a drive letter, in which
    case the path will begin '//sharename/')doc";

static const char *mkd_doc_camitk_ComponentExtension_save = R"doc(save a given Component (does not have to be top-level) into one of the
currently managed format (check the component
QFileInfo(component->getFileName()).completeSuffix().

Redefine this method to extract all needed data/information from the
Geometry or BitMap representation in order to export a given component
to one of the file extension managed by this component extension.

.. note::
    this will enable to export to one of the managed filename
    extension at the CamiTK level (i.e. if you write this method, any
    compatible component can be saved to your managed format!

.. note::
    this method is called by CamiTK only if the filename extension is
    managed by this component extension. There should be no need to
    check it in the method.

The default behaviour is a "not implemented yet" message box.

Returns:
    false if the operation was not performed properly or not performed
    at all.)doc";

static const char *mkd_doc_camitk_ComponentExtension_setLocation = R"doc(set the file path (once loaded as a dynamic library))doc";


/* ----------------------------------------
   Docstrings for Core
---------------------------------------- */

static const char *mkd_doc_camitk_Core = R"doc(Core class specifies the basic static information for the CamiTK API.

Extensions can only be in three different places: - CAMITK_DIR (where
the libcamitkcore is) - user config directory - current wording
directory

Taking into account multiarch is difficult as some compiler/OS define
CMAKE_INSTALL_LIBDIR to different values ("lib", "lib64" or even
"lib/x86_64-linux-gnu" or more complicated paths). This value
sometimes depends on where CMAKE_INSTALL_PATH points to (see CMake
GNUInstallDirs module). For instance on debian, if CMAKE_INSTALL_PATH
is equals to "/usr" then CMAKE_INSTALL_LIBDIR is set to "lib/ARCH",
but if CMAKE_INSTALL_PATH is anything else, it is just set to "lib".
The `Core::libDir()` method returns something different than "" when
CamiTK core is compiled (see `CamiTKVersion.h.in`), but the CamiTK
repositories are required also when a CamiTK application is launched.

The difficulty therefore arises as CamiTK has to load all type of
extensions in all type of repositories and this must include: -
extensions build during CamiTK core compilation (which lands in
CMAKE_INSTALL_LIBDIR, and might be as complex as "lib/x86_64-linux-
gnu", i.e., include a subdirectory) - extensions build by CEP outside
CamiTK Community Edition (which will most certainly/by default be
"lib/")

Note that "lib/" was the only possible value of CMAKE_INSTALL_LIBDIR
before multiarch was taken into account in CamiTK 5.0.

To take into account both situations, that result in a multitude of
possible directories, it was decided that: - repositories should be
looked for either in `Core::libDir()` or `lib/` - the case when
`Core::libDir()` is equal to `lib/` must be taken into account to
avoid duplicates)doc";

static const char *mkd_doc_camitk_Core_debugPostfix = R"doc(debug postfix used on MSVC to distinguished between release and debug
version)doc";

static const char *mkd_doc_camitk_Core_getActionDirectories = R"doc(get all the action directories. It gets all the valid directories
where actions are installed, and insert them in this particular order:
1. current working directory (build install tree) 2. user config
directory (user install tree) 3. CamiTK SDK installation directory
(global install tree))doc";

static const char *mkd_doc_camitk_Core_getBugReport = R"doc(get a well formed bug report with all necessary information)doc";

static const char *mkd_doc_camitk_Core_getComponentDirectories = R"doc(@name runtime directory information @{ get all the component
directories. It gets all the valid directories where components are
installed, and insert them in this particular order: 1. current
working directory (build install tree) 2. user config directory (user
install tree) 3. CamiTK SDK installation directory (global install
tree))doc";

static const char *mkd_doc_camitk_Core_getConfig = R"doc(get more information about installation, etc... as a formatted string)doc";

static const char *mkd_doc_camitk_Core_getConfigAsJson = R"doc(get more information about installation, etc... as a JSON string
instead of the text/console version of getConfig)doc";

static const char *mkd_doc_camitk_Core_getCurrentWorkingDir = R"doc(get the current working directory (during dev, this should be the
build directory, which is an installation directory))doc";

static const char *mkd_doc_camitk_Core_getExtensionDirectories = R"doc(Used by getInstallDirectories to determine the list of extension
repositories This method check both `Core::libDir()` and `lib/` (if
different) subdirectories in order to take multiarch into account.

Parameter ``extensionType``:
    the type of extensions ("actions", "components" or "viewers"))doc";

static const char *mkd_doc_camitk_Core_getExtensionFilter = R"doc(return a list with all possible file extension for shared
object/dynamic library/dll (.so, .dll...))doc";

static const char *mkd_doc_camitk_Core_getGlobalInstallDir = R"doc(get the CAMITK_DIR (where camitk-config is installed))doc";

static const char *mkd_doc_camitk_Core_getInformationPathKeys = R"doc(@})doc";

static const char *mkd_doc_camitk_Core_getInstallDirectories = R"doc(get all installation directories, suffixed by the given word. All the
returned Strings are unique valid directories, sorted in this
particular order: 1. current working directory (build install tree) 2.
user config directory (user install tree) 3. CamiTK SDK installation
directory (global install tree)

It uses getExtensionDirectories() to take multiarch into account

If no directory is available and exitOnError is true, the application
exits. There are situation (namely for checking testdata dir) where it
not mandatory to find a directory. In this case, exitOnError should be
set to false so that the application does not exit.)doc";

static const char *mkd_doc_camitk_Core_getPaths = R"doc(get all important paths as a formatted string)doc";

static const char *mkd_doc_camitk_Core_getPathsAsJson = R"doc(get all important paths as a JSON string instead of the text/console
version of getPaths())doc";

static const char *mkd_doc_camitk_Core_getPythonStatus = R"doc(get the python status)doc";

static const char *mkd_doc_camitk_Core_getTestDataDir = R"doc(Get a valid camitk test data directory name. It returns the first
valid test data directory that is found. Checking is done in this
particular order: 1. current working directory (build install tree) 2.
user config directory (user install tree) 3. CamiTK SDK installation
directory (global install tree)

If none of this three directories is valid, return user's home
directory.

A test data directory is valid if it exists and contains a least one
file.

Returns:
    a null QString, checkable with isNull(), if no test data directory
    found)doc";

static const char *mkd_doc_camitk_Core_getUserInstallDir = R"doc(get the user config directory (this is the local installation
directory))doc";

static const char *mkd_doc_camitk_Core_getViewerDirectories = R"doc(get all the viewers directories. It gets all the valid directories
where viewers are installed, and insert them in this particular order:
1. current working directory (build install tree) 2. user config
directory (user install tree) 3. CamiTK SDK installation directory
(global install tree))doc";

static const char *mkd_doc_camitk_Core_isDebugBuild = R"doc(@name runtime build information @{ get the type of build we are
running, Debug or Release

Returns:
    true if running in Debug, elsewhere false for Release build.)doc";

static const char *mkd_doc_camitk_Core_libDir = R"doc(library folder set depending on the compiler and environment choice
(it could be lib/ or lib64/ on Linux).

libDir value is set directly to the value of CMAKE_INSTALL_LIBDIR.

Although it can not be called a version variable per se, it is
required for the extension manager to find the available extensions.)doc";

static const char *mkd_doc_camitk_Core_shortVersion = R"doc(short version string (all in lower case, without the patch number))doc";

static const char *mkd_doc_camitk_Core_soVersion = R"doc(version used for so name)doc";

static const char *mkd_doc_camitk_Core_version = R"doc(@name CamiTK Version and build information set at configure time @{
complete version string)doc";


/* ----------------------------------------
   Docstrings for ExtensionManager
---------------------------------------- */

static const char *mkd_doc_camitk_ExtensionManager = R"doc(This class is used to manage all plugins loaded by the application.

The current version is able to load dynamic library for -
ComponentExtension - ActionExtension

This class is a contained for all the loaded extension. It contains
only static members.)doc";

static const char *mkd_doc_camitk_ExtensionManager_ExtensionType = R"doc(\enum ExtensionType describes the CamiTK Extension Type (Action,
Component, Application...). CamiTK follows Component-Based programming
architecture. The Service Layer defines four types of extensions.)doc";

static const char *mkd_doc_camitk_ExtensionManager_InstallationRepository = R"doc(\enum InstallationRepository corresponds to where the extension is
installed)doc";

static const char *mkd_doc_camitk_ExtensionManager_actionExtensionLessThan = R"doc(Custom comparaison method between two ActionExtension* This method
uses the QString::<() (less than operator) to perform the comparaison
of two ActionExtension* based on their name. This method is used for
sorting alphabetically a list of ActionExtension*.

Parameter ``left``:
    left ActionExtension* to compare

Parameter ``right``:
    right ActionExtension* to compare

Returns:
    the comparaison result, based on their name (alphabetically order)

.. note::
    This method does not take const input arguments as the
    ActionExtension::getName() accessor is a mutable method (not
    const). This should be updated, but would change the CamiTK API
    check the Wiki for Code developer guidelines)doc";

static const char *mkd_doc_camitk_ExtensionManager_addLibraryPath = R"doc(check if the given directory contains an extension repository and if
it does update PATH (on windows) and call
QCoreApplication::addLibraryPath for the given directory and all
derived possible extension directories (actions, components and
viewers) To check if it contains an extension repository, the given
QString is used)doc";

static const char *mkd_doc_camitk_ExtensionManager_autoload_1 = R"doc(Autoload component, action and viewer extensions (dlls) as well as
registered CamiTK extension file)doc";

static const char *mkd_doc_camitk_ExtensionManager_autoload_2 = R"doc(Autoload all the extension of a given type. This method try to load
all the extensions of the given type that are found (in this specific
order) : - in the current working directory (considered as an install
directory), this should be the build directory (load extensions that
are just being compiled, before their installation - in the user
config directory (CamiTK user install) - in the system-wide install
(CamiTK global install) - and in the list of user-registered
extensions (stored in the configuration directory)

Duplicates found within the installation directory are removed (e.g.
if you have the extension x.so in the build directory as well as the
user directory, only the extension in the build directory will be
loaded (it takes precedence).

Parameter ``type``:
    the extension type)doc";

static const char *mkd_doc_camitk_ExtensionManager_componentExtensionLessThan = R"doc(@name Custom comparaison methods @{

Custom comparaison method between two ComponentExtension* This method
uses the QString::<() (less than operator) to perform the comparaison
of two ComponentExtension* based on their name. This method is used
for sorting alphabetically a list of ComponentExtension*.

Parameter ``left``:
    left ComponentExtension* to compare

Parameter ``right``:
    right ComponentExtension* to compare

Returns:
    the comparaison result, based on their name (alphabetically order))doc";

static const char *mkd_doc_camitk_ExtensionManager_getActionExtension = R"doc(Get the ActionExtension corresponding to the given shared library
file.

If the given shared library is not loaded return nullptr. The shared
library file should be given as a complete filepath in the QString.

Returns:
    nullptr if the given shared library complete path is not loaded.)doc";

static const char *mkd_doc_camitk_ExtensionManager_getActionExtensionMap = R"doc(get the singleton map of loaded action plugins (the key is the shared
object/dll/dylib filename) This is the private (intern) method. The
action extension map is updated by loadActionExtension,
unloadActionExtension and autoloadActionExtensions. This method
follows the "construct on first use" idiom/design-pattern. It
therefore avoids the infamous "static initialization order fiasco",
see http://www.parashift.com/c++-faq/ctors.html)doc";

static const char *mkd_doc_camitk_ExtensionManager_getActionExtensionsList = R"doc(Get the list of registered ActionExtension. The list contains unique
elements (no duplicates possible) and is alphabetically sorted.

.. note::
    The list is read-only and cannot be modified. This list is useful
    to loop over the loaded ActionExtension, especially when order
    counts.

Returns:
    list of unique ActionExtension loaded in the Core.)doc";

static const char *mkd_doc_camitk_ExtensionManager_getComponentExtension = R"doc(@name Component extension list management

@{ get the plugin corresponding to a given extension or name.)doc";

static const char *mkd_doc_camitk_ExtensionManager_getComponentExtensionMap = R"doc(get the singleton map of loaded component plugins for files (the key
is the file extension) This is the private (intern) method. The
component extension map is updated by loadComponentExtension,
unloadComponentExtension and autoloadComponentExtensions. This method
follows the "construct on first use" idiom/design-pattern. It
therefore avoids the infamous "static initialization order fiasco",
see http://www.parashift.com/c++-faq/ctors.html)doc";

static const char *mkd_doc_camitk_ExtensionManager_getComponentExtensionsList = R"doc(Get the list of registered ComponentExtension. The list contains
unique elements (no duplicates possible) and is alphabetically sorted.

.. note::
    The list is read-only and cannot be modified. This list is useful
    to loop over the loaded ComponentExtension, especially when order
    counts.

Returns:
    list of unique ComponentExtension loaded in the Core.)doc";

static const char *mkd_doc_camitk_ExtensionManager_getDataDirectoryComponentExtension = R"doc(get the plugin corresponding to a given data directory component
extension's name.)doc";

static const char *mkd_doc_camitk_ExtensionManager_getDataDirectoryComponentExtensionMap = R"doc(get the singleton map of loaded component plugins for data directory
(the key is the name) This is the private (intern) method. The data
directory component extension map is updated by loadExtension,
unloadExtension and autoloadExtensions. This method follows the
"construct on first use" idiom/design-pattern. It therefore avoids the
infamous "static initialization order fiasco", see
http://www.parashift.com/c++-faq/ctors.html)doc";

static const char *mkd_doc_camitk_ExtensionManager_getDataDirectoryComponentsList = R"doc(Get the list of registered ComponentExtension working on directory.
The list contains unique elements (no duplicates possible) and is
alphabetically sorted.

.. note::
    The list is read-only and cannot be modified. This list is useful
    to loop over the loaded ComponentExtension, especially when order
    counts.

Returns:
    list of unique ComponentExtension working on data directory loaded
    in the Core.)doc";

static const char *mkd_doc_camitk_ExtensionManager_getDataDirectoryExtNames = R"doc(get the list of all the name of the registered Component data
directory)doc";

static const char *mkd_doc_camitk_ExtensionManager_getFileExtensions = R"doc(get the list of all the suffixes managed by registered component
extensions (all possible file suffix))doc";

static const char *mkd_doc_camitk_ExtensionManager_getInstallationRepository = R"doc(Returns the enum corresponding to the installation repository
(directory) of a given shared library.

The shared library should be the name corresponding to the value of
getName() of an existing ComponentExtension, ActionExtension or
ViewerExtension.

The following string code are returned: - GLOBAL for an extension
installed in the global installation directory (where CamiTK SDK is
installed) - LOCAL for an extension installed in the user
configuration directory (local install) - WORKING for an extension
loaded directly from the current working directory (build installation
tree) - USER for an extension loaded manually by the user -
NOT_REGISTERED the extension name was not found in the list of loaded
extensions

.. note::
    calls getInstallationString and Core methods.

Returns:
    the enum value corresponding to the type of installation
    repository/directory

Parameter ``name``:
    the extension plugin name (i.e. the extension getName() value))doc";

static const char *mkd_doc_camitk_ExtensionManager_getInstallationString = R"doc(Returns a three char string that corresponds to the installation
directory of a given shared library.

The shared library should be the complete/fullpath filename
corresponding to a component, action or viewer extension.

The following enum value is returned: - "[G]" for an extension
installed in the global installation directory (where CamiTK SDK is
installed) - "[L]" for an extension installed in the user
configuration directory (local install) - "[W]" for an extension
loaded directly from the current working directory (build installation
tree) - "[U]" for an extension loaded manually by the user

Returns:
    the string coding for the installation

Parameter ``file``:
    the extension plugin file

Parameter ``globalInstallDir``:
    the global installation directory

Parameter ``userInstallDir``:
    the user installation directory

Parameter ``currentWorkingDir``:
    the current working directory)doc";

static const char *mkd_doc_camitk_ExtensionManager_getPluginFileNames = R"doc(return the list of shared objects in a directory considering
debug/release on MSVC)doc";

static const char *mkd_doc_camitk_ExtensionManager_getViewerExtension = R"doc(Get the Viewer Extension corresponding to the given shared library
file.

If the given shared library is not loaded return nullptr. The shared
library file should be given as a complete filepath in the QString.

Returns:
    nullptr if the given shared library complete path is not loaded.)doc";

static const char *mkd_doc_camitk_ExtensionManager_getViewerExtensionMap = R"doc(get the singleton map of loaded viewer plugins (the key is the shared
object/dll/dylib filename) This is the private (intern) method. The
viewer extension map is updated by loadViewerExtension,
unloadViewerExtension and autoloadViewerExtensions. This method
follows the "construct on first use" idiom/design-pattern. It
therefore avoids the infamous "static initialization order fiasco",
see http://www.parashift.com/c++-faq/ctors.html)doc";

static const char *mkd_doc_camitk_ExtensionManager_getViewerExtensionsList = R"doc(Get the list of registered ViewerExtension. The list contains unique
elements (no duplicates possible) and is alphabetically sorted.

.. note::
    The list is read-only and cannot be modified. This list is useful
    to loop over the loaded ViewerExtension, especially when order
    counts.

Returns:
    list of unique ViewerExtension loaded in the Core.)doc";

static const char *mkd_doc_camitk_ExtensionManager_initPrivateLibDirs = R"doc(Add the private library directories (lib/camitk-version) in the
current session PATH: - the current build library directory - the
local installation library directory - the global installation library
directory Note that we also add the actions and component private
library subdirectories. Uses addLibraryPath(). Takes multiarch into
account.)doc";

static const char *mkd_doc_camitk_ExtensionManager_loadExtension = R"doc(Load a specific extension from a file. This methods loads a
ActionExtension, ComponentExtension,... plugin from a .dll/.so/.dylib
filename

Parameter ``type``:
    the extension type

Parameter ``file``:
    the plugin filename (.dll/.so/.dylib)

Returns:
    false if it cannot be loaded)doc";

static const char *mkd_doc_camitk_ExtensionManager_registerFileExtension = R"doc(Register the file extension with the current application for opening
This function is called by registerFileExtensions

Parameter ``fileExtension``:
    the file extension to associate with the current application for
    opening)doc";

static const char *mkd_doc_camitk_ExtensionManager_registerNewComponentExtension = R"doc(Register the given ComponentExtension. If the given ComponentExtension
is managing file extensions that are already registered, it will not
be registered, and this method will return false and a info message
will be printed with more information.

Parameter ``ce``:
    valid ComponentExtension pointer (loaded from a shared library
    plugin (.dll/.so/.dylib) or instantiated programmatically)

Parameter ``filename``:
    (optional) if the extension was loaded from a shared library
    (.dll/.so/.dylib), path to this file

Returns:
    true if the extension was registered without error)doc";

static const char *mkd_doc_camitk_ExtensionManager_unloadActionExtension = R"doc(Unload an action extension using its .dll/.so/.dylib filename

Returns:
    false if the plugin could not be unloaded - still in use somewhere)doc";

static const char *mkd_doc_camitk_ExtensionManager_unloadAllActionExtensions = R"doc(unload all action extensions and delete instantiated actions)doc";

static const char *mkd_doc_camitk_ExtensionManager_unloadAllViewerExtensions = R"doc(unload all viewer extensions and delete instantiated actions)doc";

static const char *mkd_doc_camitk_ExtensionManager_unloadComponentExtension = R"doc(Unload a plugin corresponding to a given extension or component name.

Returns:
    false if the plugin could not be unloaded - still in use somewhere)doc";

static const char *mkd_doc_camitk_ExtensionManager_unloadViewerExtension = R"doc(Unload an viewer extension using its .dll/.so/.dylib filename

Returns:
    false if the plugin could not be unloaded - still in use somewhere)doc";

static const char *mkd_doc_camitk_ExtensionManager_viewerExtensionLessThan = R"doc(Custom comparaison method between two ViewerExtension* based on the
same principle as actionExtensionLessThan(..)

See also:
    actionExtensionLessThan(..) for more information)doc";


/* ----------------------------------------
   Docstrings for FrameOfReference
---------------------------------------- */

static const char *mkd_doc_camitk_FrameOfReference = R"doc(FrameOfReference is only a label for an abstract coordinate system. It
is used as origins and destinations of transformations.

There is no information stored in a FrameOfReference except - an ID, -
a name and description - a number of dimensions (between 1 and 5,
default is 3) and units ("mm" for the first 3 dimensions) - a
AnatomicalOrientation that can describe whether there is a known
anatomical orientation associated to each axis (

See also:
    AnatomicalOrientation) - a color (used in the transformation graph
    visualisation)

All constructors are protected, use TransformationManager to create a
new instance.

See also:
    Transformation, TransformationManager, AnatomicalOrientation)doc";

static const char *mkd_doc_camitk_FrameOfReference_FrameOfReference_1 = R"doc(Empty FrameOfReference Constructor. This constructor should only be
used to create a temporary FrameOfReference which UUid should be later
set to a valid value.

.. warning::
    The UUID of this frame is Null, it must be set to a valid value
    before use!)doc";

static const char *mkd_doc_camitk_FrameOfReference_FrameOfReference_2 = R"doc(Basic Frame Constructor

.. warning::
    The UUID of this frame is Null, it must be set to a valid value
    before use!)doc";

static const char *mkd_doc_camitk_FrameOfReference_FrameOfReference_3 = R"doc(Standard Frame Constructor This constructor needs explicit values for
all members. For the uuid, you can generate a new uuid by calling
QUuid::create())doc";

static const char *mkd_doc_camitk_FrameOfReference_FrameOfReference_4 = R"doc(copy constructor should copy all the members but reset Uuid, index and
color)doc";

static const char *mkd_doc_camitk_FrameOfReference_anatomicalOrientation = R"doc(Anatomical information for the frame axes)doc";

static const char *mkd_doc_camitk_FrameOfReference_color = R"doc(Color for a graphical representation of the Frame The initial color is
invalid, and will be attributed only when getColor() is called the
first time, this will avoid to jump over colors in the palette for
unused frame (e.g., when a workspace file is read))doc";

static const char *mkd_doc_camitk_FrameOfReference_description = R"doc(description of the FrameOfReference)doc";

static const char *mkd_doc_camitk_FrameOfReference_fromVariant = R"doc(Load the Frame content from a QVariant)doc";

static const char *mkd_doc_camitk_FrameOfReference_getAnatomicalOrientation_1 = R"doc(Get the anatomical information of the Frame)doc";

static const char *mkd_doc_camitk_FrameOfReference_getAnatomicalOrientation_2 = R"doc(Get the anatomical information of the Frame (non-const version))doc";

static const char *mkd_doc_camitk_FrameOfReference_getAnatomicalOrientationLabel = R"doc(Get the Anatomical orientation label of the corresponding
axis/direction (or empty string if there is no label).

Parameter ``axis``:
    The axis index (0,1,2)

Parameter ``minDirection``:
    if true, return the label of the minimum/negative direction,
    otherwise return the label of the maximum/position direction for
    the given axis)doc";

static const char *mkd_doc_camitk_FrameOfReference_getColor = R"doc(Get the color for graphical representation of the FrameOfReference Set
the color the first time this is called to avoid "loosing" colors in
the palette.)doc";

static const char *mkd_doc_camitk_FrameOfReference_getDescription = R"doc(Get the description of the FrameOfReference. Optional string, more
detailed than the name)doc";

static const char *mkd_doc_camitk_FrameOfReference_getIndex = R"doc(Get the index (a non-unique ID useful for user interaction) indexes
start at 1)doc";

static const char *mkd_doc_camitk_FrameOfReference_getName = R"doc(Get the FrameOfReference name)doc";

static const char *mkd_doc_camitk_FrameOfReference_getNextColorAndIndex = R"doc(get the next available color (used for frame colors) and the
associated index)doc";

static const char *mkd_doc_camitk_FrameOfReference_getNumberOfDimensions = R"doc(Get the number of dimensions of this FrameOfReference)doc";

static const char *mkd_doc_camitk_FrameOfReference_getUnit = R"doc(get the unit of the given dimension if dimension is valid otherwise
returns an invalid Unit)doc";

static const char *mkd_doc_camitk_FrameOfReference_getUuid = R"doc(Get the unique identifier of the Frame)doc";

static const char *mkd_doc_camitk_FrameOfReference_index = R"doc(Index number intended for user interaction (simpler than UUID) index
value of 0 means the color and index is not initialized yet)doc";

static const char *mkd_doc_camitk_FrameOfReference_name = R"doc(name of the FrameOfReference)doc";

static const char *mkd_doc_camitk_FrameOfReference_numberOfDimensions = R"doc(Number of dimensions, often 3, sometimes 4 for time)doc";

static const char *mkd_doc_camitk_FrameOfReference_resetUuid = R"doc(Reset the unique identifier even if it is already set. This is private
because this is necessary only for TransformationManager creating a
copy of a FrameOfReference

Returns:
    True if the ID was changed, false if it was not (because it was
    already set))doc";

static const char *mkd_doc_camitk_FrameOfReference_setAnatomicalOrientation_1 = R"doc(Set anatomical orientation information)doc";

static const char *mkd_doc_camitk_FrameOfReference_setAnatomicalOrientation_2 = R"doc(Set anatomical orientation information.

Parameter ``threeLetterCode``:
    Set a standard 3-letter orientation code (e.g. "RAI" for X axis
    from Right to Left, Y axis from Anterior to Posterior, Z axis from
    Inferior to Superior))doc";

static const char *mkd_doc_camitk_FrameOfReference_setColor = R"doc(Set a color for graphical representation of the FrameOfReference)doc";

static const char *mkd_doc_camitk_FrameOfReference_setDescription = R"doc(Set the description of the FrameOfReference. Optional string, more
detailed than the name)doc";

static const char *mkd_doc_camitk_FrameOfReference_setName = R"doc(Set the name of the FrameOfReference Should be a short string, use
setDescription if you want to store a more detailed description of the
FrameOfReference)doc";

static const char *mkd_doc_camitk_FrameOfReference_setNumberOfDimensions = R"doc(Set the number of dimensions of this FrameOfReference

Usually, the first three dimensions are spatial coordinates, the 4th
one is time, and other dimensions may be used to represent other data
type within the same 5D volume)doc";

static const char *mkd_doc_camitk_FrameOfReference_setUnit = R"doc(Set the unit of one dimension

Parameter ``u``:
    should be a string following the Unified Codes for Units of
    Measurement standard (https://ucum.org) also used by DICOM. Common
    values are "mm" for space, "s" for time)doc";

static const char *mkd_doc_camitk_FrameOfReference_setUuid = R"doc(Set the unique identifier only if it is not already set

Returns:
    True if the ID was changed, false if it was not (because it was
    already set))doc";

static const char *mkd_doc_camitk_FrameOfReference_toVariant = R"doc(@name Implementation of InterfacePersistence @{

Convert the Frame to a QVariant for Persistence)doc";

static const char *mkd_doc_camitk_FrameOfReference_units = R"doc(units, usually {"mm", "mm", "mm", "s"}, its size must be equal to
numberOfDimensions)doc";

static const char *mkd_doc_camitk_FrameOfReference_uuid = R"doc(Unique identifier, essential for Persistence)doc";


/* ----------------------------------------
   Docstrings for HotPlugAction
---------------------------------------- */

static const char *mkd_doc_camitk_HotPlugAction = R"doc(An Action that can be created on the fly)doc";

static const char *mkd_doc_camitk_HotPlugAction_HotPlugAction = R"doc(Default Constructor)doc";

static const char *mkd_doc_camitk_HotPlugAction_apply = R"doc(this method is automatically called when the action is triggered. Call
getTargets() method to get the list of components to use.

.. note::
    getTargets() is automatically filtered so that it only contains
    compatible components, i.e., instances of "$componentClass$" (or a
    subclass).)doc";

static const char *mkd_doc_camitk_HotPlugAction_createParameter = R"doc(returns a new Property* (action parameter) corresponding to the given
data model

Parameter ``parameter``:
    is the dictionary with all the information about one parameter)doc";

static const char *mkd_doc_camitk_HotPlugAction_createParameters = R"doc(create all the parameters from the data model

Parameter ``parameters``:
    is the "parameters" of the action)doc";

static const char *mkd_doc_camitk_HotPlugAction_event = R"doc(manage property change immediately)doc";

static const char *mkd_doc_camitk_HotPlugAction_getWidget = R"doc(Calls user-defined targetDefined() and getUI())doc";

static const char *mkd_doc_camitk_HotPlugAction_hotPlugExtension = R"doc(where the action is managed)doc";

static const char *mkd_doc_camitk_HotPlugAction_init = R"doc(calls user-defined init()

Returns:
    true if the initialization went well)doc";

static const char *mkd_doc_camitk_HotPlugAction_initializationPending = R"doc(do not manage event during initialization)doc";

static const char *mkd_doc_camitk_HotPlugAction_needsUpdate = R"doc(if this method returns true, update() should be called. To be
reimplemented in subclass for language (i.e., C++) that needs to watch
the user source code

Returns:
    false unless reimplemented)doc";

static const char *mkd_doc_camitk_HotPlugAction_parameterChangedEvent = R"doc(called when a parameter was changed by an event reimplemented in
inherited class)doc";

static const char *mkd_doc_camitk_HotPlugAction_setParameterAttributes = R"doc(use the parameterData to set attributes of the given parameter managed
attributes are: group, minimum, maximum, singleStep, decimals regExp,
readOnly and enumValues Note that the parameter type is not checked
(apart for the attribute enumValues, a valid data model is assumed))doc";

static const char *mkd_doc_camitk_HotPlugAction_update = R"doc(update the action from the source code. To be reimplemented in
subclass for language (i.e., C++) that needs to watch the user source
code and rebuild the code By default does nothing and returns true)doc";


/* ----------------------------------------
   Docstrings for ImageComponent
---------------------------------------- */

static const char *mkd_doc_camitk_ImageComponent = R"doc(The manager of the Image Volume data. An image volume data has no
concrete 3D representation, as its representation is provided by its
sub-components (axial, sagittal, coronal and arbitrary slices as well
as volume rendering).

It builds a complete/ready-to-use VTK pipeline:

See also:
    Slice

.. note::
    You can use the following properties to change the visualization
    of an ImageComponent and children components: - "Display Image in
    3D Viewer" type boolean, controls what is displayed in the default
    3D viewer

Every time a property is changed using setProperty(QString
propertyName, QVariant value), the ImageComponent will automatically
update, thanks to the propertyValueChanged(..) method.)doc";

static const char *mkd_doc_camitk_ImageComponent_ImageComponent_1 = R"doc(Creates an ImageComponent from a file. This method is called from a
ComponentExtension derived class that support the given file format.

This method may throw an AbortException if a problem occurs.

Parameter ``file``:
    the complete path to the image file

Parameter ``name``:
    name to be given to the Component (this name will appear in the
    explorer))doc";

static const char *mkd_doc_camitk_ImageComponent_ImageComponent_2 = R"doc(Creates an ImageComponent from a vtkImageData.

By default, does not copy the original image, but references the
corresponding smart pointer (for memory reasons, but if copy is set to
true, performs a deep copy).

This method may throw an AbortException if a problem occurs.

Parameter ``anImageData``:
    volume image of the new ImageComponent

Parameter ``name``:
    name to be given to the Component (this name will appear in the
    explorer)

Parameter ``copy``:
    perform or not a deep copy of the image given in parameters.

Parameter ``initialOrientation``:
    the initial orientation of the image. This information may be
    stored in the file header or in some time (DICOM). If no
    orientation information is provided, assume the image orientation
    is RAI.)doc";

static const char *mkd_doc_camitk_ImageComponent_addAdditionalFrame = R"doc(add an additional frame (neither data nor main))doc";

static const char *mkd_doc_camitk_ImageComponent_addAdditionalTransformation = R"doc(add an additional Transformation)doc";

static const char *mkd_doc_camitk_ImageComponent_arbitrarySlices = R"doc(the arbitrary slices representation (all intelligence is delegated to
a Slice class instance))doc";

static const char *mkd_doc_camitk_ImageComponent_axialSlices = R"doc(the axial slices representation (all intelligence is delegated to a
Slice class instance))doc";

static const char *mkd_doc_camitk_ImageComponent_buildImageComponents = R"doc(build the SingleImageComponent (one for each image plane);)doc";

static const char *mkd_doc_camitk_ImageComponent_coronalSlices = R"doc(the coronal slices representation (all intelligence is delegated to a
Slice class instance))doc";

static const char *mkd_doc_camitk_ImageComponent_currentPixelPicked = R"doc(Store the coordinates of the center of the last selected pixel in the
data FrameOfReference)doc";

static const char *mkd_doc_camitk_ImageComponent_cursorActor = R"doc(3D cursor actor)doc";

static const char *mkd_doc_camitk_ImageComponent_cursorActorPointSet = R"doc(3D cursor actor unstructured grid)doc";

static const char *mkd_doc_camitk_ImageComponent_fromVariant = R"doc(Load data from a QVariant to initialize the current object)doc";

static const char *mkd_doc_camitk_ImageComponent_getActualMaxColor = R"doc(Max gray level found in the image given its data type)doc";

static const char *mkd_doc_camitk_ImageComponent_getActualMinColor = R"doc(Min gray level found in the image given its data type)doc";

static const char *mkd_doc_camitk_ImageComponent_getActualNumberOfColors = R"doc(Actual Number of colors: difference betweent the maximun and the
minimum gray levels found in the image.)doc";

static const char *mkd_doc_camitk_ImageComponent_getAdditionalFrames = R"doc(get the other frames (neither data nor main))doc";

static const char *mkd_doc_camitk_ImageComponent_getAdditionalTransformations = R"doc(get the additional Transformations)doc";

static const char *mkd_doc_camitk_ImageComponent_getAllFrames = R"doc(Get all FrameOfReference owned by this image @arg
includeChildrenFrames Include the frames of this image's children
along with its own

Returns:
    A multimap that associates each FrameOfReference to the Components
    that own it)doc";

static const char *mkd_doc_camitk_ImageComponent_getAllTransformations = R"doc(Get all Transformation owned by this image @arg
includeChildrenTransformations Include the Transformation of this
image's children along with its own

Returns:
    A multimap that associates each Transformation to the Components
    that own it)doc";

static const char *mkd_doc_camitk_ImageComponent_getArbitrarySlices = R"doc(Returns the arbitrary slice)doc";

static const char *mkd_doc_camitk_ImageComponent_getAxialSlices = R"doc(Returns the axial slice)doc";

static const char *mkd_doc_camitk_ImageComponent_getBoundingBox = R"doc(internal method used to put a mesh in volumeRenderingChild and
accessoiry display the bounding box)doc";

static const char *mkd_doc_camitk_ImageComponent_getCoronalSlices = R"doc(Returns the coronal slice)doc";

static const char *mkd_doc_camitk_ImageComponent_getDataFrame = R"doc(get the data FrameOfReference (i.e., the vtkImageData frame))doc";

static const char *mkd_doc_camitk_ImageComponent_getImageData = R"doc(get the image volume managed by this Component)doc";

static const char *mkd_doc_camitk_ImageComponent_getImageDataWithFrameTransform = R"doc(Compute a copy of the original image data on which the frame transform
has been applied. This allows one to keep all the frame transform
information on the file when saving it.

Returns:
    a vtkImageData deep copied from the original image data on which
    the frame transform has been applied.)doc";

static const char *mkd_doc_camitk_ImageComponent_getInitialOrientation = R"doc(Get the initial image orientation)doc";

static const char *mkd_doc_camitk_ImageComponent_getLastPixelPicked = R"doc(Get the last pixel picked using CTRL + LEFT/RIGHT CLICK in voxel index
(i, j, k) indicates the voxel index (no notion of voxel size))doc";

static const char *mkd_doc_camitk_ImageComponent_getLastPointPickedDataFrame = R"doc(Get the last point picked using CTRL + LEFT/RIGHT CLICK in the data
frame coordinates (this takes into account voxel size))doc";

static const char *mkd_doc_camitk_ImageComponent_getLastPointPickedWorldFrame = R"doc(Get Get the last point picked using CTRL + LEFT/RIGHT CLICK in the
world coordinates This takes into account voxel size and image origin
(and possible image rigid transforms).)doc";

static const char *mkd_doc_camitk_ImageComponent_getLut_1 = R"doc(get the current lookup table)doc";

static const char *mkd_doc_camitk_ImageComponent_getLut_2 = R"doc(get the current lookup table (const version))doc";

static const char *mkd_doc_camitk_ImageComponent_getMainTransformation = R"doc(Get main Transformation (data -> main))doc";

static const char *mkd_doc_camitk_ImageComponent_getMaxColor = R"doc(Max possible gray level of the image given its data type)doc";

static const char *mkd_doc_camitk_ImageComponent_getMinColor = R"doc(Min possible gray level of the image given its data type)doc";

static const char *mkd_doc_camitk_ImageComponent_getNumberOfColors = R"doc(Number of colors: number of possible gray levels in the image computed
from the min and the max of the data type ; e.g. for a volume coded on
unsigned char, returns 256.)doc";

static const char *mkd_doc_camitk_ImageComponent_getNumberOfPropertyWidget = R"doc(return number of tabs in property explorer: there is more than one
widget)doc";

static const char *mkd_doc_camitk_ImageComponent_getNumberOfSlices = R"doc(Number of axial slices (i.e. dim[2]))doc";

static const char *mkd_doc_camitk_ImageComponent_getPropertyWidgetAt = R"doc(get the property widget (to view as tabs in the property explorer):
the default property widget and the selection view)doc";

static const char *mkd_doc_camitk_ImageComponent_getRotationMatrix = R"doc(@})doc";

static const char *mkd_doc_camitk_ImageComponent_getSagittalSlices = R"doc(Returns the sagittal slice)doc";

static const char *mkd_doc_camitk_ImageComponent_getVolumeRenderingChild = R"doc(Returns the MeshComponent which will contain the volume rendering
actor)doc";

static const char *mkd_doc_camitk_ImageComponent_init = R"doc(initialize pointers to nullptr and other attributes)doc";

static const char *mkd_doc_camitk_ImageComponent_initCursor = R"doc(Create the 3D cursor)doc";

static const char *mkd_doc_camitk_ImageComponent_initImageProperties = R"doc(Update the Properties displayed in the PropertyExplorer It should be
called by setImageData to update the properties with respect to the
new image data The properties updated are: - Image Name - Image
Dimensions - Image Size - Voxel Size - Voxel Data Type - Display Image
in 3D Viewer)doc";

static const char *mkd_doc_camitk_ImageComponent_initRepresentation = R"doc(the concrete building of the 3D objects (Slice/Geometry): none in this
case!)doc";

static const char *mkd_doc_camitk_ImageComponent_initialFrameTransform = R"doc(The initial frame of the image at opening @note This transform is
equal to the initial image translation (Offset) multiplies by its
rotation (TransformMatrix) multiplies by the reorientation transform
(transform -> RAI))doc";

static const char *mkd_doc_camitk_ImageComponent_initialImageDataTransform = R"doc(The initial transform to the vtkImageData @note This transform is
equal to the initial image translation (Offset) multiplies by the
reorientation transform (transform -> RAI))doc";

static const char *mkd_doc_camitk_ImageComponent_initialOrientation = R"doc(Initial image orientation)doc";

static const char *mkd_doc_camitk_ImageComponent_lut = R"doc(the current lookup table)doc";

static const char *mkd_doc_camitk_ImageComponent_model = R"doc(Model to display data)doc";

static const char *mkd_doc_camitk_ImageComponent_originalImageData = R"doc(the core Image Volume that is managed here)doc";

static const char *mkd_doc_camitk_ImageComponent_pixelPicked = R"doc(Method called when a pixel has been picked in the 3D view. This method
tells all the scene3D to display the slice containing the picked
pixel. The arguments are the coordinates of the 3D point.)doc";

static const char *mkd_doc_camitk_ImageComponent_propertyValueChanged = R"doc(@name InterfaceProperty InterfaceProperty implemented methods

@{ manages dynamic property viewIn3D)doc";

static const char *mkd_doc_camitk_ImageComponent_refresh = R"doc(force refresh of all interactive viewers that are displaying sub-
components as ImageComponent is not itself displayed by any viewer)doc";

static const char *mkd_doc_camitk_ImageComponent_removeAdditionalFrame = R"doc(remove an additional frame)doc";

static const char *mkd_doc_camitk_ImageComponent_removeAdditionalTransformation = R"doc(Remove an additional Transformation from the Component)doc";

static const char *mkd_doc_camitk_ImageComponent_replaceImageData = R"doc(Replaces the current image volume by the one given in parameters

Parameter ``anImageData``:
    the replacement image data

Parameter ``copy``:
    if it is set to true, performs a deep copy before replacing the
    image. If copy is set to false, only takes the smart pointer as
    input.

Parameter ``initialOrientation``:
    the initial orientation of the replacement image. If no
    orientation information is provided, assume the image orientation
    is RAI.)doc";

static const char *mkd_doc_camitk_ImageComponent_resetFrame = R"doc(Reset this object's FrameOfReference, that is call setFrame with a
newly created frame of reference. \note if the given object is an
ImageComponent, this will call setFramesAndTransformation using newly
created main and data frames, and a new transformation (preserving the
current main transformation matrix))doc";

static const char *mkd_doc_camitk_ImageComponent_rotationMatrix = R"doc(The rotation matrix, that might have been altered by the user Will be
saved in header file information as TransformMatrix tag.)doc";

static const char *mkd_doc_camitk_ImageComponent_sagittalSlices = R"doc(the sagittal slices representation (all intelligence is delegated to a
Slice class instance))doc";

static const char *mkd_doc_camitk_ImageComponent_selectionView = R"doc(Tab displaying data selected point in the property explorer)doc";

static const char *mkd_doc_camitk_ImageComponent_setFrame = R"doc(set the main FrameOfReference overriden to manage subcomponents
@warning if the transformation from the data frame to the new main
frame already exists, it will be used as the new main transformation,
removing the previous main transformation If there is currently no
transformation from the data frame to the new main frame, it will try
to create a new main transformation using the same matrix. If this
cannot be done, this generates a CamiTK error)doc";

static const char *mkd_doc_camitk_ImageComponent_setFrameFrom = R"doc(\note if the given object is an ImageComponent, this will call
setFramesAndTransformation using the object main and data frame and
its main transformation)doc";

static const char *mkd_doc_camitk_ImageComponent_setFramesAndTransformation = R"doc(* @name Frame management Override to force subComponents to have the
same data and main frame than this Component

@{ set the main and data FrameOfReference as well as the
transformation between them)doc";

static const char *mkd_doc_camitk_ImageComponent_setImageData = R"doc(Set the image data of the volumic images with the given orientation
options.

Parameter ``anImageData``:
    The main vtkImageData of the volumic image.

Parameter ``copy``:
    Indicate if we do a vtk deep copy of these data or directly work
    on the one provided.

Parameter ``initialOrientation``:
    Initial image orientation

Parameter ``initialTransformMatrix``:
    Initial image rotation (provided as a 4x4 matrix))doc";

static const char *mkd_doc_camitk_ImageComponent_setLastPointPickedFromPixel = R"doc(Set the last point picked coordinates to the center of the x,y,z voxel)doc";

static const char *mkd_doc_camitk_ImageComponent_setLut = R"doc(Update the lookup table of the image viewer (see InterfaceBitMap).)doc";

static const char *mkd_doc_camitk_ImageComponent_setMainTransformation = R"doc(Set main Transformation (dataFrame -> mainFrame) return false if the
main transformation was not modified (that is tr was nullptr))doc";

static const char *mkd_doc_camitk_ImageComponent_setSelected = R"doc(set selected will select all the Image components (axial, sagittal and
coronal).)doc";

static const char *mkd_doc_camitk_ImageComponent_setSingleImageComponents = R"doc(Set all single images. The only time this method should be used is
when you redefined the SingleImageComponent class. **Warning:** this
overwrite the original single image components. **Note:** if you need
to change only one of these SingleImageComponent instances, you'd
better use the getter methods on the remaining instances.

Parameter ``axialSlices``:
    the axial slices representation (use getAxialSlices() if you don't
    need to modify this particular orientation)

Parameter ``sagittalSlices``:
    the sagittal slices representation (use getSagittalSlices() if you
    don't need to modify this particular orientation)

Parameter ``coronalSlices``:
    the coronal slices representation (use getCoronalSlices() if you
    don't need to modify this particular orientation)

Parameter ``arbitrarySlices``:
    the arbitrary slices representation (use getArbitrarySlices() if
    you don't need to modify this particular orientation))doc";

static const char *mkd_doc_camitk_ImageComponent_setVisibility = R"doc(set the visibility inside the viewer of the given name (override
required to manage the specific case of the 3D viewer))doc";

static const char *mkd_doc_camitk_ImageComponent_toVariant = R"doc(* @name InterfacePersistence Customized InterfacePersistence methods
to support LUT

@{ Convert all data from the object to a QVariant (usually a
QVariantMap))doc";

static const char *mkd_doc_camitk_ImageComponent_updateCursor = R"doc(Update the cursor, to be called when the picked point changed or the
voxel size changed)doc";

static const char *mkd_doc_camitk_ImageComponent_updateImageComponents = R"doc(update the image components vtkImageData of all the available
SingleImageComponent)doc";

static const char *mkd_doc_camitk_ImageComponent_updateMainTransformation = R"doc(update the main transformation using the given 4x4 matrix)doc";

static const char *mkd_doc_camitk_ImageComponent_volumeRenderingChild = R"doc(When an action computes volume rendering for an image, it stores the
corresponding actor as a prop of this Component.)doc";


/* ----------------------------------------
   Docstrings for InterfaceBitMap
---------------------------------------- */

static const char *mkd_doc_camitk_InterfaceBitMap = R"doc(This class describes what are the methods to implement for a BitMap.
An InterfaceBitMap is a kind of simplifier/wrapper for vtkImageData.

This class defines an "interface" (in the OOP/java meaning of the
term). See the introduction of GoF: "Program to an interface, not an
implementation." To see what Erich Gamma has to say about it:
http://www.artima.com/lejava/articles/designprinciplesP.html To see
what Bjarne Stroustrup has to say about it:
http://www.artima.com/intv/modern.html

See also:
    Slice)doc";

static const char *mkd_doc_camitk_InterfaceBitMap_addProp = R"doc(insert an additional prop, defining it by its name (default visibility
= false)

Returns:
    true if the additional prop was added (i.e. another additional
    prop of the same name does not exist))doc";

static const char *mkd_doc_camitk_InterfaceBitMap_getImageData = R"doc(Returns the encapsultaed data structure: the image as a vtkImageData.)doc";

static const char *mkd_doc_camitk_InterfaceBitMap_getNumberOfColors = R"doc(Return the number of colors in the images. If color is coded on 1
byte, the images are on 256 grey level. If color is coded on 2 bytes,
the images are on 4096 grey level (not 65536).)doc";

static const char *mkd_doc_camitk_InterfaceBitMap_getNumberOfProp = R"doc(return the number of additional prop)doc";

static const char *mkd_doc_camitk_InterfaceBitMap_getNumberOfSlices = R"doc(Return the number of slices in the image data set.)doc";

static const char *mkd_doc_camitk_InterfaceBitMap_getPickPlaneActor = R"doc(Return the vtkActor used to pick pixels in the slices.)doc";

static const char *mkd_doc_camitk_InterfaceBitMap_getPixelActor = R"doc(Return the vtkActor used to pick pixels in the slices.)doc";

static const char *mkd_doc_camitk_InterfaceBitMap_getProp_1 = R"doc(Return the vtkProp (actors, volumes and annotations) corresponding to
the given name)doc";

static const char *mkd_doc_camitk_InterfaceBitMap_getProp_2 = R"doc(return an additional prop by its index)doc";

static const char *mkd_doc_camitk_InterfaceBitMap_getSlice = R"doc(Return the index of the current displayed slice.)doc";

static const char *mkd_doc_camitk_InterfaceBitMap_pixelPicked = R"doc(This method is called when the associated plane has been picked in the
InteractiveViewer, the given coordinates is position where the plane
was picked.)doc";

static const char *mkd_doc_camitk_InterfaceBitMap_removeProp = R"doc(remove a given additional prop.

Returns:
    true if effictively done)doc";

static const char *mkd_doc_camitk_InterfaceBitMap_setArbitraryTransform = R"doc(Set the pointer to the image transformation. this should be done once,
at initialization, using the frame transformation (getTransform))doc";

static const char *mkd_doc_camitk_InterfaceBitMap_setOriginalVolume = R"doc(set the original volume image data (the source vtkImageData before any
reslice) and refresh the vtk pipeline)doc";

static const char *mkd_doc_camitk_InterfaceBitMap_setPixelRealPosition = R"doc(move the pixel selection green indicator (pixelActor) to the given
real position)doc";

static const char *mkd_doc_camitk_InterfaceBitMap_setSlice_1 = R"doc(Set the current slice index. If the slice index is less than the first
slice index, the first slice is displayed. If the slice index is more
than the last slice index, the last slice is displayed.

Parameter ``s``:
    the index of the slice to display (base 0).)doc";

static const char *mkd_doc_camitk_InterfaceBitMap_setSlice_2 = R"doc(Set the slice corresponding to the given image coordinates (in RAI
convention))doc";

static const char *mkd_doc_camitk_InterfaceBitMap_updatePickPlane = R"doc(update the position of the plane surrounding the currently selected
slice)doc";


/* ----------------------------------------
   Docstrings for InterfaceFrame
---------------------------------------- */

static const char *mkd_doc_camitk_InterfaceFrame = R"doc(This class describes the methods to implement in order to manage a
Component position in space.

Each Component has a frame of reference which is used to define its
relation to other objects. You can define new frames and
transformations between frames as required, but all FrameOfReference
and Transformation objects must be managed by the
TransformationManager.

See also:
    TransformationManager)doc";

static const char *mkd_doc_camitk_InterfaceFrame_getAllFrames = R"doc(Get all FrameOfReference owned by this object @arg
includeChildrenFrames Include the frames of this object's children
along with its own

Returns:
    A multimap that associates each FrameOfReference to the objects
    that own it)doc";

static const char *mkd_doc_camitk_InterfaceFrame_getAllTransformations = R"doc(Get all Transformation owned by this object @arg
includeChildrenTransformations Include the Transformation of this
object's children along with its own

Returns:
    A multimap that associates each Transformation to the objects that
    own it)doc";

static const char *mkd_doc_camitk_InterfaceFrame_getFrame = R"doc(Get the pointer to this object's FrameOfReference. \note Please use
TransformationManager::getFrameOfReferenceOwnership(FrameOfReference*))doc";

static const char *mkd_doc_camitk_InterfaceFrame_getFrameAxisActor = R"doc(add a 3D Actor representing the Frame FIXME \note this is temporary,
the frame axis actor should be managed otherwise as the component
might not be the sole owner of its frame)doc";

static const char *mkd_doc_camitk_InterfaceFrame_getFrameVisibility = R"doc(get the visibility of the Frame axis actor FIXME \note this is
temporary, the frame axis actor should be managed otherwise as the
component might not be the sole owner of its frame)doc";

static const char *mkd_doc_camitk_InterfaceFrame_resetFrame = R"doc(Reset this object's FrameOfReference, that is call setFrame with a
newly created frame of reference.

.. note::
    you can reimplement this method if you need to manage more than
    this frame of reference (

See also:
    ImageComponent::setFrameFrom()))doc";

static const char *mkd_doc_camitk_InterfaceFrame_setFrame = R"doc(Set the FrameOfReference of this object. Note that this methods will
take ownership of the given frame thanks to the shared_ptr.)doc";

static const char *mkd_doc_camitk_InterfaceFrame_setFrameFrom = R"doc(Modify this object's frame using the given object's frame.

.. note::
    you can reimplement this method if you need to manage more than
    this frame of reference (

See also:
    ImageComponent::setFrameFrom()))doc";

static const char *mkd_doc_camitk_InterfaceFrame_setFrameVisibility = R"doc(set the visibility of the Frame axis actor FIXME \note this is
temporary, the frame axis actor should be managed otherwise as the
component might not be the sole owner of its frame)doc";


/* ----------------------------------------
   Docstrings for InterfaceGeometry
---------------------------------------- */

static const char *mkd_doc_camitk_InterfaceGeometry = R"doc(This class describes what are the methods to implement for a Geometry
(rendering parameters, input/output, filters, picking parameters...)

An InterfaceGeometry is a kind of simplifier/wrapper for vtkPointSet.

This class defines an "interface" (in the OOP/java meaning of the
term). See the introduction of GoF: "Program to an interface, not an
implementation." To see what Erich Gamma has to say about it:
http://www.artima.com/lejava/articles/designprinciplesP.html To see
what Bjarne Stroustrup has to say about it:
http://www.artima.com/intv/modern.html

See also:
    Geometry)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_RenderingMode = R"doc(@enum RenderingMode (and QFlags RenderingModes) handle actor rendering
options (render this InterfaceGeometry as a surface, a wireframe and
set of points).)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_addProp = R"doc(insert an additional prop, defining it by its name (default visibility
= false).

Returns:
    true if the additional prop was added (i.e. another additional
    prop of the same name does not exist))doc";

static const char *mkd_doc_camitk_InterfaceGeometry_cellPicked = R"doc(This method is called when a vtkCell included in the vtk
representation was picked.

This is the same as method getChildComponentFromVtkPointId, but for
CELL_PICKING.

A Component re-implementing this method can manage a specific
selection process (or any other suitable action).

Parameter ``cellId``:
    the vtkCell id that was selected by picking

Parameter ``pickingIsSelecting``:
    indicates if the current picking session is selecting or
    unselecting

See also:
    InteractiveViewer)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_getActor = R"doc(Return the actor for the representation mode, nullptr if the actor
doesn't exist.)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_getActorColor = R"doc(Get the color of given representation modes in the second parameter.

Parameter ``color``:
    the 4-sized double tab of color (r,g,b,a) of the actor.

Parameter ``ignoreEnhancedModes``:
    Return the color without considering the changes that may be due
    to enhanced modes (highlight) @warning color must points a 4
    double-sized tab minimum.)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_getActorOpacity = R"doc(Return the opacity of a given renderng mode.)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_getBoundingRadius = R"doc(compute the object's bounding sphere radius)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_getBounds = R"doc(compute the object's bounding box [xmin,xmax, ymin,ymax, zmin,zmax]

Parameter ``bounds``:
    the 6-sized double tab of the bounding box (in 3D). @warning
    bounds must points a 6 double-sized tab minimum.)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_getDataPort = R"doc(get the custom algorithm pipeline input. This method returns the
unmodified data that you have to use as an input for your
filter/algorithm. I.e. if you want to temporarily apply some
filter/algorithm to the InterfaceGeometry call this method to get the
input of your filter/algorithm pipeline. Typically, your custom
filter/algorithm connection should start with:

```
vtkSomeAlgorithm *startFilter = vtkSomeAlgorithm::New();
   startFilter->SetInputConnection(theAbstractGeometry->getDataPort());
   ...
   // in the end call setDataConnection()
```

See also:
    setDataConnection()

See also:
    Geometry)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_getEnhancedModes = R"doc(get the current enhanced mode)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_getNumberOfProp = R"doc(return the number of additional prop)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_getPointSet = R"doc(@name Vtk related @{ get the low-level vtk data)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_getProp_1 = R"doc(Return the vtkProp (actors, volumes and annotations) corresponding to
the given name)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_getProp_2 = R"doc(return an additional prop by its index)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_getRenderingModes = R"doc(Return if the actor associated to a rendering mode is currently
visible or not.)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_pointPicked = R"doc(This method is called when a vtkPoint included in the vtk
representation was picked.

When the picking mode is set in InteractiveViewer to POINT_PICKING the
vtk picker can select a specific vtkPoint in the big Geometry.

A Component re-implementing this method can manage a specific
selection process (or any other suitable action).

Parameter ``pointId``:
    the vtkPoint id that was selected by picking

Parameter ``pickingIsSelecting``:
    indicates if the current picking session is selecting or
    unselecting

See also:
    InteractiveViewer)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_removeProp = R"doc(remove a given additional prop.

Returns:
    true if effictively done)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_setActorColor_1 = R"doc(Set the color of given representation modes.

Parameter ``color``:
    the 4-sized double tab of color (r,g,b,a) of the actor. @warning
    color must points a 4 double-sized tab minimum.)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_setActorColor_2 = R"doc(Set the color of given representation modes.)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_setActorOpacity = R"doc(Set the opacity of this representation modes. WARNING color field
(surfaceColor, ...) are not modified!)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_setColor_1 = R"doc(Set an (r,g,b) color to all representation modes, without changing the
opacity.)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_setColor_2 = R"doc(Set an (r,g,b,a) color to all representation modes.)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_setDataConnection = R"doc(Set/reset the connection for the InterfaceGeometry internal algorithm.
This method sets the input for the InterfaceGeometry mapping/rendering
pipeline. Your should call this method to have the correct rendering
of your custom filter/algorithm pipelines. Typically, your custom
filter/algorithm connection should end with:

```
// begining of the custom filter/algorithm pipelines (don't forget to call getDataPort()!)
   ...
   theAbstractGeometry->setDataConnection(endFilter->GetOutputPort());
```

To remove your custom pipeline, either call setDataConnection(nullptr)
or theAbstractGeometry->setDataConnection(theAbstractGeometry-
>getDataPort())

See also:
    getDataPort()

See also:
    Geometry)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_setEnhancedModes = R"doc(set the enhanced mode)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_setGlyphType = R"doc(Set the glyph type (a glyph is a geometric representation attached to
every point in the input dataset). The glyph size is needed when the
type is not NoGlyph (the size value is used depending on the current
GlyphTypes) : - if type is Sphere, size is the radius for the sphere
(this is the default) - if type is NoGlyph, then no glyph are shown

To show the glyph call getProp("glyph")->SetVisibility(true) or
getProp("glyph")->VisibilityOn().

Parameter ``type``:
    the glyph type

Parameter ``size``:
    size of the glyph (default is 0.0))doc";

static const char *mkd_doc_camitk_InterfaceGeometry_setLinesAsTubes = R"doc(Set the lines as tubes (**works only for vtkDataSet representation
that contains lines**)

Parameter ``isTubes``:
    activate tube representation of lines

Parameter ``radiusFromLength``:
    radius of tubes is computed as a proportion of line length

Parameter ``radiusFactor``:
    radius of tubes will be : radiusFactor*lineLength if
    radiusFromLength is true, radiusFactor if it is false

Parameter ``numberOfSides``:
    Number of sides of the tubes)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_setMapperScalarRange = R"doc(Set the mapper scalar range)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_setMeshWorldTransform = R"doc(set the transformation for 3D representation)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_setOpacity = R"doc(Set the opacity of this object. WARNING color field (surfaceColor,
...) are not modified!)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_setPointData = R"doc(set the point data (may contains a lookup table). \note values have to
be in interval [0..1])doc";

static const char *mkd_doc_camitk_InterfaceGeometry_setPointPosition = R"doc(set a given point position)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_setPointSet = R"doc(set the low-level data set.

.. note::
    if there is already a vtkPointSet, this method calls DeepCopy(ds)

.. note::
    it is very important to overload this method in your Component
    subclass as this will be called by all the operators that operates
    a change directly on the data.)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_setRenderingModes = R"doc(@name rendering mode settings @{ Set the actor associated to a
rendering mode visible or not.)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_setTexture = R"doc(Set a texture to this object.)doc";

static const char *mkd_doc_camitk_InterfaceGeometry_updateLabel = R"doc(update position and text of the label prop)doc";


/* ----------------------------------------
   Docstrings for InterfaceNode
---------------------------------------- */

static const char *mkd_doc_camitk_InterfaceNode = R"doc(This class describe what are the methods to implement for a
hierarchical tree node.

An InterfaceNode can only have one parent, even if it is a child of
more than one InterfaceNodes.

Consequence: an InterfaceNode can be present many times in the
hierarchy, but can only depends from one parent. To add an
InterfaceNode as a child and change its parent to this use addChild().
To add an InterfaceNode as a child without modifying its parent, use
attachChild().

This class defines an "interface" (in the OOP/java meaning of the
term). See the introduction of GoF: "Program to an interface, not an
implementation." To see what Erich Gamma has to say about it:
http://www.artima.com/lejava/articles/designprinciplesP.html To see
what Bjarne Stroustrup has to say about it:
http://www.artima.com/intv/modern.html)doc";

static const char *mkd_doc_camitk_InterfaceNode_addChild = R"doc(add a child Component (sub item in the hierarchy), and modify the
child's parent to be equal to this instance

This is to be used with care. The preferred method to add a child
component is to use the Component's constructor with the parent
parameter: Component(Component *, const QString &, Representation rep)
.

See also:
    attachChild())doc";

static const char *mkd_doc_camitk_InterfaceNode_attachChild = R"doc(add a child Component (but leave its parent unchanged)

There can be some refresh problem, see the note in addChild())doc";

static const char *mkd_doc_camitk_InterfaceNode_deleteChildren = R"doc(delete all sub Component, but do not delete the pointer (only the top-
level component has the right to do that))doc";

static const char *mkd_doc_camitk_InterfaceNode_doubleClicked = R"doc(this method is called each time the InterfaceNode is double clicked by
the user.

Returns:
    a boolean telling if there was modification made in the Component
    due to this double click)doc";

static const char *mkd_doc_camitk_InterfaceNode_getChildren = R"doc(get the list of the InterfaceNode children (sub items in the
hierarchy))doc";

static const char *mkd_doc_camitk_InterfaceNode_getIcon = R"doc(Get the pixmap that will be displayed for this node. If you want your
component to have a nice pixmap displayed in the explorer, for
example, you just need to 1. declare a new static member and redefines
the getIcon() method (in MyComponent.h):

```
public:
  virtual QPixmap getIcon();
private:
  static QPixmap * myPixmap; // declare a ptr here (it is static for optimization)
```

2. add these lines in your code (in MyComponent.cpp):

```
// use this two lines or better use a Qt resource bundle (recommanded!)
#include "myComponent_pixmap.xpm" // include the pixmap resource file or use a Qt resource bundle
QPixmap * MyComponent::myPixmap = nullptr; // static initialization

QPixmap MyComponent::getIcon() {
  // check if the class instance was already used somewhere
  if (!myPixmap) {
    // create the pixmap from the data like this (or using the Qt resource bundle, see Qt documentation)
    myPixmap = new QPixmap(myComponent_pixmap); // myComponent_pixmap is the name of the char[] found in the .xpm file
  }
  // return the object (not the pointer
  return (*myPixmap);
}
```

And that all folks! A nice icon will be now used to display your
component!

.. note::
    Recommanded pixmap size is 20x20 (not nice, but efficient)...)doc";

static const char *mkd_doc_camitk_InterfaceNode_getName = R"doc(get the name to be displayed)doc";

static const char *mkd_doc_camitk_InterfaceNode_getNodeModified = R"doc(Get the current modification flag)doc";

static const char *mkd_doc_camitk_InterfaceNode_getParent = R"doc(get the parent Component)doc";

static const char *mkd_doc_camitk_InterfaceNode_getPopupMenu = R"doc(get the popup menu to display (or nullptr if inexistant))doc";

static const char *mkd_doc_camitk_InterfaceNode_inItalic = R"doc(should the name be displayed in italic?)doc";

static const char *mkd_doc_camitk_InterfaceNode_removeChild = R"doc(remove a sub Component (only the top-level component has the right to
do that))doc";

static const char *mkd_doc_camitk_InterfaceNode_setName = R"doc(set the name to be displayed)doc";

static const char *mkd_doc_camitk_InterfaceNode_setNodeModified = R"doc(Set up the node modification flag. This means that the name(s) or
children hierarchy were modified This can be useful information when a
viewer, such as the Explorer viewer, needs to know what to refresh)doc";

static const char *mkd_doc_camitk_InterfaceNode_setParent = R"doc(set the parent Component)doc";


/* ----------------------------------------
   Docstrings for InterfacePersistence
---------------------------------------- */

static const char *mkd_doc_camitk_InterfacePersistence = R"doc(Interface for all objects that should be serialized by the
PersistenceManager)doc";

static const char *mkd_doc_camitk_InterfacePersistence_fromVariant = R"doc(Load data from a QVariant to initialize the current object)doc";

static const char *mkd_doc_camitk_InterfacePersistence_getUuid = R"doc(Get the universally unique ID of the object to be saved)doc";

static const char *mkd_doc_camitk_InterfacePersistence_setUuid = R"doc(Set the universally unique ID of the object to be saved

Parameter ``id``:
    The value of the UUID to set. If you don't set this parameter, it
    will set a random UUID.

.. warning::
    DO NOT change the UUID of an object, set it only if it is null

Returns:
    If the current Uuid is not null, this returns false and does not
    modify the object)doc";

static const char *mkd_doc_camitk_InterfacePersistence_toVariant = R"doc(Convert all data from the object to a QVariant (usually a QVariantMap))doc";


/* ----------------------------------------
   Docstrings for InterfaceProperty
---------------------------------------- */

static const char *mkd_doc_camitk_InterfaceProperty = R"doc(This class describes what are the methods to implement in order to
manage dynamic properties. InterfaceProperty is one of the interfaces
implemented by the camitk::Component "Component" class.)doc";

static const char *mkd_doc_camitk_InterfaceProperty_addProperty = R"doc(Add a new CamiTK property to the component. If the property already
exist, it will just change its value.

.. note::
    The component takes ownership of the Property instance.

Returns:
    false if the Qt Meta Object property was added by this method
    (otherwise the property was already defined and true is returned
    if it was successfully updated))doc";

static const char *mkd_doc_camitk_InterfaceProperty_getHierarchy = R"doc(Get the inheritance hierachy of this Component instance as a list of
QString)doc";

static const char *mkd_doc_camitk_InterfaceProperty_getIndexOfPropertyExplorerTab = R"doc(Get the index of the tab in the PropertyExplorer to select for
display. The PropertyExplorer may feature several tabs of widget. This
method allows one to get the selected tab to display in a given context.

Returns:
    the index to select in the tab of the ProperlyExplorer.)doc";

static const char *mkd_doc_camitk_InterfaceProperty_getNumberOfPropertyWidget = R"doc(get the number of alternative property widgets

See also:
    PropertyExplorer)doc";

static const char *mkd_doc_camitk_InterfaceProperty_getProperty = R"doc(Get a Property given its name

Parameter ``name``:
    the property name

Returns:
    nullptr if the name does not match any property name

See also:
    Property)doc";

static const char *mkd_doc_camitk_InterfaceProperty_getPropertyObject = R"doc(get the property object that could be understood by PropertyEditor.
Returns this as any Component instance can manage its list of dynamic
properties (and Component inherits from InterfaceProperty aka
QObject). You can also have a separate class to manage your Component
properties. In this case, just override this method and return the
corresponding instance.

See also:
    PropertyExplorer

See also:
    ObjectController)doc";

static const char *mkd_doc_camitk_InterfaceProperty_getPropertyValue = R"doc(get the property QVariant (same as property(const char*)) but check if
it exists first. If the property was not declared using addProperty,
this methods prints an error message and returns an invalid QVariant)doc";

static const char *mkd_doc_camitk_InterfaceProperty_getPropertyWidgetAt = R"doc(get the ith alternative property widget override this method and use
the method setObjectName of QWidget if you want alternative widgets

See also:
    PropertyExplorer)doc";

static const char *mkd_doc_camitk_InterfaceProperty_isInstanceOf = R"doc(Assert that a Component instance really inherits from a given
className

Parameter ``className``:
    the name of the class to compare to)doc";

static const char *mkd_doc_camitk_InterfaceProperty_propertyValueChanged = R"doc(This method is called when a dynamic property value has been modified.
If you override this method, do not forget to call the superclass
method for the properties not managed locally in order to properly
manage all inherited dynamic properties. This method is called when a
dynamic property has been updated.

Use getPropertyValue(name) to get the current (updated) value of the
dynamic property.

Parameter ``name``:
    the name of the dynamic property)doc";

static const char *mkd_doc_camitk_InterfaceProperty_setIndexOfPropertyExplorerTab = R"doc(Set the index of the tab in the PropertyExplorer to select for
display. The PropertyExplorer may feature several tabs of widget. This
method allows one to select the tab to display in a given context.

Returns:
    the index to select in the tab of the ProperlyExplorer.)doc";

static const char *mkd_doc_camitk_InterfaceProperty_setPropertyValue = R"doc(set the property QVariant value (same as setProperty(const char*,
newValue)) but check if it exists first. If the property was not
declared using addProperty, this methods prints an error message and
returns false)doc";


/* ----------------------------------------
   Docstrings for Log
---------------------------------------- */

static const char *mkd_doc_camitk_Log = R"doc(This class is a log utility.

The aims of the log in CamiTK are: - to simplify and give a flexible
way to log message in any application - to be minimally invasive in
the source code - to help bug tracking and report - to help new
development by providing automatically generated debugging information
- to suppress any need to use qDebug macro or std::cout / std::cerr
"printf"

There are four types of message (

See also:
    InterfaceLogger): - ERROR error messages should be used only when
    a problem occurs that - cannot be taken care of by the source code
    - imply a preventive crash action - might result in unfinished
    process / undefined behaviour - WARNING warning messages should be
    used when something went wrong but is not critical to the
    application state but might require some corrective or alternative
    action by the user - INFO: information messages should be used to
    show normal processing, stage or intermediate step or display some
    useful data values - TRACE: trace messages should be used to trace
    anything useful for debugging or log post-processing

These messages are written using the corresponding CAMITK log macros:
CAMITK_ERROR, CAMITK_WARNING, CAMITK_INFO and CAMITK_TRACE.

For static methods and non QObject class, use the ALT CAMITK log
macros: CAMITK_ERROR_ALT, CAMITK_WARNING_ALT, CAMITK_INFO_ALT and
CAMITK_TRACE_ALT.

There are also specific IF CAMITK macros use to log only if a given
boolean expression is true: CAMITK_ERROR_IF, CAMITK_WARNING_IF,
CAMITK_INFO_IF and CAMITK_TRACE_IF.

And their corresponding counterparts for static methods or non QObject
class: CAMITK_ERROR_IF_ALT, CAMITK_WARNING_IF_ALT, CAMITK_INFO_IF_ALT
and CAMITK_TRACE_IF_ALT.

Depending on the current application logger log level, not all the
messages are displayed.

A default logger is instantiated for all application using the
CamiTKLogger class

See also:
    CamiTKLogger

The current log level can be set to - NONE in this case, no message
are logged. Logger is completely silent - ERROR only error messages
are logged - WARNING only WARNING and ERROR messages are logged - INFO
INFO, WARNING and ERROR messages are logged - TRACE all types of
messages are logged

A message box level is also available: any message equals or above the
message box level will be shown in a modal QMessageBox dialog.

Debug information are also available: it will automatically print the
method name, class or file name and line where the log message
originated. This is very useful during debug session.

Debug information are optional.

To log message, use the macro defined in this class header.

The log message time stamp can be turned on and off as well.

.. note::
    How to use the macro in the source: - Make sure that the file
    Log.h is correctly included in the current source code - Determine
    the level of your log message: ERROR, WARNING, INFO and TRACE - If
    the log message should be written only if a corresponding boolean
    expression is true, use the _IF version - If the log message is in
    a static method or a non QObject derived class (most CamiTK class
    derived from QObject), use the ALT version - Start the log message
    with an uppercase - Do not add the file, class, or method name,
    this is taken care of automatically by the debug information - The
    log message should be a QString: - use QString::number(..) to
    convert primitive numeric type to QString - use
    QString::fromStdString(..) to convert std::string

.. note::
    completely disabling log To void any log message, add the
    following line at the beginning of the CMakeLists.txt
    corresponding to the project you want to silence:

```
add_definitions(-DCAMITK_DISABLE_LOG)
# you can also also add "-DCAMITK_DISABLE_LOG" to the camitk_extension macro DEFINES option
```

This will transform all CAMITK log macro written in your code to null
function. Note that it will not void the camitkcore log entry (to have
absolutely no log at all, you need to compile CamiTK SDK with
"-DCAMITK_DISABLE_LOG"

Some simple examples:

```
unsigned int value = 4;

CAMITK_INFO(tr("Current value: %1").arg(QString::number(value)))  // tr(..) is for translation of string to other language
CAMITK_TRACE_IF((value<10), tr("Current value is a digit"))
```

.. note::
    if the source code is compiled with CAMITK_DISABLE_LOG defined,
    then any log macro results into a NOOP. This does not mean that
    there can't be any logger. In this case to add debug information
    you will explicitely have to call Log::getLogger()->log(...)

.. note::
    The default logger can be used/started at any time, even without
    any camitk application instance. In order to define the default
    log levels and parameter, you need to set the values before the
    camitk::Application is instantiated. If the default settings are
    modified by the user, they will automatically replace the default
    log values. Here is an example:

```
in main.cpp
...

 instantiate default CamiTKLogger and set default levels
 This level are used for the first run, and may be later overriden by the user if saved in the user settings
camitk::Log::getLogger()->setLogLevel(InterfaceLogger::INFO);
camitk::Log::getLogger()->setMessageBoxLevel(InterfaceLogger::WARNING);
 force to log all messages to a file as well as stdout
camitk::Log::getLogger()->setLogToFile(true);

 Say hello
CAMITK_INFO_ALT(tr("Logger started, log is written to file %1").arg(camitk::Log::getLogger()->getLogFileInfo().fileName()))
...

 init a camitk application context
camitk::Application a("camitk-myapp", argc, argv, true, true);
```

.. note::
    In order to force log settings and ignore user settings, you need
    modify the Application property object directly. For a CamiTK
    application, you can do that in the constructor of the
    camitk::Application inherited class (as the first lines for
    instance, if you don't want to miss anything):

```
MyCamiTKApplication::MyCamiTKApplication(int& argc, char** argv, QString inputFileName, QString outputDirectory) : Application("camitk-myapplication", argc, argv) {
 modify default log options for this application
setProperty("Log to File", true);
setProperty("Logger Level",InterfaceLogger::TRACE);
...
```

Or you can do that from outside (e.g. in the main.cpp), using the
application property object:

```
#include <PropertyObject.h>
...
main(..) {
 create a camitk application
MyCamiTKApplication myapp(argc, argv, ...);

 Force the log parameters and ignore the user saved settings, by directly changing the application properties
 so that it is recorded at every launch (overriding any previous user choice)
myapp.getPropertyObject()->setProperty("Logger Level",InterfaceLogger::INFO);
myapp.getPropertyObject()->setProperty("Message Box Level",InterfaceLogger::WARNING);
...
```

Available application property names linked to log settings: - "Logger
Level" - "Message Box Level" - "Log to Standard Output" - "Log to
File" - "Display Debug Information to Log Message" - "Display Time
Stamp Information to Log Message"

.. note::
    for MSVC users A (legacy) MS Windows header defines ERROR as a
    preprocessor macro. This header is unfortunately sometimes
    included in low-level library code. This will clash with the
    CAMITK_ERROR macro. Hints: if you use the CAMITK_ERROR or
    CAMITK_ERROR_ALT macro in your code and get these compilation
    errors: - error C2589: 'constant': illegal token on right side of
    '::' - error C2059: syntax error: '::' Move your
    #include&gt;Log.h> line at the end of your #include lines.
    Therefore #include &gtLog.h> should be the last #include
    directive.)doc";

static const char *mkd_doc_camitk_Log_getLevelAsString = R"doc(get the enum value as a text)doc";

static const char *mkd_doc_camitk_Log_getLevelFromString = R"doc(get the enum value from the text)doc";

static const char *mkd_doc_camitk_Log_getLogger = R"doc(get the current application logger)doc";

static const char *mkd_doc_camitk_Log_setLogger = R"doc(set the application logger and delete the previous logger Call this
method transfers the logger instance ownership to class Log.)doc";


/* ----------------------------------------
   Docstrings for MeshComponent
---------------------------------------- */

static const char *mkd_doc_camitk_MeshComponent = R"doc(Basic component to manage any kind of mesh.)doc";

static const char *mkd_doc_camitk_MeshComponent_DataType = R"doc(@enum DataType Data fields can have different dimensions)doc";

static const char *mkd_doc_camitk_MeshComponent_FieldType = R"doc(@enum FieldType Data fields can be applied to one of this)doc";

static const char *mkd_doc_camitk_MeshComponent_MeshComponent_1 = R"doc(Creates a top-level MeshComponent from a file.

.. note::
    this is only to be used from a Component Extension open(...) or
    from an Action that creates data from a filter or transformation
    of a vtkPointSet. This method may throw an AbortException if a
    problem occurs.

Please consider using MeshComponent(vtkSmartPointer<vtkPointSet> ,
const QString &))doc";

static const char *mkd_doc_camitk_MeshComponent_MeshComponent_2 = R"doc(Creates a top-level MeshComponent from a vtkPointSet (and instantiate
its 3D representation).

.. note::
    the filename is set to the empty string "".

.. note::
    if aPointSet is nullptr, the representation is not initialized, it
    is the responsibility of the subclass to initialize it later

Parameter ``aPointSet``:
    point set of the new MeshComponent

Parameter ``name``:
    name to be given to the Component)doc";

static const char *mkd_doc_camitk_MeshComponent_MeshComponent_3 = R"doc(Creates a MeshComponent as a sub component of another Component using
a vtkPointSet (and instantiate its 3D representation).

.. note::
    if aPointSet is nullptr, the representation is not initialized, it
    is the responsibility of the subclass to initialize it later

Parameter ``parentComponent``:
    the parent component of the new MeshComponent

Parameter ``aPointSet``:
    point set of the new MeshComponent

Parameter ``name``:
    name to be given to the new MeshComponent)doc";

static const char *mkd_doc_camitk_MeshComponent_SpecificRepresentation = R"doc(@enum SpecificRepresentation 3D data can be represented by 1 value in
different ways)doc";

static const char *mkd_doc_camitk_MeshComponent_VectorRepresentation = R"doc(@enum VectorRepresentation how are vector data represented in 3D)doc";

static const char *mkd_doc_camitk_MeshComponent_addCellData = R"doc(Add a data array linked to the cells.

Parameter ``name``:
    name

Parameter ``data``:
    data array)doc";

static const char *mkd_doc_camitk_MeshComponent_addDataArray = R"doc(Add a data array.

Parameter ``fieldType``:
    field type

Parameter ``name``:
    name given to the array to add

Parameter ``data``:
    data array)doc";

static const char *mkd_doc_camitk_MeshComponent_addPointData = R"doc(Add a data array linked to the points.

Parameter ``name``:
    name

Parameter ``data``:
    data array)doc";

static const char *mkd_doc_camitk_MeshComponent_addSelection = R"doc(Add a selection.

If the name of the selection already exists, the data of the existing
selection are updated according to the SelectionPolicy flag.

Parameter ``name``:
    name of the selection

Parameter ``fieldType``:
    field type of the selection (one of
    vtkSelectionNode::SelectionField)

Parameter ``contentType``:
    content type (one of vtkSelectionNode::SelectionContent)

Parameter ``array``:
    array of the selection

Parameter ``policy``:
    policy to update the existing selection

Returns:
    the index of the added selection in the selection list)doc";

static const char *mkd_doc_camitk_MeshComponent_addToSelectedSelection = R"doc(Add a selection to the currently selected selection.

If there is no selected selection, one is created with the name
"Picked Selection".

Parameter ``fieldType``:
    field type of the selection (one of
    vtkSelectionNode::SelectionField)

Parameter ``contentType``:
    content type (one of vtkSelectionNode::SelectionContent)

Parameter ``array``:
    array of the selection

Parameter ``policy``:
    policy to updated the selection selection

Returns:
    the index of the selected selection in the selection list)doc";

static const char *mkd_doc_camitk_MeshComponent_cellPicked = R"doc(reimplemented to save the last pick point id)doc";

static const char *mkd_doc_camitk_MeshComponent_changeSelectedSelection = R"doc(called when the selection is modified)doc";

static const char *mkd_doc_camitk_MeshComponent_createDataRepresentation = R"doc(create the data representation of a given data (identified with its
name) of a given field type, default visibility is off)doc";

static const char *mkd_doc_camitk_MeshComponent_currentSelection = R"doc(manages current selection using vtk)doc";

static const char *mkd_doc_camitk_MeshComponent_dataModel = R"doc(data model (model as the M in Qt MVC design pattern))doc";

static const char *mkd_doc_camitk_MeshComponent_dataRepresentationVisibility = R"doc(map of visibility status of data)doc";

static const char *mkd_doc_camitk_MeshComponent_dataView = R"doc(data GUI View (view as the V in Qt MVC design pattern))doc";

static const char *mkd_doc_camitk_MeshComponent_dataWidget = R"doc(selection widget)doc";

static const char *mkd_doc_camitk_MeshComponent_displayTypePolicyBox = R"doc(combo box to select how to display vector data (data with 3
components))doc";

static const char *mkd_doc_camitk_MeshComponent_displayTypePolicyChanged = R"doc(called when the datatype for vector data is modified (refresh the data
model))doc";

static const char *mkd_doc_camitk_MeshComponent_fromVariant = R"doc(Load data from a QVariant to initialize the current object)doc";

static const char *mkd_doc_camitk_MeshComponent_getActiveSelection = R"doc(Get active selections

Returns:
    active selections)doc";

static const char *mkd_doc_camitk_MeshComponent_getDataArray_1 = R"doc(Get the data array of specified field type and name.

Parameter ``fieldType``:
    field type

Parameter ``arrayName``:
    array name

Returns:
    data array)doc";

static const char *mkd_doc_camitk_MeshComponent_getDataArray_2 = R"doc(Get the data array of specified field type and index.

Parameter ``fieldType``:
    field type

Parameter ``index``:
    index

Returns:
    data array)doc";

static const char *mkd_doc_camitk_MeshComponent_getDataModel = R"doc(Returns the current data view model (model as the M in Qt MVC design
pattern))doc";

static const char *mkd_doc_camitk_MeshComponent_getDataRepresentationVisibility = R"doc(get the current visibility status of a given data (identified with its
name) of a given field type)doc";

static const char *mkd_doc_camitk_MeshComponent_getDataType = R"doc(Returns the data type of a data array depending on the number of
components of the given data array:)doc";

static const char *mkd_doc_camitk_MeshComponent_getDataTypeName_1 = R"doc(Helper method that returns the datatype as a string)doc";

static const char *mkd_doc_camitk_MeshComponent_getDataTypeName_2 = R"doc(Returns the data type string of an data array depending on the number
of components of the given data array: If the number of components is
different than 1, 3 and 9 (the managed type SCALARS, VECTORS, TENSORS)
then the method returns a string equals to the number of components.)doc";

static const char *mkd_doc_camitk_MeshComponent_getDataTypeNames = R"doc(static method that returns the DataType enum as a QString)doc";

static const char *mkd_doc_camitk_MeshComponent_getFieldData = R"doc(Returns the corresponding vtkFieldData (point data, cell data or field
data))doc";

static const char *mkd_doc_camitk_MeshComponent_getFieldName = R"doc(helper method that returns the field type as a string)doc";

static const char *mkd_doc_camitk_MeshComponent_getFieldNames = R"doc(@name Enum management and helper methods @{

static method that returns the FieldType enum as a QString)doc";

static const char *mkd_doc_camitk_MeshComponent_getIcon = R"doc(Get the pixmap that will be displayed for this node)doc";

static const char *mkd_doc_camitk_MeshComponent_getNumberOfDataArray = R"doc(Get the number of data arrays of a given type without taking the
specific representation into account.

This method does not take into account: - the field arrays - the
specific representation of 3D data (i.e., representation of 3D data as
norm or component#i values)

Parameter ``fieldFlag``:
    is a FieldType or a combinaison of field types.

Returns:
    the number of arrays corresponding to the field flag)doc";

static const char *mkd_doc_camitk_MeshComponent_getNumberOfPropertyWidget = R"doc(there is more than one property widgets (to view as tabs in the
property explorer))doc";

static const char *mkd_doc_camitk_MeshComponent_getNumberOfSelections = R"doc(Get the number of selections.

Returns:
    the number of selections.)doc";

static const char *mkd_doc_camitk_MeshComponent_getPickedCellId = R"doc(get the last pick point id,

Returns:
    -1 if no point where picked)doc";

static const char *mkd_doc_camitk_MeshComponent_getPickedPointId = R"doc(get the last pick point id,

Returns:
    -1 if no point where picked)doc";

static const char *mkd_doc_camitk_MeshComponent_getPropertyWidgetAt = R"doc(the proprety widgets are: default property widget, selection view and
data view)doc";

static const char *mkd_doc_camitk_MeshComponent_getSelection = R"doc(Get a selection from its name.

TODO This method should return a const ref, so that external code
cannot modify it

Parameter ``name``:
    name of the selection

Returns:
    the selection node)doc";

static const char *mkd_doc_camitk_MeshComponent_getSelectionAt = R"doc(Get a selection from its index in the list.

TODO This method should return a const ref, so that external code
cannot modify it

Parameter ``index``:
    index of the selection

Returns:
    the selection node)doc";

static const char *mkd_doc_camitk_MeshComponent_getSelectionIndex = R"doc(Get the selection index in the list from its name.

Parameter ``name``:
    name of the selection

Returns:
    the selection index or -1 if there is no selection of that name)doc";

static const char *mkd_doc_camitk_MeshComponent_getSelections = R"doc(Get the selection list.

The selection list contains vtkSelectionNode.

.. note::
    TODO This method should be const, in case a subcomponent needs to
    add extra/specific behavior. And then: - To loop over selections,
    use getNumberOfSelections() and getSelectionAt(). - To remove
    selection, use removeSelection(). - To add selections, use
    addSelection() or addToSelectedSelection().

Returns:
    the selection list)doc";

static const char *mkd_doc_camitk_MeshComponent_getSpecificRepresentationName = R"doc(Helper method that returns the SpecificRepresentation as a QString)doc";

static const char *mkd_doc_camitk_MeshComponent_init = R"doc(initialisation of the mesh component members)doc";

static const char *mkd_doc_camitk_MeshComponent_initData = R"doc(initialize data)doc";

static const char *mkd_doc_camitk_MeshComponent_initDataNames = R"doc(initialize DataType QString map)doc";

static const char *mkd_doc_camitk_MeshComponent_initDynamicProperties = R"doc(create and initialize dynamic properties)doc";

static const char *mkd_doc_camitk_MeshComponent_initFieldNames = R"doc(initialize FieldType QString map)doc";

static const char *mkd_doc_camitk_MeshComponent_initRepresentation_1 = R"doc(build the instance of Geometry from the given vtkPointSet)doc";

static const char *mkd_doc_camitk_MeshComponent_initRepresentation_2 = R"doc(the concrete building of the 3D objects (Slice/Geometry): none in this
case, everything is done by initRepresentation(vtkPointSet))doc";

static const char *mkd_doc_camitk_MeshComponent_initSelection = R"doc(initialize selections)doc";

static const char *mkd_doc_camitk_MeshComponent_initialFrameOfReference = R"doc(the initial frame created by this mesh (useful in case renaming may
also rename the frame))doc";

static const char *mkd_doc_camitk_MeshComponent_insertionPolicyBox = R"doc(combo box to select the selection insertion policy)doc";

static const char *mkd_doc_camitk_MeshComponent_inspectData = R"doc(action to inspect data)doc";

static const char *mkd_doc_camitk_MeshComponent_inspectSelection = R"doc(action to inspect selection)doc";

static const char *mkd_doc_camitk_MeshComponent_isInInitRepresentation = R"doc(this bool is set to true during initRepresentation(vtkPointSet) and is
used to avoid unnecessary calls to refresh())doc";

static const char *mkd_doc_camitk_MeshComponent_mergeSelection = R"doc(action to merge selections)doc";

static const char *mkd_doc_camitk_MeshComponent_numberOfCellDataSpecificRepresentation = R"doc(number of specific 3D representation for cell data)doc";

static const char *mkd_doc_camitk_MeshComponent_pickedCellId = R"doc(the last picked cell)doc";

static const char *mkd_doc_camitk_MeshComponent_pickedPointId = R"doc(the last picked point)doc";

static const char *mkd_doc_camitk_MeshComponent_pointPicked = R"doc(reimplemented to save the last pick point id)doc";

static const char *mkd_doc_camitk_MeshComponent_removeData = R"doc(action to remove data)doc";

static const char *mkd_doc_camitk_MeshComponent_removeDataArray = R"doc(Remove a data array.

Parameter ``fieldType``:
    field type

Parameter ``name``:
    name of the array to remove)doc";

static const char *mkd_doc_camitk_MeshComponent_removeSelectedData = R"doc(remove the selected selection)doc";

static const char *mkd_doc_camitk_MeshComponent_removeSelectedSelections = R"doc(remove the selected selection)doc";

static const char *mkd_doc_camitk_MeshComponent_removeSelections = R"doc(action to remove selections)doc";

static const char *mkd_doc_camitk_MeshComponent_selectionList = R"doc(list of selections)doc";

static const char *mkd_doc_camitk_MeshComponent_selectionModel = R"doc(selection model (model as the M in Qt MVC design pattern))doc";

static const char *mkd_doc_camitk_MeshComponent_selectionView = R"doc(selection GUI View (view as the V in Qt MVC design pattern))doc";

static const char *mkd_doc_camitk_MeshComponent_selectionWidget = R"doc(selection widget)doc";

static const char *mkd_doc_camitk_MeshComponent_setDataRepresentationOff = R"doc(hide all the data representation of a given data type (hide all by
default) By default this->refresh() is called unless blockRefresh is
set to true)doc";

static const char *mkd_doc_camitk_MeshComponent_setDataRepresentationVisibility = R"doc(set the visibility of a given representation for a given data
(identified by its name) of a given field type (create it if needed)
By default this->refresh() is called unless blockRefresh is set to
true)doc";

static const char *mkd_doc_camitk_MeshComponent_setName = R"doc(set the component name and update frame name)doc";

static const char *mkd_doc_camitk_MeshComponent_setScalarDataRepresentationOn = R"doc(show the specific scalar array)doc";

static const char *mkd_doc_camitk_MeshComponent_toVariant = R"doc(* @name InterfacePersistence Customized InterfacePersistence methods
to support geometry data (e.g. color)

@{ Convert all data from the object to a QVariant (usually a
QVariantMap))doc";

static const char *mkd_doc_camitk_MeshComponent_vectorActors = R"doc(list of all vector data 3D actors' names (needed for cleaning up))doc";

static const char *mkd_doc_camitk_MeshComponent_vectorRepresentationPolicyBox = R"doc(combo box to select how the vector are represented in 3D)doc";

static const char *mkd_doc_camitk_MeshComponent_vectorRepresentationPolicyChanged = R"doc(called when the representation for vector data is modified (remove all
actors and refresh the data model))doc";


/* ----------------------------------------
   Docstrings for Property
---------------------------------------- */

static const char *mkd_doc_camitk_Property = R"doc(This class describes a property that can be used in components and
actions or any class that needs to be passed to ObjectController. A
property has a type, a description (to be displayed for example as a
tooltip, can be rich-text, see https://doc.qt.io/qt-5/richtext-html-
subset.html for supported html tags), a value, a unit of measurement
(SI unit if possible), and some specific attributes (that depends on
the type, e.g. minimal and maximal values, single steps, number of
decimals, regular expression...). An enum type can also be used for
properties.

Properties can be grouped in subgroups, see Property::setGroupName().

Basically this is a way to overcome the Qt Meta Object properties
limitations. A camitk::Property enriches a Qt Meta Object property (a
very simplified Decorator Design Pattern).

Using camitk::Property instead of directly using Qt Meta Object
property helps to build a better interactive GUI (in the property
explorer for components and in the ActionWidget for actions). Note
that a camitk::Property is represented as a regular Qt Meta Object
property as well (the value of the camitk::Property is in fact stored
by the Qt Meta Object property)

Here are some examples to get started with:

```
Demonstrates how rich text can be used in description
addParameter(new Property("Bool Prop", false, "This a <i>normal</i> bool property.<br/>**Note:** Rich text description!<br/>See also: <a href=\"http://camitk.imag.fr\">CamiTK web page</a>", ""));

 beware: the action takes ownership of the Property pointer
 This means that the line above does not generate memory leak.

 Demonstrates how properties can be set as read-only
 Demonstrates how properties can be grouped.
 Here all read-only properties are assemble in the same eponymic group
Property *readOnlyBool = new Property("Read Only Bool", true, "This a read-only boolean", "");
readOnlyBool->setReadOnly(true);
readOnlyBool->setGroupName("Read Only Properties");
addParameter(readOnlyBool);

 beware: the action takes ownership of the Property pointer
 This means that you should NOT delete readOnlyBool in the action destructor

 Demonstrates how integer properties can be bounded
Property *boundedInt = new Property("Bounded Int", 12, "An integer bounded between 0 and 20", "");
boundedInt->setAttribute("minimum", 0);
boundedInt->setAttribute("maximum", 20);
boundedInt->setGroupName("Numeric Properties");
addParameter(boundedInt);

 Demonstrates how double properties can be half-bounded
Property *doubleWithMax = new Property("Double With Max", -10.0, "A double with a max value of -4.2", "");
doubleWithMax->setAttribute("maximum", -4.2);
doubleWithMax->setGroupName("Numeric Properties");
addParameter(doubleWithMax);

Property *intWithSingleStep = new Property("Int With Single Step", -10, "An integer with a single step of <i>5</i>", "");
intWithSingleStep->setAttribute("singleStep", 5);
intWithSingleStep->setGroupName("Numeric Properties");
addParameter(intWithSingleStep);

Property *doubleWithStepAndDecimal = new Property("Double With Single Step And Precision", 3.14159, "A double with 5 decimals and a single step of 1.10<sup>-5</sup>", "");
doubleWithStepAndDecimal->setAttribute("singleStep", 10e-6);
doubleWithStepAndDecimal->setAttribute("decimals", 5);
doubleWithStepAndDecimal->setGroupName("Numeric Properties");
addParameter(doubleWithStepAndDecimal);

Property *intWithDecimal = new Property("Int With Precision", 4, "An integer with a precision set to 5 decimals: this should not affect it.", "");
intWithDecimal->setAttribute("decimals", 5);
intWithDecimal->setGroupName("Numeric Properties");
addParameter(intWithDecimal);

Property *readOnlyQVector3D = new Property("Read Only QVector3D", QVector3D(-4.0, 2.0, 0.1), "A read-only QVector3D", "");
readOnlyQVector3D->setReadOnly(true);
readOnlyQVector3D->setGroupName("Read Only Properties");
addParameter(readOnlyQVector3D);

Property *stringWithRegExp = new Property("QString Constrained by RegExp", QString("loweronly"), "A QString constrained to lowercase characters only (no separators, numbers...)", "");
stringWithRegExp->setAttribute("regExp", QRegularExpression("[a-z]*"));
addParameter(stringWithRegExp);

Property *constrainedQRect = new Property("Constrained QRect", QRect(10,10,20,20), "A QRect constrained to (0,0,50,50)", "");
constrainedQRect->setAttribute("constraint", QRect(0,0,50,50));
addParameter(constrainedQRect);

Property *constrainedQVector3D = new Property("Constrained QVector3D", QVector3D(1.1, 2.2, 3.3), "A constrained QVector3D (not yet implemented)", "");
constrainedQVector3D->setAttribute("constraint", QVector3D(10.0, 10.0, 10.0));
addParameter(constrainedQVector3D);
```

.. note::
    To create a new Property, prefer using Property. To check if a
    Property has been added to your Component / Action, use either
    Component::getProperty() or Action::getProperty() methods. To
    modify an existing Property's value, check if it exists: - if not,
    create a new instance of Property - if yes, directly modify its
    value by using QObject::setProperty() method.e

The GUI interaction is automatically build and managed by the class
ObjectController.

An example for adding properties to an action can be seen in
tutorials/actions/properties. More specifically see the
EnumPropertyExample action to learn about how to use enum properties.

The class PropComponent and PropAction in the tutorials demonstrates
how to use camitk::Property instead of Qt Meta Object Property.

The available property types are:

Property Type | Property Type Id ------------- | ----------------- int
| QVariant::Int double | QVariant::Double bool | QVariant::Bool
QString | QVariant::String QVector3D | QVariant::QVector3D QColor |
QVariant::Color QDate | QVariant::Date QTime | QVariant::Time QChar |
QVariant::Char QDateTime | QVariant::DateTime QPoint | QVariant::Point
QPointF | QVariant::PointF QKeySequence | QVariant::KeySequence
QLocale | QVariant::Locale QSize | QVariant::Size QSizeF |
QVariant::SizeF QRect | QVariant::Rect QRectF | QVariant::RectF
QSizePolicy | QVariant::SizePolicy QFont | QVariant::Font QCursor |
QVariant::Cursor enum | enumTypeId() flag | flagTypeId() group |
groupTypeId()

Possible attributes depends on the property type, mostly (see also
QtVariantPropertyManager API doc): Property Type | Attribute Name |
Attribute Type ------------- | :------------: | :------------: ``int``
| minimum | QVariant::Int ``int`` | maximum | QVariant::Int ``int`` |
singleStep | QVariant::Int ``double`` | minimum | QVariant::Double
``double`` | maximum | QVariant::Double ``double`` | singleStep |
QVariant::Double ``double`` | decimals | QVariant::Int QString |
regExp | QVariant::RegExp QDate | minimum | QVariant::Date QDate |
maximum | QVariant::Date QPointF | decimals | QVariant::Int QSize |
minimum | QVariant::Size QSize | maximum | QVariant::Size QSizeF |
minimum | QVariant::SizeF QSizeF | maximum | QVariant::SizeF QSizeF |
decimals | QVariant::Int QRect | constraint | QVariant::Rect QRectF |
constraint | QVariant::RectF QRectF | decimals | QVariant::Int
``enum`` | enumNames | QVariant::StringList (note that this can be
build automatically) ``flag`` | flagNames (NOT IMPLEMENTED YET) |
QVariant::StringList

.. note::
    Anywhere in your code use the property(..).toInt() method to get
    the classical enum value of the property, and use
    Property::getEnumValueAsString() to get the enum value as a
    string. If you declared your enum using Q_ENUM (Qt>=5.5), you can
    also use directly QMetaEnum::fromType to retrieve the enum value
    as strings (see below).

.. note::
    If your property is an action parameter, it is safer to use the
    dedicated methods getParameterValue(..), setParameterValue(..),
    getParameterValueAsString(..) as they will first check that the
    given parameter name is a declared parameter. For component
    properties, it is safer to use the dedicated methods
    getPropertyValue(..) and setPropertyValue(..) as they will also
    first check that the given property name is a declared property.

.. note::
    For enums, you need to do few things in the C++ class that has a
    enum typed property: - add Q_underscore_OBJECT macro in your class
    declaration - either setup a new enum (option 1) or just fill in
    strings in the enum names (option 2)

For option 1, you need - add the enum type in your class declaration -
register your enum name using the Q_ENUM macro in your class
declaration - register the enum type name to the property using the
Property::setEnumTypeName (see example below)

For option 2 (recommended), just - create a QStringList with the GUI
strings - use the Property::setAttribute("enumNames", yourQStringList)

.. note::
    Using option 2 is recommended as it will allow you to dynamically
    update the enum names at any time (for instance if you want to
    select a component, you can update the enum names using the
    currently opened components).

You can change the enum value names in the GUI using the "enumNames"
attributes. There is also a way to automatically build nicer enumNames
(see below).

Enum icons might be set using Property::setEnumIcons.

For instance in the header:

```
class MyAction : public camitk::Action {
 Really needed! (replace ‗ by _ in your code if you copy-paste this snippet)
Q‗OBJECT

-- option 1
 declare the C++ enum
enum MyEnum {
PossibleValue1,
PossibleValue2
};
 register the enum (Qt >= 5.5)
Q_ENUM(MyEnum)

-- option 2 (recommended)
 -> nothing to declare in the header
...
};
```

And then in the code:

```
MyAction::MyAction(ActionExtension * extension) : Action(extension) {
...
-- option 1
 build the dynamic prop based on the enumeration
Property *enumProp = new Property("My Enumeration", MyAction::PossibleValue2, "Enumeration support example","");
 register the enum type name for automatically manage the enum as a popup list
enumProp->setEnumTypeName("MyEnum",this);
 The Property class automatically build the enum names presented to the user in the GUI
 (it will changed the enum literals to get a cleaner look, e.g. PossibleValue1 becomes "Possible Value 1")

 OR

-- option 2 (recommended)
 build the dynamic prop based on a custom string list
Property *enumProp = new Property("My Enumeration", 0 /-* index of the initial value in the string list *-/, "Enumeration support example","");
 Set the enum names of your choice, using the enumNames property:
enumProp->setEnumTypeName("MyEnum");
 add strings to populate the GUI
QStringList enumValues;
enumValues << "Possible Value #1" << "Possible Value #2";
enumProp->setAttribute("enumNames", enumValues);

-- after either option 1 or 2: register the new prop as an action parameter
addParameter(enumProp);
}

...

-- option 1 usage
 option 1.1: get the value as classical C++ enum
MyEnum enumPropCurrentValue = (MyEnum) getParameterValue("My Enumeration").toInt();

 option 1.2: get the value as a QString (either "PossibleValue1" or "PossibleValue2", beware: this is different from the GUI names), you need the enumProp pointer
QString enumPropAsString = enumProp->getEnumValueAsString(this);

 option 1.3: using the Q_ENUM declaration in the header, get the value using Qt meta object
QMetaEnum metaEnum = QMetaEnum::fromType<EnumerationExample>();
QString enumPropAsStringDirect = metaEnum.valueToKey(enumPropCurrentValue);

-- option 2 usage (recommended)
QString QString enumPropAsString = enumValues.value(getParameterValue("My Enumeration").toInt()
```

.. note::
    This is not exactly a decorator design pattern, as the Property
    class is not abstract. The Qt Meta Object is still held by the
    QtObject inherited class (e.g. Component or Action). The
    camitk::Property class adds description, readOnly status and
    specific attributes to a QObject dynamic property.)doc";

static const char *mkd_doc_camitk_Property_Property_1 = R"doc(Constructor. The variant parameters also allows you to initialize the
value of the property. By default a Property is enabled and editable
(i.e. by default it is not read-only)

Parameter ``name``:
    property name (unique identifier of your class property

Parameter ``variant``:
    specify the property type (QVariant) and initial value

Parameter ``description``:
    a sentence or two to describe the property (and its unit if any),
    can be Rich Text

Parameter ``unit``:
    a unit of measurement (in SI unit), use symbols from
    https://en.wikipedia.org/wiki/SI_base_unit or
    https://en.wikipedia.org/wiki/SI_derived_unit when possible)doc";

static const char *mkd_doc_camitk_Property_Property_2 = R"doc(Copy constructor (needed for python module))doc";

static const char *mkd_doc_camitk_Property_attributeValues = R"doc(map containing all the attributes and their values)doc";

static const char *mkd_doc_camitk_Property_description = R"doc(description of the property, can be rich text)doc";

static const char *mkd_doc_camitk_Property_enumIcons = R"doc(map containing all the icons for the enum)doc";

static const char *mkd_doc_camitk_Property_enumTypeName = R"doc(if the property's type is an enum, this is the Qt registered enum
name, otherwise it is the null string)doc";

static const char *mkd_doc_camitk_Property_getAttribute = R"doc(get the current value of a given attribute, see setAttribute() if the
attribute attName was never set using setAttribute(), the return
QVariant is invalid. To test if a QVariant is invalid, use the
QVariant::isValid() method e.g.: if
(!myProp.getAttribute("bad").isValid()) { CAMITK_INFO(tr("myProp does
not have an attribute 'bad' (or this attribute is still equals to the
default value)")) }

It is recommended to only use this method inside a foreach(QString s:
getAttributeList()))doc";

static const char *mkd_doc_camitk_Property_getAttributeList = R"doc(returns the list of attribute names that are specific to this property)doc";

static const char *mkd_doc_camitk_Property_getDescription = R"doc(get the description)doc";

static const char *mkd_doc_camitk_Property_getEnumIcons = R"doc(get the enum icons)doc";

static const char *mkd_doc_camitk_Property_getEnumTypeName = R"doc(Returns:
    the name of the Qt registered enum if the property's type is an
    enum, the null string otherwise (can be tested against QString
    isNull() method))doc";

static const char *mkd_doc_camitk_Property_getEnumValueAsString = R"doc(Utility method to get the current property value as a string. The
string corresponds one of the enum values: not the gui enum values set
using setAttribute("enumNames"...)

If the property's type is an enum, this is the string corresponding to
its value (the property value can be accessed, the normal way using
the QVariant toInt() to get the int value (classical C++ enum value)

Parameter ``objectDeclaringTheEnum``:
    is a pointer to the object instantiated from the class that
    declared the enum

Returns:
    the enum value as QString.)doc";

static const char *mkd_doc_camitk_Property_getGroupName = R"doc(get this property subgroup's name

Returns:
    the group name or the null QString if no group were set, it can be
    tested with QString::isNull().)doc";

static const char *mkd_doc_camitk_Property_getInitialValue = R"doc(return the initial (default) value)doc";

static const char *mkd_doc_camitk_Property_getName = R"doc(get the name of the property)doc";

static const char *mkd_doc_camitk_Property_getProperty = R"doc(get the camitk::Property decoration of a named property of the given
QObject or nullptr if object does not have any camitk::Property

.. note::
    If object is an instance of a class that declares a Q_INVOKABLE
    getProperty(QString) method, it means that a Qt Property
    "decoration" was stored. In this case, this method returns the
    result of getProperty(name) (i.e., it is expected that the result
    won't b nullptr if the named property is found.

Parameter ``object``:
    The QObject to check

Parameter ``name``:
    The property name to look for

Returns:
    the pointer to the camitk::Property corresponding to the CamiTK
    Property of the named property)doc";

static const char *mkd_doc_camitk_Property_getPropertyInformation = R"doc(Get the CamiTK property information as QJsonObject If name is the name
of a CamiTK property of the given object, this method returns a
QJsonObject that contains the following keys: "name", "type",
"defaultValue", "readOnly", "unit"...

Returns:
    the CamiTK property information as QJsonObject or an empty
    QJsonObject if name is not a CamiTK property of object)doc";

static const char *mkd_doc_camitk_Property_getReadOnly = R"doc(Returns:
    true only if this property is read-only)doc";

static const char *mkd_doc_camitk_Property_getUnit = R"doc(get the unit)doc";

static const char *mkd_doc_camitk_Property_getValueAsString = R"doc(Transform a QVariant to a QString representation)doc";

static const char *mkd_doc_camitk_Property_groupName = R"doc(name of the group in which this property is classified (null if no
group name were set))doc";

static const char *mkd_doc_camitk_Property_initialValue = R"doc(initial value of the property, Only needed between the time when the
property is instantiated and the time it is created by the Component
or Action as a Qt Meta Property. Once the Qt Meta Property is created,
the value of the property is managed by the Qt Meta Property.)doc";

static const char *mkd_doc_camitk_Property_name = R"doc(name of the property)doc";

static const char *mkd_doc_camitk_Property_readOnly = R"doc(is the property read only)doc";

static const char *mkd_doc_camitk_Property_setAttribute = R"doc(Set a given property for this attribute. Note that not all the
attributes are not usable for all property type (see table above). The
supported attribute names are (see QtVariantPropertyManagerPrivate()
constructor): - "maximum" - "minimum" - "singleStep" - "decimals" -
"constraint" - "enumNames" - "regExp"

Parameter ``attribute``:
    name of the attribute

Parameter ``value``:
    value of this attribute)doc";

static const char *mkd_doc_camitk_Property_setDescription = R"doc(set the description (can be rich text))doc";

static const char *mkd_doc_camitk_Property_setEnumIcons = R"doc(set the icons for all the enums)doc";

static const char *mkd_doc_camitk_Property_setEnumTypeName_1 = R"doc(if the property's type is an enum, set the name of the registered Qt
Enum. The enum names that will appear in the GUI will have to be given
by setting the "enumNames" attribute.)doc";

static const char *mkd_doc_camitk_Property_setEnumTypeName_2 = R"doc(if the property's type is an enum, set the name of the registered Qt
Enum AND automatically build the enum names that will be used in the
GUI. There is no need to set the "enumNames" attribute, the enum names
will automatically be build from the enum literals: - all words will
be capitalized - all "_" (underscore) will be transformed to space

Parameter ``enumTypeName``:
    the enum type name as declared in the header file

Parameter ``objectDeclaringTheEnum``:
    is a pointer to the object instantiated from the class that
    declared the enum)doc";

static const char *mkd_doc_camitk_Property_setGroupName = R"doc(Set the group name. Properties can be separated into subgroups. Just
set the group name and they will be arranged/classified by group.

Parameter ``groupName``:
    name of the group for this property)doc";

static const char *mkd_doc_camitk_Property_setReadOnly = R"doc(set this property as read-only)doc";

static const char *mkd_doc_camitk_Property_setUnit = R"doc(set the unit)doc";

static const char *mkd_doc_camitk_Property_unit = R"doc(unit (or null string if not specified))doc";


/* ----------------------------------------
   Docstrings for Transformation
---------------------------------------- */

static const char *mkd_doc_camitk_Transformation = R"doc(Transformation represents a geometrical transformation between two
FrameOfReferences

It supports linear and non-linear transforms stored in a vtkTransform
(linear) or any vtkAbstractTransform (non-linear)

It has a direction (from a FrameOfReference to another
FrameOfReference)

Its constructor is private as Transformation objects must only be
created through TransformationManager::getTransformationManager()
(although it is possible to instantiate your own TransformationManager
if you know what you're doing!)

.. warning::
    Transformation are instantiated/stored/managed/destroyed by
    TransformationManager::getTransformationManager(), therefore you
    should not keep a pointer to any Transformation, just call
    TransformationManager::getTransformationOwnership(..) when you
    need to access it. This guarantees the coherence of the complete
    reference system and avoid dangling pointers and memory leaks.

```
{.cpp}
...
FrameOfReference* from = TransformationManager::addFrameOfReference("Source Frame");
FrameOfReference* to = TransformationManager::addFrameOfReference("Destination Frame");
Transformation* t = TransformationManager::addTransformation(from, to);
...
t->setMatrix(...);
 note: t MUST not be a member
 call TransformationManager::getTransformationOwnership(from, to) to access it later on
```

See also:
    TransformationManager)doc";

static const char *mkd_doc_camitk_Transformation_Transformation_1 = R"doc(Create an identity transformation between two instances of
FrameOfReference)doc";

static const char *mkd_doc_camitk_Transformation_Transformation_2 = R"doc(Create a Transformation between two instances of FrameOfReference with
the provided linear vtkTransform)doc";

static const char *mkd_doc_camitk_Transformation_description = R"doc(A more detailed description than provided by the name)doc";

static const char *mkd_doc_camitk_Transformation_from = R"doc(Origin FrameOfReference, where the Transformation starts from)doc";

static const char *mkd_doc_camitk_Transformation_fromVariant = R"doc(Fill the Transformation from a QVariant)doc";

static const char *mkd_doc_camitk_Transformation_getDescription = R"doc(Get the description of the Transformation Description is used to
provide more information than the name (e.g. method used to compute
it))doc";

static const char *mkd_doc_camitk_Transformation_getFrom = R"doc(Get the FrameOfReference the Transformation starts from (origin))doc";

static const char *mkd_doc_camitk_Transformation_getInverse = R"doc(Create and return the inverse transformation (if this Transformation
is inversible)

This function creates a raw Transformation* and the caller is the
owner of the Transformation object (e.g. responsible for deleting it))doc";

static const char *mkd_doc_camitk_Transformation_getMatrix = R"doc(Get the internal 4x4 matrix if the Transformation is linear, otherwise
nullptr

Note: this method should return a pointer to a const vtkMatrix4x4
Unfortunately, at some stage in some part of your VTK pipeline, you
might need a non-const vtkMatrix4x4 (e.g. to setup a vtkActor).

.. warning::
    You should only use this method to send the vtkMatrix4x4* to a vtk
    method. \warning **NEVER** use this method to modify the content
    of the matrix directly, as it might generate inconsistencies in
    the transformation management. If you need to change the values
    you **MUST** use TransformationManager::updateTransformation(..))doc";

static const char *mkd_doc_camitk_Transformation_getName = R"doc(Get the name of the Transformation)doc";

static const char *mkd_doc_camitk_Transformation_getTo = R"doc(Get the FrameOfReference that the Transformation goes to (destination))doc";

static const char *mkd_doc_camitk_Transformation_getTransform = R"doc(Get the internal vtkTransform (linear transformation) or a nullptr

Note: this method should return a vtkSmartPointer to a const
vtkTransform Unfortunately, at some stage in some part of your VTK
pipeline, you might need a non-const vtkTransform.

.. warning::
    You should only use this method to send the vtkTransform to a vtk
    method. \warning **NEVER** use this method to modify the content
    of the matrix directly, as it might generate inconsistencies in
    the transformation management. If you need to change the values
    you **MUST** use TransformationManager::updateTransformation(..))doc";

static const char *mkd_doc_camitk_Transformation_getUuid = R"doc(Get the unique identifier of this Transformation)doc";

static const char *mkd_doc_camitk_Transformation_inversible = R"doc(Whether this Transformation's inverse can be computed)doc";

static const char *mkd_doc_camitk_Transformation_name = R"doc(Name, a short description)doc";

static const char *mkd_doc_camitk_Transformation_setDescription = R"doc(Set the description of the Transformation Description is used to
provide more information than the name (e.g. method used to compute
it))doc";

static const char *mkd_doc_camitk_Transformation_setFrom = R"doc(Set the origin FrameOfReference)doc";

static const char *mkd_doc_camitk_Transformation_setMatrix = R"doc(Sets the Transformation to a linear transformation using the matrix m

.. warning::
    : this will deep copy the matrix (so Transformation will not be
    affected if the provided matrix is changed after the function is
    called))doc";

static const char *mkd_doc_camitk_Transformation_setName = R"doc(Set the name of the Transformation)doc";

static const char *mkd_doc_camitk_Transformation_setTo = R"doc(Set the destination FrameOfReference)doc";

static const char *mkd_doc_camitk_Transformation_setTransform = R"doc(Set a vtkTransform.

This will use the vtkMatrix from the vtkTransform, not the
vtkTransform itself So if the vtkTransform is updated later, the
Transformation will not update)doc";

static const char *mkd_doc_camitk_Transformation_setUuid = R"doc(Set the unique identifier of this transformation if the current one is
Null

.. warning::
    This should almost never be used except when loading a
    Transformation from a camitk file

Returns:
    true if the UUID was changed, false if it was not (because it
    already had a non-null value))doc";

static const char *mkd_doc_camitk_Transformation_to = R"doc(Destination FrameOfReference, where the Transformation goes to)doc";

static const char *mkd_doc_camitk_Transformation_toVariant = R"doc(@name Implementation of InterfacePersistence @{

Convert the Transformation to a QVariant (for serializing))doc";

static const char *mkd_doc_camitk_Transformation_transform = R"doc(Internal linear transformation)doc";

static const char *mkd_doc_camitk_Transformation_uuid = R"doc(Unique identifier, used for serialization with InterfacePersistence)doc";


/* ----------------------------------------
   Docstrings for TransformationManager
---------------------------------------- */

static const char *mkd_doc_camitk_TransformationManager = R"doc(TransformationManager manages frames of reference and transformations
for a CamiTK Application

This class is the entry point to using FrameOfReference and
Transformation system.

Every Component that is displayable contains data which are located in
space using coordinates. But two Components may not use the same
origin in space, or the same axes.

To manage that, the notion of Frame specifies an origin and axes, this
is modeled by camitk::FrameOfReference. Each component has a
FrameOfReference accessed by Component::getFrame()

Two Components may share a common Frame, for example two meshes of two
organs computed from the same image. In this case both components'
getFrame() should return the same FrameOfReference.

TransformationManager stores and manages all the FrameOfReference
objects used in a CamiTK Application.

When you need to display two Components, or to apply an Action that
uses multiple Components, it is necessary to be able to transform the
coordinates of one Component's data to another.

These geometrical transformations are stored in the
camitk::Transformation class. A Transformation stores the frame of
origin, the frame of destination and the geometrical transformation
itself. Currently it supports linear transformations (represented in a
4x4 homogeneous matrices).

All Transformation objects are also stored and managed in the
TransformationManager. The TransformationManager provides and manages
a specific and unique "world frame". This is the frame used by VTK and
the default for 3D viewers. Having a world frame simplifies the usage
of frames.

Alongside Component, Viewers also have a FrameOfReference, which
determines the "point of view" they are using for the visualization.
More precisely, it is used to set the camera and orient the vtkActors.
The default frame of the 2D and 3D viewers is the world frame.

Their is only one TransformationManager (all public methods are
static).

.. note::
    on shared and raw pointers

Transformation and Frames can be manipulated locally using their raw
pointer. Use the shared pointer only if you need to own the object as
well, that if the Transformation or Frame is part of your class
members and need to be kept alive for your code to work. Using a
shared pointer ensures that the Frame or Transformation won't be
removed from the system by the TransformationManager. If you only need
to access or modify information on a frame or transformation, only use
the raw pointer.

\section TransformationManager_API

The TransformationManager provides the following utilities: -
addFrameOfReference(...) methods add FrameOfReference objects -
addTransformation(...) methods add Transformation objects -
getTransformationOwnership(..) methods returns the shared_ptr to a
Transformation - getTransformation(...) method computes a
Transformation between two Frames, if any path exists between them -
updateTransformation(...) methods modify the transformation matrix
values

Two methods are provided for the manipulation of world frame: -
getWorldFrame() returns the unique world frame, to which all frames
should have a path to (composed of 1 or more transformations). -
ensurePathToWorld() to add a default identity Transformation between
the provided Frame and the worldFrame if no Transformation was
defined.

\section Transformation

A Transformation can either be: - directly defined by the user using
addTransformation() -> it holds a user defined 4x4 matrix. It has 0
sources. - an inverse of another Transformation. Inverse
Transformation are automatically generated by the
TransformationManager. It therefore has 1 source (the direct
Transformation it is the inverse of). - a composite transformation
defined automatically by the TransformationManager to pass from one
source to another one over more than one frame. It is composed by a
list of other transformations. It therefore has more than one sources.

Information about a Transformation t can be obtained from the
TransformationManager using: - hasSources(t) and getSources(t) -
isCompositeTransformation(t) - isInverseTransformation(t) -
isDefaultIdentityToWorld(t)

There is three cases where TransformationManager will automatically
create a transformation: - when a linear transformation is added using
addTransformation(), the inverse transformation is automatically
generated and stored in the system. The new transformation will
therefore only have 1 source. - when getTransformation() is called and
finds a new path of transformations between the two given frames, it
will generate a new composed transformation (for optimization) from
those transformations. The new transformation will therefore have all
those transformations as sources. - when ensurePathToWorld(f) is
called, and no path can be found between f and the world frame, then a
new identity transformation from f to world frame is created. This new
transformation has no source (note that TransformationManager will
also create its inverse, which has 1 source). Use
isDefaultIdentityToWorld() to check if a transformation was generated
this way.

Note that TransformationManager always generates an inverse
transformation for any existing linear transformation if it does not
exist already.

\section Transformation_Sources

The lists of Transformation sources are managed by the
TransformationManager. Sources are the transformations that are used
(composed) to compute a Transformation t. If any of the sources are
modified, t is guaranteed to reflect this update, i.e., it is
recomputed from its sources. If t has only one source, this means t is
the inverse of this source.

See also:
    hasSources() getSources()

\section FrameOfReference
A FrameOfReference represents a specific
system of coordinates in which component data's coordinates are
expressed.

It can have a name, a description, and anatomical labels associated to
its axes: for example, the X axis may have label L on the lower
values, and R on the higher values (for Left/Right anatomical
orientation). You can add new Frames of reference using
addFrameOfReference methods when creating a new Component (even though
Component constructor creates a default one for you), or if you need
to manage multiple frames in your component (e.g. for an articulated
robot).

If you need to get ownership of a specific FrameOfReference (e.g. you
want your Component to store the same Frame as another Component), use
getFrameOfReferenceOwnership()

To edit anatomical information, name or description, refer to
FrameOfReference class.

\section Transformation_Path_Management

When you need a Transformation from one Frame to another, the method
to call is getTransformation()

This method first looks if a Transformation was added using
addTransformation between those Frames, then if there is already a
cached composite Transformation linking both Frames, and finally, it
checks whether there is a path in the graph of Frames and
Transformations linking those Frames using intermediary Frames.

Private methods hasPath() and getPath() are used to search the graph
for a suitable path. If there is one, a new cached composite
Transformation is stored (it combines the path of Transformations into
one). If there is no path, these methods return nullptr.

When the user wants to ensure that a specific Frame has a
Transformation to the WorldFrame, she/he should call
ensurePathToWorld(). This will create a default identity
Transformation to the WorldFrame if there is no existing path between
the Frame and the WorldFrame.

All default identity Transformations are marked, so that if a new
Transformation is added using addTransformation, these Transformations
can be automatically removed. This is needed to avoid creation of
multiple path between Frames (there will therefore never be any cycle
in the Frame/Transformation graph).

\section Transformation_Memory_management

As FrameOfReference and Transformation constructors are private, all
Frames and Transformations must be created through the
TransformationManager.

Internally, Transformation and FrameOfReference objects are stored
using std::shared_ptr

This means that ownership of these objects is shared between the
TransformationManager and custom objects used in CamiTK such as
Component (which owns its FrameOfReference), ImageComponent (which
also owns its internal Transformation from raw to main).

Most methods of this class return or use raw pointers, meaning they do
not return or get ownership of the FrameOfReference or Transformation
object. The raw pointers are meant to be used for immediate processing
(e.g. getting the name of a Frame, transforming the coordinates of a
point using a Transformation) but not to store the pointer. If you
need to store the object, you must use getFrameOfReferenceOwnership()
and getTransformationOwnership() This makes explicit who is owning
Transformations and Frames.

Note that you may not get ownership of a composite Transformation
(computed from others) or a default Transformation, as those must be
removable at all times.

TransformationManager may delete any Transformation that is not owned
outside its internal data structure (which mean they are not used
anymore apart from internally).

See also:
    cleanupFramesAndTransformation(), removeDefaultPaths(),
    removeTransformation().

To determine whether a Transformation or Frame is owned outside the
TransformationManager, std::shared_ptr usage counter is used.

\section "Using TransformationManager in your extensions" TransformationManagerUser
TransformationManager use cases

Most common use cases for CamiTK extension developers: - adding a new
Component: use the default Component constructor which creates a new
default FrameOfReference for the Component - adding a new Component
created from another one: - if the new Component is using the same
Frame, just set its Frame to the original component's frame using
InterfaceFrame::setFrameFrom() - if you need to ensure a Component has
its own independent frame, use InterfaceFrame::resetFrame() - Special
cases for ImageComponent: ImageComponents have a data frame and a main
transformation (from their data to their main frame) that needs to be
taken care of. Be aware that ImageComponent::setFrameFrom() and
ImageComponent::resetFrame() are reimplemented to take care of the
data frame and main transformation. For instance: - your action
creates an image outImage from an image inImage, just call
`out->setFrameFrom(in)` - your action creates an mesh outMesh from an
image inImage, call `outMesh-
>setFrame(TransformationManager::getFrameOfReferenceOwnership(inImage-
>getDataFrame()));` as the mesh is computed from the image data, the
mesh is defined in the image component data frame

- Registering a Component to another: for example, compute the
registration between two meshes, then use addTransformation() between
the frames of the two meshes.

.. warning::
    : if there is already a Transformation path between the meshes and
    the world frame is not in this path, addTransformation() will
    return nullptr. This means that computed transformation (for
    example after previous registration) already gives a
    transformation between the two meshes. If you want to update
    previous registration, you should use updateTransformation()
    instead. If updateTransformation() also returns nullptr, this
    means you are trying to create a cycle in the transformation
    graph. - You can use multiple Frames and Transformation inside
    your own Component, use the TransformationExplorer to check if it
    is working as expected.

In the case of an articulated robot, each part may have its own
FrameOfReference, and each articulation its own Transformation. You
can use methods addFrameOfReference, addTransformation,
updateTransformation to create and update frames and transformations
in your Action and Component extensions.)doc";

static const char *mkd_doc_camitk_TransformationManager_addCompositeTransformation = R"doc(Create and register a Transformation which is the composition of the
provided transformations)doc";

static const char *mkd_doc_camitk_TransformationManager_addFrameOfReference_1 = R"doc(Add a FrameOfReference with a name and description This is the
standard way to create a new FrameOfReference

Returns:
    the corresponding shared_ptr (save it to keep ownership, ignore if
    ownership is not needed))doc";

static const char *mkd_doc_camitk_TransformationManager_addFrameOfReference_2 = R"doc(Add a copy of the provided FrameOfReference (with a different UUID)

Returns:
    the corresponding shared_ptr (save it to keep ownership, ignore if
    ownership is not needed))doc";

static const char *mkd_doc_camitk_TransformationManager_addFrameOfReference_3 = R"doc(Add a FrameOfReference with all data

.. warning::
    should be used only if you need a specific UUID (e.g. when reading
    a FrameOfReference from a file))doc";

static const char *mkd_doc_camitk_TransformationManager_addFrameOfReference_4 = R"doc(Add a FrameOfReference from a QVariant (as stored using
PersistenceManager))doc";

static const char *mkd_doc_camitk_TransformationManager_addTransformation_1 = R"doc(Create and register a new Transformation from a QVariant (usually from
a JSON representation in a .camitk file) if there is no corresponding
transformation (uuid and from/to path)

Returns:
    a pointer to the new Transformation or nullptr if a transformation
    with the same UUid or the same from/to frames already exist in the
    system (use getTransformationOwnership() or getTransformation(..)
    instead))doc";

static const char *mkd_doc_camitk_TransformationManager_addTransformation_2 = R"doc(Create and register a new identity Transformation between two frames
if there is no existing transformation between those frames.

Returns:
    a pointer to the new Transformation or nullptr if a transformation
    between those frames already exist (use getTransformation()))doc";

static const char *mkd_doc_camitk_TransformationManager_addTransformation_3 = R"doc(@copydoc addTransformation(const FrameOfReference*,const
FrameOfReference*))doc";

static const char *mkd_doc_camitk_TransformationManager_addTransformation_4 = R"doc(Create and register a new Transformation between two frames and sets
the transformation to the provided transform if there is no existing
transformation between those frames.

Parameter ``vtkTr``:
    The vtkTransform pointer that will be stored in the
    Transformation.

.. warning::
    if the given vtkTransform is updated later, it will affect the
    Transformation!

Returns:
    a pointer to the new Transformation or nullptr if a transformation
    between those frames already exist (use getTransformation()))doc";

static const char *mkd_doc_camitk_TransformationManager_addTransformation_5 = R"doc(@copydoc addTransformation(const FrameOfReference*,const
FrameOfReference*,vtkSmartPointer<vtkTransform>))doc";

static const char *mkd_doc_camitk_TransformationManager_addTransformation_6 = R"doc(Create and register a new Transformation between two frames, copying
the content of the provided matrix if there is no existing
transformation between those frames. A deep copy of the given matrix
is used to initialize the new Transformation

Returns:
    a pointer to the new Transformation or nullptr if a transformation
    between those frames already exist)doc";

static const char *mkd_doc_camitk_TransformationManager_addTransformation_7 = R"doc(@copydoc addTransformation(const FrameOfReference*,const
FrameOfReference*,const vtkMatrix4x4*))doc";

static const char *mkd_doc_camitk_TransformationManager_cleanupCompositeTransformations = R"doc(Remove all composite from internal structures)doc";

static const char *mkd_doc_camitk_TransformationManager_cleanupFramesAndTransformations = R"doc(Remove transformations and frames that are unused (i.e. only present
in the TransformationManager))doc";

static const char *mkd_doc_camitk_TransformationManager_ensurePathToWorld = R"doc(Make sure there is a Transformation from the given Frame to the world
Frame. This will create an identity (default) transformation if no
path to world already exists.)doc";

static const char *mkd_doc_camitk_TransformationManager_fromVariant = R"doc(Load Frame and Transformation data from a QVariant

This reads "frames" and "transformations" from the provided
QVariantMap to add Frame and Transformation objects in the
TransformationManager

See also:
    InterfacePersistence)doc";

static const char *mkd_doc_camitk_TransformationManager_getDirectTransformations = R"doc(Returns the list of direct transformations, that is the
transformations that are independent of any other. The inverse
transformations (which have one source) and composite transformations
(which have 2 or more sources) are not included.)doc";

static const char *mkd_doc_camitk_TransformationManager_getFrameOfReferenceOwnership_1 = R"doc(Get a FrameOfReference from its UUID)doc";

static const char *mkd_doc_camitk_TransformationManager_getFrameOfReferenceOwnership_2 = R"doc(Get the shared_ptr that owns the given FrameOfReference. This should
only be used to take shared ownership of the given FrameOfReference.

Returns:
    nullptr if the given FrameOfReference is unknown to the
    TransformationManager)doc";

static const char *mkd_doc_camitk_TransformationManager_getFramesOfReference = R"doc(Get a list of all stored FrameOfReference)doc";

static const char *mkd_doc_camitk_TransformationManager_getInverseTransformation = R"doc(Returns:
    the inverse transformation (creates it if it does not exists yet,
    that is if tr is a composite) or nullptr if tr is nullptr)doc";

static const char *mkd_doc_camitk_TransformationManager_getPath = R"doc(If there is a path of transformations between two frames of reference,
this will return it.

This will search for a path in the graph of frames/transformations.

.. note::
    if from or to are nullptr, returns an empty QVector

Returns:
    The list of Transformations that once chained link Frame 'from' to
    Frame 'to' or an empty QVector if there is no path or if `from`
    equals `to`.)doc";

static const char *mkd_doc_camitk_TransformationManager_getSources = R"doc(Get the list of sources used to compute the provided Transformation)doc";

static const char *mkd_doc_camitk_TransformationManager_getTransformation = R"doc(Get a transformation if it exists or compute it if a path exists
between the frames.)doc";

static const char *mkd_doc_camitk_TransformationManager_getTransformationOwnership_1 = R"doc(Get the shared_ptr that owns the given Transformation. This should
only be used to take shared ownership of the given Transformation.

.. warning::
    You cannot take ownership of a Composite or a default identity to
    world transformation.

.. warning::
    use getTransformation() if you don't need to take ownership of a
    Transformation.

Returns:
    nullptr if the given Transformation is unknown to the
    TransformationManager or is a composite or is a default identity
    to world.)doc";

static const char *mkd_doc_camitk_TransformationManager_getTransformationOwnership_2 = R"doc(Get the shared_ptr that owns the Transformation with given UUID. This
should only be used to take shared ownership of the given
Transformation.

.. warning::
    You cannot take ownership of a Composite or a default identity to
    world transformation.

.. warning::
    use getTransformation() if you don't need to take ownership of a
    Transformation.

Returns:
    nullptr if the given Transformation is unknown to the
    TransformationManager or is a composite or is a default identity
    to world.)doc";

static const char *mkd_doc_camitk_TransformationManager_getTransformationOwnership_3 = R"doc(Get the shared_ptr that owns the given Transformation between from and
to. This should only be used to take shared ownership of the given
Transformation.

.. warning::
    You cannot take ownership of a Composite or a default identity to
    world transformation.

.. warning::
    use getTransformation() if you don't need to take ownership of a
    Transformation.

Returns:
    nullptr if the given Transformation is unknown to the
    TransformationManager or is a composite or is a default identity
    to world.)doc";

static const char *mkd_doc_camitk_TransformationManager_getTransformationSharedPtr = R"doc(Get the shared_ptr that owns the given Transformation (works for all
transformation that are not composite)

.. warning::
    This should never be a public method (see difference with
    getTransformationOwnership))doc";

static const char *mkd_doc_camitk_TransformationManager_getTransformations = R"doc(Returns the list of all transformations managed in the system,
independents or not.)doc";

static const char *mkd_doc_camitk_TransformationManager_getWorldFrame = R"doc(Get the WorldFrame

This is the Frame that links all Frames so that there is a common
space If a Component's frame is not linked by a Transformation to any
other Frame, a default identity Transformation should be created
between it and this worldFrame

This is done by calling ensurePathToWorld)doc";

static const char *mkd_doc_camitk_TransformationManager_hasPath = R"doc(returns true if there a path of transformations between two frames of
reference 'from' and 'to' or if `from` equals `to`.

This will search for a path in the graph of frames/transformations.)doc";

static const char *mkd_doc_camitk_TransformationManager_hasSources = R"doc(Was this Transformation computed from others or not?)doc";

static const char *mkd_doc_camitk_TransformationManager_isCompositeTransformation = R"doc(Is this transformation composed of two or more transformations ?)doc";

static const char *mkd_doc_camitk_TransformationManager_isDefaultIdentityToWorld = R"doc(Is the transformation a default one ? This means that it was created
as Identity by default and might be replaced it another Transformation
is set It is usually a Transformation which destination is worldFrame)doc";

static const char *mkd_doc_camitk_TransformationManager_isInverseTransformation = R"doc(Returns:
    true if the given Transformation is an inverse, i.e., has one and
    only one source)doc";

static const char *mkd_doc_camitk_TransformationManager_preferredDefaultIdentityToWorldLink = R"doc(Call this method when you prefer (for visualization purpose only) to
have a direct link to world from the given frame instead of any other
path. If another path to world exists from the frame and include a
default identity transformation to world, it will be delete in favor
of a new default identity transformation that directly links the given
frame to world.

Returns:
    false if there is a path to world that contains no default
    identity transformation)doc";

static const char *mkd_doc_camitk_TransformationManager_registerTransformation = R"doc(Private method to add a Transformation in the members.

.. warning::
    : TransformationManager takes ownership of the provided pointer,
    therefore YOU MUST NOT DELETE IT

Parameter ``tr``:
    the transformation to add

Parameter ``sources``:
    List of Transformations that were used to compute this one. This
    list is empty if this method is called inside addTransformation().)doc";

static const char *mkd_doc_camitk_TransformationManager_removeDefaultPaths = R"doc(Remove the default identity to world Transformations that are present
in the path between from and to

Returns:
    true if and only if at least one default transformation was
    removed between from and to)doc";

static const char *mkd_doc_camitk_TransformationManager_removeTransformation_1 = R"doc(Remove an existing transformation between the two frames.

This method checks that the given shared_ptr<Transformation> has no
other owner than the caller (i.e., only the caller of this method has
ownership of the given shared_ptr). If this is true, then the
shared_ptr will be set to nullptr, which will result in the deletion
of the Transformation.

If there is another owner, the shared_ptr is not modified, and the
Transformation will not be removed.

If the given shared_ptr is equal to nullptr (for instance when calling
removeTransformation(getTransformationOwnership(t)) with t being a
composite transformation), this method returns false.

.. warning::
    if successful, the shared_ptr must not be used anymore (as it is
    set to nullptr).

Returns:
    true if the Transformation was removed from the transformation
    system, false otherwise.)doc";

static const char *mkd_doc_camitk_TransformationManager_removeTransformation_2 = R"doc(Remove an existing transformation between the two frames.

See also:
    removeTransformation(std::shared_ptr<Transformation>&)

.. warning::
    if successful, the shared_ptr must not be used anymore (as it is
    set to nullptr) after that.)doc";

static const char *mkd_doc_camitk_TransformationManager_removeTransformationFromInternalStructures = R"doc(Helper method that removes a transformation from all internal members
except the owner (transformations) @warning this is a utility methods,
should only be called from cleanUp and removeTransformation methods.)doc";

static const char *mkd_doc_camitk_TransformationManager_toString = R"doc(get current state as a QString)doc";

static const char *mkd_doc_camitk_TransformationManager_toVariant = R"doc(Save Frame and Transformation data to a QVariant

This creates a QVariantMap with the keys "frames" and
"transformations" for saving the state of the TransformationManager

See also:
    InterfacePersistence)doc";

static const char *mkd_doc_camitk_TransformationManager_updateTransformation_1 = R"doc(Modify the Transformation between the two frames by setting its
vtkTransform @warning only the vtkMatrix of the given vtkTransform is
duplicated (later modification of vtkTr will not update the
transformations))doc";

static const char *mkd_doc_camitk_TransformationManager_updateTransformation_2 = R"doc(Modify the Transformation between the two frames by setting its
vtkMatrix)doc";

static const char *mkd_doc_camitk_TransformationManager_updateTransformation_3 = R"doc(Modify the Transformation by setting its vtkTransform @warning only
the vtkMatrix of the given vtkTransform is duplicated (later
modification of vtkTr will not update the transformations))doc";

static const char *mkd_doc_camitk_TransformationManager_updateTransformation_4 = R"doc(Modify the Transformation by setting its matrix)doc";

