// Copyright 2016 The Chromium Authors. All rights reserved.
// Use of this source code is governed by a BSD-style license that can be
// found in the LICENSE file.

#ifndef NET_ANDROID_CELLULAR_SIGNAL_STRENGTH_H_
#define NET_ANDROID_CELLULAR_SIGNAL_STRENGTH_H_

#include <jni.h>
#include <stdint.h>

#include "base/optional.h"
#include "net/base/net_export.h"

namespace net {

namespace android {

namespace cellular_signal_strength {

// Returns the signal strength level (between 0 and 4, both inclusive) of the
// currently registered cellular connection. If the value is unavailable, an
// empty value is returned.
NET_EXPORT_PRIVATE base::Optional<int32_t> GetSignalStrengthLevel();

}  // namespace cellular_signal_strength

}  // namespace android

}  // namespace net

#endif  // NET_ANDROID_CELLULAR_SIGNAL_STRENGTH_H_
