/****************************************************************************
 *    lib/c/Program.h - This file is part of coala							*
 *																			*
 *    Copyright (C) 2009  Torsten Grote										*
 *																			*
 *    This program is free software; you can redistribute it and/or modify	*
 *    it under the terms of the GNU General Public License as published by	*
 *    the Free Software Foundation; either version 3 of the License, or		*
 *    (at your option) any later version.									*
 *																			*
 *    This program is distributed in the hope that it will be useful,		*
 *    but WITHOUT ANY WARRANTY; without even the implied warranty of		*
 *    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the			*
 *    GNU General Public License for more details.							*
 *																			*
 *    You should have received a copy of the GNU General Public License		*
 *    along with this program; if not, see http://www.gnu.org/licenses		*
 ****************************************************************************/


#ifndef program_h
#define program_h

#include <string>
#include <vector>
#include <map>

#include "../options.h"
#include "Variable.h"
#include "Formula.h"
#include "StaticRule.h"
#include "DynamicRule.h"
#include "ActionDefinition.h"
#include "FluentDefinition.h"
#include "Query.h"
#include "QQuery.h"
#include "RQuery.h"
#include "LTLQuery.h"
#include "Printer.h"

namespace C {

class Program
{
public:
	Program(Coala::CompilerOptions*);
	
	virtual ~Program();
	
	void setLine(int* line);
	
	virtual void print(Printer* p);
	
	Variable* addVariable(string*);
	Formula* addFormula(char, Formula*);
	Formula* addFormula(char, vector<Formula*>*);
	
	bool addAction(FluentAction* action);
	void addActionDef(Formula* action_list, Types* types=0);
	bool addFluent(FluentAction* fluent);
	void addFluentDef(Formula* fluent_list, Types* types=0);
	
	virtual void addStaticRule(Formula* F, Formula* G, Types* types=NULL);
	virtual void addDynamicRule(Formula* F, Formula* G, Formula* H, Types* types=NULL);
	
	void addDefaultRule(Formula* F, Formula* G, Types* types=NULL);
	void addInertialRule(Formula* F, Types* types=NULL);
	void addCausesRule(Formula* A, Formula* F, Formula* G, Types* types=NULL);
	void addAlwaysRule(Formula* G, Types* types=NULL);
	void addMayCauseRule(Formula* A, Formula* F, Formula* G, Types* types=NULL);
	virtual void addNonexecutableRule(Formula* A, Formula* G, Types* types=NULL);
	void addQQuery(string type, Formula* A, string time, Types* types=NULL);
	void addRQuery(Formula* F, Formula* A, string time, Types* types=NULL);
	LTLNode* getLTLNode(int, LTLNode*, LTLNode*, Formula* content=NULL);
	void addLTLQuery(LTLNode*);

protected:
	void transformFormula(Formula* I, string type);

	int* line_;
	Coala::CompilerOptions* options_;
	int ltl_node_num_;
	Printer* p_;
	map<string, FluentAction*> actions_;
	map<string, FluentAction*> fluents_;
	map<string, Variable*> variables_;
	vector<QQuery*> qqueries_;
	vector<RQuery*> rqueries_;
	LTLQuery* ltlquery_;

	vector<StaticRule*> static_rules_;
	vector<DynamicRule*> dynamic_rules_;
	vector<ActionDefinition*> action_definitions_;
	vector<FluentDefinition*> fluent_definitions_;

};
}; // end of package namespace

#endif // PROGRAM_H
