/* $Id: leak_check-test.c,v 1.3 2013-10-08 11:18:57 aagudo Exp $
 *
 * This file is part of the KMOS Library
 * Copyright (C) 2002-2006 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301 USA
 */

/*
 * $Author: aagudo $
 * $Date: 2013-10-08 11:18:57 $
 * $Revision: 1.3 $
 * $Name: not supported by cvs2svn $
 */

#ifdef HAVE_CONFIG_H
#include <config.h>
#endif

#include <string.h>

#include <cpl.h>

/**
    @defgroup leak_check_test  check memory leaks in unit tests

    @{
*/

/**
  @brief    Check memory leaks in unit tests
  @param    argc   the number of parameters
  @param    argv   the parameter list
 */
int main()
{
    int ret = 0;

    cpl_test_init("<kmos-spark@mpe.mpg.de>", CPL_MSG_WARNING);

    // run bash-script to examine all generated log_*.txt files in
    // kmosp/recipes/tests
    char *my_path = cpl_sprintf("%s/../../recipes/tests/kmo_final_test.sh", getenv("srcdir"));
    ret = system(my_path);
    cpl_free(my_path);

    // have to shift by 8 (divide by 256) to get back
    //correct exit status from kmo_final_test.sh
    ret = ret >> 8;

    // test if zero active pointers
    cpl_test_eq(ret, 0);

    return cpl_test_end(0);
}

/** @} */
