/*
 * This file is part of the ESO UVES Pipeline
 * Copyright (C) 2004,2005 European Southern Observatory
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, 51 Franklin St, Fifth Floor, Boston, MA  02111-1307  USA
 */

/*
 * $Author: amodigli $
 * $Date: 2010-09-24 09:31:30 $
 * $Revision: 1.23 $
 * $Name: not supported by cvs2svn $
 * $Log: not supported by cvs2svn $
 * Revision 1.21  2008/06/20 14:23:05  amodigli
 * added flames_get_basename()
 *
 * Revision 1.20  2008/02/25 07:22:57  amodigli
 * add param save_flat_size
 *
 * Revision 1.19  2008/02/25 07:09:43  amodigli
 * added param save_flat_size
 *
 * Revision 1.18  2008/02/18 16:23:38  amodigli
 * added msffsz_flames2
 *
 * Revision 1.17  2008/01/27 13:52:40  amodigli
 * added flames_get_mff_hw_and_yshift
 *
 * Revision 1.16  2008/01/25 12:24:32  amodigli
 * added msffsz_flames
 *
 * Revision 1.15  2007/10/17 15:03:44  amodigli
 * removed ipercube stuff
 *
 * Revision 1.14  2007/06/20 11:12:00  jmlarsen
 * Moved flames_reset_crval_to_one()
 *
 * Revision 1.13  2007/06/06 08:17:33  amodigli
 * replace tab with 4 spaces
 *
 * Revision 1.12  2007/06/06 07:20:52  jmlarsen
 * Generalized flames_image_duplicate
 *
 * Revision 1.11  2007/05/31 16:06:21  jmlarsen
 * Added flames_select_all
 *
 * Revision 1.10  2007/05/10 14:05:12  jmlarsen
 * Added flames_select_non_null()
 *
 * Revision 1.9  2007/05/04 12:25:01  amodigli
 * added flames_new_ipercube and flames_new_table
 *
 * Revision 1.8  2007/04/26 13:25:41  jmlarsen
 * Added flames_sort_table_2()
 *
 * Revision 1.7  2007/04/24 12:49:34  jmlarsen
 * Replaced cpl_propertylist -> uves_propertylist which is much faster
 *
 * Revision 1.6  2007/04/23 07:09:27  amodigli
 * added flames_new_framelist
 *
 * Revision 1.5  2007/04/23 07:01:10  amodigli
 * uncommented BKG_XY_WIN_SZ_X BKG_XY_WIN_SZ_Y BKG_MAX_IO_WIN
 *
 * Revision 1.4  2007/04/20 14:49:21  jmlarsen
 * Added functions flames_merge/rename/sort_table()
 *
 * Revision 1.3  2007/01/29 13:09:57  jmlarsen
 * Work on conversion to CPL
 *
 * Revision 1.2  2007/01/10 11:08:34  jmlarsen
 * Don't define DRS_USE_ORDEF
 *
 * Revision 1.1  2006/10/20 06:42:09  jmlarsen
 * Moved FLAMES source to flames directory
 *
 * Revision 1.78  2006/10/12 11:37:28  jmlarsen
 * Temporarily disabled FLAMES code generation
 *
 */
#ifndef FLAMES_UTILS_H
#define FLAMES_UTILS_H



#ifdef HAVE_CONFIG_H
#  include <config.h>
#endif

/*-----------------------------------------------------------------------------
                    Includes
 -----------------------------------------------------------------------------*/
#include <uves_propertylist.h>
#include <uves_chip.h>
#include <flames_dfs.h>
#include <flames_get_flat_size.h>
#include <cpl.h>

/*-----------------------------------------------------------------------------
                             Defines
 -----------------------------------------------------------------------------*/

/*-----------------------------------------------------------------------------
                                   Prototypes
 -----------------------------------------------------------------------------*/
char * 
flames_get_basename(const char *filename);

cpl_error_code
flames_get_mff_hw_and_yshift(cpl_frame* frm, const int save_flat_size, const char* name_tbl);

int flames_get_version_binary(void);

const char *
flames_get_frmid(const cpl_frame *frame, enum uves_chip chip,
         int *wc);
cpl_frame *
flames_new_table(const char *filename, 
         const cpl_table *table, 
         const uves_propertylist *header);

cpl_frame *
flames_new_frame(const char *filename, 
         const cpl_image *image, 
         const uves_propertylist *header);

cpl_frame *
flames_new_framelist(const char *filename, 
         const cpl_imagelist *imagelist, 
         const uves_propertylist *header);

cpl_frame *
flames_new_frame_table(const char *filename, 
               const cpl_table *table, 
               const uves_propertylist *header,
               const uves_propertylist *theader);

cpl_frame *
flames_image_duplicate(const char *filename_prefix,
                       const cpl_frame *frame,
                       bool prefix,
                       bool reset_crval);

cpl_frame *
flames_image_subtract_scalar_create(const char *filename_prefix,
                    const cpl_frame *f,
                    double value);
cpl_frame *
flames_image_subtract_create(const char *filename_prefix,
                 const cpl_frame *f1,
                 const cpl_frame *f2);

void flames_merge_table(const char *n1, const char *n2);
void flames_rename_table(const char *n1, const char *n2);
void flames_sort_table_2(const char *filename, const char *c1, const char *c2);
void flames_sort_table(const char *filename, 
               const char *c1, 
               const char *c2, 
               const char *c3);

void
flames_reset_crval_to_one(uves_propertylist** h);

void
flames_select_non_null(const char *filename, const char *column);

void
flames_select_all(const char *filename);

double
flames_image_get_median(const cpl_frame *f);

cpl_error_code
msffsz_flames(cpl_frame *in_ima,
              const int save_flat_size,
              const char *in_tab,
              enum uves_chip chip);
void
msffsz_flames2(cpl_frame *in_ima,
              const int save_flat_size,
              const char *in_tab,
               enum uves_chip chip);

#endif
