#!/usr/bin/env python
from distutils.core import setup
from cyclograph.version import VERSION
import glob

files = ["openlayers.html", 
         "map.html",
         "google.css",
         "draw_on_map.js"]

icons = glob.glob('pixmaps/icon_*.png') + glob.glob('pixmaps/icon_*svg')

setup(name = "cyclograph",
    version = VERSION,
    description = "route altimetry plotting application",
    author = "Federico Brega, Pierluigi Villani",
    author_email = "charon66@users.sourceforge.net",
    url = "http://cyclograph.sourceforge.net",
    license = "GPL v3 or later",
    packages = ['cyclograph',
                'cyclograph.qt',
                'cyclograph.gtk3'],
    package_data = {'cyclograph' : files },
    scripts = ["cyclograph/cyclograph"],
    data_files = [('share/icons/hicolor/scalable/apps', ['pixmaps/cyclograph.svg']),
        ('share/icons/hicolor/32x32/apps', ['pixmaps/cyclograph.png']),
        ('share/pixmaps', icons),
        ('share/locale/en/LC_MESSAGES',
            ['po/en/LC_MESSAGES/cyclograph.mo']),
        ('share/locale/it/LC_MESSAGES',
            ['po/it/LC_MESSAGES/cyclograph.mo']),
        ('share/applications',
            ['cyclograph-qt.desktop',
             'cyclograph-gtk3.desktop']),
        ],
    long_description = \
"""CycloGraph is an application for plotting the elevation profile of routes.
Its main value is in the graphical visualization of the difficulty of a
road, in term of slope, difference in height, etc. Plots like these are
often used in cycling competitions, but are also useful in other sports,
such as hiking or running."""
) 
