#include "shortcuts.h"
#include <wreport/error.h>
#include <cstring>

namespace dballe {
namespace impl {

const Shortcut& Shortcut::by_name(const char* key, unsigned len)
{
    switch (key) { // mklookup
        case "st_type": return sc::st_type;
        case "st_name": return sc::st_name;
        case "st_name_icao": return sc::st_name_icao;
        case "rep_memo": return sc::rep_memo;
        case "poll_lcode": return sc::poll_lcode;
        case "poll_scode": return sc::poll_scode;
        case "poll_gemscode": return sc::poll_gemscode;
        case "poll_source": return sc::poll_source;
        case "poll_atype": return sc::poll_atype;
        case "poll_ttype": return sc::poll_ttype;
        case "flight_reg_no": return sc::flight_reg_no;
        case "flight_phase": return sc::flight_phase;
        case "flight_roll": return sc::flight_roll;
        case "navsys": return sc::navsys;
        case "data_relay": return sc::data_relay;
        case "wind_inst": return sc::wind_inst;
        case "temp_precision": return sc::temp_precision;
        case "latlon_spec": return sc::latlon_spec;
        case "timesig": return sc::timesig;
        case "block": return sc::block;
        case "station": return sc::station;
        case "ident": return sc::ident;
        case "year": return sc::year;
        case "month": return sc::month;
        case "day": return sc::day;
        case "hour": return sc::hour;
        case "minute": return sc::minute;
        case "second": return sc::second;
        case "latitude": return sc::latitude;
        case "longitude": return sc::longitude;
        case "height_station": return sc::height_station;
        case "height_baro": return sc::height_baro;
        case "height_release": return sc::height_release;
        case "station_height_quality": return sc::station_height_quality;
        case "isobaric_surface": return sc::isobaric_surface;
        case "st_dir": return sc::st_dir;
        case "st_speed": return sc::st_speed;
        case "meas_equip_type": return sc::meas_equip_type;
        case "sonde_type": return sc::sonde_type;
        case "sonde_method": return sc::sonde_method;
        case "sonde_correction": return sc::sonde_correction;
        case "sonde_tracking": return sc::sonde_tracking;
        case "press": return sc::press;
        case "press_3h": return sc::press_3h;
        case "press_24h": return sc::press_24h;
        case "water_temp": return sc::water_temp;
        case "height_anem": return sc::height_anem;
        case "press_tend": return sc::press_tend;
        case "visibility": return sc::visibility;
        case "pres_wtr": return sc::pres_wtr;
        case "past_wtr1_3h": return sc::past_wtr1_3h;
        case "past_wtr1_6h": return sc::past_wtr1_6h;
        case "past_wtr2_3h": return sc::past_wtr2_3h;
        case "past_wtr2_6h": return sc::past_wtr2_6h;
        case "metar_wtr": return sc::metar_wtr;
        case "tot_prec1": return sc::tot_prec1;
        case "tot_prec3": return sc::tot_prec3;
        case "tot_prec6": return sc::tot_prec6;
        case "tot_prec12": return sc::tot_prec12;
        case "tot_prec24": return sc::tot_prec24;
        case "tot_snow": return sc::tot_snow;
        case "state_ground": return sc::state_ground;
        case "press_msl": return sc::press_msl;
        case "qnh": return sc::qnh;
        case "temp_2m": return sc::temp_2m;
        case "wet_temp_2m": return sc::wet_temp_2m;
        case "dewpoint_2m": return sc::dewpoint_2m;
        case "humidity": return sc::humidity;
        case "wind_dir": return sc::wind_dir;
        case "wind_speed": return sc::wind_speed;
        case "wind_gust_max_speed": return sc::wind_gust_max_speed;
        case "wind_gust_max_dir": return sc::wind_gust_max_dir;
        case "ex_ccw_wind": return sc::ex_ccw_wind;
        case "ex_cw_wind": return sc::ex_cw_wind;
        case "cloud_n": return sc::cloud_n;
        case "cloud_nh": return sc::cloud_nh;
        case "cloud_hh": return sc::cloud_hh;
        case "cloud_cl": return sc::cloud_cl;
        case "cloud_cm": return sc::cloud_cm;
        case "cloud_ch": return sc::cloud_ch;
        case "cloud_n1": return sc::cloud_n1;
        case "cloud_c1": return sc::cloud_c1;
        case "cloud_h1": return sc::cloud_h1;
        case "cloud_n2": return sc::cloud_n2;
        case "cloud_c2": return sc::cloud_c2;
        case "cloud_h2": return sc::cloud_h2;
        case "cloud_n3": return sc::cloud_n3;
        case "cloud_c3": return sc::cloud_c3;
        case "cloud_h3": return sc::cloud_h3;
        case "cloud_n4": return sc::cloud_n4;
        case "cloud_c4": return sc::cloud_c4;
        case "cloud_h4": return sc::cloud_h4;
        default: wreport::error_notfound::throwf("Shortcut name '%s' not found", key);
    }
}
}
}
