/*
    Copyright (C) 2008-2010 Stefan Haller

    This program is free software: you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation, either version 3 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program.  If not, see <http://www.gnu.org/licenses/>.
*/

#ifndef XML_H_
#define XML_H_

#include <glib.h>

struct file_node
{
	gchar * filename;
	gboolean is_dir;
	gboolean use_subfolders;
	struct file_node * next;
};

struct profile_node
{
	gchar * name;
	struct file_node * files;
	struct profile_node * next;
};

struct module_node
{
	gchar * name;
	struct module_node * next;
};

struct settings
{
	gboolean changebyinterval;
	gint interval;
	gboolean changeeverylaunch;
	#ifdef CACHE_FILE_LIST
	gboolean cachefilelist;
	#endif
	gboolean mouse_wheel;
	gchar * default_profile;
	gchar * filters;
	struct profile_node * profiles;
	struct module_node * modules;
};

struct settings * load_settings();
void save_settings(struct settings * set);
void free_settings(struct settings * set);

#endif /*XML_H_*/
