/* $Id: Location.hpp 4323 2009-01-27 13:48:12Z potyra $ 
 *
 * Copyright (C) 2007-2009 FAUmachine Team <info@faumachine.org>.
 * This program is free software. You can redistribute it and/or modify it
 * under the terms of the GNU General Public License, either version 2 of
 * the License, or (at your option) any later version. See COPYING.
 */

#ifndef __LOCATION_HPP_INCLUDED
#define __LOCATION_HPP_INCLUDED

#include <ostream>
#include <string>

namespace ast {

/** location of a definiton. */
class Location {
public:
	//! c'tor
	/** @param lineNo line number in the file.
          * @param filenm name of the file.
          */
	Location(
		unsigned int lineNo, 
		const std::string *filenm
		) : 	line(lineNo),
			filename(filenm),
			information(NULL) {}

	//! alternate c'tor for builtins.
	/** @param info additional information.
          */
	Location(const char *info) :	line(0),
					filename(NULL),
					information(info) {}

	//! dummy d'tor
	virtual ~Location() {}

	/** Output the location to a stream.
          * @param out stream to which the location should get written to.
          * @return stream on which the location was written to.
          */
	std::ostream& put(std::ostream &out) const;
	
	/** line in the file */
	unsigned int line;
	/** filename */
	const std::string *filename;
	/** other information */
	const char *information;
};

/** overloaded operator to conveniently output locations.
 * @param stream stream to which a location should get written to.
 * @param loc location reference that should get written to the stream.
 * @return modified stream
 */
std::ostream&
operator <<(std::ostream& stream, const Location& loc);

}; /* namespace ast */

#endif /* __LOCATION_HPP_INCLUDED */
