/*
 * Decompiled with CFR 0.152.
 */
package loci.formats;

import java.io.IOException;
import java.util.Vector;
import loci.formats.FormatException;
import loci.formats.IFormatHandler;
import loci.formats.LogTools;
import loci.formats.StatusEvent;
import loci.formats.StatusListener;

public abstract class FormatHandler
implements IFormatHandler {
    public static boolean debug = false;
    public static int debugLevel = 1;
    protected String format;
    protected String[] suffixes;
    protected Vector statusListeners;
    protected String currentId;

    public FormatHandler(String format, String suffix) {
        String[] stringArray;
        if (suffix == null) {
            stringArray = null;
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = suffix;
        }
        this(format, stringArray);
    }

    public FormatHandler(String format, String[] suffixes) {
        this.statusListeners = new Vector();
        this.format = format;
        this.suffixes = suffixes == null ? new String[]{} : suffixes;
    }

    protected void status(String message) {
        this.status(new StatusEvent(message));
    }

    protected void status(int progress, int maximum, String message) {
        this.status(new StatusEvent(progress, maximum, message));
    }

    protected void status(StatusEvent e) {
        StatusListener[] l = this.getStatusListeners();
        for (int i = 0; i < l.length; ++i) {
            l[i].statusUpdated(e);
        }
    }

    protected void debug(String s) {
        String prefix;
        String name = this.getClass().getName();
        if (name.startsWith(prefix = "loci.formats.")) {
            name = name.substring(name.lastIndexOf(".") + 1);
        }
        String msg = System.currentTimeMillis() + ": " + name + ": " + s;
        if (debugLevel > 3) {
            LogTools.trace(msg);
        } else {
            LogTools.println(msg);
        }
    }

    protected void trace(String s) {
        LogTools.trace(s);
    }

    protected void trace(Throwable t) {
        LogTools.trace(t);
    }

    public boolean isThisType(String name) {
        return this.isThisType(name, true);
    }

    public boolean isThisType(String name, boolean open) {
        String lname = name.toLowerCase();
        for (int i = 0; i < this.suffixes.length; ++i) {
            if (lname.endsWith("." + this.suffixes[i])) {
                return true;
            }
            if (lname.endsWith("." + this.suffixes[i] + ".gz")) {
                return true;
            }
            if (lname.endsWith("." + this.suffixes[i] + ".bz2")) {
                return true;
            }
            if (!lname.endsWith("." + this.suffixes[i] + ".zip")) continue;
            return true;
        }
        return false;
    }

    public String getFormat() {
        return this.format;
    }

    public String[] getSuffixes() {
        return this.suffixes;
    }

    public void setId(String id) throws FormatException, IOException {
        this.setId(id, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addStatusListener(StatusListener l) {
        Vector vector = this.statusListeners;
        synchronized (vector) {
            if (!this.statusListeners.contains(l)) {
                this.statusListeners.add(l);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeStatusListener(StatusListener l) {
        Vector vector = this.statusListeners;
        synchronized (vector) {
            this.statusListeners.remove(l);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusListener[] getStatusListeners() {
        Vector vector = this.statusListeners;
        synchronized (vector) {
            Object[] l = new StatusListener[this.statusListeners.size()];
            this.statusListeners.copyInto(l);
            return l;
        }
    }

    public static void setDebug(boolean debug) {
        FormatHandler.debug = debug;
    }

    public static void setDebugLevel(int debugLevel) {
        FormatHandler.debugLevel = debugLevel;
    }
}

