/*
 * Decompiled with CFR 0.152.
 */
package ucar.grib.grib2;

import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ucar.grib.GribNumbers;
import ucar.grib.grib2.Grib2BitMapSection;
import ucar.grib.grib2.Grib2DataRepresentationSection;
import ucar.grib.grib2.Grib2GridDefinitionSection;
import ucar.jpeg.jj2000.j2k.decoder.Grib2JpegDecoder;
import ucar.unidata.io.RandomAccessFile;

public final class Grib2DataSection {
    private static final boolean debug = false;
    private static int[] bitsmv1 = new int[31];
    private static final Logger logger;
    private static boolean staticMissingValueInUse;
    private int length;
    private final int section;
    private float[] data;
    private int bitBuf = 0;
    private int bitPos = 0;
    private int scanMode;
    private int count;
    private int Xlength;

    public Grib2DataSection(boolean getData, RandomAccessFile raf, Grib2GridDefinitionSection gds, Grib2DataRepresentationSection drs, Grib2BitMapSection bms) throws IOException {
        this.length = GribNumbers.int4(raf);
        this.section = raf.read();
        if (!getData) {
            if (this.length > 0 && (long)this.length < raf.length()) {
                raf.skipBytes(this.length - 5);
            } else {
                this.length = 5;
            }
            return;
        }
        int dtn = drs.getDataTemplateNumber();
        if (dtn == 0) {
            this.simpleUnpacking(raf, gds, drs, bms);
        } else if (dtn == 1) {
            this.data = null;
            logger.error("Matrix values - simple packing not implemented");
        } else if (dtn == 2) {
            this.complexUnpacking(raf, gds, drs, bms);
        } else if (dtn == 3) {
            this.complexUnpackingWithSpatial(raf, gds, drs, bms);
        } else if (dtn == 40 || dtn == 40000) {
            this.jpeg2000Unpacking(raf, gds, drs, bms);
        }
    }

    private void simpleUnpacking(RandomAccessFile raf, Grib2GridDefinitionSection gds, Grib2DataRepresentationSection drs, Grib2BitMapSection bms) throws IOException {
        int mvm = drs.getMissingValueManagement();
        float mv = Float.NaN;
        if (staticMissingValueInUse) {
            mv = Float.NaN;
        } else if (mvm == 0) {
            mv = Float.NaN;
        } else if (mvm == 1) {
            mv = drs.getPrimaryMissingValue();
        } else if (mvm == 2) {
            mv = drs.getSecondaryMissingValue();
        }
        int nb = drs.getNumberOfBits();
        int D = drs.getDecimalScaleFactor();
        float DD = (float)Math.pow(10.0, D);
        float R = drs.getReferenceValue();
        int E = drs.getBinaryScaleFactor();
        float EE = (float)Math.pow(2.0, E);
        int numberPoints = gds.getGdsVars().getNumberPoints();
        this.data = new float[numberPoints];
        boolean[] bitmap = bms.getBitmap();
        if (bitmap == null) {
            for (int i = 0; i < numberPoints; ++i) {
                this.data[i] = (R + (float)this.bits2UInt(nb, raf) * EE) / DD;
            }
        } else {
            this.bitPos = 0;
            this.bitBuf = 0;
            for (int i = 0; i < bitmap.length; ++i) {
                this.data[i] = bitmap[i] ? (R + (float)this.bits2UInt(nb, raf) * EE) / DD : mv;
            }
        }
        this.scanMode = gds.getGdsVars().getScanMode();
        this.Xlength = gds.getGdsVars().getNx();
        this.scanningModeCheck();
    }

    private void complexUnpacking(RandomAccessFile raf, Grib2GridDefinitionSection gds, Grib2DataRepresentationSection drs, Grib2BitMapSection bms) throws IOException {
        int i;
        int i2;
        int mvm = drs.getMissingValueManagement();
        float mv = Float.NaN;
        if (staticMissingValueInUse) {
            mv = Float.NaN;
        } else if (mvm == 0) {
            mv = Float.NaN;
        } else if (mvm == 1) {
            mv = drs.getPrimaryMissingValue();
        } else if (mvm == 2) {
            mv = drs.getSecondaryMissingValue();
        }
        int numberPoints = gds.getGdsVars().getNumberPoints();
        int NG = drs.getNumberOfGroups();
        if (NG == 0) {
            logger.debug("Grib2DataSection.complexUnpacking : NG = 0 for file" + raf.getLocation());
            this.data = new float[numberPoints];
            if (mvm == 0) {
                for (int i3 = 0; i3 < numberPoints; ++i3) {
                    this.data[i3] = mv;
                }
            } else {
                for (int i4 = 0; i4 < numberPoints; ++i4) {
                    this.data[i4] = mv;
                }
            }
            return;
        }
        int[] X1 = new int[NG];
        int nb = drs.getNumberOfBits();
        if (nb != 0) {
            this.bitPos = 0;
            this.bitBuf = 0;
            for (i2 = 0; i2 < NG; ++i2) {
                X1[i2] = this.bits2UInt(nb, raf);
            }
        } else {
            for (i2 = 0; i2 < NG; ++i2) {
                X1[i2] = 0;
            }
        }
        int[] NB = new int[NG];
        nb = drs.getBitsGroupWidths();
        if (nb != 0) {
            this.bitPos = 0;
            this.bitBuf = 0;
            for (i = 0; i < NG; ++i) {
                NB[i] = this.bits2UInt(nb, raf);
            }
        } else {
            for (i = 0; i < NG; ++i) {
                NB[i] = 0;
            }
        }
        int[] L = new int[NG];
        int ref = drs.getReferenceGroupLength();
        int len_inc = drs.getLengthIncrement();
        nb = drs.getBitsScaledGroupLength();
        this.bitPos = 0;
        this.bitBuf = 0;
        for (int i5 = 0; i5 < NG; ++i5) {
            L[i5] = ref + this.bits2UInt(nb, raf) * len_inc;
        }
        L[NG - 1] = drs.getLengthLastGroup();
        int D = drs.getDecimalScaleFactor();
        float DD = (float)Math.pow(10.0, D);
        float R = drs.getReferenceValue();
        int E = drs.getBinaryScaleFactor();
        float EE = (float)Math.pow(2.0, E);
        this.data = new float[numberPoints];
        this.Xlength = gds.getGdsVars().getNx();
        this.count = 0;
        this.bitPos = 0;
        this.bitBuf = 0;
        for (int i6 = 0; i6 < NG; ++i6) {
            for (int j = 0; j < L[i6]; ++j) {
                if (NB[i6] == 0) {
                    if (mvm == 0) {
                        this.data[this.count++] = (R + (float)X1[i6] * EE) / DD;
                        continue;
                    }
                    this.data[this.count++] = mv;
                    continue;
                }
                int X2 = this.bits2UInt(NB[i6], raf);
                this.data[this.count++] = mvm == 0 ? (R + (float)(X1[i6] + X2) * EE) / DD : (X2 == bitsmv1[NB[i6]] ? mv : (R + (float)(X1[i6] + X2) * EE) / DD);
            }
        }
        boolean[] bitmap = bms.getBitmap();
        if (bitmap != null) {
            int idx = 0;
            float[] tmp = new float[numberPoints];
            for (int i7 = 0; i7 < numberPoints; ++i7) {
                tmp[i7] = bitmap[i7] ? this.data[idx++] : mv;
            }
            this.data = tmp;
        }
        this.scanMode = gds.getGdsVars().getScanMode();
        this.scanningModeCheck();
    }

    private void complexUnpackingWithSpatial(RandomAccessFile raf, Grib2GridDefinitionSection gds, Grib2DataRepresentationSection drs, Grib2BitMapSection bms) throws IOException {
        boolean[] bitmap;
        int i;
        int itemp;
        int i2;
        int i3;
        int i4;
        int i5;
        int i6;
        int mvm = drs.getMissingValueManagement();
        float mv = Float.NaN;
        if (staticMissingValueInUse) {
            mv = Float.NaN;
        } else if (mvm == 0) {
            mv = Float.NaN;
        } else if (mvm == 1) {
            mv = drs.getPrimaryMissingValue();
        } else if (mvm == 2) {
            mv = drs.getSecondaryMissingValue();
        }
        int ival1 = 0;
        int ival2 = 0;
        int minsd = 0;
        int os = drs.getOrderSpatial();
        int nbitsd = drs.getDescriptorSpatial();
        this.bitPos = 0;
        this.bitBuf = 0;
        if ((nbitsd *= 8) != 0) {
            int sign = this.bits2UInt(1, raf);
            ival1 = this.bits2UInt(nbitsd - 1, raf);
            if (sign == 1) {
                ival1 = -ival1;
            }
            if (os == 2) {
                sign = this.bits2UInt(1, raf);
                ival2 = this.bits2UInt(nbitsd - 1, raf);
                if (sign == 1) {
                    ival2 = -ival2;
                }
            }
            sign = this.bits2UInt(1, raf);
            minsd = this.bits2UInt(nbitsd - 1, raf);
            if (sign == 1) {
                minsd = -minsd;
            }
        } else {
            System.out.println("DS error os=" + os + " nbitsd -1 =" + (nbitsd - 1));
            return;
        }
        int numberPoints = gds.getGdsVars().getNumberPoints();
        int NG = drs.getNumberOfGroups();
        if (NG == 0) {
            this.data = new float[numberPoints];
            if (mvm == 0) {
                for (int i7 = 0; i7 < numberPoints; ++i7) {
                    this.data[i7] = mv;
                }
            } else {
                for (int i8 = 0; i8 < numberPoints; ++i8) {
                    this.data[i8] = mv;
                }
            }
            return;
        }
        int[] X1 = new int[NG];
        int nb = drs.getNumberOfBits();
        if (nb != 0) {
            this.bitPos = 0;
            this.bitBuf = 0;
            for (i6 = 0; i6 < NG; ++i6) {
                X1[i6] = this.bits2UInt(nb, raf);
            }
        } else {
            for (i6 = 0; i6 < NG; ++i6) {
                X1[i6] = 0;
            }
        }
        int[] NB = new int[NG];
        nb = drs.getBitsGroupWidths();
        if (nb != 0) {
            this.bitPos = 0;
            this.bitBuf = 0;
            for (i5 = 0; i5 < NG; ++i5) {
                NB[i5] = this.bits2UInt(nb, raf);
            }
        } else {
            for (i5 = 0; i5 < NG; ++i5) {
                NB[i5] = 0;
            }
        }
        int referenceGroupWidths = drs.getReferenceGroupWidths();
        int i9 = 0;
        while (i9 < NG) {
            int n = i9++;
            NB[n] = NB[n] + referenceGroupWidths;
        }
        int[] L = new int[NG];
        int referenceGroupLength = drs.getReferenceGroupLength();
        nb = drs.getBitsScaledGroupLength();
        int len_inc = drs.getLengthIncrement();
        this.bitPos = 0;
        this.bitBuf = 0;
        if (nb != 0) {
            for (i4 = 0; i4 < NG; ++i4) {
                L[i4] = this.bits2UInt(nb, raf);
            }
        } else {
            for (i4 = 0; i4 < NG; ++i4) {
                L[i4] = 0;
            }
        }
        int totalL = 0;
        for (i3 = 0; i3 < NG; ++i3) {
            L[i3] = L[i3] * len_inc + referenceGroupLength;
            totalL += L[i3];
        }
        totalL -= L[NG - 1];
        totalL += drs.getLengthLastGroup();
        L[NG - 1] = drs.getLengthLastGroup();
        if (mvm != 0) {
            if (totalL != numberPoints) {
                for (i3 = 0; i3 < numberPoints; ++i3) {
                    this.data[i3] = mv;
                }
                return;
            }
        } else if (totalL != drs.getDataPoints()) {
            for (i3 = 0; i3 < numberPoints; ++i3) {
                this.data[i3] = mv;
            }
            return;
        }
        int D = drs.getDecimalScaleFactor();
        float DD = (float)Math.pow(10.0, D);
        float R = drs.getReferenceValue();
        int E = drs.getBinaryScaleFactor();
        float EE = (float)Math.pow(2.0, E);
        this.data = new float[numberPoints];
        this.Xlength = gds.getGdsVars().getNx();
        this.count = 0;
        this.bitPos = 0;
        this.bitBuf = 0;
        int dataSize = 0;
        boolean[] dataBitMap = null;
        if (mvm == 0) {
            for (i2 = 0; i2 < NG; ++i2) {
                int j;
                if (NB[i2] != 0) {
                    for (j = 0; j < L[i2]; ++j) {
                        this.data[this.count++] = this.bits2UInt(NB[i2], raf) + X1[i2];
                    }
                    continue;
                }
                for (j = 0; j < L[i2]; ++j) {
                    this.data[this.count++] = X1[i2];
                }
            }
        } else if (mvm == 1 || mvm == 2) {
            dataBitMap = new boolean[numberPoints];
            dataSize = 0;
            for (i2 = 0; i2 < NG; ++i2) {
                int j;
                int msng2;
                int msng1;
                if (NB[i2] != 0) {
                    msng1 = bitsmv1[NB[i2]];
                    msng2 = msng1 - 1;
                    for (j = 0; j < L[i2]; ++j) {
                        this.data[this.count] = this.bits2UInt(NB[i2], raf);
                        if (this.data[this.count] == (float)msng1) {
                            dataBitMap[this.count] = false;
                        } else if (mvm == 2 && this.data[this.count] == (float)msng2) {
                            dataBitMap[this.count] = false;
                        } else {
                            dataBitMap[this.count] = true;
                            this.data[dataSize++] = this.data[this.count] + (float)X1[i2];
                        }
                        ++this.count;
                    }
                    continue;
                }
                msng1 = bitsmv1[drs.getNumberOfBits()];
                msng2 = msng1 - 1;
                if (X1[i2] == msng1) {
                    for (j = 0; j < L[i2]; ++j) {
                        dataBitMap[this.count++] = false;
                    }
                    continue;
                }
                if (mvm == 2 && X1[i2] == msng2) {
                    for (j = 0; j < L[i2]; ++j) {
                        dataBitMap[this.count++] = false;
                    }
                    continue;
                }
                for (j = 0; j < L[i2]; ++j) {
                    dataBitMap[this.count] = true;
                    this.data[dataSize++] = X1[i2];
                    ++this.count;
                }
            }
        }
        if (os == 1) {
            this.data[0] = ival1;
            itemp = mvm == 0 ? numberPoints : dataSize;
            for (i = 1; i < itemp; ++i) {
                int n = i;
                this.data[n] = this.data[n] + (float)minsd;
                this.data[i] = this.data[i] + this.data[i - 1];
            }
        } else if (os == 2) {
            this.data[0] = ival1;
            this.data[1] = ival2;
            itemp = mvm == 0 ? numberPoints : dataSize;
            for (i = 2; i < itemp; ++i) {
                int n = i;
                this.data[n] = this.data[n] + (float)minsd;
                this.data[i] = this.data[i] + 2.0f * this.data[i - 1] - this.data[i - 2];
            }
        }
        if (mvm == 0) {
            for (i2 = 0; i2 < this.data.length; ++i2) {
                this.data[i2] = (R + this.data[i2] * EE) / DD;
            }
        } else {
            dataSize = 0;
            float[] tmp = new float[numberPoints];
            for (i = 0; i < this.data.length; ++i) {
                tmp[i] = dataBitMap[i] ? (R + this.data[dataSize++] * EE) / DD : mv;
            }
            this.data = tmp;
        }
        if ((bitmap = bms.getBitmap()) != null) {
            int idx = 0;
            float[] tmp = new float[numberPoints];
            for (int i10 = 0; i10 < numberPoints; ++i10) {
                tmp[i10] = bitmap[i10] ? this.data[idx++] : mv;
            }
            this.data = tmp;
        }
        this.scanMode = gds.getGdsVars().getScanMode();
        this.scanningModeCheck();
    }

    private void jpeg2000Unpacking(RandomAccessFile raf, Grib2GridDefinitionSection gds, Grib2DataRepresentationSection drs, Grib2BitMapSection bms) throws IOException {
        int mvm = drs.getMissingValueManagement();
        float mv = Float.NaN;
        if (staticMissingValueInUse) {
            mv = Float.NaN;
        } else if (mvm == 0) {
            mv = Float.NaN;
        } else if (mvm == 1) {
            mv = drs.getPrimaryMissingValue();
        } else if (mvm == 2) {
            mv = drs.getSecondaryMissingValue();
        }
        int nb = drs.getNumberOfBits();
        int D = drs.getDecimalScaleFactor();
        float DD = (float)Math.pow(10.0, D);
        float R = drs.getReferenceValue();
        int E = drs.getBinaryScaleFactor();
        float EE = (float)Math.pow(2.0, E);
        Grib2JpegDecoder g2j = null;
        int numberPoints = 0;
        try {
            if (nb != 0) {
                String[] argv = new String[]{"-rate", Integer.toString(nb), "-verbose", "off"};
                g2j = new Grib2JpegDecoder(argv);
                byte[] buf = new byte[this.length - 5];
                raf.read(buf);
                g2j.decode(buf);
            }
            numberPoints = gds.getGdsVars().getNumberPoints();
            this.data = new float[numberPoints];
            boolean[] bitmap = bms.getBitmap();
            if (nb == 0) {
                if (mvm == 0) {
                    for (int i = 0; i < numberPoints; ++i) {
                        this.data[i] = R;
                    }
                } else {
                    for (int i = 0; i < numberPoints; ++i) {
                        this.data[i] = mv;
                    }
                }
            } else if (bitmap == null) {
                if (g2j.data.length != numberPoints) {
                    this.data = null;
                    return;
                }
                for (int i = 0; i < numberPoints; ++i) {
                    this.data[i] = (R + (float)g2j.data[i] * EE) / DD;
                }
            } else {
                int j = 0;
                for (int i = 0; i < bitmap.length; ++i) {
                    this.data[i] = bitmap[i] ? (R + (float)g2j.data[j++] * EE) / DD : mv;
                }
            }
        }
        catch (NullPointerException npe) {
            logger.error("Grib2DataSection.jpeg2000Unpacking: bit rate too small nb =" + nb + " for file" + raf.getLocation());
            for (int i = 0; i < numberPoints; ++i) {
                this.data[i] = mv;
            }
            return;
        }
        this.scanMode = gds.getGdsVars().getScanMode();
        this.scanningModeCheck();
    }

    private int bits2UInt(int nb, RandomAccessFile raf) throws IOException {
        int shift;
        int bitsLeft = nb;
        int result = 0;
        if (this.bitPos == 0) {
            this.bitBuf = raf.read();
            this.bitPos = 8;
        }
        while ((shift = bitsLeft - this.bitPos) > 0) {
            result |= this.bitBuf << shift;
            bitsLeft -= this.bitPos;
            this.bitBuf = raf.read();
            this.bitPos = 8;
        }
        this.bitPos -= bitsLeft;
        this.bitBuf &= 255 >> 8 - this.bitPos;
        return result |= this.bitBuf >> -shift;
    }

    private void scanningModeCheck() {
        if (this.scanMode == 0 || this.scanMode == 64) {
            return;
        }
        if (this.scanMode == 128 || this.scanMode == 192) {
            int mid = this.Xlength / 2;
            for (int index = 0; index < this.data.length; index += this.Xlength) {
                for (int idx = 0; idx < mid; ++idx) {
                    float tmp = this.data[index + idx];
                    this.data[index + idx] = this.data[index + this.Xlength - idx - 1];
                    this.data[index + this.Xlength - idx - 1] = tmp;
                }
            }
            return;
        }
        int mid = this.Xlength / 2;
        for (int index = 0; index < this.data.length; index += this.Xlength) {
            int row = index / this.Xlength;
            if (row % 2 != 1) continue;
            for (int idx = 0; idx < mid; ++idx) {
                float tmp = this.data[index + idx];
                this.data[index + idx] = this.data[index + this.Xlength - idx - 1];
                this.data[index + this.Xlength - idx - 1] = tmp;
            }
        }
    }

    public final float[] getData() {
        return this.data;
    }

    public static boolean isStaticMissingValueInUse() {
        return staticMissingValueInUse;
    }

    public static void setStaticMissingValueInUse(boolean staticMissingValueInUse) {
        Grib2DataSection.staticMissingValueInUse = staticMissingValueInUse;
    }

    static {
        for (int i = 0; i < 31; ++i) {
            Grib2DataSection.bitsmv1[i] = (int)Math.pow(2.0, i) - 1;
        }
        logger = LoggerFactory.getLogger(Grib2DataSection.class);
        staticMissingValueInUse = true;
    }
}

