/*
 * Decompiled with CFR 0.152.
 */
package visad.data.visad.object;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import visad.data.visad.BinaryReader;
import visad.data.visad.BinaryWriter;
import visad.data.visad.object.BinaryObject;

public class BinaryIntegerArray
implements BinaryObject {
    private static final boolean fasterButUglier = true;

    public static final int computeBytes(int[] array) {
        return array == null ? 0 : 4 + array.length * 4;
    }

    public static final int computeBytes(Object[] array) {
        if (array != null) {
            boolean empty = true;
            for (int i = 0; i < array.length; ++i) {
                if (array[i] == null) continue;
                empty = false;
                break;
            }
            if (empty) {
                array = null;
            }
        }
        return array == null ? 0 : 4 + array.length * 4;
    }

    public static final int[] read(BinaryReader reader) throws IOException {
        DataInput file = reader.getInput();
        int len = file.readInt();
        if (len < 1) {
            throw new IOException("Corrupted file (bad double array length " + len + ")");
        }
        int[] array = new int[len];
        for (int i = 0; i < len; ++i) {
            array[i] = file.readInt();
        }
        return array;
    }

    public static final void write(BinaryWriter writer, int[] array, Object token) throws IOException {
        DataOutput file = writer.getOutput();
        byte[] buf = new byte[BinaryIntegerArray.computeBytes(array)];
        int bufIdx = 0;
        int l = array.length;
        for (int b = 3; b >= 0; --b) {
            buf[bufIdx + b] = (byte)(l & 0xFF);
            l >>= 8;
        }
        bufIdx += 4;
        for (int i = 0; i < array.length; ++i) {
            int x = array[i];
            for (int b = 3; b >= 0; --b) {
                buf[bufIdx + b] = (byte)(x & 0xFF);
                x >>= 8;
            }
            bufIdx += 4;
        }
        if (bufIdx < buf.length) {
            System.err.println("BinaryIntegerArray: Missing " + (buf.length - bufIdx) + " bytes");
        }
        file.write(buf);
    }
}

