/*
 * Decompiled with CFR 0.152.
 */
package visad.util;

import java.rmi.RemoteException;
import java.util.Vector;
import visad.Data;
import visad.Display;
import visad.DisplayImpl;
import visad.DisplayRealType;
import visad.FunctionImpl;
import visad.FunctionType;
import visad.MouseBehavior;
import visad.Real;
import visad.RealTuple;
import visad.RealTupleType;
import visad.RealType;
import visad.ScalarMap;
import visad.ScalarType;
import visad.VisADException;
import visad.VisADRay;

public class CursorUtil {
    public static double[] cursorToDomain(DisplayImpl d, RealType[] types, double[] cursor) {
        if (d == null) {
            return null;
        }
        double[][] scale = CursorUtil.getScaleValues(d, types);
        double[] domain = new double[3];
        for (int i = 0; i < 3; ++i) {
            domain[i] = scale[i] == null ? 0.0 : (cursor[i] - scale[i][1]) / scale[i][0];
        }
        return domain;
    }

    public static double[] domainToCursor(DisplayImpl d, RealType[] types, double[] domain) {
        if (d == null) {
            return null;
        }
        double[][] scale = CursorUtil.getScaleValues(d, types);
        double[] cursor = new double[3];
        for (int i = 0; i < 3; ++i) {
            cursor[i] = scale[i] == null ? 0.0 : scale[i][0] * domain[i] + scale[i][1];
        }
        return cursor;
    }

    public static double[] cursorToDomain(DisplayImpl d, double[] cursor) {
        return CursorUtil.cursorToDomain(d, null, cursor);
    }

    public static double[] domainToCursor(DisplayImpl d, double[] domain) {
        return CursorUtil.domainToCursor(d, null, domain);
    }

    public static double[] pixelToCursor(DisplayImpl d, int x, int y) {
        if (d == null) {
            return null;
        }
        MouseBehavior mb = d.getDisplayRenderer().getMouseBehavior();
        VisADRay ray = mb.findRay(x, y);
        return ray.position;
    }

    public static int[] cursorToPixel(DisplayImpl d, double[] cursor) {
        if (d == null) {
            return null;
        }
        MouseBehavior mb = d.getDisplayRenderer().getMouseBehavior();
        return mb.getScreenCoords(cursor);
    }

    public static double[] pixelToDomain(DisplayImpl d, int x, int y) {
        return CursorUtil.cursorToDomain(d, CursorUtil.pixelToCursor(d, x, y));
    }

    public static int[] domainToPixel(DisplayImpl d, double[] domain) {
        return CursorUtil.cursorToPixel(d, CursorUtil.domainToCursor(d, domain));
    }

    public static double[] evaluate(FunctionImpl data, double[] domain) throws VisADException, RemoteException {
        FunctionType functionType = (FunctionType)data.getType();
        RealTupleType domainType = functionType.getDomain();
        RealType[] domainTypes = domainType.getRealComponents();
        int len = domainTypes.length < domain.length ? domainTypes.length : domain.length;
        Real[] v = new Real[len];
        for (int i = 0; i < len; ++i) {
            v[i] = new Real(domainTypes[i], domain[i]);
        }
        RealTuple tuple = new RealTuple(v);
        Data result = data.evaluate(tuple, 100, 202);
        double[] range = null;
        if (result instanceof Real) {
            Real r = (Real)result;
            range = new double[]{r.getValue()};
        } else if (result instanceof RealTuple) {
            RealTuple rt = (RealTuple)result;
            int dim = rt.getDimension();
            range = new double[dim];
            for (int j = 0; j < dim; ++j) {
                Real r = (Real)rt.getComponent(j);
                range[j] = r.getValue();
            }
        }
        return range;
    }

    public static double[][] getScaleValues(DisplayImpl d, RealType[] types) {
        ScalarMap[] maps = CursorUtil.getXYZMaps(d, types);
        ScalarMap mapX = maps[0];
        ScalarMap mapY = maps[1];
        ScalarMap mapZ = maps[2];
        double[][] scale = new double[3][];
        double[] dummy = new double[2];
        if (mapX == null) {
            scale[0] = null;
        } else {
            scale[0] = new double[2];
            mapX.getScale(scale[0], dummy, dummy);
        }
        if (mapY == null) {
            scale[1] = null;
        } else {
            scale[1] = new double[2];
            mapY.getScale(scale[1], dummy, dummy);
        }
        if (mapZ == null) {
            scale[2] = null;
        } else {
            scale[2] = new double[2];
            mapZ.getScale(scale[2], dummy, dummy);
        }
        return scale;
    }

    public static ScalarMap[] getXYZMaps(DisplayImpl d, RealType[] types) {
        Vector maps = d.getMapVector();
        int numMaps = maps.size();
        ScalarMap mapX = null;
        ScalarMap mapY = null;
        ScalarMap mapZ = null;
        for (int i = 0; i < numMaps && (mapX == null || mapY == null || mapZ == null); ++i) {
            ScalarMap map = (ScalarMap)maps.elementAt(i);
            if (types == null) {
                DisplayRealType drt = map.getDisplayScalar();
                if (drt.equals(Display.XAxis) && mapX == null) {
                    mapX = map;
                    continue;
                }
                if (drt.equals(Display.YAxis) && mapY == null) {
                    mapY = map;
                    continue;
                }
                if (!drt.equals(Display.ZAxis) || mapZ != null) continue;
                mapZ = map;
                continue;
            }
            ScalarType st = map.getScalar();
            if (st.equals(types[0])) {
                mapX = map;
            }
            if (st.equals(types[1])) {
                mapY = map;
            }
            if (!st.equals(types[2])) continue;
            mapZ = map;
        }
        return new ScalarMap[]{mapX, mapY, mapZ};
    }
}

