# Autogenerated do not modify manually!
# This is a type-hinting python stub file, used by python IDEs to provide type hints. For more information
# about stub files, see https://www.python.org/dev/peps/pep-0484/#stub-files
# During execution, the actual module is made available via
# a C++ Boost-python process as part of the launch.
from enum import IntEnum
from typing import Generic, Iterable, Iterator, Tuple, TypeVar, overload

from common.fo_typing import (
    BuildingId,
    BuildingName,
    EmpireId,
    FleetId,
    ObjectId,
    PartName,
    PlanetId,
    ShipId,
    SpeciesName,
    SystemId,
    Turn,
)

KT = TypeVar("KT")
VT = TypeVar("VT")

class Set(Generic[VT]):
    def __contains__(self, number: VT) -> bool: ...
    def __iter__(self) -> Iterator[VT]: ...
    def __len__(self) -> int: ...

class Vec(Generic[VT]):
    def __contains__(self, val: VT) -> bool: ...
    def __delitem__(self, val: VT) -> None: ...
    def __getitem__(self, ind: int) -> KT: ...
    def __iter__(self) -> Iterator[VT]: ...
    def __len__(self) -> int: ...
    def __setitem__(self, ind: int, val: VT) -> None: ...
    def append(self, val: VT) -> None: ...
    def extend(self, iterable: Iterable[VT]) -> None: ...

class Item(Generic[KT, VT]):
    def key(self) -> KT: ...
    def data(self) -> VT: ...

class Map(Generic[KT, VT]):
    def __contains__(self, key: KT) -> bool: ...
    def __delitem__(self, key: KT) -> None: ...
    def __getitem__(self, key: KT) -> VT: ...
    def __iter__(self) -> Iterator[Item[KT, VT]]: ...
    def __len__(self) -> int: ...
    def __setitem__(self, key: KT, value: VT) -> None: ...

class AccountingInfo:
    @property
    def causeType(self): ...
    @property
    def customLabel(self): ...
    @property
    def meterChange(self): ...
    @property
    def meterRunningTotal(self): ...
    @property
    def sourceID(self): ...
    @property
    def specificCause(self): ...

class FleetPlan:
    def name(self) -> object: ...
    def ship_designs(self) -> list: ...

class GalaxySetupData:
    @property
    def age(self) -> galaxySetupOptionGeneric: ...
    @property
    def gameUID(self) -> str: ...
    @property
    def maxAIAggression(self) -> aggression: ...
    @property
    def monsterFrequency(self) -> galaxySetupOptionMonsterFreq: ...
    @property
    def nativeFrequency(self) -> galaxySetupOptionGeneric: ...
    @property
    def planetDensity(self) -> galaxySetupOptionGeneric: ...
    @property
    def seed(self) -> str: ...
    @property
    def shape(self) -> galaxyShape: ...
    @property
    def size(self) -> int: ...
    @property
    def specialsFrequency(self) -> galaxySetupOptionGeneric: ...
    @property
    def starlaneFrequency(self) -> galaxySetupOptionGeneric: ...

class GameRules:
    @property
    def empty(self) -> bool: ...
    def getDescription(self, string: str) -> str: ...
    def getDouble(self, string: str) -> float: ...
    def getInt(self, string: str) -> int: ...
    def getRulesAsStrings(self) -> Map[str, str]: ...
    def getString(self, string: str) -> str: ...
    def getToggle(self, string: str) -> bool: ...
    def ruleExists(self, string: str) -> bool: ...
    def ruleExistsWithType(self, string: str, rule_type: ruleType) -> bool: ...

class MonsterFleetPlan:
    def locations(self, item_list: list) -> list: ...
    def name(self) -> object: ...
    def ship_designs(self) -> list: ...
    def spawn_limit(self) -> int: ...
    def spawn_rate(self) -> float: ...

class PlayerSetupData:
    @property
    def empire_color(self): ...
    @property
    def empire_name(self): ...
    @property
    def player_name(self): ...
    @property
    def starting_species(self): ...
    @property
    def starting_team(self): ...

class StringSet2:
    def __contains__(self, string: str) -> bool: ...
    def __iter__(self) -> object: ...
    def __len__(self) -> int: ...
    def empty(self) -> bool: ...

class UnlockableItem:
    @property
    def name(self) -> str: ...
    @property
    def type(self) -> unlockableItemType: ...

class buildingType:
    @property
    def costTimeLocationInvariant(self) -> bool: ...
    @property
    def description(self) -> str: ...
    @property
    def name(self) -> str: ...
    def canBeEnqueued(self, number1: int, number2: int) -> bool: ...
    def canBeProduced(self, number1: int, number2: int) -> bool: ...
    def captureResult(self, number1: int, number2: int, number3: int, boolean: bool) -> captureResult: ...
    def dump(self, number: int) -> str:
        """
        Returns string with debug information, use '0' as argument.
        """
    def perTurnCost(self, number1: int, number2: int) -> float: ...
    def productionCost(self, number1: int, number2: int) -> float: ...
    def productionTime(self, number1: int, number2: int) -> int: ...

class diplomaticMessage:
    @property
    def recipient(self) -> int: ...
    @property
    def sender(self) -> int: ...
    @property
    def type(self) -> diplomaticMessageType: ...

class diplomaticStatusUpdate:
    @property
    def empire1(self): ...
    @property
    def empire2(self): ...
    @property
    def status(self): ...

class empire:
    @property
    def adoptedPolicies(self) -> Vec[str]: ...
    @property
    def allShipDesigns(self) -> Set[int]: ...
    @property
    def availableBuildingTypes(self) -> Set[str]: ...
    @property
    def availablePolicies(self) -> StringSet2: ...
    @property
    def availableShipDesigns(self) -> Set[int]: ...
    @property
    def availableShipHulls(self) -> Set[str]: ...
    @property
    def availableShipParts(self) -> Set[str]: ...
    @property
    def availableTechs(self) -> Set[str]: ...
    @property
    def capitalID(self) -> PlanetId: ...
    @property
    def categoriesSlotPolicies(self) -> Map[str, Map[int, str]]: ...
    @property
    def colour(self) -> tuple: ...
    @property
    def eliminated(self) -> bool: ...
    @property
    def empireID(self) -> EmpireId: ...
    @property
    def emptyPolicySlots(self) -> Map[str, int]: ...
    @property
    def exploredSystemIDs(self) -> Set[int]: ...
    @property
    def fleetSupplyableSystemIDs(self) -> Set[int]: ...
    @property
    def name(self) -> str: ...
    @property
    def planetsWithAllocatedPP(self) -> Map[Set[int], float]: ...
    @property
    def planetsWithAvailablePP(self) -> Map[Set[int], float]: ...
    @property
    def planetsWithWastedPP(self) -> Set[Set[int]]: ...
    @property
    def playerName(self) -> str: ...
    @property
    def productionPoints(self) -> float: ...
    @property
    def productionQueue(self) -> productionQueue: ...
    @property
    def researchQueue(self) -> researchQueue: ...
    @property
    def resourceSupplyGroups(self) -> Set[Set[int]]: ...
    @property
    def supplyUnobstructedSystems(self) -> Set[int]: ...
    @property
    def systemSupplyRanges(self) -> Map[int, float]: ...
    @property
    def totalPolicySlots(self) -> Map[str, int]: ...
    @property
    def totalShipsOwned(self) -> int: ...
    @property
    def turnsPoliciesAdopted(self) -> Map[str, int]: ...
    @property
    def won(self) -> bool: ...
    def buildingTypeAvailable(self, string: str) -> bool: ...
    @overload
    def canBuild(self, build_type: buildType, string: str, number: int) -> bool: ...
    @overload
    def canBuild(self, build_type: buildType, number1: int, number2: int) -> bool: ...
    def canBuild(*args) -> bool: ...
    def getMeter(self, string: str) -> meter:
        """
        Returns the empire meter with the indicated name (string).
        """
    def getTechStatus(self, string: str) -> techStatus: ...
    def hasExploredSystem(self, number: int) -> bool: ...
    def obstructedStarlanes(self) -> Vec[Tuple[int, int]]: ...
    def policyAdopted(self, string: str) -> bool: ...
    def policyAvailable(self, string: str) -> bool: ...
    def policyPrereqsAndExclusionsOK(self, string: str) -> bool: ...
    def population(self) -> float: ...
    def preservedLaneTravel(self, number1: int, number2: int) -> bool: ...
    def productionCostAndTime(self, production_queue_element: productionQueueElement) -> object: ...
    def researchProgress(self, string: str) -> float: ...
    def resourceAvailable(self, resource_type: resourceType) -> float: ...
    def resourceProduction(self, resource_type: resourceType) -> float: ...
    def resourceStockpile(self, resource_type: resourceType) -> float: ...
    def shipDesignAvailable(self, number: int) -> bool: ...
    def slotPolicyAdoptedIn(self, string: str) -> int: ...
    def supplyProjections(self) -> Map[SystemId, int]:
        """
        Returns the (negative) number of jumps (int) away each known system ID (int) is from this empire's supply network. 0 in dicates systems that are fleet supplied. -1 indicates a system that is 1 jump away from a supplied system. -4 indicates a system that is 4 jumps from a supply connection.
        """
    def techResearched(self, string: str) -> bool: ...
    def turnPolicyAdopted(self, string: str) -> int: ...

class fieldType:
    @property
    def description(self) -> str: ...
    @property
    def name(self) -> str: ...
    def dump(self, number: int) -> str:
        """
        Returns string with debug information, use '0' as argument.
        """

class meter:
    @property
    def current(self) -> float: ...
    @property
    def initial(self) -> float: ...
    def dump(self) -> str:
        """
        Returns string with debug information.
        """

class policy:
    @property
    def category(self) -> str: ...
    @property
    def description(self) -> str: ...
    @property
    def name(self) -> str: ...
    @property
    def shortDescription(self) -> str: ...
    @overload
    def adoptionCost(self) -> float: ...
    @overload
    def adoptionCost(self, empire_object: empire) -> float: ...
    @overload
    def adoptionCost(self, number: int) -> float: ...
    def adoptionCost(*args) -> float: ...

class popCenter:
    @property
    def speciesName(self) -> SpeciesName: ...

class productionQueue:
    @property
    def allocatedPP(self) -> Map[Set[int], float]: ...
    @property
    def empireID(self) -> EmpireId: ...
    @property
    def empty(self) -> bool: ...
    @property
    def size(self) -> int: ...
    @property
    def totalSpent(self) -> float: ...
    def __getitem__(self, number: int) -> productionQueueElement: ...
    def __iter__(self) -> object: ...
    def __len__(self) -> int: ...

class productionQueueElement:
    @property
    def allocation(self): ...
    @property
    def allowedStockpile(self): ...
    @property
    def blocksize(self): ...
    @property
    def buildType(self): ...
    @property
    def designID(self): ...
    @property
    def locationID(self): ...
    @property
    def name(self) -> str: ...
    @property
    def paused(self): ...
    @property
    def progress(self): ...
    @property
    def remaining(self): ...
    @property
    def turnsLeft(self): ...

class researchQueue:
    @property
    def empireID(self) -> EmpireId: ...
    @property
    def empty(self) -> bool: ...
    @property
    def size(self) -> int: ...
    @property
    def totalSpent(self) -> float: ...
    def __contains__(self, research_queue_element: researchQueueElement) -> bool: ...
    def __getitem__(self, number: int) -> researchQueueElement: ...
    def __iter__(self) -> object: ...
    def __len__(self) -> int: ...
    def inQueue(self, string: str) -> bool: ...

class researchQueueElement:
    @property
    def allocation(self): ...
    @property
    def tech(self): ...
    @property
    def turnsLeft(self): ...

class resourceCenter:
    @property
    def availableFoci(self): ...
    @property
    def focus(self): ...
    @property
    def turnsSinceFocusChange(self): ...

class shipDesign:
    @property
    def attack(self) -> float: ...
    @property
    def attackStats(self) -> Vec[int]: ...
    @property
    def canColonize(self) -> bool: ...
    @property
    def canInvade(self) -> bool: ...
    @property
    def colonyCapacity(self) -> float: ...
    @property
    def costTimeLocationInvariant(self) -> bool: ...
    @property
    def defense(self) -> float: ...
    @property
    def description(self) -> str: ...
    @property
    def designedOnTurn(self) -> Turn: ...
    @property
    def detection(self) -> float: ...
    @property
    def fuel(self) -> float: ...
    @property
    def hasDirectWeapons(self) -> bool: ...
    @property
    def hasFighters(self) -> bool: ...
    @property
    def hull(self) -> str: ...
    @property
    def id(self) -> int: ...
    @property
    def industryGeneration(self) -> float: ...
    @property
    def influenceGeneration(self) -> float: ...
    @property
    def isArmed(self) -> bool: ...
    @property
    def isMonster(self) -> bool: ...
    @property
    def name(self) -> str: ...
    @property
    def parts(self) -> Vec[PartName]: ...
    @property
    def researchGeneration(self) -> float: ...
    @property
    def shields(self) -> float: ...
    @property
    def ship_hull(self) -> shipHull: ...
    @property
    def speed(self) -> float: ...
    @property
    def stealth(self) -> float: ...
    @property
    def structure(self) -> float: ...
    @property
    def troopCapacity(self) -> float: ...
    def dump(self, number: int) -> str:
        """
        Returns string with debug information, use '0' as argument.
        """
    def perTurnCost(self, number1: int, number2: int) -> float: ...
    def productionCost(self, number1: int, number2: int) -> float: ...
    def productionLocationForEmpire(self, number1: int, number2: int) -> bool: ...
    def productionTime(self, number1: int, number2: int) -> int: ...

class shipHull:
    @property
    def costTimeLocationInvariant(self) -> bool: ...
    @property
    def fuel(self) -> float: ...
    @property
    def name(self) -> str: ...
    @property
    def numSlots(self) -> int: ...
    @property
    def slots(self) -> Vec[shipSlotType]: ...
    @property
    def speed(self) -> float: ...
    @property
    def stealth(self) -> float: ...
    @property
    def structure(self) -> float: ...
    def hasTag(self, string: str) -> bool: ...
    def numSlotsOfSlotType(self, ship_slot_type: shipSlotType) -> int: ...
    def productionCost(self, number1: int, number2: int, number3: int) -> float: ...
    def productionLocation(self, number: int) -> bool:
        """
        Returns the result of Location condition (bool) in passed location_id (int)
        """
    def productionTime(self, number1: int, number2: int, number3: int) -> int: ...

class shipPart:
    @property
    def capacity(self) -> float: ...
    @property
    def costTimeLocationInvariant(self) -> bool: ...
    @property
    def mountableSlotTypes(self) -> Vec[shipSlotType]: ...
    @property
    def name(self) -> str: ...
    @property
    def partClass(self) -> shipPartClass: ...
    @property
    def secondaryStat(self) -> float: ...
    def canMountInSlotType(self, ship_slot_type: shipSlotType) -> bool: ...
    def hasTag(self, string: str) -> bool: ...
    def productionCost(self, number1: int, number2: int, number3: int) -> float: ...
    def productionLocation(self, number: int) -> bool:
        """
        Returns the result of Location condition (bool) in passed location_id (int)
        """
    def productionTime(self, number1: int, number2: int, number3: int) -> int: ...

class special:
    @property
    def description(self) -> str: ...
    @property
    def name(self) -> str: ...
    @property
    def spawnlimit(self) -> int: ...
    @property
    def spawnrate(self) -> float: ...
    def dump(self, number: int) -> str:
        """
        Returns string with debug information, use '0' as argument.
        """
    def initialCapacity(self, number: int) -> float: ...

class species:
    @property
    def canColonize(self) -> bool: ...
    @property
    def canProduceShips(self) -> bool: ...
    @property
    def description(self) -> str: ...
    @property
    def dislikes(self) -> Vec[str]: ...
    @property
    def foci(self) -> Vec[str]: ...
    @property
    def homeworlds(self) -> Set[int]: ...
    @property
    def likes(self) -> Vec[str]: ...
    @property
    def name(self) -> str: ...
    @property
    def native(self) -> bool: ...
    @property
    def preferredFocus(self) -> str: ...
    @property
    def spawnlimit(self) -> int: ...
    @property
    def spawnrate(self) -> float: ...
    @property
    def tags(self) -> Vec[str]: ...
    def dump(self, number: int) -> str:
        """
        Returns string with debug information, use '0' as argument.
        """
    def getPlanetEnvironment(self, planet_type: planetType) -> planetEnvironment: ...

class tech:
    @property
    def category(self) -> str: ...
    @property
    def description(self) -> str: ...
    @property
    def name(self) -> str: ...
    @property
    def prerequisites(self) -> Set[str]: ...
    @property
    def shortDescription(self) -> str: ...
    @property
    def unlockedItems(self) -> Vec[UnlockableItem]: ...
    @property
    def unlockedTechs(self) -> Set[str]: ...
    def perTurnCost(self, number: int) -> float: ...
    def recursivePrerequisites(self, number: int) -> Vec[str]: ...
    def researchCost(self, number: int) -> float: ...
    def researchTime(self, number: int) -> int: ...

class universe:
    @property
    def allObjectIDs(self) -> Vec[int]: ...
    @property
    def buildingIDs(self) -> Vec[BuildingId]: ...
    @property
    def effectAccounting(self) -> Map[int, Map[meterType, Vec[AccountingInfo]]]: ...
    @property
    def fieldIDs(self) -> Vec[int]: ...
    @property
    def fleetIDs(self) -> Vec[FleetId]: ...
    @property
    def planetIDs(self) -> Vec[PlanetId]: ...
    @property
    def shipIDs(self) -> Vec[ShipId]: ...
    @property
    def systemIDs(self) -> Vec[SystemId]: ...
    def destroyedObjectIDs(self, number: int) -> Set[int]: ...
    def dump(self) -> None: ...
    def getBuilding(self, number: int) -> building: ...
    def getField(self, number: int) -> field: ...
    def getFleet(self, number: int) -> fleet: ...
    def getGenericShipDesign(self, string: str) -> shipDesign:
        """
        Returns the ship design (ShipDesign) with the indicated name (string).
        """
    def getImmediateNeighbors(self, number1: int, number2: int) -> Vec[int]: ...
    def getObject(self, number: int) -> universeObject: ...
    def getPlanet(self, number: int) -> planet: ...
    def getShip(self, number: int) -> ship: ...
    def getSystem(self, number: int) -> system: ...
    def getSystemNeighborsMap(self, number1: int, number2: int) -> Map[int, float]: ...
    def getVisibility(self, number1: int, number2: int) -> visibility: ...
    def getVisibilityTurnsMap(self, number1: int, number2: int) -> Map[visibility, int]: ...
    def jumpDistance(self, number1: int, number2: int) -> int:
        """
        If two system ids are passed or both objects are within a system, return the jump distance between the two systems. If one object (e.g. a fleet) is on a starlane, then calculate the jump distance from both ends of the starlane to the target system and return the smaller one.
        """
    def leastJumpsPath(self, number1: int, number2: int, number3: int) -> Vec[int]: ...
    def linearDistance(self, number1: int, number2: int) -> float: ...
    def shortestNonHostilePath(self, number1: int, number2: int, number3: int) -> Vec[int]:
        """
        Shortest sequence of System ids and distance from System (number1) to System (number2) with no hostile Fleets as determined by visibility of Empire (number3).  (number3) must be a valid empire.
        """
    def shortestPath(self, number1: int, number2: int, number3: int) -> Vec[int]: ...
    def shortestPathDistance(self, number1: int, number2: int) -> float: ...
    def statRecords(self) -> Map[str, Map[int, Map[int, float]]]:
        """
        Empire statistics recorded by the server each turn. Indexed first by staistic name (string), then by empire id (int), then by turn number (int), pointing to the statisic value (double).
        """
    def systemHasStarlane(self, number1: int, number2: int) -> bool: ...
    def systemsConnected(self, number1: int, number2: int, number3: int) -> bool: ...
    def updateMeterEstimates(self, obj: object) -> None: ...

class universeObject:
    @property
    def ageInTurns(self): ...
    @property
    def containedObjects(self): ...
    @property
    def containerObject(self): ...
    @property
    def creationTurn(self): ...
    @property
    def id(self) -> ObjectId: ...
    @property
    def meters(self): ...
    @property
    def name(self) -> str: ...
    @property
    def owner(self) -> EmpireId: ...
    @property
    def specials(self): ...
    @property
    def systemID(self) -> SystemId: ...
    @property
    def tags(self): ...
    @property
    def unowned(self): ...
    @property
    def x(self): ...
    @property
    def y(self): ...
    def containedBy(self, number: int) -> bool: ...
    def contains(self, number: int) -> bool: ...
    def currentMeterValue(self, meter_type: meterType) -> float: ...
    def dump(self) -> str:
        """
        Returns string with debug information.
        """
    def getMeter(self, meter_type: meterType) -> meter: ...
    def hasSpecial(self, obj: object) -> bool: ...
    def hasTag(self, string: str) -> bool: ...
    def initialMeterValue(self, meter_type: meterType) -> float: ...
    def ownedBy(self, number: int) -> bool: ...
    def specialAddedOnTurn(self, obj: object) -> int: ...

class building(universeObject):
    @property
    def buildingTypeName(self) -> BuildingName: ...
    @property
    def orderedScrapped(self) -> bool: ...
    @property
    def planetID(self) -> int: ...
    @property
    def producedByEmpireID(self) -> int: ...

class field(universeObject):
    @property
    def fieldTypeName(self) -> str: ...
    @overload
    def inField(self, base_object: universeObject) -> bool: ...
    @overload
    def inField(self, floating_number1: float, floating_number2: float) -> bool: ...
    def inField(*args) -> bool: ...

class fleet(universeObject):
    @property
    def aggression(self) -> fleetAggression: ...
    @property
    def aggressive(self) -> bool: ...
    @property
    def canChangeDirectionEnRoute(self) -> bool: ...
    @property
    def empty(self) -> bool: ...
    @property
    def finalDestinationID(self) -> int: ...
    @property
    def fuel(self) -> float: ...
    @property
    def hasArmedShips(self) -> bool: ...
    @property
    def hasColonyShips(self) -> bool: ...
    @property
    def hasFighterShips(self) -> bool: ...
    @property
    def hasMonsters(self) -> bool: ...
    @property
    def hasOutpostShips(self) -> bool: ...
    @property
    def hasTroopShips(self) -> bool: ...
    @property
    def maxFuel(self) -> float: ...
    @property
    def nextSystemID(self) -> int: ...
    @property
    def numShips(self) -> int: ...
    @property
    def obstructive(self) -> bool: ...
    @property
    def previousSystemID(self) -> int: ...
    @property
    def route(self) -> Vec[int]: ...
    @property
    def shipIDs(self) -> Set[ShipId]: ...
    @property
    def speed(self) -> float: ...

class ship(universeObject):
    @property
    def arrivedOnTurn(self) -> int: ...
    @property
    def canBombard(self) -> bool: ...
    @property
    def canColonize(self) -> bool: ...
    @property
    def canInvade(self) -> bool: ...
    @property
    def colonyCapacity(self) -> float: ...
    @property
    def design(self) -> shipDesign: ...
    @property
    def designID(self) -> int: ...
    @property
    def fleetID(self) -> int: ...
    @property
    def hasFighters(self) -> bool: ...
    @property
    def isArmed(self) -> bool: ...
    @property
    def isMonster(self) -> bool: ...
    @property
    def lastResuppliedOnTurn(self) -> int: ...
    @property
    def lastTurnActiveInCombat(self) -> int: ...
    @property
    def orderedColonizePlanet(self) -> int: ...
    @property
    def orderedInvadePlanet(self) -> int: ...
    @property
    def orderedScrapped(self) -> bool: ...
    @property
    def partMeters(self) -> Map[Tuple[str, str], meter]: ...
    @property
    def producedByEmpireID(self) -> int: ...
    @property
    def speciesName(self) -> SpeciesName: ...
    @property
    def speed(self) -> float: ...
    @property
    def troopCapacity(self) -> float: ...
    def currentPartMeterValue(self, meter_type: meterType, string: str) -> float: ...
    def initialPartMeterValue(self, meter_type: meterType, string: str) -> float: ...

class system(universeObject):
    @property
    def buildingIDs(self) -> Set[BuildingId]: ...
    @property
    def fieldIDs(self) -> Set[int]: ...
    @property
    def fleetIDs(self) -> Set[FleetId]: ...
    @property
    def lastTurnBattleHere(self) -> int: ...
    @property
    def numStarlanes(self) -> int: ...
    @property
    def numWormholes(self) -> int: ...
    @property
    def planetIDs(self) -> Set[PlanetId]: ...
    @property
    def shipIDs(self) -> Set[ShipId]: ...
    @property
    def starType(self) -> starType: ...
    @property
    def starlanesWormholes(self) -> Map[int, bool]: ...
    def HasStarlaneToSystemID(self, number: int) -> bool: ...
    def HasWormholeToSystemID(self, number: int) -> bool:
        """
        Currently unused.
        """

class planet(universeObject, popCenter, resourceCenter):
    @property
    def InitialOrbitalPosition(self) -> float: ...
    @property
    def LastTurnAttackedByShip(self) -> int: ...
    @property
    def LastTurnColonized(self) -> int: ...
    @property
    def LastTurnConquered(self) -> int: ...
    @property
    def OrbitalPeriod(self) -> float: ...
    @property
    def RotationalPeriod(self) -> float: ...
    @property
    def buildingIDs(self) -> Set[BuildingId]: ...
    @property
    def clockwiseNextPlanetType(self) -> planetType: ...
    @property
    def counterClockwiseNextPlanetType(self) -> planetType: ...
    @property
    def distanceFromOriginalType(self) -> int: ...
    @property
    def habitableSize(self) -> int: ...
    @property
    def nextLargerPlanetSize(self) -> planetSize: ...
    @property
    def nextSmallerPlanetSize(self) -> planetSize: ...
    @property
    def originalType(self) -> planetType: ...
    @property
    def size(self) -> planetSize: ...
    @property
    def type(self) -> planetType: ...
    def OrbitalPositionOnTurn(self, number: int) -> float: ...
    def environmentForSpecies(self, string: str) -> planetEnvironment: ...
    def nextBetterPlanetTypeForSpecies(self, string: str) -> planetType: ...

class aggression(IntEnum):
    invalid = -1
    beginner = 0
    turtle = 1
    cautious = 2
    typical = 3
    aggressive = 4
    maniacal = 5

class buildType(IntEnum):
    INVALID_BUILD_TYPE = -1
    BT_NOT_BUILDING = 0
    BT_BUILDING = 1
    BT_SHIP = 2
    BT_PROJECT = 3
    BT_STOCKPILE = 4
    NUM_BUILD_TYPES = 5

class captureResult(IntEnum):
    capture = 0
    destroy = 1
    retain = 2

class diplomaticMessageType(IntEnum):
    noMessage = -1
    warDeclaration = 0
    peaceProposal = 1
    acceptPeaceProposal = 2
    alliesProposal = 3
    acceptAlliesProposal = 4
    endAllies = 5
    cancelProposal = 6
    rejectProposal = 7

class diplomaticStatus(IntEnum):
    war = 0
    peace = 1
    allied = 2

class effectsCauseType(IntEnum):
    invalid = -1
    unknown = 0
    inherent = 1
    tech = 2
    building = 3
    field = 4
    special = 5
    species = 6
    shipPart = 7
    shipHull = 8
    policy = 9

class fleetAggression(IntEnum):
    passive = 0
    defensive = 1
    obstructive = 2
    aggressive = 3

class galaxySetupOptionGeneric(IntEnum):
    invalid = -1
    none = 0
    low = 1
    medium = 2
    high = 3
    random = 4

class galaxySetupOptionMonsterFreq(IntEnum):
    invalid = -1
    none = 0
    extremelyLow = 1
    veryLow = 2
    low = 3
    medium = 4
    high = 5
    veryHigh = 6
    extremelyHigh = 7
    random = 8

class galaxyShape(IntEnum):
    invalid = -1
    spiral2 = 0
    spiral3 = 1
    spiral4 = 2
    cluster = 3
    elliptical = 4
    disc = 5
    box = 6
    irregular = 7
    ring = 8
    random = 9

class meterType(IntEnum):
    targetPopulation = 0
    targetIndustry = 1
    targetResearch = 2
    targetInfluence = 3
    targetConstruction = 4
    targetHappiness = 5
    maxCapacity = 6
    maxSecondaryStat = 7
    maxFuel = 8
    maxShield = 9
    maxStructure = 10
    maxDefense = 11
    maxSupply = 12
    maxStockpile = 13
    maxTroops = 14
    population = 15
    industry = 16
    research = 17
    influence = 18
    construction = 19
    happiness = 20
    capacity = 21
    secondaryStat = 22
    fuel = 23
    shield = 24
    structure = 25
    defense = 26
    supply = 27
    stockpile = 28
    troops = 29
    rebels = 30
    size = 31
    stealth = 32
    detection = 33
    speed = 34

class planetEnvironment(IntEnum):
    uninhabitable = 0
    hostile = 1
    poor = 2
    adequate = 3
    good = 4

class planetSize(IntEnum):
    unknown = -1
    noWorld = 0
    tiny = 1
    small = 2
    medium = 3
    large = 4
    huge = 5
    asteroids = 6
    gasGiant = 7

class planetType(IntEnum):
    unknown = -1
    swamp = 0
    toxic = 1
    inferno = 2
    radiated = 3
    barren = 4
    tundra = 5
    desert = 6
    terran = 7
    ocean = 8
    asteroids = 9
    gasGiant = 10

class resourceType(IntEnum):
    industry = 0
    influence = 1
    research = 2
    stockpile = 3

class roleType(IntEnum):
    host = 0
    clientTypeModerator = 1
    clientTypePlayer = 2
    clientTypeObserver = 3
    galaxySetup = 4

class ruleType(IntEnum):
    invalid = -1
    toggle = 0
    int = 1
    double = 2
    string = 3

class shipPartClass(IntEnum):
    shortRange = 0
    fighterBay = 1
    fighterHangar = 2
    shields = 3
    armour = 4
    troops = 5
    detection = 6
    stealth = 7
    fuel = 8
    colony = 9
    speed = 10
    general = 11
    bombard = 12
    industry = 13
    research = 14
    influence = 15
    productionLocation = 16

class shipSlotType(IntEnum):
    external = 0
    internal = 1
    core = 2

class starType(IntEnum):
    unknown = -1
    blue = 0
    white = 1
    yellow = 2
    orange = 3
    red = 4
    neutron = 5
    blackHole = 6
    noStar = 7

class techStatus(IntEnum):
    unresearchable = 0
    partiallyUnlocked = 1
    researchable = 2
    complete = 3

class unlockableItemType(IntEnum):
    invalid = -1
    building = 0
    shipPart = 1
    shipHull = 2
    shipDesign = 3
    tech = 4
    policy = 5

class visibility(IntEnum):
    invalid = -1
    none = 0
    basic = 1
    partial = 2
    full = 3

def add_special(number: int, string: str) -> None: ...
def all_empires() -> int: ...
def create_building(string: str, number1: int, number2: int) -> int: ...
def create_field(string: str, floating_number1: float, floating_number2: float, floating_number3: float) -> int: ...
def create_field_in_system(string: str, floating_number: float, number: int) -> int: ...
def create_fleet(string: str, number1: int, number2: int, boolean: bool) -> int: ...
def create_monster(string: str, number: int) -> int: ...
def create_monster_fleet(number: int) -> int: ...
def create_planet(planet_size: planetSize, planet_type: planetType, number1: int, number2: int, string: str) -> int: ...
def create_ship(string1: str, string2: str, string3: str, number: int) -> int: ...
def create_system(star_type: starType, string: str, floating_number1: float, floating_number2: float) -> int: ...
def current_turn() -> int: ...
def design_create(
    string1: str,
    string2: str,
    string3: str,
    item_list: list,
    string4: str,
    string5: str,
    boolean: bool,
) -> bool: ...
def design_get_monster_list() -> list: ...
def design_get_premade_list() -> list: ...
def empire_add_ship_design(number: int, string: str) -> None: ...
def empire_set_homeworld(number1: int, number2: int, string: str) -> bool: ...
def empire_set_name(number: int, string: str) -> None: ...
def empire_set_stockpile(number: int, resource_type: resourceType, floating_number: float) -> None: ...
def empire_unlock_item(number: int, unlockable_item_type: unlockableItemType, string: str) -> None: ...
@overload
def generate_sitrep(number: int, string1: str, dictionary: dict, string2: str) -> None: ...
@overload
def generate_sitrep(number: int, string1: str, string2: str) -> None: ...
def generate_sitrep(*args) -> None: ...
def generate_starlanes(number1: int, number2: int) -> None: ...
def getBuildingType(string: str) -> buildingType:
    """
    Returns the building type (BuildingType) with the indicated name (string).
    """

def getFieldType(string: str) -> fieldType: ...
def getGameRules() -> GameRules:
    """
    Returns the game rules manager, which can be used to look up the names (string) of rules are defined with what type (boolean / toggle, int, double, string), and what values the rules have in the current game.
    """

def getNamedInt(string: str) -> int:
    """
    Returns the named integer value of the scripted constant with name (string). If no such named constant exists, returns 0.
    """

def getNamedReal(string: str) -> float:
    """
    Returns the named real value of the scripted constant with name (string). If no such named constant exists, returns 0.0.
    """

def getPolicy(string: str) -> policy:
    """
    Returns the policy (Policy) with the indicated name (string).
    """

def getPredefinedShipDesign(string: str) -> shipDesign:
    """
    Returns the ship design (ShipDesign) with the indicated name (string).
    """

def getShipDesign(number: int) -> shipDesign:
    """
    Returns the ship design (ShipDesign) with the indicated id number (int).
    """

def getShipHull(string: str) -> shipHull:
    """
    Returns the ship hull with the indicated name (string).
    """

def getShipPart(string: str) -> shipPart:
    """
    Returns the ShipPart with the indicated name (string).
    """

def getSpecial(string: str) -> special:
    """
    Returns the special (Special) with the indicated name (string).
    """

def getSpecies(string: str) -> species:
    """
    Returns the species (Species) with the indicated name (string).
    """

def getTech(string: str) -> tech:
    """
    Returns the tech (Tech) with the indicated name (string).
    """

def getTechCategories() -> Vec[str]:
    """
    Returns the names of all tech categories (StringVec).
    """

def get_all_empires() -> list: ...
def get_all_objects() -> list: ...
def get_all_specials() -> list: ...
def get_all_species() -> list: ...
def get_empire(number: int) -> empire: ...
def get_galaxy_setup_data() -> GalaxySetupData: ...
def get_name(number: int) -> object:
    """
    Returns the name (string) of the universe object with the specified object id (int). If there is no such object, returns an empty string and logs an error to the error log.
    """

def get_native_species() -> list: ...
def get_options_db_option_bool(string: str) -> object:
    """
    Returns the bool value of option in OptionsDB or None if the option does not exist.
    """

def get_options_db_option_double(string: str) -> object:
    """
    Returns the double value of option in OptionsDB or None if the option does not exist.
    """

def get_options_db_option_int(string: str) -> object:
    """
    Returns the integer value of option in OptionsDB or None if the option does not exist.
    """

def get_options_db_option_str(string: str) -> object:
    """
    Returns the string value of option in OptionsDB or None if the option does not exist.
    """

def get_owner(number: int) -> int: ...
def get_playable_species() -> list: ...
def get_pos(number: int) -> tuple: ...
def get_resource_dir() -> object: ...
def get_systems() -> list: ...
def get_universe() -> universe: ...
def get_universe_width() -> float: ...
def get_user_config_dir() -> str:
    """
    Returns path to directory where FreeOrion stores user specific configuration.
    """

def get_user_data_dir() -> str:
    """
    Returns path to directory where FreeOrion stores user specific data (saves, etc.).
    """

def get_x(number: int) -> float: ...
def get_y(number: int) -> float: ...
def invalid_object() -> int: ...
def invalid_position() -> float: ...
def jump_distance(number1: int, number2: int) -> int: ...
def large_meter_value() -> float: ...
def linear_distance(number1: int, number2: int) -> float: ...
def load_fleet_plan_list() -> list: ...
def load_monster_fleet_plan_list() -> list: ...
def load_starting_buildings() -> list: ...
def load_unlockable_item_list() -> list: ...
def namedIntDefined(string: str) -> bool:
    """
    Returns true/false (boolean) whether there is a defined int-valued scripted constant with name (string).
    """

def namedRealDefined(string: str) -> bool:
    """
    Returns true/false (boolean) whether there is a defined double-valued scripted constant with name (string).
    """

def objs_get_systems(item_list: list) -> list: ...
def planet_available_foci(number: int) -> list: ...
def planet_cardinal_suffix(number: int) -> object: ...
def planet_get_focus(number: int) -> object: ...
def planet_get_size(number: int) -> planetSize: ...
def planet_get_species(number: int) -> object: ...
def planet_get_type(number: int) -> planetType: ...
def planet_make_colony(number1: int, number2: int, string: str, floating_number: float) -> bool: ...
def planet_make_outpost(number1: int, number2: int) -> bool: ...
def planet_set_focus(number: int, string: str) -> None: ...
def planet_set_size(number: int, planet_size: planetSize) -> None: ...
def planet_set_species(number: int, string: str) -> None: ...
def planet_set_type(number: int, planet_type: planetType) -> None: ...
def policies() -> Vec[str]:
    """
    Returns the names of all policies (StringVec).
    """

def policiesInCategory(string: str) -> Vec[str]:
    """
    Returns the names of all policies (StringVec) in the indicated policy category name (string).
    """

def policyCategories() -> Vec[str]:
    """
    Returns the names of all policy categories (StringVec).
    """

def remove_special(number: int, string: str) -> None: ...
def roman_number(number: int) -> str: ...
def set_name(number: int, string: str) -> None:
    """
    Sets the name (string) of the universe object with the specified object id (int). If there is no such object, just logs an error to the error log.
    """

def set_universe_width(floating_number: float) -> None: ...
def special_has_location(string: str) -> bool: ...
def special_locations(string: str, item_list: list) -> list: ...
def special_spawn_limit(string: str) -> int: ...
def special_spawn_rate(string: str) -> float: ...
def species_add_homeworld(string: str, number: int) -> None: ...
def species_can_colonize(string: str) -> bool: ...
def species_get_planet_environment(string: str, planet_type: planetType) -> planetEnvironment: ...
def species_preferred_focus(string: str) -> object: ...
def species_remove_homeworld(string: str, number: int) -> None: ...
def sys_add_starlane(number1: int, number2: int) -> None: ...
def sys_free_orbits(number: int) -> list: ...
def sys_get_fleets(number: int) -> list: ...
def sys_get_num_orbits(number: int) -> int: ...
def sys_get_planets(number: int) -> list: ...
def sys_get_star_type(number: int) -> starType: ...
def sys_get_starlanes(number: int) -> list: ...
def sys_orbit_occupied(number1: int, number2: int) -> bool: ...
def sys_orbit_of_planet(number1: int, number2: int) -> int: ...
def sys_remove_starlane(number1: int, number2: int) -> None: ...
def sys_set_star_type(number: int, star_type: starType) -> None: ...
def systems_within_jumps_unordered(number: int, item_list: list) -> list:
    """
    Return all systems within ''jumps'' of the systems with ids ''sys_ids''
    """

def techs() -> Vec[str]:
    """
    Returns the names of all techs (StringVec).
    """

def techsInCategory(string: str) -> Vec[str]:
    """
    Returns the names of all techs (StringVec) in the indicated tech category name (string).
    """

def userString(string: str) -> str: ...
def userStringExists(string: str) -> bool: ...
def validShipDesign(string: str, item_list: list) -> bool:
    """
    Returns true (boolean) if the passed hull (string) and parts (list of string) make up a valid ship design, and false (boolean) otherwise. Valid ship designs don't have any parts in slots that can't accept that type of part, and contain only hulls and parts that exist (and may also need to contain the correct number of parts - this needs to be verified).
    """
