import QtQuick 2.0
import Ubuntu.Components 0.1
import Friends 0.2
import Ubuntu.Layouts 0.1

Page {
    title: i18n.tr("Conversation")
    id: conversationPage

    property bool useBroadLayout: main.width > units.gu(120) && metaInfo.isImagePost

    clip: true

    //TODO doesn't work yet
    flickable: null
    //flickable: useBroadLayout ? null : normalFlickable

    function setContent(tile) {
        this.tile = tile

        //Assign all values of the tile to the conversation page
        //This way we can have one page for all tiles
        liked = tile.liked
        likeCount = tile.likeCount
        likesString = tile.likesString
        fromMe = tile.fromMe
        service = tile.service
        linkUrl = tile.linkUrl
        linkName = tile.linkName
        linkDescription = tile.linkDescription
        avatar = tile.avatar
        message = tile.message
        timeString = tile.timeString
        location = tile.location
        sender = tile.sender
        linkPicture = tile.linkPicture
        latitude = tile.latitude
        longitude = tile.longitude
        messageId = tile.messageId
        accountId = tile.accountId
        stream = tile.stream
        senderNick = tile.senderNick
        url = tile.url

        conversationDetails.reset()
    }

    //Forward properties from StatusUpdateTile
    property bool liked
    property int likeCount
    property string likesString
    property bool fromMe
    property string service
    property string linkUrl
    property string linkName
    property string linkDescription
    property variant avatar
    property string message
    property variant tile
    property string timeString
    property string location
    property string sender
    property string linkPicture
    property int latitude
    property int longitude
    property string messageId
    property string accountId
    property string stream
    property string senderNick
    property string url

    function close() {
        main.closeConversation();
    }

    MetaInfo {
        id: metaInfo
    }

    Layouts {
        id: layouts

        width: parent.width
        height: childrenRect.height
        layouts: [
            ConditionalLayout {
                name: "broad"
                when: conversationPage.useBroadLayout

                Item {
                    id: broadLayout
                    width: conversationPage.width
                    height: conversationPage.height

                    // Add some background to it
                    Rectangle {
                        id: sideColumnContainer

                        anchors {
                            top: parent.top
                            bottom: parent.bottom
                            left: parent.left
                        }

                        width: units.gu(60)
                        color: Qt.rgba(1,1,1,0.2)

                        Flickable {
                            id: sideFlickable

                            anchors {
                                fill: parent
                                margins: units.gu(1)
                            }

                            // chilrenRect.height seems to be broken
                            contentHeight: sideColumn.height + 2 * sideColumn.anchors.margins

                            flickableDirection: Flickable.VerticalFlick
                            boundsBehavior: Flickable.DragOverBounds

                            Column {
                                id: sideColumn

                                anchors {
                                    top: parent.top
                                    left: parent.left
                                    right: parent.right
                                    margins: units.gu(3)
                                }

                                height: childrenRect.height

                                spacing: units.gu(1)

                                ItemLayout {
                                    item: "OriginalPost"

                                    width: parent.width
                                    height: statusUpdateContent.height
                                }

                                ItemLayout {
                                    item: "ConversationDetails"

                                    width: parent.width
                                    height: conversationDetails.childrenRect.height
                                }
                            }
                        }
                    }

                    Image {
                        id: imageContainer

                        anchors {
                            top: parent.top
                            right: parent.right
                            left: sideColumnContainer.right

                            margins: units.gu(5)
                        }

                        height: 0.9 * conversationPage.height

                        visible: linkPicture.length > 0 && status == Image.Ready
                        source: Qt.resolvedUrl(linkPicture)
                        asynchronous: true

                        fillMode: Image.PreserveAspectFit

                        MouseArea {
                            anchors.fill: parent
                            cursorShape: Qt.PointingHandCursor

                            onClicked: {
                                if (linkUrl.length > 0)
                                {
                                    Qt.openUrlExternally(linkUrl);
                                }
                            }
                        }
                    }
                }
            },
            ConditionalLayout {
                name: "normal"
                when: !conversationPage.useBroadLayout

                Flickable {
                    id: normalFlickable

                    width: conversationPage.width
                    height: conversationPage.height

                    // chilrenRect.height seems to be broken
                    contentHeight: column.height + 2 * column.anchors.margins

                    flickableDirection: Flickable.VerticalFlick
                    boundsBehavior: Flickable.DragOverBounds

                    Column {
                        id: column

                        anchors {
                            left: parent.left
                            right: parent.right
                            top: parent.top

                            margins: units.gu(3)
                        }

                        spacing: units.gu(1)

                        ItemLayout {
                            item: "OriginalPost"

                            width: parent.width
                            height: statusUpdateContent.height
                        }

                        StatusUpdateAttachment {
                            width: parent.width
                            crop: false
                        }

                        ItemLayout {
                            item: "ConversationDetails"

                            width: parent.width

                            //Ugly hack needed for layouts to work :(
                            height: conversationDetails.childrenRect.height
                        }
                    }
                }
            }
        ]

        Row {
            id: originalPost
            Layouts.item: "OriginalPost"

            spacing: units.gu(1)

            AvatarImage {
                id: avatarImage
            }

            StatusUpdateContent {
                id: statusUpdateContent

                width: parent.width - avatarImage.width
                showDetails: true
            }
        }

        ConversationDetails {
            Layouts.item: "ConversationDetails"
            id: conversationDetails
        }
    }

    Keys.onEscapePressed: {
        conversationPage.close()
    }
}

