/*
 * Decompiled with CFR 0.152.
 */
package hypergraph.hyperbolic;

import hypergraph.hyperbolic.Isometry;
import hypergraph.hyperbolic.LineRenderer;
import hypergraph.hyperbolic.Model;
import hypergraph.hyperbolic.ModelPanel;
import hypergraph.hyperbolic.ModelPoint;
import hypergraph.hyperbolic.Renderer;
import hypergraph.hyperbolic.TextRenderer;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.geom.Point2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.Hashtable;
import javax.swing.CellRendererPane;
import javax.swing.JComponent;
import javax.swing.Timer;
import javax.swing.plaf.ComponentUI;

public class ModelPanelUI
extends ComponentUI
implements PropertyChangeListener {
    private ModelPoint tempmp;
    private Isometry viewMatrix;
    private Isometry inversViewMatrix;
    private boolean draft;
    private boolean animation;
    protected ModelPanel panel;
    private Hashtable currentRenderer;
    private String projection;
    private CellRendererPane rendererPane;
    Timer timer;
    Animator animator = new Animator();

    public static ComponentUI createUI(JComponent jComponent) {
        return new ModelPanelUI();
    }

    public void installUI(JComponent jComponent) {
        jComponent.addPropertyChangeListener(this);
        this.panel = (ModelPanel)jComponent;
        this.rendererPane = new CellRendererPane();
        this.tempmp = ((ModelPanel)jComponent).getModel().getOrigin();
    }

    public void uninstallUI(JComponent jComponent) {
    }

    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
    }

    public CellRendererPane getRendererPane() {
        return this.rendererPane;
    }

    public void paintRenderer(Graphics graphics, JComponent jComponent, Renderer renderer) {
        Component component = renderer.getComponent();
        this.getRendererPane().paintComponent(graphics, component, jComponent, component.getX(), component.getY(), component.getWidth(), component.getHeight());
    }

    public void paintLine(Graphics graphics, JComponent jComponent, ModelPoint modelPoint, ModelPoint modelPoint2) {
        LineRenderer lineRenderer = this.panel.getLineRenderer();
        lineRenderer.configure(this.panel, modelPoint, modelPoint2);
        this.paintRenderer(graphics, jComponent, lineRenderer);
    }

    public void paintText(Graphics graphics, JComponent jComponent, ModelPoint modelPoint, String string) {
        TextRenderer textRenderer = this.panel.getTextRenderer();
        textRenderer.configure(this.panel, modelPoint, string);
        this.paintRenderer(graphics, jComponent, textRenderer);
    }

    public boolean isDraft() {
        return this.draft;
    }

    public void setDraft(boolean bl) {
        this.draft = bl;
    }

    public boolean isAnimation() {
        return this.animation;
    }

    public void setAnimation(boolean bl) {
        this.animation = bl;
    }

    public Point2D getScale(ModelPoint modelPoint, JComponent jComponent) {
        this.tempmp.setTo(modelPoint);
        this.applyViewMatrix(this.tempmp, jComponent);
        return ((ModelPanel)jComponent).getProjector().getScale(this.tempmp, jComponent);
    }

    public Point map(ModelPoint modelPoint, JComponent jComponent) {
        return ((ModelPanel)jComponent).getProjector().map(modelPoint, jComponent);
    }

    public Point project(ModelPoint modelPoint, JComponent jComponent) {
        this.tempmp.setTo(modelPoint);
        this.applyViewMatrix(this.tempmp, jComponent);
        return this.map(this.tempmp, jComponent);
    }

    public ModelPoint inversMap(Point point, JComponent jComponent) {
        return ((ModelPanel)jComponent).getProjector().inversMap(point, jComponent);
    }

    public ModelPoint unProject(Point point, JComponent jComponent) {
        ModelPoint modelPoint = this.inversMap(point, jComponent);
        if (modelPoint == null) {
            return null;
        }
        this.applyInversViewMatrix(modelPoint, jComponent);
        return modelPoint;
    }

    public void applyViewMatrix(ModelPoint modelPoint, JComponent jComponent) {
        Isometry isometry = ((ModelPanel)jComponent).getViewMatrix();
        isometry.apply(modelPoint);
    }

    public void applyInversViewMatrix(ModelPoint modelPoint, JComponent jComponent) {
        Isometry isometry = ((ModelPanel)jComponent).getInversViewMatrix();
        isometry.apply(modelPoint);
    }

    public void animate(Isometry[] isometryArray, JComponent jComponent) {
        if (this.timer == null) {
            this.timer = new Timer(0, this.animator);
            this.animator.setTimer(this.timer);
        }
        if (!this.timer.isRunning()) {
            this.animator.setIsometries(isometryArray);
            this.animator.setComponent(jComponent);
            this.timer.setDelay(50);
            this.timer.setInitialDelay(50);
            this.timer.start();
        }
    }

    public Point getCenter(JComponent jComponent) {
        return new Point(jComponent.getWidth() / 2, jComponent.getHeight() / 2);
    }

    public void center(Point point, JComponent jComponent) {
        this.move(point, this.getCenter(jComponent), jComponent);
    }

    public void center(ModelPoint modelPoint, JComponent jComponent) {
        this.move(modelPoint, this.getCenter(jComponent), jComponent);
    }

    public void move(ModelPoint modelPoint, Point point, JComponent jComponent) {
        ModelPoint modelPoint2 = (ModelPoint)modelPoint.clone();
        this.applyViewMatrix(modelPoint2, jComponent);
        ModelPoint modelPoint3 = this.inversMap(point, jComponent);
        if (modelPoint3 == null) {
            return;
        }
        this.moveOnIntermediateLevel(modelPoint2, modelPoint3, jComponent);
    }

    public void move(Point point, Point point2, JComponent jComponent) {
        Model model = ((ModelPanel)jComponent).getModel();
        ModelPoint modelPoint = this.inversMap(point, jComponent);
        if (modelPoint == null) {
            return;
        }
        ModelPoint modelPoint2 = this.inversMap(point2, jComponent);
        if (modelPoint2 == null) {
            return;
        }
        this.moveOnIntermediateLevel(modelPoint, modelPoint2, jComponent);
    }

    private void moveOnIntermediateLevel(ModelPoint modelPoint, ModelPoint modelPoint2, JComponent jComponent) {
        Model model = ((ModelPanel)jComponent).getModel();
        if (model.dist(modelPoint, modelPoint2) < 0.01) {
            return;
        }
        int n = 1;
        if (this.isAnimation()) {
            n = 10;
        }
        Isometry[] isometryArray = new Isometry[n];
        for (int i = 0; i < isometryArray.length; ++i) {
            isometryArray[i] = model.getTranslation(modelPoint, modelPoint2, ((double)i + 1.0) / (double)n);
            isometryArray[i].multiplyRight(((ModelPanel)jComponent).getViewMatrix());
        }
        this.animate(isometryArray, jComponent);
    }

    class Animator
    implements ActionListener {
        Timer timer;
        int current;
        Isometry[] isometries;
        JComponent c;

        Animator() {
        }

        public void setComponent(JComponent jComponent) {
            this.c = jComponent;
        }

        public void setIsometries(Isometry[] isometryArray) {
            this.isometries = isometryArray;
            this.current = 0;
        }

        public void setTimer(Timer timer) {
            this.timer = timer;
        }

        public void actionPerformed(ActionEvent actionEvent) {
            if (this.current < 0 || this.current >= this.isometries.length) {
                this.timer.stop();
                return;
            }
            if (this.current == 0) {
                ModelPanelUI.this.setDraft(true);
            }
            if (this.current == this.isometries.length - 1) {
                ModelPanelUI.this.setDraft(false);
                this.timer.stop();
            }
            ((ModelPanel)this.c).setViewMatrix(this.isometries[this.current]);
            ++this.current;
        }
    }
}

