<?php $thisPage="Documentation"; include("header.inc") ?>
  <div id="content">
    <h1>Getfem documentation</h1>

    A number of documents are available. Please report any error or
    mistake to <a
    href="mailto:Yves.Renard@insa-lyon.fr">Yves.Renard@insa-lyon.fr</a>,
    or <a
    href="mailto:Julien.Pommier@insa-toulouse.fr">Julien.Pommier@insa-toulouse.fr</a>.

    <table style="margin:1em;">
      <tr>
	<td class="docptr" width="30%">
	  Basic User documentation<br> <a href="http://download.gna.org/getfem/doc/getfemuser.pdf">[pdf]</a> <a href="http://download.gna.org/getfem/doc/getfemuser/getfemuser.html">[html]</a>
	</td>
	<td width="70%">
	  This is the core Getfem++ documentation. It documents most of Getfem++ features, and shows a number of examples.
	</td>
      </tr>      
      <tr>
	<td class="docptr" width="30%">
	  Reference documentation<br> <a href="http://download.gna.org/getfem/doc/getfem_reference/index.html">[html]</a>
	</td>
	<td width="70%">
	  This is the documentation extracted from the source files with <a href="http://www.doxygen.org/">doxygen</a>.
	</td>
      </tr>      
      <tr>
	<td class="docptr">
	  Matlab Interface<br> <a href="http://download.gna.org/getfem/doc/getfem_matlab.pdf">[pdf]</a> <a href="http://download.gna.org/getfem/doc/getfem_matlab/gfm.html">[html]</a>
	</td>
	<td>
	  Complete documentation of the Matlab interface: installation, tutorial, and reference. This documentation may also be useful for the Python interface as the functionalities are the same.
	</td>
      </tr>
      <tr>
	<td class="docptr">
	  Python Interface notes<br> <a href="getfempython.html">[html]</a>
	</td>
	<td>
	  Usage notes for the python interface.
	</td>
      </tr>
      <tr>
	<td class="docptr">
	  Python Interface reference<br> <a href="http://download.gna.org/getfem/doc/getfem_python_reference.html">[html]</a>
	</td>
	<td>
	  Autogenerated documentation for the python interface.
	</td>
      </tr>
      <tr>
	<td class="docptr">
	  GMM user guide<br> <a href="http://download.gna.org/getfem/doc/gmmuser.pdf">[pdf]</a> <a href="http://download.gna.org/getfem/doc/gmmuser/gmmuser.html">[html]</a>
	</td>
	<td>
	  GMM++ (Generic Matrix Methods) documentation. GMM is linear algebra meta-library included in Getfem.
	</td>
      </tr>
      <tr>
	<td class="docptr">
	  Getfem++ project documentation<br> <a href="http://download.gna.org/getfem/doc/getfem_project.pdf">[pdf]</a> <a href="http://download.gna.org/getfem/doc/getfem_project/getfem_project.html">[html]</a>
	</td>
	<td>
	  Description of the project including the present state, the perspectives and an exhaustive list of finite element and integration methods implemented in Getfem.
	</td>	
      </tr>
  </table>
  <p>

  Documentation of the older versions is still available below:
  <ul>
    <li>  
      Basic User documentation for getfem++-1.7: <a href="http://download.gna.org/getfem/doc/getfemuser-1.7.pdf">[pdf]</a>
    </li>
    <li>
      Matlab Interface, v1.7 : <a href="http://download.gna.org/getfem/doc/getfem_matlab-1.7.pdf">[pdf]</a>
    </li>
    <li>
      GMM user guide, v1.7 : <a href="http://download.gna.org/getfem/doc/gmmuser-1.7.pdf">[pdf]</a>
    </li>
  </ul>
    
    <p>
      A presentation (in french) of getfem++ <a href="http://download.gna.org/getfem/doc/presentation_2003.pdf">presentation_2003.pdf</a>.
    </p>
    <p>
      A Getfem++ poster <a href="http://download.gna.org/getfem/doc/poster_getfem.pdf">poster_getfem.pdf (in french)</a>, <a href="http://download.gna.org/getfem/doc/poster_english.pdf">poster_getfem.pdf (in english)</a>.
    </p>
  </div>
<?php include("footer.inc") ?>

