.\" @(#)$RCSfile: gfal_mkdir.man,v $ $Revision: 1.1.1.1 $ $Date: 2003/11/19 12:56:29 $ CERN Jean-Philippe Baud
.\" Copyright (C) 2003 by CERN
.\" All rights reserved
.\"
.TH GFAL_MKDIR 3 "$Date: 2003/11/19 12:56:29 $" GFAL "Library Functions"
.SH NAME
gfal_mkdir \- create a new directory
.SH SYNOPSIS
\fB#include "gfal_api.h"\fR
.sp
.BI "int gfal_mkdir (const char *" dirname ,
.BI "mode_t " mode );
.SH DESCRIPTION
.B gfal_mkdir
creates a new directory with permission bits taken from
.IR mode .
.TP
.I dirname
specifies the directory name (this can only be a TURL in the current implementation).
.TP
.I mode
the bit pattern is built by an OR of the constants defined in
.RB < sys/stat.h >.
.SH RETURN VALUE
This routine returns 0 if the operation was successful or -1 if the operation
failed. In the latter case,
.B errno
is set appropriately.
.SH ERRORS
.TP 1.3i
.B ENOENT
A component of
.I dirname
prefix does not exist.
.TP
.B EACCES
Search permission is denied on a component of the
.I dirname
prefix or write permission on the parent directory is denied.
.TP
.B EFAULT
.I dirname
is a NULL pointer.
.TP
.B ENOTDIR
A component of
.I dirname
prefix is not a directory.
.TP
.B EINVAL
.I dirname
has an invalid syntax.
.TP
.B ECOMM
Communication error.
.TP
.B EPROTONOSUPPORT
Access method not supported.
.SH SEE ALSO
.B gfal(3)
