// Code generated by smithy-go-codegen DO NOT EDIT.

package omics

import (
	"context"
	"fmt"
	awsmiddleware "github.com/aws/aws-sdk-go-v2/aws/middleware"
	"github.com/aws/aws-sdk-go-v2/aws/signer/v4"
	"github.com/aws/aws-sdk-go-v2/service/omics/types"
	"github.com/aws/smithy-go/middleware"
	smithyhttp "github.com/aws/smithy-go/transport/http"
)

// Retrieves a list of annotation stores.
func (c *Client) ListAnnotationStores(ctx context.Context, params *ListAnnotationStoresInput, optFns ...func(*Options)) (*ListAnnotationStoresOutput, error) {
	if params == nil {
		params = &ListAnnotationStoresInput{}
	}

	result, metadata, err := c.invokeOperation(ctx, "ListAnnotationStores", params, optFns, c.addOperationListAnnotationStoresMiddlewares)
	if err != nil {
		return nil, err
	}

	out := result.(*ListAnnotationStoresOutput)
	out.ResultMetadata = metadata
	return out, nil
}

type ListAnnotationStoresInput struct {

	// A filter to apply to the list.
	Filter *types.ListAnnotationStoresFilter

	// IDs of stores to list.
	Ids []string

	// The maximum number of stores to return in one page of results.
	MaxResults *int32

	// Specify the pagination token from a previous request to retrieve the next page
	// of results.
	NextToken *string

	noSmithyDocumentSerde
}

type ListAnnotationStoresOutput struct {

	// A list of stores.
	AnnotationStores []types.AnnotationStoreItem

	// A pagination token that's included if more results are available.
	NextToken *string

	// Metadata pertaining to the operation's result.
	ResultMetadata middleware.Metadata

	noSmithyDocumentSerde
}

func (c *Client) addOperationListAnnotationStoresMiddlewares(stack *middleware.Stack, options Options) (err error) {
	if err := stack.Serialize.Add(&setOperationInputMiddleware{}, middleware.After); err != nil {
		return err
	}
	err = stack.Serialize.Add(&awsRestjson1_serializeOpListAnnotationStores{}, middleware.After)
	if err != nil {
		return err
	}
	err = stack.Deserialize.Add(&awsRestjson1_deserializeOpListAnnotationStores{}, middleware.After)
	if err != nil {
		return err
	}
	if err := addProtocolFinalizerMiddlewares(stack, options, "ListAnnotationStores"); err != nil {
		return fmt.Errorf("add protocol finalizers: %v", err)
	}

	if err = addlegacyEndpointContextSetter(stack, options); err != nil {
		return err
	}
	if err = addSetLoggerMiddleware(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddClientRequestIDMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddComputeContentLengthMiddleware(stack); err != nil {
		return err
	}
	if err = addResolveEndpointMiddleware(stack, options); err != nil {
		return err
	}
	if err = v4.AddComputePayloadSHA256Middleware(stack); err != nil {
		return err
	}
	if err = addRetryMiddlewares(stack, options); err != nil {
		return err
	}
	if err = awsmiddleware.AddRawResponseToMetadata(stack); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecordResponseTiming(stack); err != nil {
		return err
	}
	if err = addClientUserAgent(stack, options); err != nil {
		return err
	}
	if err = smithyhttp.AddErrorCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = smithyhttp.AddCloseResponseBodyMiddleware(stack); err != nil {
		return err
	}
	if err = addSetLegacyContextSigningOptionsMiddleware(stack); err != nil {
		return err
	}
	if err = addEndpointPrefix_opListAnnotationStoresMiddleware(stack); err != nil {
		return err
	}
	if err = stack.Initialize.Add(newServiceMetadataMiddleware_opListAnnotationStores(options.Region), middleware.Before); err != nil {
		return err
	}
	if err = awsmiddleware.AddRecursionDetection(stack); err != nil {
		return err
	}
	if err = addRequestIDRetrieverMiddleware(stack); err != nil {
		return err
	}
	if err = addResponseErrorMiddleware(stack); err != nil {
		return err
	}
	if err = addRequestResponseLogging(stack, options); err != nil {
		return err
	}
	if err = addDisableHTTPSMiddleware(stack, options); err != nil {
		return err
	}
	return nil
}

type endpointPrefix_opListAnnotationStoresMiddleware struct {
}

func (*endpointPrefix_opListAnnotationStoresMiddleware) ID() string {
	return "EndpointHostPrefix"
}

func (m *endpointPrefix_opListAnnotationStoresMiddleware) HandleFinalize(ctx context.Context, in middleware.FinalizeInput, next middleware.FinalizeHandler) (
	out middleware.FinalizeOutput, metadata middleware.Metadata, err error,
) {
	if smithyhttp.GetHostnameImmutable(ctx) || smithyhttp.IsEndpointHostPrefixDisabled(ctx) {
		return next.HandleFinalize(ctx, in)
	}

	req, ok := in.Request.(*smithyhttp.Request)
	if !ok {
		return out, metadata, fmt.Errorf("unknown transport type %T", in.Request)
	}

	req.URL.Host = "analytics-" + req.URL.Host

	return next.HandleFinalize(ctx, in)
}
func addEndpointPrefix_opListAnnotationStoresMiddleware(stack *middleware.Stack) error {
	return stack.Finalize.Insert(&endpointPrefix_opListAnnotationStoresMiddleware{}, "ResolveEndpointV2", middleware.After)
}

// ListAnnotationStoresAPIClient is a client that implements the
// ListAnnotationStores operation.
type ListAnnotationStoresAPIClient interface {
	ListAnnotationStores(context.Context, *ListAnnotationStoresInput, ...func(*Options)) (*ListAnnotationStoresOutput, error)
}

var _ ListAnnotationStoresAPIClient = (*Client)(nil)

// ListAnnotationStoresPaginatorOptions is the paginator options for
// ListAnnotationStores
type ListAnnotationStoresPaginatorOptions struct {
	// The maximum number of stores to return in one page of results.
	Limit int32

	// Set to true if pagination should stop if the service returns a pagination token
	// that matches the most recent token provided to the service.
	StopOnDuplicateToken bool
}

// ListAnnotationStoresPaginator is a paginator for ListAnnotationStores
type ListAnnotationStoresPaginator struct {
	options   ListAnnotationStoresPaginatorOptions
	client    ListAnnotationStoresAPIClient
	params    *ListAnnotationStoresInput
	nextToken *string
	firstPage bool
}

// NewListAnnotationStoresPaginator returns a new ListAnnotationStoresPaginator
func NewListAnnotationStoresPaginator(client ListAnnotationStoresAPIClient, params *ListAnnotationStoresInput, optFns ...func(*ListAnnotationStoresPaginatorOptions)) *ListAnnotationStoresPaginator {
	if params == nil {
		params = &ListAnnotationStoresInput{}
	}

	options := ListAnnotationStoresPaginatorOptions{}
	if params.MaxResults != nil {
		options.Limit = *params.MaxResults
	}

	for _, fn := range optFns {
		fn(&options)
	}

	return &ListAnnotationStoresPaginator{
		options:   options,
		client:    client,
		params:    params,
		firstPage: true,
		nextToken: params.NextToken,
	}
}

// HasMorePages returns a boolean indicating whether more pages are available
func (p *ListAnnotationStoresPaginator) HasMorePages() bool {
	return p.firstPage || (p.nextToken != nil && len(*p.nextToken) != 0)
}

// NextPage retrieves the next ListAnnotationStores page.
func (p *ListAnnotationStoresPaginator) NextPage(ctx context.Context, optFns ...func(*Options)) (*ListAnnotationStoresOutput, error) {
	if !p.HasMorePages() {
		return nil, fmt.Errorf("no more pages available")
	}

	params := *p.params
	params.NextToken = p.nextToken

	var limit *int32
	if p.options.Limit > 0 {
		limit = &p.options.Limit
	}
	params.MaxResults = limit

	result, err := p.client.ListAnnotationStores(ctx, &params, optFns...)
	if err != nil {
		return nil, err
	}
	p.firstPage = false

	prevToken := p.nextToken
	p.nextToken = result.NextToken

	if p.options.StopOnDuplicateToken &&
		prevToken != nil &&
		p.nextToken != nil &&
		*prevToken == *p.nextToken {
		p.nextToken = nil
	}

	return result, nil
}

func newServiceMetadataMiddleware_opListAnnotationStores(region string) *awsmiddleware.RegisterServiceMetadata {
	return &awsmiddleware.RegisterServiceMetadata{
		Region:        region,
		ServiceID:     ServiceID,
		OperationName: "ListAnnotationStores",
	}
}
