// Code generated by smithy-go-codegen DO NOT EDIT.

package swf

import (
	"bytes"
	"context"
	"encoding/json"
	"fmt"
	"github.com/aws/aws-sdk-go-v2/aws/protocol/restjson"
	"github.com/aws/aws-sdk-go-v2/service/swf/types"
	smithy "github.com/aws/smithy-go"
	smithyio "github.com/aws/smithy-go/io"
	"github.com/aws/smithy-go/middleware"
	"github.com/aws/smithy-go/ptr"
	smithytime "github.com/aws/smithy-go/time"
	smithyhttp "github.com/aws/smithy-go/transport/http"
	"io"
	"io/ioutil"
	"strings"
	"time"
)

func deserializeS3Expires(v string) (*time.Time, error) {
	t, err := smithytime.ParseHTTPDate(v)
	if err != nil {
		return nil, nil
	}
	return &t, nil
}

type awsAwsjson10_deserializeOpCountClosedWorkflowExecutions struct {
}

func (*awsAwsjson10_deserializeOpCountClosedWorkflowExecutions) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpCountClosedWorkflowExecutions) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorCountClosedWorkflowExecutions(response, &metadata)
	}
	output := &CountClosedWorkflowExecutionsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentCountClosedWorkflowExecutionsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorCountClosedWorkflowExecutions(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpCountOpenWorkflowExecutions struct {
}

func (*awsAwsjson10_deserializeOpCountOpenWorkflowExecutions) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpCountOpenWorkflowExecutions) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorCountOpenWorkflowExecutions(response, &metadata)
	}
	output := &CountOpenWorkflowExecutionsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentCountOpenWorkflowExecutionsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorCountOpenWorkflowExecutions(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpCountPendingActivityTasks struct {
}

func (*awsAwsjson10_deserializeOpCountPendingActivityTasks) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpCountPendingActivityTasks) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorCountPendingActivityTasks(response, &metadata)
	}
	output := &CountPendingActivityTasksOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentCountPendingActivityTasksOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorCountPendingActivityTasks(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpCountPendingDecisionTasks struct {
}

func (*awsAwsjson10_deserializeOpCountPendingDecisionTasks) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpCountPendingDecisionTasks) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorCountPendingDecisionTasks(response, &metadata)
	}
	output := &CountPendingDecisionTasksOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentCountPendingDecisionTasksOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorCountPendingDecisionTasks(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpDeleteActivityType struct {
}

func (*awsAwsjson10_deserializeOpDeleteActivityType) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpDeleteActivityType) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorDeleteActivityType(response, &metadata)
	}
	output := &DeleteActivityTypeOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorDeleteActivityType(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("TypeNotDeprecatedFault", errorCode):
		return awsAwsjson10_deserializeErrorTypeNotDeprecatedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpDeleteWorkflowType struct {
}

func (*awsAwsjson10_deserializeOpDeleteWorkflowType) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpDeleteWorkflowType) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorDeleteWorkflowType(response, &metadata)
	}
	output := &DeleteWorkflowTypeOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorDeleteWorkflowType(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("TypeNotDeprecatedFault", errorCode):
		return awsAwsjson10_deserializeErrorTypeNotDeprecatedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpDeprecateActivityType struct {
}

func (*awsAwsjson10_deserializeOpDeprecateActivityType) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpDeprecateActivityType) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorDeprecateActivityType(response, &metadata)
	}
	output := &DeprecateActivityTypeOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorDeprecateActivityType(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("TypeDeprecatedFault", errorCode):
		return awsAwsjson10_deserializeErrorTypeDeprecatedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpDeprecateDomain struct {
}

func (*awsAwsjson10_deserializeOpDeprecateDomain) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpDeprecateDomain) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorDeprecateDomain(response, &metadata)
	}
	output := &DeprecateDomainOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorDeprecateDomain(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("DomainDeprecatedFault", errorCode):
		return awsAwsjson10_deserializeErrorDomainDeprecatedFault(response, errorBody)

	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpDeprecateWorkflowType struct {
}

func (*awsAwsjson10_deserializeOpDeprecateWorkflowType) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpDeprecateWorkflowType) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorDeprecateWorkflowType(response, &metadata)
	}
	output := &DeprecateWorkflowTypeOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorDeprecateWorkflowType(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("TypeDeprecatedFault", errorCode):
		return awsAwsjson10_deserializeErrorTypeDeprecatedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpDescribeActivityType struct {
}

func (*awsAwsjson10_deserializeOpDescribeActivityType) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpDescribeActivityType) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorDescribeActivityType(response, &metadata)
	}
	output := &DescribeActivityTypeOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentDescribeActivityTypeOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorDescribeActivityType(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpDescribeDomain struct {
}

func (*awsAwsjson10_deserializeOpDescribeDomain) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpDescribeDomain) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorDescribeDomain(response, &metadata)
	}
	output := &DescribeDomainOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentDescribeDomainOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorDescribeDomain(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpDescribeWorkflowExecution struct {
}

func (*awsAwsjson10_deserializeOpDescribeWorkflowExecution) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpDescribeWorkflowExecution) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorDescribeWorkflowExecution(response, &metadata)
	}
	output := &DescribeWorkflowExecutionOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentDescribeWorkflowExecutionOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorDescribeWorkflowExecution(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpDescribeWorkflowType struct {
}

func (*awsAwsjson10_deserializeOpDescribeWorkflowType) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpDescribeWorkflowType) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorDescribeWorkflowType(response, &metadata)
	}
	output := &DescribeWorkflowTypeOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentDescribeWorkflowTypeOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorDescribeWorkflowType(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpGetWorkflowExecutionHistory struct {
}

func (*awsAwsjson10_deserializeOpGetWorkflowExecutionHistory) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpGetWorkflowExecutionHistory) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorGetWorkflowExecutionHistory(response, &metadata)
	}
	output := &GetWorkflowExecutionHistoryOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentGetWorkflowExecutionHistoryOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorGetWorkflowExecutionHistory(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpListActivityTypes struct {
}

func (*awsAwsjson10_deserializeOpListActivityTypes) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpListActivityTypes) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorListActivityTypes(response, &metadata)
	}
	output := &ListActivityTypesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentListActivityTypesOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorListActivityTypes(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpListClosedWorkflowExecutions struct {
}

func (*awsAwsjson10_deserializeOpListClosedWorkflowExecutions) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpListClosedWorkflowExecutions) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorListClosedWorkflowExecutions(response, &metadata)
	}
	output := &ListClosedWorkflowExecutionsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentListClosedWorkflowExecutionsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorListClosedWorkflowExecutions(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpListDomains struct {
}

func (*awsAwsjson10_deserializeOpListDomains) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpListDomains) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorListDomains(response, &metadata)
	}
	output := &ListDomainsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentListDomainsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorListDomains(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpListOpenWorkflowExecutions struct {
}

func (*awsAwsjson10_deserializeOpListOpenWorkflowExecutions) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpListOpenWorkflowExecutions) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorListOpenWorkflowExecutions(response, &metadata)
	}
	output := &ListOpenWorkflowExecutionsOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentListOpenWorkflowExecutionsOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorListOpenWorkflowExecutions(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpListTagsForResource struct {
}

func (*awsAwsjson10_deserializeOpListTagsForResource) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpListTagsForResource) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorListTagsForResource(response, &metadata)
	}
	output := &ListTagsForResourceOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentListTagsForResourceOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorListTagsForResource(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("LimitExceededFault", errorCode):
		return awsAwsjson10_deserializeErrorLimitExceededFault(response, errorBody)

	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpListWorkflowTypes struct {
}

func (*awsAwsjson10_deserializeOpListWorkflowTypes) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpListWorkflowTypes) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorListWorkflowTypes(response, &metadata)
	}
	output := &ListWorkflowTypesOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentListWorkflowTypesOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorListWorkflowTypes(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpPollForActivityTask struct {
}

func (*awsAwsjson10_deserializeOpPollForActivityTask) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpPollForActivityTask) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorPollForActivityTask(response, &metadata)
	}
	output := &PollForActivityTaskOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentPollForActivityTaskOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorPollForActivityTask(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("LimitExceededFault", errorCode):
		return awsAwsjson10_deserializeErrorLimitExceededFault(response, errorBody)

	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpPollForDecisionTask struct {
}

func (*awsAwsjson10_deserializeOpPollForDecisionTask) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpPollForDecisionTask) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorPollForDecisionTask(response, &metadata)
	}
	output := &PollForDecisionTaskOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentPollForDecisionTaskOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorPollForDecisionTask(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("LimitExceededFault", errorCode):
		return awsAwsjson10_deserializeErrorLimitExceededFault(response, errorBody)

	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpRecordActivityTaskHeartbeat struct {
}

func (*awsAwsjson10_deserializeOpRecordActivityTaskHeartbeat) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpRecordActivityTaskHeartbeat) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorRecordActivityTaskHeartbeat(response, &metadata)
	}
	output := &RecordActivityTaskHeartbeatOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentRecordActivityTaskHeartbeatOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorRecordActivityTaskHeartbeat(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpRegisterActivityType struct {
}

func (*awsAwsjson10_deserializeOpRegisterActivityType) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpRegisterActivityType) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorRegisterActivityType(response, &metadata)
	}
	output := &RegisterActivityTypeOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorRegisterActivityType(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("LimitExceededFault", errorCode):
		return awsAwsjson10_deserializeErrorLimitExceededFault(response, errorBody)

	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("TypeAlreadyExistsFault", errorCode):
		return awsAwsjson10_deserializeErrorTypeAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpRegisterDomain struct {
}

func (*awsAwsjson10_deserializeOpRegisterDomain) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpRegisterDomain) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorRegisterDomain(response, &metadata)
	}
	output := &RegisterDomainOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorRegisterDomain(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("DomainAlreadyExistsFault", errorCode):
		return awsAwsjson10_deserializeErrorDomainAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("LimitExceededFault", errorCode):
		return awsAwsjson10_deserializeErrorLimitExceededFault(response, errorBody)

	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("TooManyTagsFault", errorCode):
		return awsAwsjson10_deserializeErrorTooManyTagsFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpRegisterWorkflowType struct {
}

func (*awsAwsjson10_deserializeOpRegisterWorkflowType) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpRegisterWorkflowType) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorRegisterWorkflowType(response, &metadata)
	}
	output := &RegisterWorkflowTypeOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorRegisterWorkflowType(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("LimitExceededFault", errorCode):
		return awsAwsjson10_deserializeErrorLimitExceededFault(response, errorBody)

	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("TypeAlreadyExistsFault", errorCode):
		return awsAwsjson10_deserializeErrorTypeAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpRequestCancelWorkflowExecution struct {
}

func (*awsAwsjson10_deserializeOpRequestCancelWorkflowExecution) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpRequestCancelWorkflowExecution) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorRequestCancelWorkflowExecution(response, &metadata)
	}
	output := &RequestCancelWorkflowExecutionOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorRequestCancelWorkflowExecution(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpRespondActivityTaskCanceled struct {
}

func (*awsAwsjson10_deserializeOpRespondActivityTaskCanceled) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpRespondActivityTaskCanceled) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorRespondActivityTaskCanceled(response, &metadata)
	}
	output := &RespondActivityTaskCanceledOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorRespondActivityTaskCanceled(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpRespondActivityTaskCompleted struct {
}

func (*awsAwsjson10_deserializeOpRespondActivityTaskCompleted) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpRespondActivityTaskCompleted) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorRespondActivityTaskCompleted(response, &metadata)
	}
	output := &RespondActivityTaskCompletedOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorRespondActivityTaskCompleted(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpRespondActivityTaskFailed struct {
}

func (*awsAwsjson10_deserializeOpRespondActivityTaskFailed) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpRespondActivityTaskFailed) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorRespondActivityTaskFailed(response, &metadata)
	}
	output := &RespondActivityTaskFailedOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorRespondActivityTaskFailed(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpRespondDecisionTaskCompleted struct {
}

func (*awsAwsjson10_deserializeOpRespondDecisionTaskCompleted) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpRespondDecisionTaskCompleted) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorRespondDecisionTaskCompleted(response, &metadata)
	}
	output := &RespondDecisionTaskCompletedOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorRespondDecisionTaskCompleted(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpSignalWorkflowExecution struct {
}

func (*awsAwsjson10_deserializeOpSignalWorkflowExecution) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpSignalWorkflowExecution) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorSignalWorkflowExecution(response, &metadata)
	}
	output := &SignalWorkflowExecutionOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorSignalWorkflowExecution(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpStartWorkflowExecution struct {
}

func (*awsAwsjson10_deserializeOpStartWorkflowExecution) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpStartWorkflowExecution) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorStartWorkflowExecution(response, &metadata)
	}
	output := &StartWorkflowExecutionOutput{}
	out.Result = output

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(response.Body, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	err = awsAwsjson10_deserializeOpDocumentStartWorkflowExecutionOutput(&output, shape)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return out, metadata, err
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorStartWorkflowExecution(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("DefaultUndefinedFault", errorCode):
		return awsAwsjson10_deserializeErrorDefaultUndefinedFault(response, errorBody)

	case strings.EqualFold("LimitExceededFault", errorCode):
		return awsAwsjson10_deserializeErrorLimitExceededFault(response, errorBody)

	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("TypeDeprecatedFault", errorCode):
		return awsAwsjson10_deserializeErrorTypeDeprecatedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	case strings.EqualFold("WorkflowExecutionAlreadyStartedFault", errorCode):
		return awsAwsjson10_deserializeErrorWorkflowExecutionAlreadyStartedFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpTagResource struct {
}

func (*awsAwsjson10_deserializeOpTagResource) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpTagResource) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorTagResource(response, &metadata)
	}
	output := &TagResourceOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorTagResource(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("LimitExceededFault", errorCode):
		return awsAwsjson10_deserializeErrorLimitExceededFault(response, errorBody)

	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("TooManyTagsFault", errorCode):
		return awsAwsjson10_deserializeErrorTooManyTagsFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpTerminateWorkflowExecution struct {
}

func (*awsAwsjson10_deserializeOpTerminateWorkflowExecution) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpTerminateWorkflowExecution) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorTerminateWorkflowExecution(response, &metadata)
	}
	output := &TerminateWorkflowExecutionOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorTerminateWorkflowExecution(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpUndeprecateActivityType struct {
}

func (*awsAwsjson10_deserializeOpUndeprecateActivityType) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpUndeprecateActivityType) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorUndeprecateActivityType(response, &metadata)
	}
	output := &UndeprecateActivityTypeOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorUndeprecateActivityType(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("TypeAlreadyExistsFault", errorCode):
		return awsAwsjson10_deserializeErrorTypeAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpUndeprecateDomain struct {
}

func (*awsAwsjson10_deserializeOpUndeprecateDomain) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpUndeprecateDomain) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorUndeprecateDomain(response, &metadata)
	}
	output := &UndeprecateDomainOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorUndeprecateDomain(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("DomainAlreadyExistsFault", errorCode):
		return awsAwsjson10_deserializeErrorDomainAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpUndeprecateWorkflowType struct {
}

func (*awsAwsjson10_deserializeOpUndeprecateWorkflowType) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpUndeprecateWorkflowType) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorUndeprecateWorkflowType(response, &metadata)
	}
	output := &UndeprecateWorkflowTypeOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorUndeprecateWorkflowType(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("TypeAlreadyExistsFault", errorCode):
		return awsAwsjson10_deserializeErrorTypeAlreadyExistsFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

type awsAwsjson10_deserializeOpUntagResource struct {
}

func (*awsAwsjson10_deserializeOpUntagResource) ID() string {
	return "OperationDeserializer"
}

func (m *awsAwsjson10_deserializeOpUntagResource) HandleDeserialize(ctx context.Context, in middleware.DeserializeInput, next middleware.DeserializeHandler) (
	out middleware.DeserializeOutput, metadata middleware.Metadata, err error,
) {
	out, metadata, err = next.HandleDeserialize(ctx, in)
	if err != nil {
		return out, metadata, err
	}

	response, ok := out.RawResponse.(*smithyhttp.Response)
	if !ok {
		return out, metadata, &smithy.DeserializationError{Err: fmt.Errorf("unknown transport type %T", out.RawResponse)}
	}

	if response.StatusCode < 200 || response.StatusCode >= 300 {
		return out, metadata, awsAwsjson10_deserializeOpErrorUntagResource(response, &metadata)
	}
	output := &UntagResourceOutput{}
	out.Result = output

	if _, err = io.Copy(ioutil.Discard, response.Body); err != nil {
		return out, metadata, &smithy.DeserializationError{
			Err: fmt.Errorf("failed to discard response body, %w", err),
		}
	}

	return out, metadata, err
}

func awsAwsjson10_deserializeOpErrorUntagResource(response *smithyhttp.Response, metadata *middleware.Metadata) error {
	var errorBuffer bytes.Buffer
	if _, err := io.Copy(&errorBuffer, response.Body); err != nil {
		return &smithy.DeserializationError{Err: fmt.Errorf("failed to copy error response body, %w", err)}
	}
	errorBody := bytes.NewReader(errorBuffer.Bytes())

	errorCode := "UnknownError"
	errorMessage := errorCode

	headerCode := response.Header.Get("X-Amzn-ErrorType")

	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	bodyInfo, err := getProtocolErrorInfo(decoder)
	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	if typ, ok := resolveProtocolErrorType(headerCode, bodyInfo); ok {
		errorCode = restjson.SanitizeErrorCode(typ)
	}
	if len(bodyInfo.Message) != 0 {
		errorMessage = bodyInfo.Message
	}
	switch {
	case strings.EqualFold("LimitExceededFault", errorCode):
		return awsAwsjson10_deserializeErrorLimitExceededFault(response, errorBody)

	case strings.EqualFold("OperationNotPermittedFault", errorCode):
		return awsAwsjson10_deserializeErrorOperationNotPermittedFault(response, errorBody)

	case strings.EqualFold("UnknownResourceFault", errorCode):
		return awsAwsjson10_deserializeErrorUnknownResourceFault(response, errorBody)

	default:
		genericError := &smithy.GenericAPIError{
			Code:    errorCode,
			Message: errorMessage,
		}
		return genericError

	}
}

func awsAwsjson10_deserializeErrorDefaultUndefinedFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.DefaultUndefinedFault{}
	err := awsAwsjson10_deserializeDocumentDefaultUndefinedFault(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson10_deserializeErrorDomainAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.DomainAlreadyExistsFault{}
	err := awsAwsjson10_deserializeDocumentDomainAlreadyExistsFault(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson10_deserializeErrorDomainDeprecatedFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.DomainDeprecatedFault{}
	err := awsAwsjson10_deserializeDocumentDomainDeprecatedFault(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson10_deserializeErrorLimitExceededFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.LimitExceededFault{}
	err := awsAwsjson10_deserializeDocumentLimitExceededFault(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson10_deserializeErrorOperationNotPermittedFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.OperationNotPermittedFault{}
	err := awsAwsjson10_deserializeDocumentOperationNotPermittedFault(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson10_deserializeErrorTooManyTagsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.TooManyTagsFault{}
	err := awsAwsjson10_deserializeDocumentTooManyTagsFault(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson10_deserializeErrorTypeAlreadyExistsFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.TypeAlreadyExistsFault{}
	err := awsAwsjson10_deserializeDocumentTypeAlreadyExistsFault(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson10_deserializeErrorTypeDeprecatedFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.TypeDeprecatedFault{}
	err := awsAwsjson10_deserializeDocumentTypeDeprecatedFault(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson10_deserializeErrorTypeNotDeprecatedFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.TypeNotDeprecatedFault{}
	err := awsAwsjson10_deserializeDocumentTypeNotDeprecatedFault(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson10_deserializeErrorUnknownResourceFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.UnknownResourceFault{}
	err := awsAwsjson10_deserializeDocumentUnknownResourceFault(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson10_deserializeErrorWorkflowExecutionAlreadyStartedFault(response *smithyhttp.Response, errorBody *bytes.Reader) error {
	var buff [1024]byte
	ringBuffer := smithyio.NewRingBuffer(buff[:])

	body := io.TeeReader(errorBody, ringBuffer)
	decoder := json.NewDecoder(body)
	decoder.UseNumber()
	var shape interface{}
	if err := decoder.Decode(&shape); err != nil && err != io.EOF {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	output := &types.WorkflowExecutionAlreadyStartedFault{}
	err := awsAwsjson10_deserializeDocumentWorkflowExecutionAlreadyStartedFault(&output, shape)

	if err != nil {
		var snapshot bytes.Buffer
		io.Copy(&snapshot, ringBuffer)
		err = &smithy.DeserializationError{
			Err:      fmt.Errorf("failed to decode response body, %w", err),
			Snapshot: snapshot.Bytes(),
		}
		return err
	}

	errorBody.Seek(0, io.SeekStart)
	return output
}

func awsAwsjson10_deserializeDocumentActivityTaskCanceledEventAttributes(v **types.ActivityTaskCanceledEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ActivityTaskCanceledEventAttributes
	if *v == nil {
		sv = &types.ActivityTaskCanceledEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "details":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.Details = ptr.String(jtv)
			}

		case "latestCancelRequestedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.LatestCancelRequestedEventId = i64
			}

		case "scheduledEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ScheduledEventId = i64
			}

		case "startedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StartedEventId = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentActivityTaskCancelRequestedEventAttributes(v **types.ActivityTaskCancelRequestedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ActivityTaskCancelRequestedEventAttributes
	if *v == nil {
		sv = &types.ActivityTaskCancelRequestedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "activityId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ActivityId to be of type string, got %T instead", value)
				}
				sv.ActivityId = ptr.String(jtv)
			}

		case "decisionTaskCompletedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DecisionTaskCompletedEventId = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentActivityTaskCompletedEventAttributes(v **types.ActivityTaskCompletedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ActivityTaskCompletedEventAttributes
	if *v == nil {
		sv = &types.ActivityTaskCompletedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "result":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.Result = ptr.String(jtv)
			}

		case "scheduledEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ScheduledEventId = i64
			}

		case "startedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StartedEventId = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentActivityTaskFailedEventAttributes(v **types.ActivityTaskFailedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ActivityTaskFailedEventAttributes
	if *v == nil {
		sv = &types.ActivityTaskFailedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "details":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.Details = ptr.String(jtv)
			}

		case "reason":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected FailureReason to be of type string, got %T instead", value)
				}
				sv.Reason = ptr.String(jtv)
			}

		case "scheduledEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ScheduledEventId = i64
			}

		case "startedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StartedEventId = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentActivityTaskScheduledEventAttributes(v **types.ActivityTaskScheduledEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ActivityTaskScheduledEventAttributes
	if *v == nil {
		sv = &types.ActivityTaskScheduledEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "activityId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ActivityId to be of type string, got %T instead", value)
				}
				sv.ActivityId = ptr.String(jtv)
			}

		case "activityType":
			if err := awsAwsjson10_deserializeDocumentActivityType(&sv.ActivityType, value); err != nil {
				return err
			}

		case "control":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.Control = ptr.String(jtv)
			}

		case "decisionTaskCompletedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DecisionTaskCompletedEventId = i64
			}

		case "heartbeatTimeout":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DurationInSecondsOptional to be of type string, got %T instead", value)
				}
				sv.HeartbeatTimeout = ptr.String(jtv)
			}

		case "input":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.Input = ptr.String(jtv)
			}

		case "scheduleToCloseTimeout":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DurationInSecondsOptional to be of type string, got %T instead", value)
				}
				sv.ScheduleToCloseTimeout = ptr.String(jtv)
			}

		case "scheduleToStartTimeout":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DurationInSecondsOptional to be of type string, got %T instead", value)
				}
				sv.ScheduleToStartTimeout = ptr.String(jtv)
			}

		case "startToCloseTimeout":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DurationInSecondsOptional to be of type string, got %T instead", value)
				}
				sv.StartToCloseTimeout = ptr.String(jtv)
			}

		case "taskList":
			if err := awsAwsjson10_deserializeDocumentTaskList(&sv.TaskList, value); err != nil {
				return err
			}

		case "taskPriority":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TaskPriority to be of type string, got %T instead", value)
				}
				sv.TaskPriority = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentActivityTaskStartedEventAttributes(v **types.ActivityTaskStartedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ActivityTaskStartedEventAttributes
	if *v == nil {
		sv = &types.ActivityTaskStartedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "identity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Identity to be of type string, got %T instead", value)
				}
				sv.Identity = ptr.String(jtv)
			}

		case "scheduledEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ScheduledEventId = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentActivityTaskTimedOutEventAttributes(v **types.ActivityTaskTimedOutEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ActivityTaskTimedOutEventAttributes
	if *v == nil {
		sv = &types.ActivityTaskTimedOutEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "details":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected LimitedData to be of type string, got %T instead", value)
				}
				sv.Details = ptr.String(jtv)
			}

		case "scheduledEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ScheduledEventId = i64
			}

		case "startedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StartedEventId = i64
			}

		case "timeoutType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ActivityTaskTimeoutType to be of type string, got %T instead", value)
				}
				sv.TimeoutType = types.ActivityTaskTimeoutType(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentActivityType(v **types.ActivityType, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ActivityType
	if *v == nil {
		sv = &types.ActivityType{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Name to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "version":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Version to be of type string, got %T instead", value)
				}
				sv.Version = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentActivityTypeConfiguration(v **types.ActivityTypeConfiguration, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ActivityTypeConfiguration
	if *v == nil {
		sv = &types.ActivityTypeConfiguration{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "defaultTaskHeartbeatTimeout":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DurationInSecondsOptional to be of type string, got %T instead", value)
				}
				sv.DefaultTaskHeartbeatTimeout = ptr.String(jtv)
			}

		case "defaultTaskList":
			if err := awsAwsjson10_deserializeDocumentTaskList(&sv.DefaultTaskList, value); err != nil {
				return err
			}

		case "defaultTaskPriority":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TaskPriority to be of type string, got %T instead", value)
				}
				sv.DefaultTaskPriority = ptr.String(jtv)
			}

		case "defaultTaskScheduleToCloseTimeout":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DurationInSecondsOptional to be of type string, got %T instead", value)
				}
				sv.DefaultTaskScheduleToCloseTimeout = ptr.String(jtv)
			}

		case "defaultTaskScheduleToStartTimeout":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DurationInSecondsOptional to be of type string, got %T instead", value)
				}
				sv.DefaultTaskScheduleToStartTimeout = ptr.String(jtv)
			}

		case "defaultTaskStartToCloseTimeout":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DurationInSecondsOptional to be of type string, got %T instead", value)
				}
				sv.DefaultTaskStartToCloseTimeout = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentActivityTypeInfo(v **types.ActivityTypeInfo, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ActivityTypeInfo
	if *v == nil {
		sv = &types.ActivityTypeInfo{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "activityType":
			if err := awsAwsjson10_deserializeDocumentActivityType(&sv.ActivityType, value); err != nil {
				return err
			}

		case "creationDate":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.CreationDate = ptr.Time(smithytime.ParseEpochSeconds(f64))

				default:
					return fmt.Errorf("expected Timestamp to be a JSON Number, got %T instead", value)

				}
			}

		case "deprecationDate":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.DeprecationDate = ptr.Time(smithytime.ParseEpochSeconds(f64))

				default:
					return fmt.Errorf("expected Timestamp to be a JSON Number, got %T instead", value)

				}
			}

		case "description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Description to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RegistrationStatus to be of type string, got %T instead", value)
				}
				sv.Status = types.RegistrationStatus(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentActivityTypeInfoList(v *[]types.ActivityTypeInfo, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.ActivityTypeInfo
	if *v == nil {
		cv = []types.ActivityTypeInfo{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.ActivityTypeInfo
		destAddr := &col
		if err := awsAwsjson10_deserializeDocumentActivityTypeInfo(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentCancelTimerFailedEventAttributes(v **types.CancelTimerFailedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CancelTimerFailedEventAttributes
	if *v == nil {
		sv = &types.CancelTimerFailedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "cause":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CancelTimerFailedCause to be of type string, got %T instead", value)
				}
				sv.Cause = types.CancelTimerFailedCause(jtv)
			}

		case "decisionTaskCompletedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DecisionTaskCompletedEventId = i64
			}

		case "timerId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TimerId to be of type string, got %T instead", value)
				}
				sv.TimerId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentCancelWorkflowExecutionFailedEventAttributes(v **types.CancelWorkflowExecutionFailedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CancelWorkflowExecutionFailedEventAttributes
	if *v == nil {
		sv = &types.CancelWorkflowExecutionFailedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "cause":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CancelWorkflowExecutionFailedCause to be of type string, got %T instead", value)
				}
				sv.Cause = types.CancelWorkflowExecutionFailedCause(jtv)
			}

		case "decisionTaskCompletedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DecisionTaskCompletedEventId = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentChildWorkflowExecutionCanceledEventAttributes(v **types.ChildWorkflowExecutionCanceledEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ChildWorkflowExecutionCanceledEventAttributes
	if *v == nil {
		sv = &types.ChildWorkflowExecutionCanceledEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "details":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.Details = ptr.String(jtv)
			}

		case "initiatedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.InitiatedEventId = i64
			}

		case "startedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StartedEventId = i64
			}

		case "workflowExecution":
			if err := awsAwsjson10_deserializeDocumentWorkflowExecution(&sv.WorkflowExecution, value); err != nil {
				return err
			}

		case "workflowType":
			if err := awsAwsjson10_deserializeDocumentWorkflowType(&sv.WorkflowType, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentChildWorkflowExecutionCompletedEventAttributes(v **types.ChildWorkflowExecutionCompletedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ChildWorkflowExecutionCompletedEventAttributes
	if *v == nil {
		sv = &types.ChildWorkflowExecutionCompletedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "initiatedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.InitiatedEventId = i64
			}

		case "result":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.Result = ptr.String(jtv)
			}

		case "startedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StartedEventId = i64
			}

		case "workflowExecution":
			if err := awsAwsjson10_deserializeDocumentWorkflowExecution(&sv.WorkflowExecution, value); err != nil {
				return err
			}

		case "workflowType":
			if err := awsAwsjson10_deserializeDocumentWorkflowType(&sv.WorkflowType, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentChildWorkflowExecutionFailedEventAttributes(v **types.ChildWorkflowExecutionFailedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ChildWorkflowExecutionFailedEventAttributes
	if *v == nil {
		sv = &types.ChildWorkflowExecutionFailedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "details":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.Details = ptr.String(jtv)
			}

		case "initiatedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.InitiatedEventId = i64
			}

		case "reason":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected FailureReason to be of type string, got %T instead", value)
				}
				sv.Reason = ptr.String(jtv)
			}

		case "startedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StartedEventId = i64
			}

		case "workflowExecution":
			if err := awsAwsjson10_deserializeDocumentWorkflowExecution(&sv.WorkflowExecution, value); err != nil {
				return err
			}

		case "workflowType":
			if err := awsAwsjson10_deserializeDocumentWorkflowType(&sv.WorkflowType, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentChildWorkflowExecutionStartedEventAttributes(v **types.ChildWorkflowExecutionStartedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ChildWorkflowExecutionStartedEventAttributes
	if *v == nil {
		sv = &types.ChildWorkflowExecutionStartedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "initiatedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.InitiatedEventId = i64
			}

		case "workflowExecution":
			if err := awsAwsjson10_deserializeDocumentWorkflowExecution(&sv.WorkflowExecution, value); err != nil {
				return err
			}

		case "workflowType":
			if err := awsAwsjson10_deserializeDocumentWorkflowType(&sv.WorkflowType, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentChildWorkflowExecutionTerminatedEventAttributes(v **types.ChildWorkflowExecutionTerminatedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ChildWorkflowExecutionTerminatedEventAttributes
	if *v == nil {
		sv = &types.ChildWorkflowExecutionTerminatedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "initiatedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.InitiatedEventId = i64
			}

		case "startedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StartedEventId = i64
			}

		case "workflowExecution":
			if err := awsAwsjson10_deserializeDocumentWorkflowExecution(&sv.WorkflowExecution, value); err != nil {
				return err
			}

		case "workflowType":
			if err := awsAwsjson10_deserializeDocumentWorkflowType(&sv.WorkflowType, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentChildWorkflowExecutionTimedOutEventAttributes(v **types.ChildWorkflowExecutionTimedOutEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ChildWorkflowExecutionTimedOutEventAttributes
	if *v == nil {
		sv = &types.ChildWorkflowExecutionTimedOutEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "initiatedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.InitiatedEventId = i64
			}

		case "startedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StartedEventId = i64
			}

		case "timeoutType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected WorkflowExecutionTimeoutType to be of type string, got %T instead", value)
				}
				sv.TimeoutType = types.WorkflowExecutionTimeoutType(jtv)
			}

		case "workflowExecution":
			if err := awsAwsjson10_deserializeDocumentWorkflowExecution(&sv.WorkflowExecution, value); err != nil {
				return err
			}

		case "workflowType":
			if err := awsAwsjson10_deserializeDocumentWorkflowType(&sv.WorkflowType, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentCompleteWorkflowExecutionFailedEventAttributes(v **types.CompleteWorkflowExecutionFailedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.CompleteWorkflowExecutionFailedEventAttributes
	if *v == nil {
		sv = &types.CompleteWorkflowExecutionFailedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "cause":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CompleteWorkflowExecutionFailedCause to be of type string, got %T instead", value)
				}
				sv.Cause = types.CompleteWorkflowExecutionFailedCause(jtv)
			}

		case "decisionTaskCompletedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DecisionTaskCompletedEventId = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentContinueAsNewWorkflowExecutionFailedEventAttributes(v **types.ContinueAsNewWorkflowExecutionFailedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ContinueAsNewWorkflowExecutionFailedEventAttributes
	if *v == nil {
		sv = &types.ContinueAsNewWorkflowExecutionFailedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "cause":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ContinueAsNewWorkflowExecutionFailedCause to be of type string, got %T instead", value)
				}
				sv.Cause = types.ContinueAsNewWorkflowExecutionFailedCause(jtv)
			}

		case "decisionTaskCompletedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DecisionTaskCompletedEventId = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentDecisionTaskCompletedEventAttributes(v **types.DecisionTaskCompletedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.DecisionTaskCompletedEventAttributes
	if *v == nil {
		sv = &types.DecisionTaskCompletedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "executionContext":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.ExecutionContext = ptr.String(jtv)
			}

		case "scheduledEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ScheduledEventId = i64
			}

		case "startedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StartedEventId = i64
			}

		case "taskList":
			if err := awsAwsjson10_deserializeDocumentTaskList(&sv.TaskList, value); err != nil {
				return err
			}

		case "taskListScheduleToStartTimeout":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DurationInSecondsOptional to be of type string, got %T instead", value)
				}
				sv.TaskListScheduleToStartTimeout = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentDecisionTaskScheduledEventAttributes(v **types.DecisionTaskScheduledEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.DecisionTaskScheduledEventAttributes
	if *v == nil {
		sv = &types.DecisionTaskScheduledEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "scheduleToStartTimeout":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DurationInSecondsOptional to be of type string, got %T instead", value)
				}
				sv.ScheduleToStartTimeout = ptr.String(jtv)
			}

		case "startToCloseTimeout":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DurationInSecondsOptional to be of type string, got %T instead", value)
				}
				sv.StartToCloseTimeout = ptr.String(jtv)
			}

		case "taskList":
			if err := awsAwsjson10_deserializeDocumentTaskList(&sv.TaskList, value); err != nil {
				return err
			}

		case "taskPriority":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TaskPriority to be of type string, got %T instead", value)
				}
				sv.TaskPriority = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentDecisionTaskStartedEventAttributes(v **types.DecisionTaskStartedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.DecisionTaskStartedEventAttributes
	if *v == nil {
		sv = &types.DecisionTaskStartedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "identity":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Identity to be of type string, got %T instead", value)
				}
				sv.Identity = ptr.String(jtv)
			}

		case "scheduledEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ScheduledEventId = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentDecisionTaskTimedOutEventAttributes(v **types.DecisionTaskTimedOutEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.DecisionTaskTimedOutEventAttributes
	if *v == nil {
		sv = &types.DecisionTaskTimedOutEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "scheduledEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ScheduledEventId = i64
			}

		case "startedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StartedEventId = i64
			}

		case "timeoutType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DecisionTaskTimeoutType to be of type string, got %T instead", value)
				}
				sv.TimeoutType = types.DecisionTaskTimeoutType(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentDefaultUndefinedFault(v **types.DefaultUndefinedFault, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.DefaultUndefinedFault
	if *v == nil {
		sv = &types.DefaultUndefinedFault{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ErrorMessage to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentDomainAlreadyExistsFault(v **types.DomainAlreadyExistsFault, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.DomainAlreadyExistsFault
	if *v == nil {
		sv = &types.DomainAlreadyExistsFault{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ErrorMessage to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentDomainConfiguration(v **types.DomainConfiguration, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.DomainConfiguration
	if *v == nil {
		sv = &types.DomainConfiguration{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "workflowExecutionRetentionPeriodInDays":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DurationInDays to be of type string, got %T instead", value)
				}
				sv.WorkflowExecutionRetentionPeriodInDays = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentDomainDeprecatedFault(v **types.DomainDeprecatedFault, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.DomainDeprecatedFault
	if *v == nil {
		sv = &types.DomainDeprecatedFault{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ErrorMessage to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentDomainInfo(v **types.DomainInfo, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.DomainInfo
	if *v == nil {
		sv = &types.DomainInfo{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "arn":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Arn to be of type string, got %T instead", value)
				}
				sv.Arn = ptr.String(jtv)
			}

		case "description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Description to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DomainName to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RegistrationStatus to be of type string, got %T instead", value)
				}
				sv.Status = types.RegistrationStatus(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentDomainInfoList(v *[]types.DomainInfo, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.DomainInfo
	if *v == nil {
		cv = []types.DomainInfo{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.DomainInfo
		destAddr := &col
		if err := awsAwsjson10_deserializeDocumentDomainInfo(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentExternalWorkflowExecutionCancelRequestedEventAttributes(v **types.ExternalWorkflowExecutionCancelRequestedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ExternalWorkflowExecutionCancelRequestedEventAttributes
	if *v == nil {
		sv = &types.ExternalWorkflowExecutionCancelRequestedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "initiatedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.InitiatedEventId = i64
			}

		case "workflowExecution":
			if err := awsAwsjson10_deserializeDocumentWorkflowExecution(&sv.WorkflowExecution, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentExternalWorkflowExecutionSignaledEventAttributes(v **types.ExternalWorkflowExecutionSignaledEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ExternalWorkflowExecutionSignaledEventAttributes
	if *v == nil {
		sv = &types.ExternalWorkflowExecutionSignaledEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "initiatedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.InitiatedEventId = i64
			}

		case "workflowExecution":
			if err := awsAwsjson10_deserializeDocumentWorkflowExecution(&sv.WorkflowExecution, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentFailWorkflowExecutionFailedEventAttributes(v **types.FailWorkflowExecutionFailedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.FailWorkflowExecutionFailedEventAttributes
	if *v == nil {
		sv = &types.FailWorkflowExecutionFailedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "cause":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected FailWorkflowExecutionFailedCause to be of type string, got %T instead", value)
				}
				sv.Cause = types.FailWorkflowExecutionFailedCause(jtv)
			}

		case "decisionTaskCompletedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DecisionTaskCompletedEventId = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentHistoryEvent(v **types.HistoryEvent, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.HistoryEvent
	if *v == nil {
		sv = &types.HistoryEvent{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "activityTaskCanceledEventAttributes":
			if err := awsAwsjson10_deserializeDocumentActivityTaskCanceledEventAttributes(&sv.ActivityTaskCanceledEventAttributes, value); err != nil {
				return err
			}

		case "activityTaskCancelRequestedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentActivityTaskCancelRequestedEventAttributes(&sv.ActivityTaskCancelRequestedEventAttributes, value); err != nil {
				return err
			}

		case "activityTaskCompletedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentActivityTaskCompletedEventAttributes(&sv.ActivityTaskCompletedEventAttributes, value); err != nil {
				return err
			}

		case "activityTaskFailedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentActivityTaskFailedEventAttributes(&sv.ActivityTaskFailedEventAttributes, value); err != nil {
				return err
			}

		case "activityTaskScheduledEventAttributes":
			if err := awsAwsjson10_deserializeDocumentActivityTaskScheduledEventAttributes(&sv.ActivityTaskScheduledEventAttributes, value); err != nil {
				return err
			}

		case "activityTaskStartedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentActivityTaskStartedEventAttributes(&sv.ActivityTaskStartedEventAttributes, value); err != nil {
				return err
			}

		case "activityTaskTimedOutEventAttributes":
			if err := awsAwsjson10_deserializeDocumentActivityTaskTimedOutEventAttributes(&sv.ActivityTaskTimedOutEventAttributes, value); err != nil {
				return err
			}

		case "cancelTimerFailedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentCancelTimerFailedEventAttributes(&sv.CancelTimerFailedEventAttributes, value); err != nil {
				return err
			}

		case "cancelWorkflowExecutionFailedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentCancelWorkflowExecutionFailedEventAttributes(&sv.CancelWorkflowExecutionFailedEventAttributes, value); err != nil {
				return err
			}

		case "childWorkflowExecutionCanceledEventAttributes":
			if err := awsAwsjson10_deserializeDocumentChildWorkflowExecutionCanceledEventAttributes(&sv.ChildWorkflowExecutionCanceledEventAttributes, value); err != nil {
				return err
			}

		case "childWorkflowExecutionCompletedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentChildWorkflowExecutionCompletedEventAttributes(&sv.ChildWorkflowExecutionCompletedEventAttributes, value); err != nil {
				return err
			}

		case "childWorkflowExecutionFailedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentChildWorkflowExecutionFailedEventAttributes(&sv.ChildWorkflowExecutionFailedEventAttributes, value); err != nil {
				return err
			}

		case "childWorkflowExecutionStartedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentChildWorkflowExecutionStartedEventAttributes(&sv.ChildWorkflowExecutionStartedEventAttributes, value); err != nil {
				return err
			}

		case "childWorkflowExecutionTerminatedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentChildWorkflowExecutionTerminatedEventAttributes(&sv.ChildWorkflowExecutionTerminatedEventAttributes, value); err != nil {
				return err
			}

		case "childWorkflowExecutionTimedOutEventAttributes":
			if err := awsAwsjson10_deserializeDocumentChildWorkflowExecutionTimedOutEventAttributes(&sv.ChildWorkflowExecutionTimedOutEventAttributes, value); err != nil {
				return err
			}

		case "completeWorkflowExecutionFailedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentCompleteWorkflowExecutionFailedEventAttributes(&sv.CompleteWorkflowExecutionFailedEventAttributes, value); err != nil {
				return err
			}

		case "continueAsNewWorkflowExecutionFailedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentContinueAsNewWorkflowExecutionFailedEventAttributes(&sv.ContinueAsNewWorkflowExecutionFailedEventAttributes, value); err != nil {
				return err
			}

		case "decisionTaskCompletedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentDecisionTaskCompletedEventAttributes(&sv.DecisionTaskCompletedEventAttributes, value); err != nil {
				return err
			}

		case "decisionTaskScheduledEventAttributes":
			if err := awsAwsjson10_deserializeDocumentDecisionTaskScheduledEventAttributes(&sv.DecisionTaskScheduledEventAttributes, value); err != nil {
				return err
			}

		case "decisionTaskStartedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentDecisionTaskStartedEventAttributes(&sv.DecisionTaskStartedEventAttributes, value); err != nil {
				return err
			}

		case "decisionTaskTimedOutEventAttributes":
			if err := awsAwsjson10_deserializeDocumentDecisionTaskTimedOutEventAttributes(&sv.DecisionTaskTimedOutEventAttributes, value); err != nil {
				return err
			}

		case "eventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.EventId = i64
			}

		case "eventTimestamp":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.EventTimestamp = ptr.Time(smithytime.ParseEpochSeconds(f64))

				default:
					return fmt.Errorf("expected Timestamp to be a JSON Number, got %T instead", value)

				}
			}

		case "eventType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected EventType to be of type string, got %T instead", value)
				}
				sv.EventType = types.EventType(jtv)
			}

		case "externalWorkflowExecutionCancelRequestedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentExternalWorkflowExecutionCancelRequestedEventAttributes(&sv.ExternalWorkflowExecutionCancelRequestedEventAttributes, value); err != nil {
				return err
			}

		case "externalWorkflowExecutionSignaledEventAttributes":
			if err := awsAwsjson10_deserializeDocumentExternalWorkflowExecutionSignaledEventAttributes(&sv.ExternalWorkflowExecutionSignaledEventAttributes, value); err != nil {
				return err
			}

		case "failWorkflowExecutionFailedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentFailWorkflowExecutionFailedEventAttributes(&sv.FailWorkflowExecutionFailedEventAttributes, value); err != nil {
				return err
			}

		case "lambdaFunctionCompletedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentLambdaFunctionCompletedEventAttributes(&sv.LambdaFunctionCompletedEventAttributes, value); err != nil {
				return err
			}

		case "lambdaFunctionFailedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentLambdaFunctionFailedEventAttributes(&sv.LambdaFunctionFailedEventAttributes, value); err != nil {
				return err
			}

		case "lambdaFunctionScheduledEventAttributes":
			if err := awsAwsjson10_deserializeDocumentLambdaFunctionScheduledEventAttributes(&sv.LambdaFunctionScheduledEventAttributes, value); err != nil {
				return err
			}

		case "lambdaFunctionStartedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentLambdaFunctionStartedEventAttributes(&sv.LambdaFunctionStartedEventAttributes, value); err != nil {
				return err
			}

		case "lambdaFunctionTimedOutEventAttributes":
			if err := awsAwsjson10_deserializeDocumentLambdaFunctionTimedOutEventAttributes(&sv.LambdaFunctionTimedOutEventAttributes, value); err != nil {
				return err
			}

		case "markerRecordedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentMarkerRecordedEventAttributes(&sv.MarkerRecordedEventAttributes, value); err != nil {
				return err
			}

		case "recordMarkerFailedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentRecordMarkerFailedEventAttributes(&sv.RecordMarkerFailedEventAttributes, value); err != nil {
				return err
			}

		case "requestCancelActivityTaskFailedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentRequestCancelActivityTaskFailedEventAttributes(&sv.RequestCancelActivityTaskFailedEventAttributes, value); err != nil {
				return err
			}

		case "requestCancelExternalWorkflowExecutionFailedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentRequestCancelExternalWorkflowExecutionFailedEventAttributes(&sv.RequestCancelExternalWorkflowExecutionFailedEventAttributes, value); err != nil {
				return err
			}

		case "requestCancelExternalWorkflowExecutionInitiatedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentRequestCancelExternalWorkflowExecutionInitiatedEventAttributes(&sv.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes, value); err != nil {
				return err
			}

		case "scheduleActivityTaskFailedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentScheduleActivityTaskFailedEventAttributes(&sv.ScheduleActivityTaskFailedEventAttributes, value); err != nil {
				return err
			}

		case "scheduleLambdaFunctionFailedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentScheduleLambdaFunctionFailedEventAttributes(&sv.ScheduleLambdaFunctionFailedEventAttributes, value); err != nil {
				return err
			}

		case "signalExternalWorkflowExecutionFailedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentSignalExternalWorkflowExecutionFailedEventAttributes(&sv.SignalExternalWorkflowExecutionFailedEventAttributes, value); err != nil {
				return err
			}

		case "signalExternalWorkflowExecutionInitiatedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentSignalExternalWorkflowExecutionInitiatedEventAttributes(&sv.SignalExternalWorkflowExecutionInitiatedEventAttributes, value); err != nil {
				return err
			}

		case "startChildWorkflowExecutionFailedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentStartChildWorkflowExecutionFailedEventAttributes(&sv.StartChildWorkflowExecutionFailedEventAttributes, value); err != nil {
				return err
			}

		case "startChildWorkflowExecutionInitiatedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentStartChildWorkflowExecutionInitiatedEventAttributes(&sv.StartChildWorkflowExecutionInitiatedEventAttributes, value); err != nil {
				return err
			}

		case "startLambdaFunctionFailedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentStartLambdaFunctionFailedEventAttributes(&sv.StartLambdaFunctionFailedEventAttributes, value); err != nil {
				return err
			}

		case "startTimerFailedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentStartTimerFailedEventAttributes(&sv.StartTimerFailedEventAttributes, value); err != nil {
				return err
			}

		case "timerCanceledEventAttributes":
			if err := awsAwsjson10_deserializeDocumentTimerCanceledEventAttributes(&sv.TimerCanceledEventAttributes, value); err != nil {
				return err
			}

		case "timerFiredEventAttributes":
			if err := awsAwsjson10_deserializeDocumentTimerFiredEventAttributes(&sv.TimerFiredEventAttributes, value); err != nil {
				return err
			}

		case "timerStartedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentTimerStartedEventAttributes(&sv.TimerStartedEventAttributes, value); err != nil {
				return err
			}

		case "workflowExecutionCanceledEventAttributes":
			if err := awsAwsjson10_deserializeDocumentWorkflowExecutionCanceledEventAttributes(&sv.WorkflowExecutionCanceledEventAttributes, value); err != nil {
				return err
			}

		case "workflowExecutionCancelRequestedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentWorkflowExecutionCancelRequestedEventAttributes(&sv.WorkflowExecutionCancelRequestedEventAttributes, value); err != nil {
				return err
			}

		case "workflowExecutionCompletedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentWorkflowExecutionCompletedEventAttributes(&sv.WorkflowExecutionCompletedEventAttributes, value); err != nil {
				return err
			}

		case "workflowExecutionContinuedAsNewEventAttributes":
			if err := awsAwsjson10_deserializeDocumentWorkflowExecutionContinuedAsNewEventAttributes(&sv.WorkflowExecutionContinuedAsNewEventAttributes, value); err != nil {
				return err
			}

		case "workflowExecutionFailedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentWorkflowExecutionFailedEventAttributes(&sv.WorkflowExecutionFailedEventAttributes, value); err != nil {
				return err
			}

		case "workflowExecutionSignaledEventAttributes":
			if err := awsAwsjson10_deserializeDocumentWorkflowExecutionSignaledEventAttributes(&sv.WorkflowExecutionSignaledEventAttributes, value); err != nil {
				return err
			}

		case "workflowExecutionStartedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentWorkflowExecutionStartedEventAttributes(&sv.WorkflowExecutionStartedEventAttributes, value); err != nil {
				return err
			}

		case "workflowExecutionTerminatedEventAttributes":
			if err := awsAwsjson10_deserializeDocumentWorkflowExecutionTerminatedEventAttributes(&sv.WorkflowExecutionTerminatedEventAttributes, value); err != nil {
				return err
			}

		case "workflowExecutionTimedOutEventAttributes":
			if err := awsAwsjson10_deserializeDocumentWorkflowExecutionTimedOutEventAttributes(&sv.WorkflowExecutionTimedOutEventAttributes, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentHistoryEventList(v *[]types.HistoryEvent, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.HistoryEvent
	if *v == nil {
		cv = []types.HistoryEvent{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.HistoryEvent
		destAddr := &col
		if err := awsAwsjson10_deserializeDocumentHistoryEvent(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentLambdaFunctionCompletedEventAttributes(v **types.LambdaFunctionCompletedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.LambdaFunctionCompletedEventAttributes
	if *v == nil {
		sv = &types.LambdaFunctionCompletedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "result":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.Result = ptr.String(jtv)
			}

		case "scheduledEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ScheduledEventId = i64
			}

		case "startedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StartedEventId = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentLambdaFunctionFailedEventAttributes(v **types.LambdaFunctionFailedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.LambdaFunctionFailedEventAttributes
	if *v == nil {
		sv = &types.LambdaFunctionFailedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "details":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.Details = ptr.String(jtv)
			}

		case "reason":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected FailureReason to be of type string, got %T instead", value)
				}
				sv.Reason = ptr.String(jtv)
			}

		case "scheduledEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ScheduledEventId = i64
			}

		case "startedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StartedEventId = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentLambdaFunctionScheduledEventAttributes(v **types.LambdaFunctionScheduledEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.LambdaFunctionScheduledEventAttributes
	if *v == nil {
		sv = &types.LambdaFunctionScheduledEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "control":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.Control = ptr.String(jtv)
			}

		case "decisionTaskCompletedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DecisionTaskCompletedEventId = i64
			}

		case "id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected FunctionId to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "input":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected FunctionInput to be of type string, got %T instead", value)
				}
				sv.Input = ptr.String(jtv)
			}

		case "name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected FunctionName to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "startToCloseTimeout":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DurationInSecondsOptional to be of type string, got %T instead", value)
				}
				sv.StartToCloseTimeout = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentLambdaFunctionStartedEventAttributes(v **types.LambdaFunctionStartedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.LambdaFunctionStartedEventAttributes
	if *v == nil {
		sv = &types.LambdaFunctionStartedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "scheduledEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ScheduledEventId = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentLambdaFunctionTimedOutEventAttributes(v **types.LambdaFunctionTimedOutEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.LambdaFunctionTimedOutEventAttributes
	if *v == nil {
		sv = &types.LambdaFunctionTimedOutEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "scheduledEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ScheduledEventId = i64
			}

		case "startedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StartedEventId = i64
			}

		case "timeoutType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected LambdaFunctionTimeoutType to be of type string, got %T instead", value)
				}
				sv.TimeoutType = types.LambdaFunctionTimeoutType(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentLimitExceededFault(v **types.LimitExceededFault, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.LimitExceededFault
	if *v == nil {
		sv = &types.LimitExceededFault{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ErrorMessage to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentMarkerRecordedEventAttributes(v **types.MarkerRecordedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.MarkerRecordedEventAttributes
	if *v == nil {
		sv = &types.MarkerRecordedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "decisionTaskCompletedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DecisionTaskCompletedEventId = i64
			}

		case "details":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.Details = ptr.String(jtv)
			}

		case "markerName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected MarkerName to be of type string, got %T instead", value)
				}
				sv.MarkerName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentOperationNotPermittedFault(v **types.OperationNotPermittedFault, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.OperationNotPermittedFault
	if *v == nil {
		sv = &types.OperationNotPermittedFault{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ErrorMessage to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentRecordMarkerFailedEventAttributes(v **types.RecordMarkerFailedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RecordMarkerFailedEventAttributes
	if *v == nil {
		sv = &types.RecordMarkerFailedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "cause":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RecordMarkerFailedCause to be of type string, got %T instead", value)
				}
				sv.Cause = types.RecordMarkerFailedCause(jtv)
			}

		case "decisionTaskCompletedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DecisionTaskCompletedEventId = i64
			}

		case "markerName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected MarkerName to be of type string, got %T instead", value)
				}
				sv.MarkerName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentRequestCancelActivityTaskFailedEventAttributes(v **types.RequestCancelActivityTaskFailedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RequestCancelActivityTaskFailedEventAttributes
	if *v == nil {
		sv = &types.RequestCancelActivityTaskFailedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "activityId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ActivityId to be of type string, got %T instead", value)
				}
				sv.ActivityId = ptr.String(jtv)
			}

		case "cause":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RequestCancelActivityTaskFailedCause to be of type string, got %T instead", value)
				}
				sv.Cause = types.RequestCancelActivityTaskFailedCause(jtv)
			}

		case "decisionTaskCompletedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DecisionTaskCompletedEventId = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentRequestCancelExternalWorkflowExecutionFailedEventAttributes(v **types.RequestCancelExternalWorkflowExecutionFailedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RequestCancelExternalWorkflowExecutionFailedEventAttributes
	if *v == nil {
		sv = &types.RequestCancelExternalWorkflowExecutionFailedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "cause":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RequestCancelExternalWorkflowExecutionFailedCause to be of type string, got %T instead", value)
				}
				sv.Cause = types.RequestCancelExternalWorkflowExecutionFailedCause(jtv)
			}

		case "control":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.Control = ptr.String(jtv)
			}

		case "decisionTaskCompletedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DecisionTaskCompletedEventId = i64
			}

		case "initiatedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.InitiatedEventId = i64
			}

		case "runId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected WorkflowRunIdOptional to be of type string, got %T instead", value)
				}
				sv.RunId = ptr.String(jtv)
			}

		case "workflowId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected WorkflowId to be of type string, got %T instead", value)
				}
				sv.WorkflowId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentRequestCancelExternalWorkflowExecutionInitiatedEventAttributes(v **types.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes
	if *v == nil {
		sv = &types.RequestCancelExternalWorkflowExecutionInitiatedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "control":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.Control = ptr.String(jtv)
			}

		case "decisionTaskCompletedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DecisionTaskCompletedEventId = i64
			}

		case "runId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected WorkflowRunIdOptional to be of type string, got %T instead", value)
				}
				sv.RunId = ptr.String(jtv)
			}

		case "workflowId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected WorkflowId to be of type string, got %T instead", value)
				}
				sv.WorkflowId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentResourceTag(v **types.ResourceTag, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ResourceTag
	if *v == nil {
		sv = &types.ResourceTag{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "key":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ResourceTagKey to be of type string, got %T instead", value)
				}
				sv.Key = ptr.String(jtv)
			}

		case "value":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ResourceTagValue to be of type string, got %T instead", value)
				}
				sv.Value = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentResourceTagList(v *[]types.ResourceTag, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.ResourceTag
	if *v == nil {
		cv = []types.ResourceTag{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.ResourceTag
		destAddr := &col
		if err := awsAwsjson10_deserializeDocumentResourceTag(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentScheduleActivityTaskFailedEventAttributes(v **types.ScheduleActivityTaskFailedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ScheduleActivityTaskFailedEventAttributes
	if *v == nil {
		sv = &types.ScheduleActivityTaskFailedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "activityId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ActivityId to be of type string, got %T instead", value)
				}
				sv.ActivityId = ptr.String(jtv)
			}

		case "activityType":
			if err := awsAwsjson10_deserializeDocumentActivityType(&sv.ActivityType, value); err != nil {
				return err
			}

		case "cause":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ScheduleActivityTaskFailedCause to be of type string, got %T instead", value)
				}
				sv.Cause = types.ScheduleActivityTaskFailedCause(jtv)
			}

		case "decisionTaskCompletedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DecisionTaskCompletedEventId = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentScheduleLambdaFunctionFailedEventAttributes(v **types.ScheduleLambdaFunctionFailedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.ScheduleLambdaFunctionFailedEventAttributes
	if *v == nil {
		sv = &types.ScheduleLambdaFunctionFailedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "cause":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ScheduleLambdaFunctionFailedCause to be of type string, got %T instead", value)
				}
				sv.Cause = types.ScheduleLambdaFunctionFailedCause(jtv)
			}

		case "decisionTaskCompletedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DecisionTaskCompletedEventId = i64
			}

		case "id":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected FunctionId to be of type string, got %T instead", value)
				}
				sv.Id = ptr.String(jtv)
			}

		case "name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected FunctionName to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentSignalExternalWorkflowExecutionFailedEventAttributes(v **types.SignalExternalWorkflowExecutionFailedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.SignalExternalWorkflowExecutionFailedEventAttributes
	if *v == nil {
		sv = &types.SignalExternalWorkflowExecutionFailedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "cause":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected SignalExternalWorkflowExecutionFailedCause to be of type string, got %T instead", value)
				}
				sv.Cause = types.SignalExternalWorkflowExecutionFailedCause(jtv)
			}

		case "control":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.Control = ptr.String(jtv)
			}

		case "decisionTaskCompletedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DecisionTaskCompletedEventId = i64
			}

		case "initiatedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.InitiatedEventId = i64
			}

		case "runId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected WorkflowRunIdOptional to be of type string, got %T instead", value)
				}
				sv.RunId = ptr.String(jtv)
			}

		case "workflowId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected WorkflowId to be of type string, got %T instead", value)
				}
				sv.WorkflowId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentSignalExternalWorkflowExecutionInitiatedEventAttributes(v **types.SignalExternalWorkflowExecutionInitiatedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.SignalExternalWorkflowExecutionInitiatedEventAttributes
	if *v == nil {
		sv = &types.SignalExternalWorkflowExecutionInitiatedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "control":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.Control = ptr.String(jtv)
			}

		case "decisionTaskCompletedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DecisionTaskCompletedEventId = i64
			}

		case "input":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.Input = ptr.String(jtv)
			}

		case "runId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected WorkflowRunIdOptional to be of type string, got %T instead", value)
				}
				sv.RunId = ptr.String(jtv)
			}

		case "signalName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected SignalName to be of type string, got %T instead", value)
				}
				sv.SignalName = ptr.String(jtv)
			}

		case "workflowId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected WorkflowId to be of type string, got %T instead", value)
				}
				sv.WorkflowId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentStartChildWorkflowExecutionFailedEventAttributes(v **types.StartChildWorkflowExecutionFailedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.StartChildWorkflowExecutionFailedEventAttributes
	if *v == nil {
		sv = &types.StartChildWorkflowExecutionFailedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "cause":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected StartChildWorkflowExecutionFailedCause to be of type string, got %T instead", value)
				}
				sv.Cause = types.StartChildWorkflowExecutionFailedCause(jtv)
			}

		case "control":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.Control = ptr.String(jtv)
			}

		case "decisionTaskCompletedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DecisionTaskCompletedEventId = i64
			}

		case "initiatedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.InitiatedEventId = i64
			}

		case "workflowId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected WorkflowId to be of type string, got %T instead", value)
				}
				sv.WorkflowId = ptr.String(jtv)
			}

		case "workflowType":
			if err := awsAwsjson10_deserializeDocumentWorkflowType(&sv.WorkflowType, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentStartChildWorkflowExecutionInitiatedEventAttributes(v **types.StartChildWorkflowExecutionInitiatedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.StartChildWorkflowExecutionInitiatedEventAttributes
	if *v == nil {
		sv = &types.StartChildWorkflowExecutionInitiatedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "childPolicy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ChildPolicy to be of type string, got %T instead", value)
				}
				sv.ChildPolicy = types.ChildPolicy(jtv)
			}

		case "control":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.Control = ptr.String(jtv)
			}

		case "decisionTaskCompletedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DecisionTaskCompletedEventId = i64
			}

		case "executionStartToCloseTimeout":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DurationInSecondsOptional to be of type string, got %T instead", value)
				}
				sv.ExecutionStartToCloseTimeout = ptr.String(jtv)
			}

		case "input":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.Input = ptr.String(jtv)
			}

		case "lambdaRole":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Arn to be of type string, got %T instead", value)
				}
				sv.LambdaRole = ptr.String(jtv)
			}

		case "tagList":
			if err := awsAwsjson10_deserializeDocumentTagList(&sv.TagList, value); err != nil {
				return err
			}

		case "taskList":
			if err := awsAwsjson10_deserializeDocumentTaskList(&sv.TaskList, value); err != nil {
				return err
			}

		case "taskPriority":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TaskPriority to be of type string, got %T instead", value)
				}
				sv.TaskPriority = ptr.String(jtv)
			}

		case "taskStartToCloseTimeout":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DurationInSecondsOptional to be of type string, got %T instead", value)
				}
				sv.TaskStartToCloseTimeout = ptr.String(jtv)
			}

		case "workflowId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected WorkflowId to be of type string, got %T instead", value)
				}
				sv.WorkflowId = ptr.String(jtv)
			}

		case "workflowType":
			if err := awsAwsjson10_deserializeDocumentWorkflowType(&sv.WorkflowType, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentStartLambdaFunctionFailedEventAttributes(v **types.StartLambdaFunctionFailedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.StartLambdaFunctionFailedEventAttributes
	if *v == nil {
		sv = &types.StartLambdaFunctionFailedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "cause":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected StartLambdaFunctionFailedCause to be of type string, got %T instead", value)
				}
				sv.Cause = types.StartLambdaFunctionFailedCause(jtv)
			}

		case "message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CauseMessage to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		case "scheduledEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ScheduledEventId = i64
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentStartTimerFailedEventAttributes(v **types.StartTimerFailedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.StartTimerFailedEventAttributes
	if *v == nil {
		sv = &types.StartTimerFailedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "cause":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected StartTimerFailedCause to be of type string, got %T instead", value)
				}
				sv.Cause = types.StartTimerFailedCause(jtv)
			}

		case "decisionTaskCompletedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DecisionTaskCompletedEventId = i64
			}

		case "timerId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TimerId to be of type string, got %T instead", value)
				}
				sv.TimerId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentTagList(v *[]string, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []string
	if *v == nil {
		cv = []string{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col string
		if value != nil {
			jtv, ok := value.(string)
			if !ok {
				return fmt.Errorf("expected Tag to be of type string, got %T instead", value)
			}
			col = jtv
		}
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentTaskList(v **types.TaskList, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.TaskList
	if *v == nil {
		sv = &types.TaskList{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Name to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentTimerCanceledEventAttributes(v **types.TimerCanceledEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.TimerCanceledEventAttributes
	if *v == nil {
		sv = &types.TimerCanceledEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "decisionTaskCompletedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DecisionTaskCompletedEventId = i64
			}

		case "startedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StartedEventId = i64
			}

		case "timerId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TimerId to be of type string, got %T instead", value)
				}
				sv.TimerId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentTimerFiredEventAttributes(v **types.TimerFiredEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.TimerFiredEventAttributes
	if *v == nil {
		sv = &types.TimerFiredEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "startedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StartedEventId = i64
			}

		case "timerId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TimerId to be of type string, got %T instead", value)
				}
				sv.TimerId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentTimerStartedEventAttributes(v **types.TimerStartedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.TimerStartedEventAttributes
	if *v == nil {
		sv = &types.TimerStartedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "control":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.Control = ptr.String(jtv)
			}

		case "decisionTaskCompletedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DecisionTaskCompletedEventId = i64
			}

		case "startToFireTimeout":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DurationInSeconds to be of type string, got %T instead", value)
				}
				sv.StartToFireTimeout = ptr.String(jtv)
			}

		case "timerId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TimerId to be of type string, got %T instead", value)
				}
				sv.TimerId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentTooManyTagsFault(v **types.TooManyTagsFault, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.TooManyTagsFault
	if *v == nil {
		sv = &types.TooManyTagsFault{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ErrorMessage to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentTypeAlreadyExistsFault(v **types.TypeAlreadyExistsFault, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.TypeAlreadyExistsFault
	if *v == nil {
		sv = &types.TypeAlreadyExistsFault{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ErrorMessage to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentTypeDeprecatedFault(v **types.TypeDeprecatedFault, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.TypeDeprecatedFault
	if *v == nil {
		sv = &types.TypeDeprecatedFault{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ErrorMessage to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentTypeNotDeprecatedFault(v **types.TypeNotDeprecatedFault, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.TypeNotDeprecatedFault
	if *v == nil {
		sv = &types.TypeNotDeprecatedFault{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ErrorMessage to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentUnknownResourceFault(v **types.UnknownResourceFault, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.UnknownResourceFault
	if *v == nil {
		sv = &types.UnknownResourceFault{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ErrorMessage to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentWorkflowExecution(v **types.WorkflowExecution, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.WorkflowExecution
	if *v == nil {
		sv = &types.WorkflowExecution{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "runId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected WorkflowRunId to be of type string, got %T instead", value)
				}
				sv.RunId = ptr.String(jtv)
			}

		case "workflowId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected WorkflowId to be of type string, got %T instead", value)
				}
				sv.WorkflowId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentWorkflowExecutionAlreadyStartedFault(v **types.WorkflowExecutionAlreadyStartedFault, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.WorkflowExecutionAlreadyStartedFault
	if *v == nil {
		sv = &types.WorkflowExecutionAlreadyStartedFault{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "message":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ErrorMessage to be of type string, got %T instead", value)
				}
				sv.Message = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentWorkflowExecutionCanceledEventAttributes(v **types.WorkflowExecutionCanceledEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.WorkflowExecutionCanceledEventAttributes
	if *v == nil {
		sv = &types.WorkflowExecutionCanceledEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "decisionTaskCompletedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DecisionTaskCompletedEventId = i64
			}

		case "details":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.Details = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentWorkflowExecutionCancelRequestedEventAttributes(v **types.WorkflowExecutionCancelRequestedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.WorkflowExecutionCancelRequestedEventAttributes
	if *v == nil {
		sv = &types.WorkflowExecutionCancelRequestedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "cause":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected WorkflowExecutionCancelRequestedCause to be of type string, got %T instead", value)
				}
				sv.Cause = types.WorkflowExecutionCancelRequestedCause(jtv)
			}

		case "externalInitiatedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ExternalInitiatedEventId = i64
			}

		case "externalWorkflowExecution":
			if err := awsAwsjson10_deserializeDocumentWorkflowExecution(&sv.ExternalWorkflowExecution, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentWorkflowExecutionCompletedEventAttributes(v **types.WorkflowExecutionCompletedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.WorkflowExecutionCompletedEventAttributes
	if *v == nil {
		sv = &types.WorkflowExecutionCompletedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "decisionTaskCompletedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DecisionTaskCompletedEventId = i64
			}

		case "result":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.Result = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentWorkflowExecutionConfiguration(v **types.WorkflowExecutionConfiguration, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.WorkflowExecutionConfiguration
	if *v == nil {
		sv = &types.WorkflowExecutionConfiguration{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "childPolicy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ChildPolicy to be of type string, got %T instead", value)
				}
				sv.ChildPolicy = types.ChildPolicy(jtv)
			}

		case "executionStartToCloseTimeout":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DurationInSeconds to be of type string, got %T instead", value)
				}
				sv.ExecutionStartToCloseTimeout = ptr.String(jtv)
			}

		case "lambdaRole":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Arn to be of type string, got %T instead", value)
				}
				sv.LambdaRole = ptr.String(jtv)
			}

		case "taskList":
			if err := awsAwsjson10_deserializeDocumentTaskList(&sv.TaskList, value); err != nil {
				return err
			}

		case "taskPriority":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TaskPriority to be of type string, got %T instead", value)
				}
				sv.TaskPriority = ptr.String(jtv)
			}

		case "taskStartToCloseTimeout":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DurationInSeconds to be of type string, got %T instead", value)
				}
				sv.TaskStartToCloseTimeout = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentWorkflowExecutionContinuedAsNewEventAttributes(v **types.WorkflowExecutionContinuedAsNewEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.WorkflowExecutionContinuedAsNewEventAttributes
	if *v == nil {
		sv = &types.WorkflowExecutionContinuedAsNewEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "childPolicy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ChildPolicy to be of type string, got %T instead", value)
				}
				sv.ChildPolicy = types.ChildPolicy(jtv)
			}

		case "decisionTaskCompletedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DecisionTaskCompletedEventId = i64
			}

		case "executionStartToCloseTimeout":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DurationInSecondsOptional to be of type string, got %T instead", value)
				}
				sv.ExecutionStartToCloseTimeout = ptr.String(jtv)
			}

		case "input":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.Input = ptr.String(jtv)
			}

		case "lambdaRole":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Arn to be of type string, got %T instead", value)
				}
				sv.LambdaRole = ptr.String(jtv)
			}

		case "newExecutionRunId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected WorkflowRunId to be of type string, got %T instead", value)
				}
				sv.NewExecutionRunId = ptr.String(jtv)
			}

		case "tagList":
			if err := awsAwsjson10_deserializeDocumentTagList(&sv.TagList, value); err != nil {
				return err
			}

		case "taskList":
			if err := awsAwsjson10_deserializeDocumentTaskList(&sv.TaskList, value); err != nil {
				return err
			}

		case "taskPriority":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TaskPriority to be of type string, got %T instead", value)
				}
				sv.TaskPriority = ptr.String(jtv)
			}

		case "taskStartToCloseTimeout":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DurationInSecondsOptional to be of type string, got %T instead", value)
				}
				sv.TaskStartToCloseTimeout = ptr.String(jtv)
			}

		case "workflowType":
			if err := awsAwsjson10_deserializeDocumentWorkflowType(&sv.WorkflowType, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentWorkflowExecutionFailedEventAttributes(v **types.WorkflowExecutionFailedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.WorkflowExecutionFailedEventAttributes
	if *v == nil {
		sv = &types.WorkflowExecutionFailedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "decisionTaskCompletedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.DecisionTaskCompletedEventId = i64
			}

		case "details":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.Details = ptr.String(jtv)
			}

		case "reason":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected FailureReason to be of type string, got %T instead", value)
				}
				sv.Reason = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentWorkflowExecutionInfo(v **types.WorkflowExecutionInfo, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.WorkflowExecutionInfo
	if *v == nil {
		sv = &types.WorkflowExecutionInfo{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "cancelRequested":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Canceled to be of type *bool, got %T instead", value)
				}
				sv.CancelRequested = jtv
			}

		case "closeStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected CloseStatus to be of type string, got %T instead", value)
				}
				sv.CloseStatus = types.CloseStatus(jtv)
			}

		case "closeTimestamp":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.CloseTimestamp = ptr.Time(smithytime.ParseEpochSeconds(f64))

				default:
					return fmt.Errorf("expected Timestamp to be a JSON Number, got %T instead", value)

				}
			}

		case "execution":
			if err := awsAwsjson10_deserializeDocumentWorkflowExecution(&sv.Execution, value); err != nil {
				return err
			}

		case "executionStatus":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ExecutionStatus to be of type string, got %T instead", value)
				}
				sv.ExecutionStatus = types.ExecutionStatus(jtv)
			}

		case "parent":
			if err := awsAwsjson10_deserializeDocumentWorkflowExecution(&sv.Parent, value); err != nil {
				return err
			}

		case "startTimestamp":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.StartTimestamp = ptr.Time(smithytime.ParseEpochSeconds(f64))

				default:
					return fmt.Errorf("expected Timestamp to be a JSON Number, got %T instead", value)

				}
			}

		case "tagList":
			if err := awsAwsjson10_deserializeDocumentTagList(&sv.TagList, value); err != nil {
				return err
			}

		case "workflowType":
			if err := awsAwsjson10_deserializeDocumentWorkflowType(&sv.WorkflowType, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentWorkflowExecutionInfoList(v *[]types.WorkflowExecutionInfo, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.WorkflowExecutionInfo
	if *v == nil {
		cv = []types.WorkflowExecutionInfo{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.WorkflowExecutionInfo
		destAddr := &col
		if err := awsAwsjson10_deserializeDocumentWorkflowExecutionInfo(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeDocumentWorkflowExecutionOpenCounts(v **types.WorkflowExecutionOpenCounts, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.WorkflowExecutionOpenCounts
	if *v == nil {
		sv = &types.WorkflowExecutionOpenCounts{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "openActivityTasks":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Count to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.OpenActivityTasks = int32(i64)
			}

		case "openChildWorkflowExecutions":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Count to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.OpenChildWorkflowExecutions = int32(i64)
			}

		case "openDecisionTasks":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected OpenDecisionTasksCount to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.OpenDecisionTasks = int32(i64)
			}

		case "openLambdaFunctions":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Count to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.OpenLambdaFunctions = int32(i64)
			}

		case "openTimers":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Count to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.OpenTimers = int32(i64)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentWorkflowExecutionSignaledEventAttributes(v **types.WorkflowExecutionSignaledEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.WorkflowExecutionSignaledEventAttributes
	if *v == nil {
		sv = &types.WorkflowExecutionSignaledEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "externalInitiatedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ExternalInitiatedEventId = i64
			}

		case "externalWorkflowExecution":
			if err := awsAwsjson10_deserializeDocumentWorkflowExecution(&sv.ExternalWorkflowExecution, value); err != nil {
				return err
			}

		case "input":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.Input = ptr.String(jtv)
			}

		case "signalName":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected SignalName to be of type string, got %T instead", value)
				}
				sv.SignalName = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentWorkflowExecutionStartedEventAttributes(v **types.WorkflowExecutionStartedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.WorkflowExecutionStartedEventAttributes
	if *v == nil {
		sv = &types.WorkflowExecutionStartedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "childPolicy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ChildPolicy to be of type string, got %T instead", value)
				}
				sv.ChildPolicy = types.ChildPolicy(jtv)
			}

		case "continuedExecutionRunId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected WorkflowRunIdOptional to be of type string, got %T instead", value)
				}
				sv.ContinuedExecutionRunId = ptr.String(jtv)
			}

		case "executionStartToCloseTimeout":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DurationInSecondsOptional to be of type string, got %T instead", value)
				}
				sv.ExecutionStartToCloseTimeout = ptr.String(jtv)
			}

		case "input":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.Input = ptr.String(jtv)
			}

		case "lambdaRole":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Arn to be of type string, got %T instead", value)
				}
				sv.LambdaRole = ptr.String(jtv)
			}

		case "parentInitiatedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.ParentInitiatedEventId = i64
			}

		case "parentWorkflowExecution":
			if err := awsAwsjson10_deserializeDocumentWorkflowExecution(&sv.ParentWorkflowExecution, value); err != nil {
				return err
			}

		case "tagList":
			if err := awsAwsjson10_deserializeDocumentTagList(&sv.TagList, value); err != nil {
				return err
			}

		case "taskList":
			if err := awsAwsjson10_deserializeDocumentTaskList(&sv.TaskList, value); err != nil {
				return err
			}

		case "taskPriority":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TaskPriority to be of type string, got %T instead", value)
				}
				sv.TaskPriority = ptr.String(jtv)
			}

		case "taskStartToCloseTimeout":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DurationInSecondsOptional to be of type string, got %T instead", value)
				}
				sv.TaskStartToCloseTimeout = ptr.String(jtv)
			}

		case "workflowType":
			if err := awsAwsjson10_deserializeDocumentWorkflowType(&sv.WorkflowType, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentWorkflowExecutionTerminatedEventAttributes(v **types.WorkflowExecutionTerminatedEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.WorkflowExecutionTerminatedEventAttributes
	if *v == nil {
		sv = &types.WorkflowExecutionTerminatedEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "cause":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected WorkflowExecutionTerminatedCause to be of type string, got %T instead", value)
				}
				sv.Cause = types.WorkflowExecutionTerminatedCause(jtv)
			}

		case "childPolicy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ChildPolicy to be of type string, got %T instead", value)
				}
				sv.ChildPolicy = types.ChildPolicy(jtv)
			}

		case "details":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.Details = ptr.String(jtv)
			}

		case "reason":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TerminateReason to be of type string, got %T instead", value)
				}
				sv.Reason = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentWorkflowExecutionTimedOutEventAttributes(v **types.WorkflowExecutionTimedOutEventAttributes, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.WorkflowExecutionTimedOutEventAttributes
	if *v == nil {
		sv = &types.WorkflowExecutionTimedOutEventAttributes{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "childPolicy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ChildPolicy to be of type string, got %T instead", value)
				}
				sv.ChildPolicy = types.ChildPolicy(jtv)
			}

		case "timeoutType":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected WorkflowExecutionTimeoutType to be of type string, got %T instead", value)
				}
				sv.TimeoutType = types.WorkflowExecutionTimeoutType(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentWorkflowType(v **types.WorkflowType, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.WorkflowType
	if *v == nil {
		sv = &types.WorkflowType{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "name":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Name to be of type string, got %T instead", value)
				}
				sv.Name = ptr.String(jtv)
			}

		case "version":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Version to be of type string, got %T instead", value)
				}
				sv.Version = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentWorkflowTypeConfiguration(v **types.WorkflowTypeConfiguration, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.WorkflowTypeConfiguration
	if *v == nil {
		sv = &types.WorkflowTypeConfiguration{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "defaultChildPolicy":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ChildPolicy to be of type string, got %T instead", value)
				}
				sv.DefaultChildPolicy = types.ChildPolicy(jtv)
			}

		case "defaultExecutionStartToCloseTimeout":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DurationInSecondsOptional to be of type string, got %T instead", value)
				}
				sv.DefaultExecutionStartToCloseTimeout = ptr.String(jtv)
			}

		case "defaultLambdaRole":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Arn to be of type string, got %T instead", value)
				}
				sv.DefaultLambdaRole = ptr.String(jtv)
			}

		case "defaultTaskList":
			if err := awsAwsjson10_deserializeDocumentTaskList(&sv.DefaultTaskList, value); err != nil {
				return err
			}

		case "defaultTaskPriority":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TaskPriority to be of type string, got %T instead", value)
				}
				sv.DefaultTaskPriority = ptr.String(jtv)
			}

		case "defaultTaskStartToCloseTimeout":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected DurationInSecondsOptional to be of type string, got %T instead", value)
				}
				sv.DefaultTaskStartToCloseTimeout = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentWorkflowTypeInfo(v **types.WorkflowTypeInfo, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *types.WorkflowTypeInfo
	if *v == nil {
		sv = &types.WorkflowTypeInfo{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "creationDate":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.CreationDate = ptr.Time(smithytime.ParseEpochSeconds(f64))

				default:
					return fmt.Errorf("expected Timestamp to be a JSON Number, got %T instead", value)

				}
			}

		case "deprecationDate":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.DeprecationDate = ptr.Time(smithytime.ParseEpochSeconds(f64))

				default:
					return fmt.Errorf("expected Timestamp to be a JSON Number, got %T instead", value)

				}
			}

		case "description":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Description to be of type string, got %T instead", value)
				}
				sv.Description = ptr.String(jtv)
			}

		case "status":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected RegistrationStatus to be of type string, got %T instead", value)
				}
				sv.Status = types.RegistrationStatus(jtv)
			}

		case "workflowType":
			if err := awsAwsjson10_deserializeDocumentWorkflowType(&sv.WorkflowType, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeDocumentWorkflowTypeInfoList(v *[]types.WorkflowTypeInfo, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.([]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var cv []types.WorkflowTypeInfo
	if *v == nil {
		cv = []types.WorkflowTypeInfo{}
	} else {
		cv = *v
	}

	for _, value := range shape {
		var col types.WorkflowTypeInfo
		destAddr := &col
		if err := awsAwsjson10_deserializeDocumentWorkflowTypeInfo(&destAddr, value); err != nil {
			return err
		}
		col = *destAddr
		cv = append(cv, col)

	}
	*v = cv
	return nil
}

func awsAwsjson10_deserializeOpDocumentCountClosedWorkflowExecutionsOutput(v **CountClosedWorkflowExecutionsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CountClosedWorkflowExecutionsOutput
	if *v == nil {
		sv = &CountClosedWorkflowExecutionsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "count":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Count to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Count = int32(i64)
			}

		case "truncated":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Truncated to be of type *bool, got %T instead", value)
				}
				sv.Truncated = jtv
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentCountOpenWorkflowExecutionsOutput(v **CountOpenWorkflowExecutionsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CountOpenWorkflowExecutionsOutput
	if *v == nil {
		sv = &CountOpenWorkflowExecutionsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "count":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Count to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Count = int32(i64)
			}

		case "truncated":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Truncated to be of type *bool, got %T instead", value)
				}
				sv.Truncated = jtv
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentCountPendingActivityTasksOutput(v **CountPendingActivityTasksOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CountPendingActivityTasksOutput
	if *v == nil {
		sv = &CountPendingActivityTasksOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "count":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Count to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Count = int32(i64)
			}

		case "truncated":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Truncated to be of type *bool, got %T instead", value)
				}
				sv.Truncated = jtv
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentCountPendingDecisionTasksOutput(v **CountPendingDecisionTasksOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *CountPendingDecisionTasksOutput
	if *v == nil {
		sv = &CountPendingDecisionTasksOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "count":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected Count to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.Count = int32(i64)
			}

		case "truncated":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Truncated to be of type *bool, got %T instead", value)
				}
				sv.Truncated = jtv
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentDescribeActivityTypeOutput(v **DescribeActivityTypeOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DescribeActivityTypeOutput
	if *v == nil {
		sv = &DescribeActivityTypeOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "configuration":
			if err := awsAwsjson10_deserializeDocumentActivityTypeConfiguration(&sv.Configuration, value); err != nil {
				return err
			}

		case "typeInfo":
			if err := awsAwsjson10_deserializeDocumentActivityTypeInfo(&sv.TypeInfo, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentDescribeDomainOutput(v **DescribeDomainOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DescribeDomainOutput
	if *v == nil {
		sv = &DescribeDomainOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "configuration":
			if err := awsAwsjson10_deserializeDocumentDomainConfiguration(&sv.Configuration, value); err != nil {
				return err
			}

		case "domainInfo":
			if err := awsAwsjson10_deserializeDocumentDomainInfo(&sv.DomainInfo, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentDescribeWorkflowExecutionOutput(v **DescribeWorkflowExecutionOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DescribeWorkflowExecutionOutput
	if *v == nil {
		sv = &DescribeWorkflowExecutionOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "executionConfiguration":
			if err := awsAwsjson10_deserializeDocumentWorkflowExecutionConfiguration(&sv.ExecutionConfiguration, value); err != nil {
				return err
			}

		case "executionInfo":
			if err := awsAwsjson10_deserializeDocumentWorkflowExecutionInfo(&sv.ExecutionInfo, value); err != nil {
				return err
			}

		case "latestActivityTaskTimestamp":
			if value != nil {
				switch jtv := value.(type) {
				case json.Number:
					f64, err := jtv.Float64()
					if err != nil {
						return err
					}
					sv.LatestActivityTaskTimestamp = ptr.Time(smithytime.ParseEpochSeconds(f64))

				default:
					return fmt.Errorf("expected Timestamp to be a JSON Number, got %T instead", value)

				}
			}

		case "latestExecutionContext":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.LatestExecutionContext = ptr.String(jtv)
			}

		case "openCounts":
			if err := awsAwsjson10_deserializeDocumentWorkflowExecutionOpenCounts(&sv.OpenCounts, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentDescribeWorkflowTypeOutput(v **DescribeWorkflowTypeOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *DescribeWorkflowTypeOutput
	if *v == nil {
		sv = &DescribeWorkflowTypeOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "configuration":
			if err := awsAwsjson10_deserializeDocumentWorkflowTypeConfiguration(&sv.Configuration, value); err != nil {
				return err
			}

		case "typeInfo":
			if err := awsAwsjson10_deserializeDocumentWorkflowTypeInfo(&sv.TypeInfo, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentGetWorkflowExecutionHistoryOutput(v **GetWorkflowExecutionHistoryOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *GetWorkflowExecutionHistoryOutput
	if *v == nil {
		sv = &GetWorkflowExecutionHistoryOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "events":
			if err := awsAwsjson10_deserializeDocumentHistoryEventList(&sv.Events, value); err != nil {
				return err
			}

		case "nextPageToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected PageToken to be of type string, got %T instead", value)
				}
				sv.NextPageToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentListActivityTypesOutput(v **ListActivityTypesOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListActivityTypesOutput
	if *v == nil {
		sv = &ListActivityTypesOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "nextPageToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected PageToken to be of type string, got %T instead", value)
				}
				sv.NextPageToken = ptr.String(jtv)
			}

		case "typeInfos":
			if err := awsAwsjson10_deserializeDocumentActivityTypeInfoList(&sv.TypeInfos, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentListClosedWorkflowExecutionsOutput(v **ListClosedWorkflowExecutionsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListClosedWorkflowExecutionsOutput
	if *v == nil {
		sv = &ListClosedWorkflowExecutionsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "executionInfos":
			if err := awsAwsjson10_deserializeDocumentWorkflowExecutionInfoList(&sv.ExecutionInfos, value); err != nil {
				return err
			}

		case "nextPageToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected PageToken to be of type string, got %T instead", value)
				}
				sv.NextPageToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentListDomainsOutput(v **ListDomainsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListDomainsOutput
	if *v == nil {
		sv = &ListDomainsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "domainInfos":
			if err := awsAwsjson10_deserializeDocumentDomainInfoList(&sv.DomainInfos, value); err != nil {
				return err
			}

		case "nextPageToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected PageToken to be of type string, got %T instead", value)
				}
				sv.NextPageToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentListOpenWorkflowExecutionsOutput(v **ListOpenWorkflowExecutionsOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListOpenWorkflowExecutionsOutput
	if *v == nil {
		sv = &ListOpenWorkflowExecutionsOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "executionInfos":
			if err := awsAwsjson10_deserializeDocumentWorkflowExecutionInfoList(&sv.ExecutionInfos, value); err != nil {
				return err
			}

		case "nextPageToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected PageToken to be of type string, got %T instead", value)
				}
				sv.NextPageToken = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentListTagsForResourceOutput(v **ListTagsForResourceOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListTagsForResourceOutput
	if *v == nil {
		sv = &ListTagsForResourceOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "tags":
			if err := awsAwsjson10_deserializeDocumentResourceTagList(&sv.Tags, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentListWorkflowTypesOutput(v **ListWorkflowTypesOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *ListWorkflowTypesOutput
	if *v == nil {
		sv = &ListWorkflowTypesOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "nextPageToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected PageToken to be of type string, got %T instead", value)
				}
				sv.NextPageToken = ptr.String(jtv)
			}

		case "typeInfos":
			if err := awsAwsjson10_deserializeDocumentWorkflowTypeInfoList(&sv.TypeInfos, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentPollForActivityTaskOutput(v **PollForActivityTaskOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *PollForActivityTaskOutput
	if *v == nil {
		sv = &PollForActivityTaskOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "activityId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected ActivityId to be of type string, got %T instead", value)
				}
				sv.ActivityId = ptr.String(jtv)
			}

		case "activityType":
			if err := awsAwsjson10_deserializeDocumentActivityType(&sv.ActivityType, value); err != nil {
				return err
			}

		case "input":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected Data to be of type string, got %T instead", value)
				}
				sv.Input = ptr.String(jtv)
			}

		case "startedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StartedEventId = i64
			}

		case "taskToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TaskToken to be of type string, got %T instead", value)
				}
				sv.TaskToken = ptr.String(jtv)
			}

		case "workflowExecution":
			if err := awsAwsjson10_deserializeDocumentWorkflowExecution(&sv.WorkflowExecution, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentPollForDecisionTaskOutput(v **PollForDecisionTaskOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *PollForDecisionTaskOutput
	if *v == nil {
		sv = &PollForDecisionTaskOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "events":
			if err := awsAwsjson10_deserializeDocumentHistoryEventList(&sv.Events, value); err != nil {
				return err
			}

		case "nextPageToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected PageToken to be of type string, got %T instead", value)
				}
				sv.NextPageToken = ptr.String(jtv)
			}

		case "previousStartedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.PreviousStartedEventId = i64
			}

		case "startedEventId":
			if value != nil {
				jtv, ok := value.(json.Number)
				if !ok {
					return fmt.Errorf("expected EventId to be json.Number, got %T instead", value)
				}
				i64, err := jtv.Int64()
				if err != nil {
					return err
				}
				sv.StartedEventId = i64
			}

		case "taskToken":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected TaskToken to be of type string, got %T instead", value)
				}
				sv.TaskToken = ptr.String(jtv)
			}

		case "workflowExecution":
			if err := awsAwsjson10_deserializeDocumentWorkflowExecution(&sv.WorkflowExecution, value); err != nil {
				return err
			}

		case "workflowType":
			if err := awsAwsjson10_deserializeDocumentWorkflowType(&sv.WorkflowType, value); err != nil {
				return err
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentRecordActivityTaskHeartbeatOutput(v **RecordActivityTaskHeartbeatOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *RecordActivityTaskHeartbeatOutput
	if *v == nil {
		sv = &RecordActivityTaskHeartbeatOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "cancelRequested":
			if value != nil {
				jtv, ok := value.(bool)
				if !ok {
					return fmt.Errorf("expected Canceled to be of type *bool, got %T instead", value)
				}
				sv.CancelRequested = jtv
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

func awsAwsjson10_deserializeOpDocumentStartWorkflowExecutionOutput(v **StartWorkflowExecutionOutput, value interface{}) error {
	if v == nil {
		return fmt.Errorf("unexpected nil of type %T", v)
	}
	if value == nil {
		return nil
	}

	shape, ok := value.(map[string]interface{})
	if !ok {
		return fmt.Errorf("unexpected JSON type %v", value)
	}

	var sv *StartWorkflowExecutionOutput
	if *v == nil {
		sv = &StartWorkflowExecutionOutput{}
	} else {
		sv = *v
	}

	for key, value := range shape {
		switch key {
		case "runId":
			if value != nil {
				jtv, ok := value.(string)
				if !ok {
					return fmt.Errorf("expected WorkflowRunId to be of type string, got %T instead", value)
				}
				sv.RunId = ptr.String(jtv)
			}

		default:
			_, _ = key, value

		}
	}
	*v = sv
	return nil
}

type protocolErrorInfo struct {
	Type    string `json:"__type"`
	Message string
	Code    any // nonstandard for awsjson but some services do present the type here
}

func getProtocolErrorInfo(decoder *json.Decoder) (protocolErrorInfo, error) {
	var errInfo protocolErrorInfo
	if err := decoder.Decode(&errInfo); err != nil {
		if err == io.EOF {
			return errInfo, nil
		}
		return errInfo, err
	}

	return errInfo, nil
}

func resolveProtocolErrorType(headerType string, bodyInfo protocolErrorInfo) (string, bool) {
	if len(headerType) != 0 {
		return headerType, true
	} else if len(bodyInfo.Type) != 0 {
		return bodyInfo.Type, true
	} else if code, ok := bodyInfo.Code.(string); ok && len(code) != 0 {
		return code, true
	}
	return "", false
}
