package authorization

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/autorest/validation"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// RoleAssignmentScheduleRequestsClient is the client for the RoleAssignmentScheduleRequests methods of the
// Authorization service.
type RoleAssignmentScheduleRequestsClient struct {
	BaseClient
}

// NewRoleAssignmentScheduleRequestsClient creates an instance of the RoleAssignmentScheduleRequestsClient client.
func NewRoleAssignmentScheduleRequestsClient(subscriptionID string) RoleAssignmentScheduleRequestsClient {
	return NewRoleAssignmentScheduleRequestsClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewRoleAssignmentScheduleRequestsClientWithBaseURI creates an instance of the RoleAssignmentScheduleRequestsClient
// client using a custom endpoint.  Use this when interacting with an Azure cloud that uses a non-standard base URI
// (sovereign clouds, Azure stack).
func NewRoleAssignmentScheduleRequestsClientWithBaseURI(baseURI string, subscriptionID string) RoleAssignmentScheduleRequestsClient {
	return RoleAssignmentScheduleRequestsClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Cancel cancels a pending role assignment schedule request.
// Parameters:
// scope - the scope of the role assignment request to cancel.
// roleAssignmentScheduleRequestName - the name of the role assignment request to cancel.
func (client RoleAssignmentScheduleRequestsClient) Cancel(ctx context.Context, scope string, roleAssignmentScheduleRequestName string) (result autorest.Response, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentScheduleRequestsClient.Cancel")
		defer func() {
			sc := -1
			if result.Response != nil {
				sc = result.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.CancelPreparer(ctx, scope, roleAssignmentScheduleRequestName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentScheduleRequestsClient", "Cancel", nil, "Failure preparing request")
		return
	}

	resp, err := client.CancelSender(req)
	if err != nil {
		result.Response = resp
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentScheduleRequestsClient", "Cancel", resp, "Failure sending request")
		return
	}

	result, err = client.CancelResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentScheduleRequestsClient", "Cancel", resp, "Failure responding to request")
		return
	}

	return
}

// CancelPreparer prepares the Cancel request.
func (client RoleAssignmentScheduleRequestsClient) CancelPreparer(ctx context.Context, scope string, roleAssignmentScheduleRequestName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"roleAssignmentScheduleRequestName": autorest.Encode("path", roleAssignmentScheduleRequestName),
		"scope":                             scope,
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Authorization/roleAssignmentScheduleRequests/{roleAssignmentScheduleRequestName}/cancel", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CancelSender sends the Cancel request. The method will close the
// http.Response Body if it receives an error.
func (client RoleAssignmentScheduleRequestsClient) CancelSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CancelResponder handles the response to the Cancel request. The method always
// closes the http.Response Body.
func (client RoleAssignmentScheduleRequestsClient) CancelResponder(resp *http.Response) (result autorest.Response, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByClosing())
	result.Response = resp
	return
}

// Create creates a role assignment schedule request.
// Parameters:
// scope - the scope of the role assignment schedule request to create. The scope can be any REST resource
// instance. For example, use '/subscriptions/{subscription-id}/' for a subscription,
// '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}' for a resource group, and
// '/subscriptions/{subscription-id}/resourceGroups/{resource-group-name}/providers/{resource-provider}/{resource-type}/{resource-name}'
// for a resource.
// roleAssignmentScheduleRequestName - a GUID for the role assignment to create. The name must be unique and
// different for each role assignment.
// parameters - parameters for the role assignment schedule request.
func (client RoleAssignmentScheduleRequestsClient) Create(ctx context.Context, scope string, roleAssignmentScheduleRequestName string, parameters RoleAssignmentScheduleRequest) (result RoleAssignmentScheduleRequest, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentScheduleRequestsClient.Create")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.RoleAssignmentScheduleRequestProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "parameters.RoleAssignmentScheduleRequestProperties.RoleDefinitionID", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "parameters.RoleAssignmentScheduleRequestProperties.PrincipalID", Name: validation.Null, Rule: true, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("authorization.RoleAssignmentScheduleRequestsClient", "Create", err.Error())
	}

	req, err := client.CreatePreparer(ctx, scope, roleAssignmentScheduleRequestName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentScheduleRequestsClient", "Create", nil, "Failure preparing request")
		return
	}

	resp, err := client.CreateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentScheduleRequestsClient", "Create", resp, "Failure sending request")
		return
	}

	result, err = client.CreateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentScheduleRequestsClient", "Create", resp, "Failure responding to request")
		return
	}

	return
}

// CreatePreparer prepares the Create request.
func (client RoleAssignmentScheduleRequestsClient) CreatePreparer(ctx context.Context, scope string, roleAssignmentScheduleRequestName string, parameters RoleAssignmentScheduleRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"roleAssignmentScheduleRequestName": autorest.Encode("path", roleAssignmentScheduleRequestName),
		"scope":                             scope,
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	parameters.ID = nil
	parameters.Name = nil
	parameters.Type = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPut(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Authorization/roleAssignmentScheduleRequests/{roleAssignmentScheduleRequestName}", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// CreateSender sends the Create request. The method will close the
// http.Response Body if it receives an error.
func (client RoleAssignmentScheduleRequestsClient) CreateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// CreateResponder handles the response to the Create request. The method always
// closes the http.Response Body.
func (client RoleAssignmentScheduleRequestsClient) CreateResponder(resp *http.Response) (result RoleAssignmentScheduleRequest, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK, http.StatusCreated),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// Get get the specified role assignment schedule request.
// Parameters:
// scope - the scope of the role assignment schedule request.
// roleAssignmentScheduleRequestName - the name (guid) of the role assignment schedule request to get.
func (client RoleAssignmentScheduleRequestsClient) Get(ctx context.Context, scope string, roleAssignmentScheduleRequestName string) (result RoleAssignmentScheduleRequest, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentScheduleRequestsClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, scope, roleAssignmentScheduleRequestName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentScheduleRequestsClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentScheduleRequestsClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentScheduleRequestsClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client RoleAssignmentScheduleRequestsClient) GetPreparer(ctx context.Context, scope string, roleAssignmentScheduleRequestName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"roleAssignmentScheduleRequestName": autorest.Encode("path", roleAssignmentScheduleRequestName),
		"scope":                             scope,
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Authorization/roleAssignmentScheduleRequests/{roleAssignmentScheduleRequestName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client RoleAssignmentScheduleRequestsClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client RoleAssignmentScheduleRequestsClient) GetResponder(resp *http.Response) (result RoleAssignmentScheduleRequest, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListForScope gets role assignment schedule requests for a scope.
// Parameters:
// scope - the scope of the role assignments schedule requests.
// filter - the filter to apply on the operation. Use $filter=atScope() to return all role assignment schedule
// requests at or above the scope. Use $filter=principalId eq {id} to return all role assignment schedule
// requests at, above or below the scope for the specified principal. Use $filter=asRequestor() to return all
// role assignment schedule requests requested by the current user. Use $filter=asTarget() to return all role
// assignment schedule requests created for the current user. Use $filter=asApprover() to return all role
// assignment schedule requests where the current user is an approver.
func (client RoleAssignmentScheduleRequestsClient) ListForScope(ctx context.Context, scope string, filter string) (result RoleAssignmentScheduleRequestListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentScheduleRequestsClient.ListForScope")
		defer func() {
			sc := -1
			if result.rasrlr.Response.Response != nil {
				sc = result.rasrlr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listForScopeNextResults
	req, err := client.ListForScopePreparer(ctx, scope, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentScheduleRequestsClient", "ListForScope", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListForScopeSender(req)
	if err != nil {
		result.rasrlr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentScheduleRequestsClient", "ListForScope", resp, "Failure sending request")
		return
	}

	result.rasrlr, err = client.ListForScopeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentScheduleRequestsClient", "ListForScope", resp, "Failure responding to request")
		return
	}
	if result.rasrlr.hasNextLink() && result.rasrlr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListForScopePreparer prepares the ListForScope request.
func (client RoleAssignmentScheduleRequestsClient) ListForScopePreparer(ctx context.Context, scope string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"scope": scope,
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Authorization/roleAssignmentScheduleRequests", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListForScopeSender sends the ListForScope request. The method will close the
// http.Response Body if it receives an error.
func (client RoleAssignmentScheduleRequestsClient) ListForScopeSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListForScopeResponder handles the response to the ListForScope request. The method always
// closes the http.Response Body.
func (client RoleAssignmentScheduleRequestsClient) ListForScopeResponder(resp *http.Response) (result RoleAssignmentScheduleRequestListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listForScopeNextResults retrieves the next set of results, if any.
func (client RoleAssignmentScheduleRequestsClient) listForScopeNextResults(ctx context.Context, lastResults RoleAssignmentScheduleRequestListResult) (result RoleAssignmentScheduleRequestListResult, err error) {
	req, err := lastResults.roleAssignmentScheduleRequestListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "authorization.RoleAssignmentScheduleRequestsClient", "listForScopeNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListForScopeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "authorization.RoleAssignmentScheduleRequestsClient", "listForScopeNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListForScopeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentScheduleRequestsClient", "listForScopeNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListForScopeComplete enumerates all values, automatically crossing page boundaries as required.
func (client RoleAssignmentScheduleRequestsClient) ListForScopeComplete(ctx context.Context, scope string, filter string) (result RoleAssignmentScheduleRequestListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentScheduleRequestsClient.ListForScope")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListForScope(ctx, scope, filter)
	return
}

// Validate validates a new role assignment schedule request.
// Parameters:
// scope - the scope of the role assignment request to validate.
// roleAssignmentScheduleRequestName - the name of the role assignment request to validate.
// parameters - parameters for the role assignment schedule request.
func (client RoleAssignmentScheduleRequestsClient) Validate(ctx context.Context, scope string, roleAssignmentScheduleRequestName string, parameters RoleAssignmentScheduleRequest) (result RoleAssignmentScheduleRequest, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleAssignmentScheduleRequestsClient.Validate")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	if err := validation.Validate([]validation.Validation{
		{TargetValue: parameters,
			Constraints: []validation.Constraint{{Target: "parameters.RoleAssignmentScheduleRequestProperties", Name: validation.Null, Rule: false,
				Chain: []validation.Constraint{{Target: "parameters.RoleAssignmentScheduleRequestProperties.RoleDefinitionID", Name: validation.Null, Rule: true, Chain: nil},
					{Target: "parameters.RoleAssignmentScheduleRequestProperties.PrincipalID", Name: validation.Null, Rule: true, Chain: nil},
				}}}}}); err != nil {
		return result, validation.NewError("authorization.RoleAssignmentScheduleRequestsClient", "Validate", err.Error())
	}

	req, err := client.ValidatePreparer(ctx, scope, roleAssignmentScheduleRequestName, parameters)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentScheduleRequestsClient", "Validate", nil, "Failure preparing request")
		return
	}

	resp, err := client.ValidateSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentScheduleRequestsClient", "Validate", resp, "Failure sending request")
		return
	}

	result, err = client.ValidateResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleAssignmentScheduleRequestsClient", "Validate", resp, "Failure responding to request")
		return
	}

	return
}

// ValidatePreparer prepares the Validate request.
func (client RoleAssignmentScheduleRequestsClient) ValidatePreparer(ctx context.Context, scope string, roleAssignmentScheduleRequestName string, parameters RoleAssignmentScheduleRequest) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"roleAssignmentScheduleRequestName": autorest.Encode("path", roleAssignmentScheduleRequestName),
		"scope":                             scope,
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	parameters.ID = nil
	parameters.Name = nil
	parameters.Type = nil
	preparer := autorest.CreatePreparer(
		autorest.AsContentType("application/json; charset=utf-8"),
		autorest.AsPost(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Authorization/roleAssignmentScheduleRequests/{roleAssignmentScheduleRequestName}/validate", pathParameters),
		autorest.WithJSON(parameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ValidateSender sends the Validate request. The method will close the
// http.Response Body if it receives an error.
func (client RoleAssignmentScheduleRequestsClient) ValidateSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ValidateResponder handles the response to the Validate request. The method always
// closes the http.Response Body.
func (client RoleAssignmentScheduleRequestsClient) ValidateResponder(resp *http.Response) (result RoleAssignmentScheduleRequest, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}
