package authorization

// Copyright (c) Microsoft Corporation. All rights reserved.
// Licensed under the MIT License. See License.txt in the project root for license information.
//
// Code generated by Microsoft (R) AutoRest Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"context"
	"github.com/Azure/go-autorest/autorest"
	"github.com/Azure/go-autorest/autorest/azure"
	"github.com/Azure/go-autorest/tracing"
	"net/http"
)

// RoleEligibilityScheduleInstancesClient is the client for the RoleEligibilityScheduleInstances methods of the
// Authorization service.
type RoleEligibilityScheduleInstancesClient struct {
	BaseClient
}

// NewRoleEligibilityScheduleInstancesClient creates an instance of the RoleEligibilityScheduleInstancesClient client.
func NewRoleEligibilityScheduleInstancesClient(subscriptionID string) RoleEligibilityScheduleInstancesClient {
	return NewRoleEligibilityScheduleInstancesClientWithBaseURI(DefaultBaseURI, subscriptionID)
}

// NewRoleEligibilityScheduleInstancesClientWithBaseURI creates an instance of the
// RoleEligibilityScheduleInstancesClient client using a custom endpoint.  Use this when interacting with an Azure
// cloud that uses a non-standard base URI (sovereign clouds, Azure stack).
func NewRoleEligibilityScheduleInstancesClientWithBaseURI(baseURI string, subscriptionID string) RoleEligibilityScheduleInstancesClient {
	return RoleEligibilityScheduleInstancesClient{NewWithBaseURI(baseURI, subscriptionID)}
}

// Get gets the specified role eligibility schedule instance.
// Parameters:
// scope - the scope of the role eligibility schedules.
// roleEligibilityScheduleInstanceName - the name (hash of schedule name + time) of the role eligibility
// schedule to get.
func (client RoleEligibilityScheduleInstancesClient) Get(ctx context.Context, scope string, roleEligibilityScheduleInstanceName string) (result RoleEligibilityScheduleInstance, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleEligibilityScheduleInstancesClient.Get")
		defer func() {
			sc := -1
			if result.Response.Response != nil {
				sc = result.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	req, err := client.GetPreparer(ctx, scope, roleEligibilityScheduleInstanceName)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilityScheduleInstancesClient", "Get", nil, "Failure preparing request")
		return
	}

	resp, err := client.GetSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilityScheduleInstancesClient", "Get", resp, "Failure sending request")
		return
	}

	result, err = client.GetResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilityScheduleInstancesClient", "Get", resp, "Failure responding to request")
		return
	}

	return
}

// GetPreparer prepares the Get request.
func (client RoleEligibilityScheduleInstancesClient) GetPreparer(ctx context.Context, scope string, roleEligibilityScheduleInstanceName string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"roleEligibilityScheduleInstanceName": autorest.Encode("path", roleEligibilityScheduleInstanceName),
		"scope":                               scope,
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Authorization/roleEligibilityScheduleInstances/{roleEligibilityScheduleInstanceName}", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// GetSender sends the Get request. The method will close the
// http.Response Body if it receives an error.
func (client RoleEligibilityScheduleInstancesClient) GetSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// GetResponder handles the response to the Get request. The method always
// closes the http.Response Body.
func (client RoleEligibilityScheduleInstancesClient) GetResponder(resp *http.Response) (result RoleEligibilityScheduleInstance, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// ListForScope gets role eligibility schedule instances of a role eligibility schedule.
// Parameters:
// scope - the scope of the role eligibility schedule.
// filter - the filter to apply on the operation. Use $filter=atScope() to return all role assignment schedules
// at or above the scope. Use $filter=principalId eq {id} to return all role assignment schedules at, above or
// below the scope for the specified principal. Use $filter=assignedTo('{userId}') to return all role
// eligibility schedules for the user. Use $filter=asTarget() to return all role eligibility schedules created
// for the current user.
func (client RoleEligibilityScheduleInstancesClient) ListForScope(ctx context.Context, scope string, filter string) (result RoleEligibilityScheduleInstanceListResultPage, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleEligibilityScheduleInstancesClient.ListForScope")
		defer func() {
			sc := -1
			if result.resilr.Response.Response != nil {
				sc = result.resilr.Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.fn = client.listForScopeNextResults
	req, err := client.ListForScopePreparer(ctx, scope, filter)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilityScheduleInstancesClient", "ListForScope", nil, "Failure preparing request")
		return
	}

	resp, err := client.ListForScopeSender(req)
	if err != nil {
		result.resilr.Response = autorest.Response{Response: resp}
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilityScheduleInstancesClient", "ListForScope", resp, "Failure sending request")
		return
	}

	result.resilr, err = client.ListForScopeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilityScheduleInstancesClient", "ListForScope", resp, "Failure responding to request")
		return
	}
	if result.resilr.hasNextLink() && result.resilr.IsEmpty() {
		err = result.NextWithContext(ctx)
		return
	}

	return
}

// ListForScopePreparer prepares the ListForScope request.
func (client RoleEligibilityScheduleInstancesClient) ListForScopePreparer(ctx context.Context, scope string, filter string) (*http.Request, error) {
	pathParameters := map[string]interface{}{
		"scope": scope,
	}

	const APIVersion = "2020-10-01"
	queryParameters := map[string]interface{}{
		"api-version": APIVersion,
	}
	if len(filter) > 0 {
		queryParameters["$filter"] = autorest.Encode("query", filter)
	}

	preparer := autorest.CreatePreparer(
		autorest.AsGet(),
		autorest.WithBaseURL(client.BaseURI),
		autorest.WithPathParameters("/{scope}/providers/Microsoft.Authorization/roleEligibilityScheduleInstances", pathParameters),
		autorest.WithQueryParameters(queryParameters))
	return preparer.Prepare((&http.Request{}).WithContext(ctx))
}

// ListForScopeSender sends the ListForScope request. The method will close the
// http.Response Body if it receives an error.
func (client RoleEligibilityScheduleInstancesClient) ListForScopeSender(req *http.Request) (*http.Response, error) {
	return client.Send(req, autorest.DoRetryForStatusCodes(client.RetryAttempts, client.RetryDuration, autorest.StatusCodesForRetry...))
}

// ListForScopeResponder handles the response to the ListForScope request. The method always
// closes the http.Response Body.
func (client RoleEligibilityScheduleInstancesClient) ListForScopeResponder(resp *http.Response) (result RoleEligibilityScheduleInstanceListResult, err error) {
	err = autorest.Respond(
		resp,
		azure.WithErrorUnlessStatusCode(http.StatusOK),
		autorest.ByUnmarshallingJSON(&result),
		autorest.ByClosing())
	result.Response = autorest.Response{Response: resp}
	return
}

// listForScopeNextResults retrieves the next set of results, if any.
func (client RoleEligibilityScheduleInstancesClient) listForScopeNextResults(ctx context.Context, lastResults RoleEligibilityScheduleInstanceListResult) (result RoleEligibilityScheduleInstanceListResult, err error) {
	req, err := lastResults.roleEligibilityScheduleInstanceListResultPreparer(ctx)
	if err != nil {
		return result, autorest.NewErrorWithError(err, "authorization.RoleEligibilityScheduleInstancesClient", "listForScopeNextResults", nil, "Failure preparing next results request")
	}
	if req == nil {
		return
	}
	resp, err := client.ListForScopeSender(req)
	if err != nil {
		result.Response = autorest.Response{Response: resp}
		return result, autorest.NewErrorWithError(err, "authorization.RoleEligibilityScheduleInstancesClient", "listForScopeNextResults", resp, "Failure sending next results request")
	}
	result, err = client.ListForScopeResponder(resp)
	if err != nil {
		err = autorest.NewErrorWithError(err, "authorization.RoleEligibilityScheduleInstancesClient", "listForScopeNextResults", resp, "Failure responding to next results request")
	}
	return
}

// ListForScopeComplete enumerates all values, automatically crossing page boundaries as required.
func (client RoleEligibilityScheduleInstancesClient) ListForScopeComplete(ctx context.Context, scope string, filter string) (result RoleEligibilityScheduleInstanceListResultIterator, err error) {
	if tracing.IsEnabled() {
		ctx = tracing.StartSpan(ctx, fqdn+"/RoleEligibilityScheduleInstancesClient.ListForScope")
		defer func() {
			sc := -1
			if result.Response().Response.Response != nil {
				sc = result.page.Response().Response.Response.StatusCode
			}
			tracing.EndSpan(ctx, sc, err)
		}()
	}
	result.page, err = client.ListForScope(ctx, scope, filter)
	return
}
