#!/bin/bash -e

self=$(basename $0)
output=$1

# Based on an archived copy of src/cmd/asm/internal/arch/arch.go.
arch="../data/arch.go.txt"

{

    echo "// Code generated by ${self}. DO NOT EDIT."
    echo
    echo 'package load'
    echo
    echo 'var annoyingaliases = []alias{'

    awk '
        /archX86/ { x86=1 }
        /^}/ { x86=0 }

        x86 && /x86/ && /instructions\[/ {
            from=$1
            to=$3

            sub(/instructions\[\"/, "", from)
            sub(/\"\]/, "", from)
            sub(/x86\.A/, "", to)

            if(from != to) {
                printf("\t{\"%s\", \"%s\"},\n", from, to)
            }
        }
    ' ${arch}

    echo '}'

} | gofmt > ${output}
