#ifdef WIN32

#include <time.h>
#include <windows.h>

#ifndef TIMEHELPER_H
#define TIMEHELPER_H

#if defined(_MSC_VER) || defined(_MSC_EXTENSIONS)
  #define DELTA_EPOCH_IN_MICROSECS  11644473600000000Ui64
#else
  #define DELTA_EPOCH_IN_MICROSECS  11644473600000000ULL
#endif


#ifndef timersub
# define timersub(a, b, result)						      \
  do {									      \
	(result)->tv_sec = (a)->tv_sec - (b)->tv_sec;			      \
	(result)->tv_usec = (a)->tv_usec - (b)->tv_usec;			      \
	if ((result)->tv_usec < 0) {					      \
	  --(result)->tv_sec;						      \
	  (result)->tv_usec += 1000000;					      \
   }									      \
  } while (0)
#endif



struct timezone
{
  int  tz_minuteswest; /* minutes W of Greenwich */
  int  tz_dsttime;     /* type of dst correction */
};

int gettimeofday(struct timeval *tv, struct timezone *tz);
#endif

#endif
