(** Disallows whitespace around the edges in [of_string] and [t_of_sexp], but doesn't
    check when reading from bin_io. *)

open Std_internal

module type S = sig
  include Identifiable with type t = private string

  module Stable : sig
    module V1 : sig
      type nonrec t = t with sexp, bin_io, compare

      include Stable_containers.Comparable.V1.S
        with type key := t
        with type comparator_witness := comparator_witness
    end
  end
end

include S

(** [Make] customizes the error messages generated by [of_string]/[of_sexp] to include
    [module_name].  It also registers a pretty printer. *)
module Make (M : sig val module_name : string end) () : S

(** This does what [Make] does without registering a pretty printer.  Use this when the
    module that is made is not exposed in mli.  Registering a pretty printer without
    exposing it causes an error in utop. *)
module Make_without_pretty_printer (M : sig val module_name : string end) () : S
