/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.test.spring.ejb;

import javax.ejb.Remote;
import javax.ejb.Stateless;
import javax.interceptor.Interceptors;
import org.jboss.annotation.spring.Spring;
import org.jboss.spring.callback.SpringLifecycleInterceptor;
import org.jboss.test.spring.beans.Calculator;
import org.jboss.test.spring.beans.LogManager;
import org.jboss.test.spring.ejb.SpringBeansManager;

@Stateless
@Remote(value={SpringBeansManager.class})
@Interceptors(value={SpringLifecycleInterceptor.class})
public class SpringBeansManagerImpl
implements SpringBeansManager {
    @Spring(jndiName="ejb")
    private Calculator calculator;
    @Spring(jndiName="ejb", bean="logManager")
    private LogManager logManager;

    public int add(int a, int b) {
        if (this.calculator == null) {
            throw new IllegalArgumentException("Null calculator.");
        }
        return this.calculator.add(a, b);
    }

    public int multipy(int a, int b) {
        if (this.calculator == null) {
            throw new IllegalArgumentException("Null calculator.");
        }
        return this.calculator.multiply(a, b);
    }

    public void log(String msg) {
        if (this.logManager == null) {
            throw new IllegalArgumentException("Null log manager.");
        }
        this.logManager.log(msg);
    }
}

