/*
    This file is part of KolabAdmin.

    Copyright (C) 2006 Tobias Koenig <tobias.koenig@credativ.de>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
*/

#ifndef FORM_CONTAINER_H
#define FORM_CONTAINER_H

#include <QtGui/QGridLayout>
#include <QtGui/QScrollArea>

#include "description.h"
#include "entry.h"
#include "pagepolicy.h"

namespace Form
{

class Container : public QScrollArea
{
  public:
    Container( const QString &name, QWidget *parent );
    ~Container();

    QString name() const;
    QGridLayout* containerLayout() const;

    virtual void build( const Description *description, const PagePolicy *policy, PagePolicy::State state );

    virtual void loadEntry( const Entry &entry );
    virtual void saveEntry( Entry &entry ) const;

    virtual bool isValid( QString &message, PagePolicy::State state ) const;

    virtual void setEditable( bool editable );

  private:
    class Private;
    Private *d;
};

}

#endif
