/* document_view.c generated by valac 0.28.0.1-2361a, the Vala compiler
 * generated from document_view.vala, do not modify */

/*
 * This file is part of LaTeXila.
 *
 * Copyright © 2010-2011 Sébastien Wilmet
 *
 * LaTeXila is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * LaTeXila is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with LaTeXila.  If not, see <http://www.gnu.org/licenses/>.
 */

#include <glib.h>
#include <glib-object.h>
#include <gtksourceview/gtksource.h>
#include <gio/gio.h>
#include <pango/pango.h>
#include <gtkspell/gtkspell.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <stdlib.h>
#include <string.h>
#include <gdk/gdk.h>
#include <glib/gi18n-lib.h>
#include <latexila.h>


#define TYPE_DOCUMENT_VIEW (document_view_get_type ())
#define DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT_VIEW, DocumentView))
#define DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT_VIEW, DocumentViewClass))
#define IS_DOCUMENT_VIEW(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT_VIEW))
#define IS_DOCUMENT_VIEW_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT_VIEW))
#define DOCUMENT_VIEW_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT_VIEW, DocumentViewClass))

typedef struct _DocumentView DocumentView;
typedef struct _DocumentViewClass DocumentViewClass;
typedef struct _DocumentViewPrivate DocumentViewPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define __vala_PangoFontDescription_free0(var) ((var == NULL) ? NULL : (var = (_vala_PangoFontDescription_free (var), NULL)))

#define TYPE_DOCUMENT (document_get_type ())
#define DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_DOCUMENT, Document))
#define DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_DOCUMENT, DocumentClass))
#define IS_DOCUMENT(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_DOCUMENT))
#define IS_DOCUMENT_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_DOCUMENT))
#define DOCUMENT_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_DOCUMENT, DocumentClass))

typedef struct _Document Document;
typedef struct _DocumentClass DocumentClass;
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_COMPLETION_PROVIDER (completion_provider_get_type ())
#define COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_COMPLETION_PROVIDER, CompletionProvider))
#define COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))
#define IS_COMPLETION_PROVIDER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_COMPLETION_PROVIDER))
#define IS_COMPLETION_PROVIDER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_COMPLETION_PROVIDER))
#define COMPLETION_PROVIDER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_COMPLETION_PROVIDER, CompletionProviderClass))

typedef struct _CompletionProvider CompletionProvider;
typedef struct _CompletionProviderClass CompletionProviderClass;
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

#define TYPE_APP_SETTINGS (app_settings_get_type ())
#define APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SETTINGS, AppSettings))
#define APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SETTINGS, AppSettingsClass))
#define IS_APP_SETTINGS(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SETTINGS))
#define IS_APP_SETTINGS_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SETTINGS))
#define APP_SETTINGS_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SETTINGS, AppSettingsClass))

typedef struct _AppSettings AppSettings;
typedef struct _AppSettingsClass AppSettingsClass;
#define __g_list_free__g_free0_0(var) ((var == NULL) ? NULL : (var = (_g_list_free__g_free0_ (var), NULL)))

struct _DocumentView {
	GtkSourceView parent_instance;
	DocumentViewPrivate * priv;
};

struct _DocumentViewClass {
	GtkSourceViewClass parent_class;
};

struct _DocumentViewPrivate {
	GSettings* _editor_settings;
	PangoFontDescription* _font_desc;
	GtkSpellChecker* _spell_checker;
};


static gpointer document_view_parent_class = NULL;

GType document_view_get_type (void) G_GNUC_CONST;
#define DOCUMENT_VIEW_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_DOCUMENT_VIEW, DocumentViewPrivate))
enum  {
	DOCUMENT_VIEW_DUMMY_PROPERTY
};
static void _vala_PangoFontDescription_free (PangoFontDescription* self);
#define DOCUMENT_VIEW_SCROLL_MARGIN 0.02
GType document_get_type (void) G_GNUC_CONST;
DocumentView* document_view_new (Document* doc);
DocumentView* document_view_construct (GType object_type, Document* doc);
static void __lambda82_ (DocumentView* self, GObject* d, GParamSpec* p);
gboolean document_get_readonly (Document* self);
static void ___lambda82__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
void document_view_set_font_from_settings (DocumentView* self);
void document_set_style_scheme_from_string (Document* self, const gchar* scheme_id);
GType completion_provider_get_type (void) G_GNUC_CONST;
CompletionProvider* completion_provider_get_default (void);
static void document_view_hide_completion_calltip_when_needed (DocumentView* self);
static gboolean document_view_on_backspace (DocumentView* self, GdkEventKey* event);
static gboolean _document_view_on_backspace_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self);
void document_view_activate_spell_checking (DocumentView* self);
static gboolean document_view_on_button_release_event (DocumentView* self, GdkEventButton* event);
static gboolean _document_view_on_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
void document_view_scroll_to_cursor (DocumentView* self, gdouble margin);
void document_view_cut_selection (DocumentView* self);
void document_view_copy_selection (DocumentView* self);
void document_view_my_paste_clipboard (DocumentView* self);
void document_view_delete_selection (DocumentView* self);
void document_view_my_select_all (DocumentView* self);
GType app_settings_get_type (void) G_GNUC_CONST;
AppSettings* app_settings_get_default (void);
const gchar* app_settings_get_system_font (AppSettings* self);
void document_view_set_font_from_string (DocumentView* self, const gchar* font);
void document_view_enlarge_font (DocumentView* self);
void document_view_shrink_font (DocumentView* self);
gchar* document_view_get_indentation_style (DocumentView* self);
static void document_view_attach_spell_checker (DocumentView* self);
static void _g_free0_ (gpointer var);
static void _g_list_free__g_free0_ (GList* self);
void document_view_disable_spell_checking (DocumentView* self);
GFile* document_get_location (Document* self);
GFile* document_get_main_file (Document* self);
static void __lambda83_ (DocumentView* self);
void completion_provider_hide_calltip_window (CompletionProvider* self);
static void ___lambda83__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void document_view_finalize (GObject* obj);


static void _vala_PangoFontDescription_free (PangoFontDescription* self) {
	g_boxed_free (pango_font_description_get_type (), self);
}


static void __lambda82_ (DocumentView* self, GObject* d, GParamSpec* p) {
	GObject* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (d != NULL);
	g_return_if_fail (p != NULL);
	_tmp0_ = d;
	_tmp1_ = document_get_readonly (G_TYPE_CHECK_INSTANCE_CAST (_tmp0_, TYPE_DOCUMENT, Document));
	_tmp2_ = _tmp1_;
	gtk_text_view_set_editable ((GtkTextView*) self, !_tmp2_);
}


static void ___lambda82__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda82_ ((DocumentView*) self, _sender, pspec);
}


static gboolean _document_view_on_backspace_gtk_widget_key_press_event (GtkWidget* _sender, GdkEventKey* event, gpointer self) {
	gboolean result;
	result = document_view_on_backspace ((DocumentView*) self, event);
	return result;
}


static gboolean _document_view_on_button_release_event_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = document_view_on_button_release_event ((DocumentView*) self, event);
	return result;
}


DocumentView* document_view_construct (GType object_type, Document* doc) {
	DocumentView * self = NULL;
	Document* _tmp0_ = NULL;
	Document* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	guint tmp = 0U;
	GSettings* _tmp3_ = NULL;
	GSettings* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GSettings* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GSettings* _tmp8_ = NULL;
	gboolean _tmp9_ = FALSE;
	Document* _tmp10_ = NULL;
	GSettings* _tmp11_ = NULL;
	gboolean _tmp12_ = FALSE;
	Document* _tmp13_ = NULL;
	GSettings* _tmp14_ = NULL;
	gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	GSettings* _tmp30_ = NULL;
	gboolean _tmp31_ = FALSE;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (doc != NULL, NULL);
	self = (DocumentView*) g_object_new (object_type, NULL);
	_tmp0_ = doc;
	gtk_text_view_set_buffer ((GtkTextView*) self, (GtkTextBuffer*) _tmp0_);
	_tmp1_ = doc;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::readonly", (GCallback) ___lambda82__g_object_notify, self, 0);
	gtk_text_view_set_wrap_mode ((GtkTextView*) self, GTK_WRAP_WORD);
	gtk_source_view_set_auto_indent ((GtkSourceView*) self, TRUE);
	gtk_source_view_set_indent_width ((GtkSourceView*) self, -1);
	_tmp2_ = g_settings_new ("org.gnome.latexila.preferences.editor");
	_g_object_unref0 (self->priv->_editor_settings);
	self->priv->_editor_settings = _tmp2_;
	document_view_set_font_from_settings (self);
	_tmp3_ = self->priv->_editor_settings;
	g_settings_get (_tmp3_, "tabs-size", "u", &tmp);
	gtk_source_view_set_tab_width ((GtkSourceView*) self, tmp);
	_tmp4_ = self->priv->_editor_settings;
	_tmp5_ = g_settings_get_boolean (_tmp4_, "insert-spaces");
	gtk_source_view_set_insert_spaces_instead_of_tabs ((GtkSourceView*) self, _tmp5_);
	_tmp6_ = self->priv->_editor_settings;
	_tmp7_ = g_settings_get_boolean (_tmp6_, "display-line-numbers");
	gtk_source_view_set_show_line_numbers ((GtkSourceView*) self, _tmp7_);
	_tmp8_ = self->priv->_editor_settings;
	_tmp9_ = g_settings_get_boolean (_tmp8_, "highlight-current-line");
	gtk_source_view_set_highlight_current_line ((GtkSourceView*) self, _tmp9_);
	_tmp10_ = doc;
	_tmp11_ = self->priv->_editor_settings;
	_tmp12_ = g_settings_get_boolean (_tmp11_, "bracket-matching");
	gtk_source_buffer_set_highlight_matching_brackets ((GtkSourceBuffer*) _tmp10_, _tmp12_);
	_tmp13_ = doc;
	_tmp14_ = self->priv->_editor_settings;
	_tmp15_ = g_settings_get_string (_tmp14_, "scheme");
	_tmp16_ = _tmp15_;
	document_set_style_scheme_from_string (_tmp13_, _tmp16_);
	_g_free0 (_tmp16_);
	gtk_source_view_set_smart_home_end ((GtkSourceView*) self, GTK_SOURCE_SMART_HOME_END_AFTER);
	{
		CompletionProvider* provider = NULL;
		CompletionProvider* _tmp17_ = NULL;
		GtkSourceCompletion* _tmp18_ = NULL;
		GtkSourceCompletion* _tmp19_ = NULL;
		GtkSourceCompletion* _tmp20_ = NULL;
		GtkSourceCompletion* _tmp21_ = NULL;
		GtkSourceCompletion* _tmp22_ = NULL;
		GtkSourceCompletion* _tmp23_ = NULL;
		GtkSourceCompletion* _tmp24_ = NULL;
		GtkSourceCompletion* _tmp25_ = NULL;
		GtkSourceCompletion* _tmp26_ = NULL;
		GtkSourceCompletion* _tmp27_ = NULL;
		_tmp17_ = completion_provider_get_default ();
		provider = _tmp17_;
		_tmp18_ = gtk_source_view_get_completion ((GtkSourceView*) self);
		_tmp19_ = _tmp18_;
		gtk_source_completion_add_provider (_tmp19_, (GtkSourceCompletionProvider*) provider, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (provider);
			goto __catch14_g_error;
		}
		_tmp20_ = gtk_source_view_get_completion ((GtkSourceView*) self);
		_tmp21_ = _tmp20_;
		g_object_set (_tmp21_, "remember-info-visibility", TRUE, NULL);
		_tmp22_ = gtk_source_view_get_completion ((GtkSourceView*) self);
		_tmp23_ = _tmp22_;
		g_object_set (_tmp23_, "show-headers", FALSE, NULL);
		_tmp24_ = gtk_source_view_get_completion ((GtkSourceView*) self);
		_tmp25_ = _tmp24_;
		g_object_set (_tmp25_, "auto-complete-delay", (guint) 0, NULL);
		_tmp26_ = gtk_source_view_get_completion ((GtkSourceView*) self);
		_tmp27_ = _tmp26_;
		g_object_set (_tmp27_, "accelerators", (guint) 0, NULL);
		document_view_hide_completion_calltip_when_needed (self);
		_g_object_unref0 (provider);
	}
	goto __finally14;
	__catch14_g_error:
	{
		GError* e = NULL;
		GError* _tmp28_ = NULL;
		const gchar* _tmp29_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp28_ = e;
		_tmp29_ = _tmp28_->message;
		g_warning ("document_view.vala:75: Completion: %s", _tmp29_);
		_g_error_free0 (e);
	}
	__finally14:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return NULL;
	}
	g_signal_connect_object ((GtkWidget*) self, "key-press-event", (GCallback) _document_view_on_backspace_gtk_widget_key_press_event, self, 0);
	_tmp30_ = self->priv->_editor_settings;
	_tmp31_ = g_settings_get_boolean (_tmp30_, "spell-checking");
	if (_tmp31_) {
		document_view_activate_spell_checking (self);
	}
	g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) _document_view_on_button_release_event_gtk_widget_button_release_event, self, 0);
	return self;
}


DocumentView* document_view_new (Document* doc) {
	return document_view_construct (TYPE_DOCUMENT_VIEW, doc);
}


void document_view_scroll_to_cursor (DocumentView* self, gdouble margin) {
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextMark* _tmp2_ = NULL;
	gdouble _tmp3_ = 0.0;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	_tmp2_ = gtk_text_buffer_get_insert (_tmp1_);
	_tmp3_ = margin;
	gtk_text_view_scroll_to_mark ((GtkTextView*) self, _tmp2_, _tmp3_, FALSE, (gdouble) 0, (gdouble) 0);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


void document_view_cut_selection (DocumentView* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkClipboard* clipboard = NULL;
	GtkClipboard* _tmp2_ = NULL;
	GtkClipboard* _tmp3_ = NULL;
	GtkTextBuffer* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	GtkTextBuffer* _tmp6_ = NULL;
	GtkTextBuffer* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = gtk_widget_get_clipboard ((GtkWidget*) self, GDK_SELECTION_CLIPBOARD);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	clipboard = _tmp3_;
	_tmp4_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = document_get_readonly (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DOCUMENT, Document));
	_tmp9_ = _tmp8_;
	gtk_text_buffer_cut_clipboard (_tmp5_, clipboard, !_tmp9_);
	document_view_scroll_to_cursor (self, DOCUMENT_VIEW_SCROLL_MARGIN);
	gtk_widget_grab_focus ((GtkWidget*) self);
	_g_object_unref0 (clipboard);
}


void document_view_copy_selection (DocumentView* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkClipboard* clipboard = NULL;
	GtkClipboard* _tmp2_ = NULL;
	GtkClipboard* _tmp3_ = NULL;
	GtkTextBuffer* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = gtk_widget_get_clipboard ((GtkWidget*) self, GDK_SELECTION_CLIPBOARD);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	clipboard = _tmp3_;
	_tmp4_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp5_ = _tmp4_;
	gtk_text_buffer_copy_clipboard (_tmp5_, clipboard);
	gtk_widget_grab_focus ((GtkWidget*) self);
	_g_object_unref0 (clipboard);
}


void document_view_my_paste_clipboard (DocumentView* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkClipboard* clipboard = NULL;
	GtkClipboard* _tmp2_ = NULL;
	GtkClipboard* _tmp3_ = NULL;
	GtkTextBuffer* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	GtkTextBuffer* _tmp6_ = NULL;
	GtkTextBuffer* _tmp7_ = NULL;
	gboolean _tmp8_ = FALSE;
	gboolean _tmp9_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = gtk_widget_get_clipboard ((GtkWidget*) self, GDK_SELECTION_CLIPBOARD);
	_tmp3_ = _g_object_ref0 (_tmp2_);
	clipboard = _tmp3_;
	_tmp4_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = document_get_readonly (G_TYPE_CHECK_INSTANCE_CAST (_tmp7_, TYPE_DOCUMENT, Document));
	_tmp9_ = _tmp8_;
	gtk_text_buffer_paste_clipboard (_tmp5_, clipboard, NULL, !_tmp9_);
	document_view_scroll_to_cursor (self, DOCUMENT_VIEW_SCROLL_MARGIN);
	gtk_widget_grab_focus ((GtkWidget*) self);
	_g_object_unref0 (clipboard);
}


void document_view_delete_selection (DocumentView* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextBuffer* _tmp2_ = NULL;
	GtkTextBuffer* _tmp3_ = NULL;
	GtkTextBuffer* _tmp4_ = NULL;
	GtkTextBuffer* _tmp5_ = NULL;
	gboolean _tmp6_ = FALSE;
	gboolean _tmp7_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp3_ = _tmp2_;
	_tmp4_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp5_ = _tmp4_;
	_tmp6_ = document_get_readonly (G_TYPE_CHECK_INSTANCE_CAST (_tmp5_, TYPE_DOCUMENT, Document));
	_tmp7_ = _tmp6_;
	gtk_text_buffer_delete_selection (_tmp3_, TRUE, !_tmp7_);
	document_view_scroll_to_cursor (self, DOCUMENT_VIEW_SCROLL_MARGIN);
}


void document_view_my_select_all (DocumentView* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	GtkTextIter start = {0};
	GtkTextIter end = {0};
	GtkTextBuffer* _tmp2_ = NULL;
	GtkTextBuffer* _tmp3_ = NULL;
	GtkTextIter _tmp4_ = {0};
	GtkTextIter _tmp5_ = {0};
	GtkTextBuffer* _tmp6_ = NULL;
	GtkTextBuffer* _tmp7_ = NULL;
	GtkTextIter _tmp8_ = {0};
	GtkTextIter _tmp9_ = {0};
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_return_if_fail (_tmp1_ != NULL);
	_tmp2_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp3_ = _tmp2_;
	gtk_text_buffer_get_bounds (_tmp3_, &_tmp4_, &_tmp5_);
	start = _tmp4_;
	end = _tmp5_;
	_tmp6_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp7_ = _tmp6_;
	_tmp8_ = start;
	_tmp9_ = end;
	gtk_text_buffer_select_range (_tmp7_, &_tmp8_, &_tmp9_);
}


void document_view_set_font_from_settings (DocumentView* self) {
	gchar* font = NULL;
	GSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	const gchar* _tmp9_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_editor_settings;
	_tmp1_ = g_settings_get_boolean (_tmp0_, "use-default-font");
	if (_tmp1_) {
		AppSettings* _tmp2_ = NULL;
		AppSettings* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		const gchar* _tmp5_ = NULL;
		gchar* _tmp6_ = NULL;
		_tmp2_ = app_settings_get_default ();
		_tmp3_ = _tmp2_;
		_tmp4_ = app_settings_get_system_font (_tmp3_);
		_tmp5_ = _tmp4_;
		_tmp6_ = g_strdup (_tmp5_);
		_g_free0 (font);
		font = _tmp6_;
		_g_object_unref0 (_tmp3_);
	} else {
		GSettings* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp7_ = self->priv->_editor_settings;
		_tmp8_ = g_settings_get_string (_tmp7_, "editor-font");
		_g_free0 (font);
		font = _tmp8_;
	}
	_tmp9_ = font;
	document_view_set_font_from_string (self, _tmp9_);
	_g_free0 (font);
}


void document_view_set_font_from_string (DocumentView* self, const gchar* font) {
	const gchar* _tmp0_ = NULL;
	PangoFontDescription* _tmp1_ = NULL;
	PangoFontDescription* _tmp2_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (font != NULL);
	_tmp0_ = font;
	_tmp1_ = pango_font_description_from_string (_tmp0_);
	__vala_PangoFontDescription_free0 (self->priv->_font_desc);
	self->priv->_font_desc = _tmp1_;
	_tmp2_ = self->priv->_font_desc;
	gtk_widget_override_font ((GtkWidget*) self, _tmp2_);
}


void document_view_enlarge_font (DocumentView* self) {
	PangoFontDescription* _tmp0_ = NULL;
	PangoFontDescription* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	PangoFontDescription* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_font_desc;
	_tmp1_ = self->priv->_font_desc;
	_tmp2_ = pango_font_description_get_size (_tmp1_);
	pango_font_description_set_size (_tmp0_, _tmp2_ + PANGO_SCALE);
	_tmp3_ = self->priv->_font_desc;
	gtk_widget_override_font ((GtkWidget*) self, _tmp3_);
}


void document_view_shrink_font (DocumentView* self) {
	PangoFontDescription* _tmp0_ = NULL;
	PangoFontDescription* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	PangoFontDescription* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_font_desc;
	_tmp1_ = self->priv->_font_desc;
	_tmp2_ = pango_font_description_get_size (_tmp1_);
	pango_font_description_set_size (_tmp0_, _tmp2_ - PANGO_SCALE);
	_tmp3_ = self->priv->_font_desc;
	gtk_widget_override_font ((GtkWidget*) self, _tmp3_);
}


gchar* document_view_get_indentation_style (DocumentView* self) {
	gchar* result = NULL;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gchar* _tmp5_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = gtk_source_view_get_insert_spaces_instead_of_tabs ((GtkSourceView*) self);
	_tmp1_ = _tmp0_;
	if (_tmp1_) {
		guint _tmp2_ = 0U;
		guint _tmp3_ = 0U;
		gchar* _tmp4_ = NULL;
		_tmp2_ = gtk_source_view_get_tab_width ((GtkSourceView*) self);
		_tmp3_ = _tmp2_;
		_tmp4_ = g_strnfill ((gsize) _tmp3_, ' ');
		result = _tmp4_;
		return result;
	}
	_tmp5_ = g_strdup ("\t");
	result = _tmp5_;
	return result;
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _g_list_free__g_free0_ (GList* self) {
	g_list_foreach (self, (GFunc) _g_free0_, NULL);
	g_list_free (self);
}


void document_view_activate_spell_checking (DocumentView* self) {
	GtkSpellChecker* _tmp0_ = NULL;
	GtkSpellChecker* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_spell_checker;
	if (_tmp0_ == NULL) {
		GtkSpellChecker* _tmp1_ = NULL;
		GtkSpellChecker* _tmp2_ = NULL;
		_tmp1_ = gtk_spell_checker_new ();
		g_object_ref_sink (_tmp1_);
		_g_object_unref0 (self->priv->_spell_checker);
		self->priv->_spell_checker = _tmp1_;
		_tmp2_ = self->priv->_spell_checker;
		g_object_set (_tmp2_, "decode-language-codes", TRUE, NULL);
	}
	_tmp3_ = self->priv->_spell_checker;
	_tmp4_ = gtk_spell_checker_get_language (_tmp3_);
	if (_tmp4_ != NULL) {
		document_view_attach_spell_checker (self);
		return;
	}
	{
		GtkSpellChecker* _tmp5_ = NULL;
		_tmp5_ = self->priv->_spell_checker;
		gtk_spell_checker_set_language (_tmp5_, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch15_g_error;
		}
		document_view_attach_spell_checker (self);
	}
	goto __finally15;
	__catch15_g_error:
	{
		GError* e = NULL;
		GList* language_list = NULL;
		GList* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		GList* _tmp8_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = gtk_spell_checker_get_language_list ();
		language_list = _tmp6_;
		_tmp8_ = language_list;
		if (_tmp8_ == NULL) {
			_tmp7_ = TRUE;
		} else {
			GList* _tmp9_ = NULL;
			gconstpointer _tmp10_ = NULL;
			_tmp9_ = language_list;
			_tmp10_ = _tmp9_->data;
			_tmp7_ = ((const gchar*) _tmp10_) == NULL;
		}
		if (_tmp7_) {
			GtkMessageDialog* dialog = NULL;
			GtkWidget* _tmp11_ = NULL;
			const gchar* _tmp12_ = NULL;
			GtkMessageDialog* _tmp13_ = NULL;
			GtkMessageDialog* _tmp14_ = NULL;
			const gchar* _tmp15_ = NULL;
			const gchar* _tmp16_ = NULL;
			gint response = 0;
			GtkMessageDialog* _tmp17_ = NULL;
			gint _tmp18_ = 0;
			gint _tmp19_ = 0;
			GtkMessageDialog* _tmp23_ = NULL;
			GSettings* _tmp24_ = NULL;
			_tmp11_ = gtk_widget_get_toplevel ((GtkWidget*) self);
			_tmp12_ = _ ("No dictionaries available for the spell checking.");
			_tmp13_ = (GtkMessageDialog*) gtk_message_dialog_new (G_TYPE_CHECK_INSTANCE_TYPE (_tmp11_, gtk_window_get_type ()) ? ((GtkWindow*) _tmp11_) : NULL, GTK_DIALOG_DESTROY_WITH_PARENT, GTK_MESSAGE_ERROR, GTK_BUTTONS_NONE, "%s", _tmp12_);
			g_object_ref_sink (_tmp13_);
			dialog = _tmp13_;
			_tmp14_ = dialog;
			_tmp15_ = _ ("_Help");
			_tmp16_ = _ ("_OK");
			gtk_dialog_add_buttons ((GtkDialog*) _tmp14_, _tmp15_, GTK_RESPONSE_HELP, _tmp16_, GTK_RESPONSE_OK, NULL, NULL);
			_tmp17_ = dialog;
			_tmp18_ = gtk_dialog_run ((GtkDialog*) _tmp17_);
			response = _tmp18_;
			_tmp19_ = response;
			if (_tmp19_ == ((gint) GTK_RESPONSE_HELP)) {
				{
					GdkScreen* _tmp20_ = NULL;
					_tmp20_ = gtk_widget_get_screen ((GtkWidget*) self);
					gtk_show_uri (_tmp20_, "help:latexila/spell_checking", (guint32) GDK_CURRENT_TIME, &_inner_error_);
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						goto __catch16_g_error;
					}
				}
				goto __finally16;
				__catch16_g_error:
				{
					GError* e = NULL;
					GError* _tmp21_ = NULL;
					const gchar* _tmp22_ = NULL;
					e = _inner_error_;
					_inner_error_ = NULL;
					_tmp21_ = e;
					_tmp22_ = _tmp21_->message;
					g_warning ("document_view.vala:221: Impossible to open the documentation: %s", _tmp22_);
					_g_error_free0 (e);
				}
				__finally16:
				if (G_UNLIKELY (_inner_error_ != NULL)) {
					_g_object_unref0 (dialog);
					__g_list_free__g_free0_0 (language_list);
					_g_error_free0 (e);
					_g_object_unref0 (dialog);
					__g_list_free__g_free0_0 (language_list);
					_g_error_free0 (e);
					g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
					g_clear_error (&_inner_error_);
					return;
				}
			}
			_tmp23_ = dialog;
			gtk_widget_destroy ((GtkWidget*) _tmp23_);
			_tmp24_ = self->priv->_editor_settings;
			g_settings_set_boolean (_tmp24_, "spell-checking", FALSE);
			_g_object_unref0 (dialog);
			__g_list_free__g_free0_0 (language_list);
			_g_error_free0 (e);
			return;
		}
		{
			GtkSpellChecker* _tmp25_ = NULL;
			GList* _tmp26_ = NULL;
			gconstpointer _tmp27_ = NULL;
			_tmp25_ = self->priv->_spell_checker;
			_tmp26_ = language_list;
			_tmp27_ = _tmp26_->data;
			gtk_spell_checker_set_language (_tmp25_, (const gchar*) _tmp27_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch17_g_error;
			}
			document_view_attach_spell_checker (self);
		}
		goto __finally17;
		__catch17_g_error:
		{
			GError* e = NULL;
			GError* _tmp28_ = NULL;
			const gchar* _tmp29_ = NULL;
			GSettings* _tmp30_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp28_ = e;
			_tmp29_ = _tmp28_->message;
			g_warning ("document_view.vala:239: GtkSpell error: %s", _tmp29_);
			_tmp30_ = self->priv->_editor_settings;
			g_settings_set_boolean (_tmp30_, "spell-checking", FALSE);
			_g_error_free0 (e);
		}
		__finally17:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			__g_list_free__g_free0_0 (language_list);
			_g_error_free0 (e);
			__g_list_free__g_free0_0 (language_list);
			_g_error_free0 (e);
			g_critical ("file %s: line %d: unexpected error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		__g_list_free__g_free0_0 (language_list);
		_g_error_free0 (e);
	}
	__finally15:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void document_view_attach_spell_checker (DocumentView* self) {
	GtkSpellChecker* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_spell_checker;
	_tmp1_ = gtk_spell_checker_attach (_tmp0_, (GtkTextView*) self);
	if (!_tmp1_) {
		g_warning ("document_view.vala:248: Impossible to attach the spell checker.");
	}
}


void document_view_disable_spell_checking (DocumentView* self) {
	GtkSpellChecker* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_spell_checker;
	if (_tmp0_ != NULL) {
		GtkSpellChecker* _tmp1_ = NULL;
		_tmp1_ = self->priv->_spell_checker;
		gtk_spell_checker_detach (_tmp1_);
	}
}


static gboolean document_view_on_button_release_event (DocumentView* self, GdkEventButton* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	GdkEventButton* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp1_ = event;
	_tmp2_ = _tmp1_->button;
	if (_tmp2_ == ((guint) 1)) {
		GdkEventButton* _tmp3_ = NULL;
		GdkModifierType _tmp4_ = 0;
		_tmp3_ = event;
		_tmp4_ = _tmp3_->state;
		_tmp0_ = (_tmp4_ & GDK_CONTROL_MASK) == GDK_CONTROL_MASK;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		LatexilaSynctex* synctex = NULL;
		LatexilaSynctex* _tmp5_ = NULL;
		LatexilaSynctex* _tmp6_ = NULL;
		Document* doc = NULL;
		GtkTextBuffer* _tmp7_ = NULL;
		GtkTextBuffer* _tmp8_ = NULL;
		Document* _tmp9_ = NULL;
		LatexilaSynctex* _tmp10_ = NULL;
		GtkTextBuffer* _tmp11_ = NULL;
		GtkTextBuffer* _tmp12_ = NULL;
		Document* _tmp13_ = NULL;
		GFile* _tmp14_ = NULL;
		GFile* _tmp15_ = NULL;
		Document* _tmp16_ = NULL;
		GFile* _tmp17_ = NULL;
		GFile* _tmp18_ = NULL;
		GdkEventButton* _tmp19_ = NULL;
		guint32 _tmp20_ = 0U;
		_tmp5_ = latexila_synctex_get_instance ();
		_tmp6_ = _g_object_ref0 (_tmp5_);
		synctex = _tmp6_;
		_tmp7_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp8_ = _tmp7_;
		_tmp9_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp8_, TYPE_DOCUMENT) ? ((Document*) _tmp8_) : NULL);
		doc = _tmp9_;
		_tmp10_ = synctex;
		_tmp11_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp12_ = _tmp11_;
		_tmp13_ = doc;
		_tmp14_ = document_get_location (_tmp13_);
		_tmp15_ = _tmp14_;
		_tmp16_ = doc;
		_tmp17_ = document_get_main_file (_tmp16_);
		_tmp18_ = _tmp17_;
		_tmp19_ = event;
		_tmp20_ = _tmp19_->time;
		latexila_synctex_forward_search (_tmp10_, _tmp12_, _tmp15_, _tmp18_, (guint) _tmp20_);
		_g_object_unref0 (_tmp18_);
		_g_object_unref0 (doc);
		_g_object_unref0 (synctex);
	}
	result = FALSE;
	return result;
}


static void __lambda83_ (DocumentView* self) {
	CompletionProvider* provider = NULL;
	CompletionProvider* _tmp0_ = NULL;
	_tmp0_ = completion_provider_get_default ();
	provider = _tmp0_;
	completion_provider_hide_calltip_window (provider);
	_g_object_unref0 (provider);
}


static void ___lambda83__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda83_ ((DocumentView*) self);
}


static void document_view_hide_completion_calltip_when_needed (DocumentView* self) {
	GtkTextBuffer* _tmp0_ = NULL;
	GtkTextBuffer* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp1_ = _tmp0_;
	g_signal_connect_object ((GObject*) _tmp1_, "notify::cursor-position", (GCallback) ___lambda83__g_object_notify, self, 0);
}


static gchar string_get (const gchar* self, glong index) {
	gchar result = '\0';
	glong _tmp0_ = 0L;
	gchar _tmp1_ = '\0';
	g_return_val_if_fail (self != NULL, '\0');
	_tmp0_ = index;
	_tmp1_ = ((gchar*) self)[_tmp0_];
	result = _tmp1_;
	return result;
}


static gboolean document_view_on_backspace (DocumentView* self, GdkEventKey* event) {
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gboolean _tmp3_ = FALSE;
	GSettings* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	GtkTextIter iter_start = {0};
	GtkTextIter iter_insert = {0};
	GtkTextBuffer* _tmp16_ = NULL;
	GtkTextBuffer* _tmp17_ = NULL;
	GtkTextBuffer* _tmp18_ = NULL;
	GtkTextBuffer* _tmp19_ = NULL;
	GtkTextMark* _tmp20_ = NULL;
	GtkTextIter _tmp21_ = {0};
	GtkTextBuffer* _tmp22_ = NULL;
	GtkTextBuffer* _tmp23_ = NULL;
	gint _tmp24_ = 0;
	GtkTextIter _tmp25_ = {0};
	gchar* text = NULL;
	GtkTextBuffer* _tmp26_ = NULL;
	GtkTextBuffer* _tmp27_ = NULL;
	GtkTextIter _tmp28_ = {0};
	GtkTextIter _tmp29_ = {0};
	gchar* _tmp30_ = NULL;
	const gchar* _tmp31_ = NULL;
	gint nb_chars_to_delete = 0;
	gboolean between = FALSE;
	GtkTextIter _tmp49_ = {0};
	gint _tmp50_ = 0;
	gboolean _tmp51_ = FALSE;
	GtkTextBuffer* _tmp52_ = NULL;
	GtkTextBuffer* _tmp53_ = NULL;
	GtkTextBuffer* _tmp54_ = NULL;
	GtkTextBuffer* _tmp55_ = NULL;
	GtkTextIter _tmp56_ = {0};
	GtkTextIter _tmp57_ = {0};
	GtkTextBuffer* _tmp58_ = NULL;
	GtkTextBuffer* _tmp59_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp4_ = self->priv->_editor_settings;
	_tmp5_ = g_settings_get_boolean (_tmp4_, "insert-spaces");
	if (!_tmp5_) {
		_tmp3_ = TRUE;
	} else {
		GSettings* _tmp6_ = NULL;
		gboolean _tmp7_ = FALSE;
		_tmp6_ = self->priv->_editor_settings;
		_tmp7_ = g_settings_get_boolean (_tmp6_, "forget-no-tabs");
		_tmp3_ = !_tmp7_;
	}
	if (_tmp3_) {
		_tmp2_ = TRUE;
	} else {
		GdkEventKey* _tmp8_ = NULL;
		guint _tmp9_ = 0U;
		_tmp8_ = event;
		_tmp9_ = _tmp8_->keyval;
		_tmp2_ = _tmp9_ != ((guint) 0xff08);
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		GtkTextBuffer* _tmp10_ = NULL;
		GtkTextBuffer* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		gboolean _tmp13_ = FALSE;
		_tmp10_ = gtk_text_view_get_buffer ((GtkTextView*) self);
		_tmp11_ = _tmp10_;
		_tmp12_ = gtk_text_buffer_get_has_selection (_tmp11_);
		_tmp13_ = _tmp12_;
		_tmp1_ = _tmp13_;
	}
	if (_tmp1_) {
		_tmp0_ = TRUE;
	} else {
		guint _tmp14_ = 0U;
		guint _tmp15_ = 0U;
		_tmp14_ = gtk_source_view_get_tab_width ((GtkSourceView*) self);
		_tmp15_ = _tmp14_;
		_tmp0_ = _tmp15_ == ((guint) 1);
	}
	if (_tmp0_) {
		result = FALSE;
		return result;
	}
	_tmp16_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp17_ = _tmp16_;
	_tmp18_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp19_ = _tmp18_;
	_tmp20_ = gtk_text_buffer_get_insert (_tmp19_);
	gtk_text_buffer_get_iter_at_mark (_tmp17_, &_tmp21_, _tmp20_);
	iter_insert = _tmp21_;
	_tmp22_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp23_ = _tmp22_;
	_tmp24_ = gtk_text_iter_get_line (&iter_insert);
	gtk_text_buffer_get_iter_at_line (_tmp23_, &_tmp25_, _tmp24_);
	iter_start = _tmp25_;
	_tmp26_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp27_ = _tmp26_;
	_tmp28_ = iter_start;
	_tmp29_ = iter_insert;
	_tmp30_ = gtk_text_buffer_get_text (_tmp27_, &_tmp28_, &_tmp29_, FALSE);
	text = _tmp30_;
	_tmp31_ = text;
	if (g_strcmp0 (_tmp31_, "") == 0) {
		result = FALSE;
		_g_free0 (text);
		return result;
	}
	nb_chars_to_delete = 0;
	between = TRUE;
	{
		glong i = 0L;
		i = (glong) 0;
		{
			gboolean _tmp32_ = FALSE;
			_tmp32_ = TRUE;
			while (TRUE) {
				glong _tmp34_ = 0L;
				const gchar* _tmp35_ = NULL;
				gint _tmp36_ = 0;
				gint _tmp37_ = 0;
				const gchar* _tmp38_ = NULL;
				glong _tmp39_ = 0L;
				gchar _tmp40_ = '\0';
				const gchar* _tmp41_ = NULL;
				glong _tmp42_ = 0L;
				gchar _tmp43_ = '\0';
				gboolean _tmp44_ = FALSE;
				gint _tmp45_ = 0;
				gint _tmp46_ = 0;
				guint _tmp47_ = 0U;
				guint _tmp48_ = 0U;
				if (!_tmp32_) {
					glong _tmp33_ = 0L;
					_tmp33_ = i;
					i = _tmp33_ + 1;
				}
				_tmp32_ = FALSE;
				_tmp34_ = i;
				_tmp35_ = text;
				_tmp36_ = strlen (_tmp35_);
				_tmp37_ = _tmp36_;
				if (!(_tmp34_ < ((glong) _tmp37_))) {
					break;
				}
				_tmp38_ = text;
				_tmp39_ = i;
				_tmp40_ = string_get (_tmp38_, _tmp39_);
				if (_tmp40_ == '\t') {
					nb_chars_to_delete = 1;
					between = TRUE;
					continue;
				}
				_tmp41_ = text;
				_tmp42_ = i;
				_tmp43_ = string_get (_tmp41_, _tmp42_);
				if (_tmp43_ != ' ') {
					result = FALSE;
					_g_free0 (text);
					return result;
				}
				_tmp44_ = between;
				if (_tmp44_) {
					nb_chars_to_delete = 1;
					between = FALSE;
					continue;
				}
				_tmp45_ = nb_chars_to_delete;
				nb_chars_to_delete = _tmp45_ + 1;
				_tmp46_ = nb_chars_to_delete;
				_tmp47_ = gtk_source_view_get_tab_width ((GtkSourceView*) self);
				_tmp48_ = _tmp47_;
				if (((guint) _tmp46_) == _tmp48_) {
					between = TRUE;
				}
			}
		}
	}
	_tmp49_ = iter_insert;
	iter_start = _tmp49_;
	_tmp50_ = nb_chars_to_delete;
	_tmp51_ = gtk_text_iter_backward_chars (&iter_start, _tmp50_);
	if (!_tmp51_) {
		result = FALSE;
		_g_free0 (text);
		return result;
	}
	_tmp52_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp53_ = _tmp52_;
	gtk_text_buffer_begin_user_action (_tmp53_);
	_tmp54_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp55_ = _tmp54_;
	_tmp56_ = iter_start;
	_tmp57_ = iter_insert;
	g_signal_emit_by_name (_tmp55_, "delete-range", &_tmp56_, &_tmp57_);
	_tmp58_ = gtk_text_view_get_buffer ((GtkTextView*) self);
	_tmp59_ = _tmp58_;
	gtk_text_buffer_end_user_action (_tmp59_);
	result = TRUE;
	_g_free0 (text);
	return result;
}


static void document_view_class_init (DocumentViewClass * klass) {
	document_view_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (DocumentViewPrivate));
	G_OBJECT_CLASS (klass)->finalize = document_view_finalize;
}


static void document_view_instance_init (DocumentView * self) {
	self->priv = DOCUMENT_VIEW_GET_PRIVATE (self);
	self->priv->_spell_checker = NULL;
}


static void document_view_finalize (GObject* obj) {
	DocumentView * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_DOCUMENT_VIEW, DocumentView);
	_g_object_unref0 (self->priv->_editor_settings);
	__vala_PangoFontDescription_free0 (self->priv->_font_desc);
	_g_object_unref0 (self->priv->_spell_checker);
	G_OBJECT_CLASS (document_view_parent_class)->finalize (obj);
}


GType document_view_get_type (void) {
	static volatile gsize document_view_type_id__volatile = 0;
	if (g_once_init_enter (&document_view_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (DocumentViewClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) document_view_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (DocumentView), 0, (GInstanceInitFunc) document_view_instance_init, NULL };
		GType document_view_type_id;
		document_view_type_id = g_type_register_static (gtk_source_view_get_type (), "DocumentView", &g_define_type_info, 0);
		g_once_init_leave (&document_view_type_id__volatile, document_view_type_id);
	}
	return document_view_type_id__volatile;
}



