---
layout: post
title: Announcing Leaflet 1.0-rc2
description: Leaflet 1.0 Release Candidate 2 is out
author: Yohan Boniface
authorsite: http://yohanboniface.me
---

Here comes the second release candidate for Leaflet 1.0, the most stable Leaflet version ever!


Leaflet 1.0-rc2 is mainly bug fixing, with two notable exceptions. The full list of changes is in the [1.0.0-rc2 changelog](https://github.com/Leaflet/Leaflet/blob/master/CHANGELOG.md#10-rc2-july-18-2016) as usual.


### Notable changes

* Event refactoring: thanks to an initial work from [@fab1an](https://github.com/fab1an), coordinated by [@perliedman](https://github.com/perliedman), the events are greatly optimized: they are faster, and consume less memory.

* New `L.Tooltip` class: started as a port of Leaflet.Label plugin to Leaflet core, and then reworked, this new class allows to display small tooltips attached to map features. The API is very similar to what Leaflet.Label was (with some exceptions in [options naming and default values](https://github.com/Leaflet/Leaflet.label#upgrade-path-to-ltooltip)), so the upgrade path from Leaflet.Label to `L.Tooltip` should be straightforward, and we encourage you to do so while upgrading your Leaflet to 1.0.

![L.Tooltip](/docs/images/2016-07-18-tooltip.png)

More in the [1.0.0-rc2 changelog](https://github.com/Leaflet/Leaflet/blob/master/CHANGELOG.md#10-rc2-july-18-2016).

## What's left for 1.0.0-final

The Leaflet team is very happy about the progress from rc1 to rc2, but not all features were tackled.

Notably, the scroll zoom with an Apple Magic Mouse has proven to be very tricky to debug (especially since not all members of the team have access to one). Getting a good experience when scroll-zooming with this particular device had been planned for rc2 but ultimately it was pushed back for 1.0.0-final.

While there are no big features planned, a few but [mischievous and tricky bugs are left](https://github.com/Leaflet/Leaflet/milestone/21) - such as subpixel offset, CSS trickery, zoom vibration.

### Leafdays

The core team being spread all over Europe, we are doing so called "Leafdays" from time to time to remotely work together during one full day. Here is a debug session with [@perliedman](https://github.com/perliedman) screen sharing:

![Remote session](/docs/images/2016-07-18-remote-session.png)

Next face-to-face session will be during [FOSS4G](http://2016.foss4g.org/) in Bonn, in August, and we hope to see you there. Will this be the final 1.0 release session?

### Get the release candidate

As with previous releases, you can use the CDN:


    <link rel="stylesheet" href="https://unpkg.com/leaflet@1.0.0-rc.2/dist/leaflet.css" />
    <script src="https://unpkg.com/leaflet@1.0.0-rc.2/dist/leaflet.js"></script>

A non-minified version of the javascript file is also available as:

    <script src="https://unpkg.com/leaflet@1.0.0-rc.2/dist/leaflet-src.js"></script>

The release is also available through NPM (`npm install leaflet@rc`), [GitHub download](https://github.com/Leaflet/Leaflet/archive/v1.0.0-rc.2.zip), and [CDN download](http://cdn.leafletjs.com/leaflet/v1.0.0-rc.2/leaflet.zip). We discourage using Bower.

Use it, enjoy it, and please report any [issue](https://github.com/Leaflet/Leaflet/issues) to help preparing the final Leaflet 1.0 release!


Best,

The "Leafteam"
