; NOTE: Assertions have been autogenerated by utils/update_llc_test_checks.py
; RUN: llc -mtriple=riscv32 < %s | FileCheck --check-prefix=RV32 %s
; RUN: llc -mtriple=riscv64 < %s | FileCheck --check-prefix=RV64 %s

define void @bool_eq(i1 zeroext %a, i1 zeroext %b, void ()* nocapture %c) nounwind {
; RV32-LABEL: bool_eq:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    beq a0, a1, .LBB0_2
; RV32-NEXT:  # %bb.1: # %if.end
; RV32-NEXT:    ret
; RV32-NEXT:  .LBB0_2: # %if.then
; RV32-NEXT:    jr a2
;
; RV64-LABEL: bool_eq:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    beq a0, a1, .LBB0_2
; RV64-NEXT:  # %bb.1: # %if.end
; RV64-NEXT:    ret
; RV64-NEXT:  .LBB0_2: # %if.then
; RV64-NEXT:    jr a2
entry:
  %0 = xor i1 %a, %b
  br i1 %0, label %if.end, label %if.then

if.then:
  tail call void %c() #1
  br label %if.end

if.end:
  ret void
}

define void @bool_ne(i1 zeroext %a, i1 zeroext %b, void ()* nocapture %c) nounwind {
; RV32-LABEL: bool_ne:
; RV32:       # %bb.0: # %entry
; RV32-NEXT:    beq a0, a1, .LBB1_2
; RV32-NEXT:  # %bb.1: # %if.then
; RV32-NEXT:    jr a2
; RV32-NEXT:  .LBB1_2: # %if.end
; RV32-NEXT:    ret
;
; RV64-LABEL: bool_ne:
; RV64:       # %bb.0: # %entry
; RV64-NEXT:    beq a0, a1, .LBB1_2
; RV64-NEXT:  # %bb.1: # %if.then
; RV64-NEXT:    jr a2
; RV64-NEXT:  .LBB1_2: # %if.end
; RV64-NEXT:    ret
entry:
  %cmp = xor i1 %a, %b
  br i1 %cmp, label %if.then, label %if.end

if.then:
  tail call void %c() #1
  br label %if.end

if.end:
  ret void
}
