/*
 * Copyright (C) 2023 Linux Studio Plugins Project <https://lsp-plug.in/>
 *           (C) 2023 Vladimir Sadovnikov <sadko4u@gmail.com>
 *
 * This file is part of lsp-tk-lib
 * Created on: 17 июл. 2017 г.
 *
 * lsp-tk-lib is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * any later version.
 *
 * lsp-tk-lib is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with lsp-tk-lib. If not, see <https://www.gnu.org/licenses/>.
 */

#ifndef LSP_PLUG_IN_TK_WIDGETS_CONTAINERS_ALIGN_H_
#define LSP_PLUG_IN_TK_WIDGETS_CONTAINERS_ALIGN_H_

#ifndef LSP_PLUG_IN_TK_IMPL
    #error "use <lsp-plug.in/tk/tk.h>"
#endif

namespace lsp
{
    namespace tk
    {
        // Style definition
        namespace style
        {
            LSP_TK_STYLE_DEF_BEGIN(Align, WidgetContainer)
                prop::Layout            sLayout;
                prop::SizeConstraints   sConstraints;
            LSP_TK_STYLE_DEF_END
        }

        /**
         * Alignment, implements a single widget container that aligns the child widget
         * according to the layout settings. The container ignores allocation() property
         * of the child widget.
         */
        class Align: public WidgetContainer
        {
            public:
                static const w_class_t    metadata;

            protected:
                Widget                 *pWidget;
                prop::Layout            sLayout;
                prop::SizeConstraints   sConstraints;

            protected:
                void                    do_destroy();

            protected:
                virtual Widget         *find_widget(ssize_t x, ssize_t y) override;
                virtual void            property_changed(Property *prop) override;
                virtual void            size_request(ws::size_limit_t *r) override;
                virtual void            realize(const ws::rectangle_t *r) override;

            public:
                explicit Align(Display *dpy);
                Align(const Align &) = delete;
                Align(Align &&) = delete;
                virtual ~Align() override;

                Align & operator = (const Align &) = delete;
                Align & operator = (Align &&) = delete;

                virtual status_t        init() override;
                virtual void            destroy() override;

            public:
                LSP_TK_PROPERTY(Layout,             layout,             &sLayout)
                LSP_TK_PROPERTY(SizeConstraints,    constraints,        &sConstraints)

            public:
                virtual void            render(ws::ISurface *s, const ws::rectangle_t *area, bool force) override;
                virtual status_t        add(Widget *widget) override;
                virtual status_t        remove(Widget *widget) override;
        };
    
    } /* namespace tk */
} /* namespace lsp */

#endif /* LSP_PLUG_IN_TK_WIDGETS_CONTAINERS_ALIGN_H_ */
