/* 
 * E-XML Library:  For XML, XML-RPC, HTTP, and related.
 * Copyright (C) 2002-2008  Elias Ross
 * 
 * genman@noderunner.net
 * http://noderunner.net/~genman
 * 
 * 1025 NE 73RD ST
 * SEATTLE WA 98115
 * USA
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * $Id$
 */

package net.noderunner.exml;

import java.io.StringWriter;

/**
 * This class is for unit testing the XmlCharArrayWriter class.
 *
 * @see XmlCharArrayWriter
 * @author Elias Ross
 * @version 1.0
 */
public class XmlCharArrayWriterTest
	extends junit.framework.TestCase
{
	public XmlCharArrayWriterTest(String name) {
		super(name);
	}


	/*
	public static junit.framework.TestSuite suite() {
		return new org.hansel.CoverageDecorator(XmlCharArrayWriterTest.class,
			new Class[] { XmlCharArrayWriter.class });
	} 
	*/


	public static void main(String[] args) {
		junit.textui.TestRunner.run(XmlCharArrayWriterTest.class);
	}

	public void testAppendString()
		throws Exception
	{
		XmlCharArrayWriter w = new XmlCharArrayWriter(10);
		XmlCharArrayWriter w2 = new XmlCharArrayWriter(10);
		StringBuffer sb = new StringBuffer();
		String X = "all your base are belong to us.";
		char X2[] = X.toCharArray();
		for (int i = 0; i < 10; i++) {
			w.write(X);
			sb.append(X);
			w2.write(X2);
		}
		assertEquals("Both the same", w.toString(), sb.toString());
		assertEquals("Both the same2", w2.toString(), sb.toString());
	}

	public void testAppendString2()
		throws Exception
	{
		XmlCharArrayWriter w = new XmlCharArrayWriter();
		String X = "all your base are belong to us.";
		w.write(X, 4, 4);
		assertEquals("Both the same", "your", w.toString());
	}

	public void testAppendString3()
		throws Exception
	{
		XmlCharArrayWriter w = new XmlCharArrayWriter();
		String X = "all your base are belong to us.";
		w.write(X);
		w.write(X);
		assertEquals("Both the same", X + X, w.toString());
	}

	public void testReset()
		throws Exception
	{
		XmlCharArrayWriter w = new XmlCharArrayWriter();
		String X = "all your base are belong to us.";
		w.write(X);
		assertEquals("Something", X.length(), w.size());
		w.reset();
		assertEquals("Zero", 0, w.size());
	}

	public void testMisc()
		throws Exception
	{
		XmlCharArrayWriter w = new XmlCharArrayWriter(0);
		w.write('a');
		w.write("bc");
		assertEquals('a', w.getBuffer()[0]);
		assertEquals('b', w.getBuffer()[1]);
		assertEquals('c', w.getBuffer()[2]);

		w.flush();
		w.close();
		w.write(new char[] { }, 0, 0);

	}

	public void testEmpty()
		throws Exception
	{
		XmlCharArrayWriter w = new XmlCharArrayWriter();
		assertEquals(w.toString(), "");
	}

	public void testEscape()
		throws Exception
	{
		XmlCharArrayWriter w = new XmlCharArrayWriter();
		StringBuffer sb = new StringBuffer();
		StringWriter sw = new StringWriter();
		w.write('<');
		w.write('>');
		w.write('\"');
		w.write('\'');
		w.write('&');
		w.write('a');
		w.writeEscapedTo(sb);
		w.writeEscapedTo(sw);

		String esc = "&lt;&gt;&quot;&apos;&amp;a";

		assertEquals("Both the same", sb.toString(), sw.toString());
		assertEquals("Escaped", esc, sb.toString());

		sw = new StringWriter();
		w.writeTo(sw);
		assertEquals("Write to the same", w.toString(), sw.toString());
	}

	public void testException()
		throws Exception
	{
		try {
			new XmlCharArrayWriter(-1);
			fail("negative size");
		} catch (IllegalArgumentException e) {
		}
		XmlCharArrayWriter w = new XmlCharArrayWriter();
		char s[] = "your".toCharArray();
		try {
			w.write(s, -1, 1);
			fail("negative size");
		} catch (java.lang.ArrayIndexOutOfBoundsException e) {
		}
	}
}
