------------------------------------------------------------------------------
--                                  G P S                                   --
--                                                                          --
--                     Copyright (C) 2003-2014, AdaCore                     --
--                                                                          --
-- This library is free software;  you can redistribute it and/or modify it --
-- under terms of the  GNU General Public License  as published by the Free --
-- Software  Foundation;  either version 3,  or (at your  option) any later --
-- version. This library is distributed in the hope that it will be useful, --
-- but WITHOUT ANY WARRANTY;  without even the implied warranty of MERCHAN- --
-- TABILITY or FITNESS FOR A PARTICULAR PURPOSE.                            --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
--                                                                          --
-- You should have received a copy of the GNU General Public License and    --
-- a copy of the GCC Runtime Library Exception along with this program;     --
-- see the files COPYING3 and COPYING.RUNTIME respectively.  If not, see    --
-- <http://www.gnu.org/licenses/>.                                          --
--                                                                          --
------------------------------------------------------------------------------

with Ada.Text_IO;           use Ada.Text_IO;
with GNATCOLL.Scripts;          use GNATCOLL.Scripts;
with GNATCOLL.Scripts.Python;   use GNATCOLL.Scripts.Python;
with GNATCOLL.Scripts.Shell;    use GNATCOLL.Scripts.Shell;
with GNATCOLL.Traces;
with Testsuite_Export;      use Testsuite_Export;
with TestConsole;           use TestConsole;

procedure TestAPI is
   use String_Lists;
   Repo    : Scripts_Repository := new Scripts_Repository_Record;
   Console : aliased Test_Console;

   procedure Completions (Input : String; Lang : Scripting_Language);
   function Starts_With (Str, Prefix : String) return Boolean;

   function Starts_With (Str, Prefix : String) return Boolean is
   begin
      return Str'Length >= Prefix'Length
        and then Str (Str'First .. Str'First + Prefix'Length - 1) = Prefix;
   end Starts_With;

   procedure Completions (Input : String; Lang : Scripting_Language) is
      Completions : String_Lists.List;
      C : String_Lists.Cursor;
   begin
      Put_Line ("Completions for " & Input & " (" & Get_Name (Lang) & "):");
      Complete (Lang, Input, Completions);
      C := First (Completions);
      while Has_Element (C) loop
         declare
            S : constant String := Element (C);
         begin
            --  Hide internal python methods, which depend on the python
            --  version
            if not Starts_With (S, Input & "__")
              and then not Starts_With (S, Input & ".__")
            then
               Put (Element (C) & ", ");
            end if;
         end;
         Next (C);
      end loop;
      New_Line;
   end Completions;

   Py : Scripting_Language;
   Sh : Scripting_Language;

begin
   GNATCOLL.Traces.Parse_Config_File ("gnatdebug");
   Register_Shell_Scripting (Repo);
   Register_Python_Scripting (Repo, "M");
   Register_Standard_Classes (Repo, "Console");

   Testsuite_Export.Register_Functions (Repo);

   Py := Lookup_Scripting_Language (Repo, "python");
   Sh := Lookup_Scripting_Language (Repo, "shell");

   Set_Default_Console (Py, Console'Unchecked_Access);
   Completions ("No", Py);
   Completions ("M", Py);
   Completions ("M.C", Py);
   Completions ("M.C1.", Py);
   Completions ("M.C1.me", Py);

   Set_Default_Console (Sh, Console'Unchecked_Access);
   Completions ("C1", Sh);
   Completions ("", Sh);
   Completions ("Ba", Sh);

   Free (Console);
   Destroy (Repo);
end TestAPI;
