/* ***************************************************************************
 *
 * Pico Technology USB Device Driver
 *
 *//**
 * \file      PicoDownloader.h 
 * \brief     Background firmware downloader for Pico products
 **//*
 *
 * Copyright (c) 2007, Pico Technology.
 * All rights reserved.
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are met:
 *  * Redistributions of source code must retain the above copyright
 *    notice, this list of conditions and the following disclaimer.
 *  * Redistributions in binary form must reproduce the above copyright
 *    notice, this list of conditions and the following disclaimer in the
 *    documentation and/or other materials provided with the distribution.
 *  * The name of Pico Technology may not be used to endorse or promote
 *    products derived from this software without specific prior written
 *    permission.
 *
 * THIS SOFTWARE IS PROVIDED BY PICO TECHNOLOGY "AS IS" AND ANY
 * EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE IMPLIED
 * WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE ARE
 * DISCLAIMED. IN NO EVENT SHALL PICO TECHNOLOGY BE LIABLE FOR ANY
 * DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL DAMAGES
 * (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
 * LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION) HOWEVER CAUSED AND
 * ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
 * (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY OUT OF THE USE OF
 * THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
 *
 * Version $Id: PicoDownloader.h,v 1.8 2008/03/06 09:26:25 douglas Exp $
 *
 *************************************************************************** */

/* Avoid including this header more than once */
#ifndef PICODOWNLOADER_H
#define PICODOWNLOADER_H

#include <vector>
#include "PicoPortability.h"
#include "IntelHexRecord.h"

const unsigned long ANY_USB_ID = 0xFFFFFFFF;


// ////////////////////////////////////////////////////////////////////////////
/// The PicoDownloader class defines a platform-independent way of downloading
/// firmware to Pico devices at runtime. A downloader is created using the 
/// Create() method which instantiates a platform-specific downloader. Create()
/// returns immediately leaving the downloader running in the background (for 
/// example, in a thread). Note that the details of the downloader are platform-
/// specific (for example, does it poll for new devices of register a callback?)
// ////////////////////////////////////////////////////////////////////////////
class PicoDownloader {
	public:
		/// The USB processors used in Pico products
		typedef enum {
			FX,
			FX2,
			FX1,
			FX2LP
		} UsbChip;
		
		typedef struct {
			unsigned long vendor;
			unsigned long product;
			unsigned long release;
			unsigned long deviceclass;
			INTEL_HEX_RECORD *firmware;
			UsbChip chip;
		} DeviceSpec;

	public:
		// Creates an instance of an OS-specific downloader class
		static PicoDownloader *Create(std::vector<DeviceSpec *> devices); 
		// Returns the number of devices identified for FW downloading at startup
		virtual int InitialDeviceCount(void)=0; 
		
		
		//virtual int Terminate();
		
		
		virtual ~PicoDownloader();
};

#endif /* not defined PICODOWNLOADER_H */
