# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.abstract_point_locator import AbstractPointLocator


class IncrementalPointLocator(AbstractPointLocator):
    r"""
    IncrementalPointLocator - Abstract class in support of both
     point location and point insertion.
    
    Superclass: AbstractPointLocator
    
    Compared to a static point locator for pure location functionalities
     through some search structure established from a fixed set of
    points,
     an incremental point locator allows for, in addition, point
    insertion
     capabilities, with the search structure maintaining a dynamically
     increasing number of points. There are two incremental point
    locators,
     i.e., PointLocator and IncrementalOctreePointLocator. As
    opposed
     to the uniform bin-based search structure (adopted in
    PointLocator)
     with a fixed spatial resolution, an octree mechanism (employed in
     IncrementalOctreePointlocator) resorts to a hierarchy of
    tree-like
     sub-division of the 3D data domain. Thus it enables data-aware
    multi-
     resolution and accordingly accelerated point location as well as
    point
     insertion, particularly when handling a radically imbalanced layout
    of
     points as not uncommon in datasets defined on adaptive meshes. In
    other
     words, IncrementalOctreePointLocator is an octree-based
    accelerated
     implementation of all functionalities of PointLocator.
    
    @sa
     Locator, IncrementalOctreePointLocator, PointLocator,
     MergePoints StaticPointLocator
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkIncrementalPointLocator, obj, update, **traits)
    
    def find_closest_inserted_point(self, *args):
        """
        find_closest_inserted_point(self, x:(float, float, float)) -> int
        C++: virtual IdType find_closest_inserted_point(const double x[3])
        Given a point x assumed to be covered by the search structure,
        return the index of the closest point (already inserted to the
        search structure) regardless of the associated minimum squared
        distance relative to the squared insertion-tolerance distance.
        This method is used when performing incremental point insertion.
        Note -1 indicates that no point is found. init_point_insertion()
        should have been called in advance.
        """
        ret = self._wrap_call(self._vtk_obj.FindClosestInsertedPoint, *args)
        return ret

    def init_point_insertion(self, *args):
        """
        init_point_insertion(self, newPts:Points, bounds:(float, float,
            float, float, float, float)) -> int
        C++: virtual int init_point_insertion(Points *newPts,
            const double bounds[6])
        init_point_insertion(self, newPts:Points, bounds:(float, float,
            float, float, float, float), estSize:int) -> int
        C++: virtual int init_point_insertion(Points *newPts,
            const double bounds[6], IdType estSize)
        Initialize the point insertion process. newPts is an object,
        storing 3D point coordinates, to which incremental point
        insertion puts coordinates. It is created and provided by an
        external VTK class. Argument bounds represents the spatial
        bounding box, into which the points fall.
        """
        my_args = deref_array(args, [('vtkPoints', ('float', 'float', 'float', 'float', 'float', 'float')), ('vtkPoints', ('float', 'float', 'float', 'float', 'float', 'float'), 'int')])
        ret = self._wrap_call(self._vtk_obj.InitPointInsertion, *my_args)
        return ret

    def insert_next_point(self, *args):
        """
        insert_next_point(self, x:(float, float, float)) -> int
        C++: virtual IdType insert_next_point(const double x[3])
        Insert a given point and return the point index.
        init_point_insertion() should have been called prior to this
        function. Also, is_inserted_point() should have been called in
        advance to ensure that the given point has not been inserted
        unless point duplication is allowed.
        """
        ret = self._wrap_call(self._vtk_obj.InsertNextPoint, *args)
        return ret

    def insert_point(self, *args):
        """
        insert_point(self, ptId:int, x:(float, float, float)) -> None
        C++: virtual void insert_point(IdType ptId, const double x[3])
        Insert a given point with a specified point index ptId.
        init_point_insertion() should have been called prior to this
        function. Also, is_inserted_point() should have been called in
        advance to ensure that the given point has not been inserted
        unless point duplication is allowed.
        """
        ret = self._wrap_call(self._vtk_obj.InsertPoint, *args)
        return ret

    def insert_unique_point(self, *args):
        """
        insert_unique_point(self, x:(float, float, float), ptId:int) -> int
        C++: virtual int insert_unique_point(const double x[3],
            IdType &ptId)
        Insert a point unless there has been a duplicate in the search
        structure. Return 0 if the point was already in the list,
        otherwise return 1. If the point was not in the list, it will be
        ADDED.  In either case, the id of the point (newly inserted or
        not) is returned in the ptId argument. This method is not thread
        safe.
        """
        ret = self._wrap_call(self._vtk_obj.InsertUniquePoint, *args)
        return ret

    def is_inserted_point(self, *args):
        """
        is_inserted_point(self, x:float, y:float, z:float) -> int
        C++: virtual IdType is_inserted_point(double x, double y,
            double z)
        is_inserted_point(self, x:(float, float, float)) -> int
        C++: virtual IdType is_inserted_point(const double x[3])
        Determine whether or not a given point has been inserted. Return
        the id of the already inserted point if true, else return -1.
        init_point_insertion() should have been called in advance.
        """
        ret = self._wrap_call(self._vtk_obj.IsInsertedPoint, *args)
        return ret

    _updateable_traits_ = \
    (('automatic', 'GetAutomatic'), ('use_existing_search_structure',
    'GetUseExistingSearchStructure'), ('debug', 'GetDebug'),
    ('global_warning_display', 'GetGlobalWarningDisplay'), ('max_level',
    'GetMaxLevel'), ('tolerance', 'GetTolerance'), ('object_name',
    'GetObjectName'), ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['automatic', 'debug', 'global_warning_display',
    'use_existing_search_structure', 'max_level', 'object_name',
    'tolerance'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(IncrementalPointLocator, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit IncrementalPointLocator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View((['automatic', 'use_existing_search_structure'], [],
            ['max_level', 'object_name', 'tolerance']),
            title='Edit IncrementalPointLocator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit IncrementalPointLocator properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

