# Automatically generated code: EDIT AT YOUR OWN RISK
from traits import api as traits
from traitsui.item import Item, spring
from traitsui.group import HGroup
from traitsui.view import View

from tvtk import vtk_module as vtk
from tvtk import tvtk_base
from tvtk.tvtk_base_handler import TVTKBaseHandler
from tvtk import messenger
from tvtk.tvtk_base import deref_vtk
from tvtk import array_handler
from tvtk.array_handler import deref_array
from tvtk.tvtk_classes.tvtk_helper import wrap_vtk

nan = float('nan')


def InstanceEditor(*args, **kw):
    from traitsui.editors.api import InstanceEditor as Editor
    return Editor(view_name="handler.view")

try:
    long
except NameError:
    # Silly workaround for Python3.
    long = int

inf = float('inf')

from tvtk.tvtk_classes.object import Object


class WebUtilities(Object):
    r"""
    WebUtilities - collection of utility functions for para_view Web.
    
    Superclass: Object
    
    WebUtilities consolidates miscellaneous utility functions useful
    for Python scripts designed for para_view Web.
    
    """
    def __init__(self, obj=None, update=True, **traits):
        tvtk_base.TVTKBase.__init__(self, vtk.vtkWebUtilities, obj, update, **traits)
    
    def process_rm_is(self, *args):
        """
        process_rm_is() -> None
        C++: static void process_rm_is()
        process_rm_is(reportError:int, dont_loop:int=0) -> None
        C++: static void process_rm_is(int reportError, int dont_loop=0)
        This method is similar to the process_rm_is() method on the
        global_controller except that it is Python friendly in the sense
        that it will release the Python GIS lock, so when run in a
        thread, this will truly work in the background without locking
        the main one.
        """
        ret = self._wrap_call(self._vtk_obj.ProcessRMIs, *args)
        return ret

    def write_attribute_headers_to_java_script(self, *args):
        """
        write_attribute_headers_to_java_script(field_type:int, __b:DataSet)
            -> str
        C++: static std::string write_attribute_headers_to_java_script(
            int field_type, DataSet *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.WriteAttributeHeadersToJavaScript, *my_args)
        return ret

    def write_attributes_to_java_script(self, *args):
        """
        write_attributes_to_java_script(field_type:int, __b:DataSet) -> str
        C++: static std::string write_attributes_to_java_script(
            int field_type, DataSet *)"""
        my_args = [deref_vtk(x) for x in args]
        ret = self._wrap_call(self._vtk_obj.WriteAttributesToJavaScript, *my_args)
        return ret

    _updateable_traits_ = \
    (('debug', 'GetDebug'), ('global_warning_display',
    'GetGlobalWarningDisplay'), ('object_name', 'GetObjectName'),
    ('reference_count', 'GetReferenceCount'))
    
    _allow_update_failure_ = \
    ()
    
    _full_traitnames_list_ = \
    (['debug', 'global_warning_display', 'object_name'])
    
    def trait_view(self, name=None, view_element=None):
        if view_element is not None or name not in (None, '', 'traits_view', 'full_traits_view', 'view'):
            return super(WebUtilities, self).trait_view(name, view_element)
        if name == 'full_traits_view':
            full_traits_view = \
            View((Item("handler._full_traits_list",show_label=False)),
            title='Edit WebUtilities properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return full_traits_view
        elif name == 'view':
            view = \
            View(([], [], ['object_name']),
            title='Edit WebUtilities properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return view
        elif name in (None, 'traits_view'):
            traits_view = \
            View((HGroup(spring, "handler.view_type", show_border=True), 
            Item("handler.info.object", editor = InstanceEditor(view_name="handler.view"), style = "custom", show_label=False)),
            title='Edit WebUtilities properties', scrollable=True, resizable=True,
            handler=TVTKBaseHandler,
            buttons=['OK', 'Cancel'])
            return traits_view
            

