C-----------------------------------------------------------------------
#include "pdf/pilot.h"
      Subroutine Ctq4R_HQ1 (Iset)
#include "pdf/impdp.inc"
      PARAMETER (MXX = 105, MXQ = 25, MXF = 6)
      PARAMETER (MXPQX = (MXF *2 +2) * MXQ * MXX)
      PARAMETER (NxI = 90, NtI = 13, NfMxI = 5)
      COMMON / W5051IC / Al, XV(0:MXX), QL(0:MXQ), UPD(MXPQX)
      COMMON / W5051ID / Nx, Nt, NfMx
      COMMON / W5051IE / Qini, Qmax, Xmin
      DIMENSION Amass(6)
      PARAMETER (NSETS=12)
      DIMENSION 
     >  XVI(0:MXX),QLI(0:MXQ),UPDI(MXPQX),
     >  AmassI(6)
C
C-----------------------------------------------------------------------
C Parton Distribution Table : CTEQ4HQ1                                        
        DATA  DrI, FlI, AlI /   2.,   5.,  .2020 /
        DATA  (AmassI(I),I=1,6) /     .000,     .000,     .200,
     +                               1.300,    5.000,  180.000 /
C        DATA  NX,  NT, NfMx /    90,    13,     5 /
        DATA  QINII, QMAXI, (QLI(I), I =0, NTI) /
     +  .100000E+01, .100000E+05,
     +  .100000E+01, .130000E+01, .170540E+01, .232751E+01, .332392E+01,
     +  .500000E+01, .846148E+01, .156092E+02, .318356E+02, .729780E+02,
     +  .191662E+03, .589700E+03, .218145E+04, .100000E+05 /
        DATA  XMINI, (XVI(I), I =0, NXI) /
     +  .100000E-04,
     +  .000000E+00, .999983E-05, .124433E-04, .154836E-04, .192668E-04,
     +  .239740E-04, .298310E-04, .371184E-04, .461852E-04, .574656E-04,
     +  .714994E-04, .889575E-04, .110674E-03, .137686E-03, .171280E-03,
     +  .213055E-03, .264997E-03, .329564E-03, .409809E-03, .509508E-03,
     +  .633332E-03, .787053E-03, .977784E-03, .121428E-02, .150728E-02,
     +  .186993E-02, .231825E-02, .288037E-02, .356397E-02, .440443E-02,
     +  .543508E-02, .669508E-02, .822984E-02, .100851E-01, .123281E-01,
     +  .150167E-01, .182174E-01, .219985E-01, .264278E-01, .315720E-01,
     +  .374800E-01, .442088E-01, .517931E-01, .602576E-01, .696136E-01,
     +  .798586E-01, .909356E-01, .102935E+00, .115681E+00, .129293E+00,
     +  .143599E+00, .158606E+00, .174271E+00, .190550E+00, .207405E+00,
     +  .224796E+00, .242685E+00, .261038E+00, .279820E+00, .299001E+00,
     +  .318550E+00, .338442E+00, .358653E+00, .379067E+00, .399881E+00,
     +  .420953E+00, .442266E+00, .463806E+00, .485559E+00, .507513E+00,
     +  .529656E+00, .551978E+00, .574483E+00, .597187E+00, .619860E+00,
     +  .642828E+00, .665921E+00, .689135E+00, .712467E+00, .735911E+00,
     +  .759464E+00, .783080E+00, .806909E+00, .830741E+00, .854673E+00,
     +  .878696E+00, .902804E+00, .926992E+00, .951257E+00, .975603E+00,
     +  .100000E+01 /
C Parton Distribution Table:                                                   
C
        DATA (UPDI(I),I=1,52) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=53,104) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=105,156) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=157,208) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=209,260) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=261,312) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=313,364) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=365,416) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=417,468) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .253069E+06,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=469,520) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=521,572) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .118748E+06, .904727E+05,
     +  .678230E+05, .507988E+05, .380230E+05, .284321E+05,
     +  .212453E+05, .158584E+05, .118283E+05, .881243E+04,
     +  .656004E+04, .487747E+04, .362318E+04, .268796E+04,
     +  .199219E+04, .147447E+04, .109013E+04, .804769E+03,
     +  .593423E+03, .436877E+03, .321235E+03, .235802E+03,
     +  .172859E+03, .126490E+03, .924246E+02, .674143E+02 /
        DATA (UPDI(I),I=573,624) /
     +  .491166E+02, .355530E+02, .258184E+02, .187139E+02,
     +  .135501E+02, .979523E+01, .707502E+01, .510922E+01,
     +  .368663E+01, .265924E+01, .192018E+01, .138728E+01,
     +  .100443E+01, .728381E+00, .530180E+00, .386943E+00,
     +  .283568E+00, .208538E+00, .154115E+00, .114316E+00,
     +  .853204E-01, .637673E-01, .479957E-01, .361578E-01,
     +  .273783E-01, .207729E-01, .158124E-01, .120520E-01,
     +  .920654E-02, .703236E-02, .537543E-02, .410387E-02,
     +  .313275E-02, .238480E-02, .181245E-02, .137158E-02,
     +  .103412E-02, .776286E-03, .578093E-03, .426376E-03,
     +  .311426E-03, .224355E-03, .159202E-03, .110525E-03,
     +  .747780E-04, .486658E-04, .299961E-04, .168666E-04,
     +  .807002E-05, .225922E-05, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=625,676) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .272894E+06, .207291E+06, .154851E+06,
     +  .115573E+06, .861975E+05, .642234E+05, .478144E+05,
     +  .355596E+05, .264238E+05, .196125E+05, .145439E+05,
     +  .107720E+05, .797047E+04, .588979E+04, .434767E+04,
     +  .320476E+04, .235959E+04, .173465E+04, .127365E+04,
     +  .933618E+03, .683465E+03, .499460E+03, .364469E+03,
     +  .265470E+03, .193060E+03, .140139E+03, .101597E+03,
     +  .731671E+02, .528596E+02, .381143E+02, .274486E+02,
     +  .197338E+02, .141730E+02, .101765E+02, .729944E+01,
     +  .523361E+01, .375556E+01, .269626E+01, .193952E+01 /
        DATA (UPDI(I),I=677,728) /
     +  .139730E+01, .101025E+01, .732337E+00, .532980E+00,
     +  .389249E+00, .285635E+00, .210377E+00, .155890E+00,
     +  .115680E+00, .864338E-01, .646440E-01, .485883E-01,
     +  .365980E-01, .276533E-01, .209230E-01, .158647E-01,
     +  .120296E-01, .912821E-02, .691940E-02, .524483E-02,
     +  .396590E-02, .299484E-02, .225328E-02, .169032E-02,
     +  .126381E-02, .938810E-03, .692260E-03, .507036E-03,
     +  .367888E-03, .264513E-03, .187762E-03, .131619E-03,
     +  .906488E-04, .612132E-04, .402816E-04, .258881E-04,
     +  .159393E-04, .934766E-05, .508696E-05, .247198E-05,
     +  .944995E-06, .144721E-06, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=729,780) /
     +  .469588E+06, .355601E+06, .264681E+06, .196829E+06,
     +  .146260E+06, .108572E+06, .805284E+05, .596633E+05,
     +  .441650E+05, .326544E+05, .241205E+05, .177945E+05,
     +  .131139E+05, .965148E+04, .709517E+04, .520836E+04,
     +  .381863E+04, .279533E+04, .204353E+04, .149141E+04,
     +  .108692E+04, .790706E+03, .574334E+03, .416373E+03,
     +  .301356E+03, .217683E+03, .157027E+03, .112506E+03,
     +  .808585E+02, .579968E+02, .415408E+02, .297013E+02,
     +  .212108E+02, .151426E+02, .107970E+02, .769478E+01,
     +  .548736E+01, .391490E+01, .279797E+01, .200267E+01,
     +  .143828E+01, .103563E+01, .748550E+00, .542949E+00,
     +  .395643E+00, .289373E+00, .212913E+00, .156886E+00,
     +  .116384E+00, .864266E-01, .644937E-01, .482337E-01 /
        DATA (UPDI(I),I=781,832) /
     +  .361821E-01, .271804E-01, .204594E-01, .154021E-01,
     +  .116024E-01, .873217E-02, .657108E-02, .493382E-02,
     +  .369960E-02, .276481E-02, .206045E-02, .153108E-02,
     +  .113088E-02, .829902E-03, .605584E-03, .438473E-03,
     +  .315246E-03, .224462E-03, .158462E-03, .110566E-03,
     +  .762634E-04, .518954E-04, .350457E-04, .232745E-04,
     +  .152918E-04, .992491E-05, .639485E-05, .408798E-05,
     +  .261347E-05, .166805E-05, .106295E-05, .670324E-06,
     +  .411789E-06, .238229E-06, .123742E-06, .525386E-07,
     +  .146420E-07, .121447E-08, .000000E+00, .716891E+06,
     +  .541160E+06, .401301E+06, .297314E+06, .220095E+06,
     +  .162761E+06, .120257E+06, .887540E+05, .654416E+05,
     +  .481950E+05, .354574E+05, .260528E+05, .191215E+05 /
        DATA (UPDI(I),I=833,884) /
     +  .140149E+05, .102598E+05, .749967E+04, .547496E+04,
     +  .399046E+04, .290439E+04, .211025E+04, .153095E+04,
     +  .110862E+04, .801490E+03, .578302E+03, .416534E+03,
     +  .299399E+03, .214887E+03, .153166E+03, .109507E+03,
     +  .781300E+02, .556570E+02, .395751E+02, .281017E+02,
     +  .199470E+02, .141383E+02, .100156E+02, .709820E+01,
     +  .503253E+01, .357369E+01, .254139E+01, .181311E+01,
     +  .129685E+01, .931016E+00, .670730E+00, .485390E+00,
     +  .352574E+00, .257613E+00, .188510E+00, .138860E+00,
     +  .102397E+00, .758717E-01, .563473E-01, .419690E-01,
     +  .313063E-01, .233967E-01, .174889E-01, .130804E-01,
     +  .977526E-02, .730353E-02, .544546E-02, .405458E-02,
     +  .300949E-02, .222769E-02, .164466E-02, .120724E-02 /
        DATA (UPDI(I),I=885,936) /
     +  .881009E-03, .639722E-03, .461424E-03, .330901E-03,
     +  .235478E-03, .166540E-03, .116817E-03, .813599E-04,
     +  .562426E-04, .388410E-04, .266265E-04, .182373E-04,
     +  .124786E-04, .855755E-05, .586908E-05, .402841E-05,
     +  .274655E-05, .184219E-05, .119964E-05, .742863E-06,
     +  .423782E-06, .212340E-06, .853859E-07, .224247E-07,
     +  .193681E-08, .000000E+00, .102340E+07, .770054E+06,
     +  .568876E+06, .419865E+06, .309621E+06, .228081E+06,
     +  .167860E+06, .123399E+06, .906238E+05, .664730E+05,
     +  .487058E+05, .356408E+05, .260501E+05, .190133E+05,
     +  .138599E+05, .100879E+05, .733245E+04, .532088E+04,
     +  .385545E+04, .278867E+04, .201387E+04, .145157E+04,
     +  .104448E+04, .750029E+03, .537597E+03, .384502E+03 /
        DATA (UPDI(I),I=937,988) /
     +  .274572E+03, .194693E+03, .138468E+03, .982697E+02,
     +  .696230E+02, .492327E+02, .347615E+02, .245328E+02,
     +  .172860E+02, .121722E+02, .857359E+01, .604085E+01,
     +  .426245E+01, .301178E+01, .213465E+01, .151679E+01,
     +  .108163E+01, .774024E+00, .556338E+00, .401367E+00,
     +  .291257E+00, .211675E+00, .154845E+00, .113400E+00,
     +  .834412E-01, .615436E-01, .455207E-01, .337213E-01,
     +  .250250E-01, .185763E-01, .137966E-01, .102393E-01,
     +  .759671E-02, .562519E-02, .415953E-02, .306672E-02,
     +  .225498E-02, .165416E-02, .120671E-02, .875675E-03,
     +  .632636E-03, .454434E-03, .324890E-03, .230873E-03,
     +  .163356E-03, .114939E-03, .805609E-04, .562717E-04,
     +  .394213E-04, .275505E-04, .193164E-04, .135768E-04 /
        DATA (UPDI(I),I=989,1040) /
     +  .957441E-05, .674752E-05, .473755E-05, .328415E-05,
     +  .222055E-05, .144531E-05, .886249E-06, .496417E-06,
     +  .241979E-06, .937502E-07, .236345E-07, .208487E-08,
     +  .000000E+00, .139807E+07, .104856E+07, .771650E+06,
     +  .567331E+06, .416736E+06, .305785E+06, .224156E+06,
     +  .164127E+06, .120048E+06, .876987E+05, .639941E+05,
     +  .466344E+05, .339424E+05, .246692E+05, .179057E+05,
     +  .129764E+05, .939065E+04, .678432E+04, .489378E+04,
     +  .352366E+04, .253293E+04, .181720E+04, .130137E+04,
     +  .930020E+03, .663357E+03, .472088E+03, .335412E+03,
     +  .236597E+03, .167391E+03, .118167E+03, .832656E+02,
     +  .585560E+02, .411111E+02, .288485E+02, .202076E+02,
     +  .141448E+02, .990234E+01, .693411E+01, .486196E+01 /
        DATA (UPDI(I),I=1041,1092) /
     +  .341360E+01, .240379E+01, .169692E+01, .120210E+01,
     +  .854549E+00, .610106E+00, .437211E+00, .315132E+00,
     +  .227484E+00, .165280E+00, .120222E+00, .878584E-01,
     +  .643643E-01, .472822E-01, .347888E-01, .256401E-01,
     +  .189036E-01, .139436E-01, .102784E-01, .757367E-02,
     +  .557054E-02, .409148E-02, .299690E-02, .218942E-02,
     +  .159612E-02, .115744E-02, .835376E-03, .600599E-03,
     +  .429721E-03, .306324E-03, .217374E-03, .153846E-03,
     +  .108526E-03, .764655E-04, .538543E-04, .381408E-04,
     +  .270271E-04, .192467E-04, .137513E-04, .984625E-05,
     +  .702903E-05, .497687E-05, .346238E-05, .233561E-05,
     +  .150828E-05, .912209E-06, .501106E-06, .237973E-06,
     +  .891548E-07, .216793E-07, .194514E-08, .000000E+00 /
        DATA (UPDI(I),I=1093,1144) /
     +  .184999E+07, .138299E+07, .101382E+07, .742484E+06,
     +  .543256E+06, .397047E+06, .289894E+06, .211409E+06,
     +  .154004E+06, .112045E+06, .814214E+05, .590871E+05,
     +  .428247E+05, .309925E+05, .223986E+05, .161620E+05,
     +  .116445E+05, .837530E+04, .601423E+04, .431073E+04,
     +  .308439E+04, .220251E+04, .156983E+04, .111649E+04,
     +  .792473E+03, .561171E+03, .396691E+03, .278371E+03,
     +  .195919E+03, .137576E+03, .964188E+02, .674348E+02,
     +  .470796E+02, .328494E+02, .228762E+02, .159184E+02,
     +  .110767E+02, .770917E+01, .537179E+01, .374789E+01,
     +  .262235E+01, .183932E+01, .129449E+01, .914233E+00,
     +  .648416E+00, .461599E+00, .330507E+00, .237001E+00,
     +  .171045E+00, .123587E+00, .897139E-01, .652877E-01 /
        DATA (UPDI(I),I=1145,1196) /
     +  .476398E-01, .348188E-01, .254899E-01, .186677E-01,
     +  .136776E-01, .100157E-01, .733107E-02, .535694E-02,
     +  .390902E-02, .284522E-02, .206570E-02, .149702E-02,
     +  .107945E-02, .775132E-03, .554795E-03, .395541E-03,
     +  .281250E-03, .199374E-03, .141184E-03, .998561E-04,
     +  .707013E-04, .501553E-04, .358416E-04, .256700E-04,
     +  .184837E-04, .133464E-04, .963856E-05, .692081E-05,
     +  .490897E-05, .340761E-05, .228315E-05, .145832E-05,
     +  .868426E-06, .467570E-06, .216429E-06, .785335E-07,
     +  .184694E-07, .168267E-08, .000000E+00, .238813E+07,
     +  .177947E+07, .129941E+07, .947927E+06, .690844E+06,
     +  .502915E+06, .365722E+06, .265633E+06, .192718E+06,
     +  .139636E+06, .101051E+06, .730263E+05, .527040E+05 /
        DATA (UPDI(I),I=1197,1248) /
     +  .379799E+05, .273302E+05, .196348E+05, .140844E+05,
     +  .100852E+05, .720948E+04, .514395E+04, .366361E+04,
     +  .260392E+04, .184716E+04, .130743E+04, .923491E+03,
     +  .650708E+03, .457673E+03, .319506E+03, .223706E+03,
     +  .156264E+03, .108929E+03, .757705E+02, .526053E+02,
     +  .364987E+02, .252711E+02, .174822E+02, .120924E+02,
     +  .836534E+01, .579324E+01, .401689E+01, .279288E+01,
     +  .194652E+01, .136116E+01, .955143E+00, .673038E+00,
     +  .476016E+00, .338611E+00, .241228E+00, .172954E+00,
     +  .124149E+00, .895306E-01, .647302E-01, .469232E-01,
     +  .340715E-01, .247790E-01, .180290E-01, .131235E-01,
     +  .954800E-02, .694362E-02, .504172E-02, .365592E-02,
     +  .264488E-02, .190887E-02, .137561E-02, .986664E-03 /
        DATA (UPDI(I),I=1249,1300) /
     +  .705195E-03, .502713E-03, .357314E-03, .253565E-03,
     +  .179652E-03, .127343E-03, .903257E-04, .642596E-04,
     +  .458838E-04, .330391E-04, .238612E-04, .173177E-04,
     +  .125881E-04, .913022E-05, .656566E-05, .464739E-05,
     +  .320845E-05, .212999E-05, .134334E-05, .786897E-06,
     +  .415091E-06, .187321E-06, .659016E-07, .150199E-07,
     +  .138820E-08, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1301,1352) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1353,1404) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .667144E+05, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1405,1456) /
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=1457,1508) /
     +  .295719E+05, .230606E+05, .177583E+05, .136648E+05,
     +  .105125E+05, .808086E+04, .620999E+04, .476813E+04,
     +  .365990E+04, .280663E+04, .215152E+04, .164766E+04,
     +  .126129E+04, .964470E+03, .737159E+03, .562761E+03,
     +  .429398E+03, .327222E+03, .249210E+03, .189538E+03,
     +  .144064E+03, .109344E+03, .829326E+02, .628058E+02,
     +  .475266E+02, .359138E+02, .271250E+02, .203738E+02,
     +  .153560E+02, .115568E+02, .869595E+01, .653554E+01,
     +  .491248E+01, .369297E+01, .277704E+01, .208843E+01,
     +  .157380E+01, .118702E+01, .898090E+00, .680685E+00,
     +  .518251E+00, .395636E+00, .303475E+00, .233540E+00,
     +  .180698E+00, .140268E+00, .109575E+00, .856873E-01,
     +  .674840E-01, .531734E-01, .421107E-01, .333948E-01 /
        DATA (UPDI(I),I=1509,1560) /
     +  .265745E-01, .211633E-01, .168967E-01, .134832E-01,
     +  .107696E-01, .858981E-02, .685450E-02, .545455E-02,
     +  .433688E-02, .343533E-02, .271429E-02, .213805E-02,
     +  .167397E-02, .130078E-02, .100396E-02, .767470E-03,
     +  .581211E-03, .434191E-03, .319862E-03, .230944E-03,
     +  .163124E-03, .111191E-03, .732997E-04, .452285E-04,
     +  .253673E-04, .117224E-04, .285898E-05, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .722670E+05,
     +  .561091E+05, .429931E+05, .329191E+05, .251974E+05,
     +  .192717E+05, .147341E+05, .112553E+05, .859436E+04,
     +  .655655E+04, .499961E+04, .380865E+04, .289991E+04 /
        DATA (UPDI(I),I=1561,1612) /
     +  .220566E+04, .167665E+04, .127307E+04, .966021E+03,
     +  .732118E+03, .554459E+03, .419353E+03, .316934E+03,
     +  .239192E+03, .180371E+03, .135813E+03, .102170E+03,
     +  .767530E+02, .576234E+02, .430185E+02, .322244E+02,
     +  .241031E+02, .180219E+02, .134589E+02, .100503E+02,
     +  .750607E+01, .560605E+01, .418727E+01, .313310E+01,
     +  .234639E+01, .176219E+01, .132580E+01, .100174E+01,
     +  .758935E+00, .577587E+00, .441044E+00, .338530E+00,
     +  .260723E+00, .202035E+00, .156749E+00, .122453E+00,
     +  .957250E-01, .752018E-01, .591735E-01, .467164E-01,
     +  .369183E-01, .292459E-01, .231618E-01, .183613E-01,
     +  .145396E-01, .115194E-01, .910539E-02, .719311E-02,
     +  .566452E-02, .445222E-02, .349137E-02, .272436E-02 /
        DATA (UPDI(I),I=1613,1664) /
     +  .211326E-02, .163140E-02, .125075E-02, .953204E-03,
     +  .720010E-03, .539680E-03, .400074E-03, .293490E-03,
     +  .211855E-03, .151608E-03, .106217E-03, .731254E-04,
     +  .491605E-04, .322597E-04, .205056E-04, .126079E-04,
     +  .743667E-05, .416325E-05, .219400E-05, .107695E-05,
     +  .479832E-06, .191625E-06, .655868E-07, .156337E-07,
     +  .000000E+00, .000000E+00, .130802E+06, .101142E+06,
     +  .771374E+05, .587874E+05, .447846E+05, .340903E+05,
     +  .259381E+05, .197189E+05, .149834E+05, .113749E+05,
     +  .863079E+04, .654229E+04, .495621E+04, .375072E+04,
     +  .283657E+04, .214279E+04, .161753E+04, .121952E+04,
     +  .918709E+03, .691183E+03, .519570E+03, .390018E+03,
     +  .292498E+03, .219036E+03, .163859E+03, .122406E+03 /
        DATA (UPDI(I),I=1665,1716) /
     +  .913732E+02, .678175E+02, .505025E+02, .375526E+02,
     +  .279080E+02, .207155E+02, .153721E+02, .114086E+02,
     +  .846527E+01, .628160E+01, .466835E+01, .347245E+01,
     +  .258959E+01, .193467E+01, .145120E+01, .109155E+01,
     +  .824573E+00, .625036E+00, .476155E+00, .364005E+00,
     +  .279943E+00, .215590E+00, .167147E+00, .129698E+00,
     +  .101126E+00, .789921E-01, .618997E-01, .485628E-01,
     +  .381863E-01, .300246E-01, .236289E-01, .185790E-01,
     +  .146144E-01, .114722E-01, .900006E-02, .704045E-02,
     +  .549748E-02, .428393E-02, .332256E-02, .256321E-02,
     +  .196904E-02, .150353E-02, .114228E-02, .861421E-03,
     +  .645661E-03, .479802E-03, .353778E-03, .257843E-03,
     +  .187067E-03, .133798E-03, .947979E-04, .662985E-04 /
        DATA (UPDI(I),I=1717,1768) /
     +  .458615E-04, .312523E-04, .210325E-04, .139058E-04,
     +  .899122E-05, .564894E-05, .340972E-05, .192638E-05,
     +  .983655E-06, .420479E-06, .121780E-06, .907329E-08,
     +  .000000E+00, .208465E+06, .160595E+06, .121931E+06,
     +  .925089E+05, .701539E+05, .531587E+05, .402603E+05,
     +  .304657E+05, .230411E+05, .174101E+05, .131472E+05,
     +  .991836E+04, .747751E+04, .563140E+04, .423797E+04,
     +  .318569E+04, .239277E+04, .179499E+04, .134537E+04,
     +  .100703E+04, .753076E+03, .562368E+03, .419527E+03,
     +  .312497E+03, .232517E+03, .172750E+03, .128241E+03,
     +  .946429E+02, .700777E+02, .518106E+02, .382781E+02,
     +  .282452E+02, .208322E+02, .153667E+02, .113303E+02,
     +  .835432E+01, .616815E+01, .455795E+01, .337613E+01 /
        DATA (UPDI(I),I=1769,1820) /
     +  .250524E+01, .186615E+01, .139393E+01, .104554E+01,
     +  .786967E+00, .595217E+00, .451802E+00, .344969E+00,
     +  .263791E+00, .203046E+00, .156440E+00, .121106E+00,
     +  .939384E-01, .730906E-01, .569445E-01, .444607E-01,
     +  .347163E-01, .271306E-01, .211871E-01, .165503E-01,
     +  .129043E-01, .100546E-01, .781335E-02, .606057E-02,
     +  .469206E-02, .361570E-02, .277244E-02, .211739E-02,
     +  .160821E-02, .121583E-02, .913131E-03, .682142E-03,
     +  .505851E-03, .372687E-03, .272011E-03, .197949E-03,
     +  .142446E-03, .101833E-03, .721259E-04, .507006E-04,
     +  .352472E-04, .242656E-04, .164449E-04, .109024E-04,
     +  .701138E-05, .431079E-05, .246494E-05, .126102E-05,
     +  .532499E-06, .150526E-06, .119086E-07, .000000E+00 /
        DATA (UPDI(I),I=1821,1872) /
     +  .322426E+06, .247316E+06, .186876E+06, .141106E+06,
     +  .106488E+06, .802998E+05, .605161E+05, .455682E+05,
     +  .342904E+05, .257805E+05, .193689E+05, .145378E+05,
     +  .109033E+05, .816893E+04, .611519E+04, .457258E+04,
     +  .341602E+04, .254884E+04, .189993E+04, .141435E+04,
     +  .105177E+04, .781032E+03, .579323E+03, .429061E+03,
     +  .317383E+03, .234417E+03, .172974E+03, .126875E+03,
     +  .933632E+02, .685991E+02, .503582E+02, .369214E+02,
     +  .270516E+02, .198228E+02, .145159E+02, .106298E+02,
     +  .779254E+01, .571754E+01, .420411E+01, .309693E+01,
     +  .228963E+01, .169754E+01, .126356E+01, .943926E+00,
     +  .708444E+00, .533681E+00, .404361E+00, .306874E+00,
     +  .234394E+00, .179234E+00, .137692E+00, .106009E+00 /
        DATA (UPDI(I),I=1873,1924) /
     +  .818568E-01, .633004E-01, .490466E-01, .380111E-01,
     +  .294785E-01, .228471E-01, .177077E-01, .136998E-01,
     +  .105883E-01, .816139E-02, .627638E-02, .481630E-02,
     +  .367630E-02, .279105E-02, .210873E-02, .158316E-02,
     +  .118150E-02, .874780E-03, .642936E-03, .468034E-03,
     +  .337487E-03, .240304E-03, .169891E-03, .118183E-03,
     +  .811942E-04, .549178E-04, .366086E-04, .239707E-04,
     +  .154427E-04, .975056E-05, .601039E-05, .359965E-05,
     +  .207405E-05, .112164E-05, .550405E-06, .225896E-06,
     +  .626799E-07, .467676E-08, .000000E+00, .471854E+06,
     +  .360466E+06, .271091E+06, .203728E+06, .153013E+06,
     +  .114829E+06, .861186E+05, .645308E+05, .483205E+05,
     +  .361489E+05, .270225E+05, .201803E+05, .150580E+05 /
        DATA (UPDI(I),I=1925,1976) /
     +  .112239E+05, .835847E+04, .621739E+04, .462023E+04,
     +  .342905E+04, .254226E+04, .188226E+04, .139203E+04,
     +  .102798E+04, .758208E+03, .558369E+03, .410657E+03,
     +  .301543E+03, .221189E+03, .161259E+03, .117943E+03,
     +  .861285E+02, .628298E+02, .457742E+02, .333206E+02,
     +  .242575E+02, .176442E+02, .128335E+02, .934280E+01,
     +  .680731E+01, .496973E+01, .363480E+01, .266768E+01,
     +  .196342E+01, .145064E+01, .107571E+01, .801311E+00,
     +  .599166E+00, .450584E+00, .339423E+00, .257312E+00,
     +  .195304E+00, .148918E+00, .113813E+00, .872303E-01,
     +  .669625E-01, .514985E-01, .396194E-01, .304986E-01,
     +  .234656E-01, .180522E-01, .138646E-01, .106363E-01,
     +  .813884E-02, .621291E-02, .473286E-02, .358605E-02 /
        DATA (UPDI(I),I=1977,2028) /
     +  .270313E-02, .202792E-02, .151223E-02, .112118E-02,
     +  .825135E-03, .603082E-03, .436963E-03, .313881E-03,
     +  .223030E-03, .157578E-03, .109829E-03, .757975E-04,
     +  .516932E-04, .348744E-04, .232194E-04, .152686E-04,
     +  .987761E-05, .624775E-05, .383764E-05, .225567E-05,
     +  .123423E-05, .603598E-06, .241678E-06, .640925E-07,
     +  .510405E-08, .000000E+00, .663925E+06, .505184E+06,
     +  .378168E+06, .282877E+06, .211460E+06, .157943E+06,
     +  .117887E+06, .879117E+05, .655088E+05, .487684E+05,
     +  .362762E+05, .269564E+05, .200131E+05, .148419E+05,
     +  .109963E+05, .813744E+04, .601552E+04, .444118E+04,
     +  .327515E+04, .241190E+04, .177404E+04, .130292E+04,
     +  .955657E+03, .699835E+03, .511775E+03, .373629E+03 /
        DATA (UPDI(I),I=2029,2080) /
     +  .272463E+03, .197451E+03, .143546E+03, .104191E+03,
     +  .755356E+02, .546871E+02, .395543E+02, .286103E+02,
     +  .206730E+02, .149363E+02, .107996E+02, .781479E+01,
     +  .566534E+01, .411446E+01, .299814E+01, .219085E+01,
     +  .160693E+01, .118300E+01, .874793E+00, .649358E+00,
     +  .484764E+00, .362520E+00, .272811E+00, .205568E+00,
     +  .155602E+00, .118068E+00, .898364E-01, .684688E-01,
     +  .522750E-01, .399288E-01, .305151E-01, .233108E-01,
     +  .178035E-01, .135762E-01, .103400E-01, .785601E-02,
     +  .595404E-02, .450348E-02, .338797E-02, .253619E-02,
     +  .188976E-02, .140006E-02, .103154E-02, .754819E-03,
     +  .548809E-03, .395901E-03, .283414E-03, .201015E-03,
     +  .141965E-03, .991332E-04, .687019E-04, .471906E-04 /
        DATA (UPDI(I),I=2081,2132) /
     +  .321537E-04, .216875E-04, .144754E-04, .951830E-05,
     +  .611563E-05, .380790E-05, .225768E-05, .123847E-05,
     +  .601422E-06, .236297E-06, .609493E-07, .504320E-08,
     +  .000000E+00, .906694E+06, .687222E+06, .512090E+06,
     +  .381296E+06, .283713E+06, .210922E+06, .156690E+06,
     +  .116294E+06, .862438E+05, .638954E+05, .472969E+05,
     +  .349733E+05, .258364E+05, .190648E+05, .140537E+05,
     +  .103470E+05, .760952E+04, .558884E+04, .409983E+04,
     +  .300322E+04, .219711E+04, .160490E+04, .117069E+04,
     +  .852549E+03, .619946E+03, .450018E+03, .326271E+03,
     +  .235043E+03, .169862E+03, .122552E+03, .883036E+02,
     +  .635359E+02, .456647E+02, .328200E+02, .235604E+02,
     +  .169105E+02, .121450E+02, .872898E+01, .628455E+01 /
        DATA (UPDI(I),I=2133,2184) /
     +  .453261E+01, .327965E+01, .237970E+01, .173303E+01,
     +  .126678E+01, .930037E+00, .685440E+00, .508041E+00,
     +  .377220E+00, .281841E+00, .210861E+00, .158472E+00,
     +  .119399E+00, .902049E-01, .682663E-01, .517507E-01,
     +  .392508E-01, .297855E-01, .225945E-01, .171348E-01,
     +  .129752E-01, .981293E-02, .740400E-02, .557240E-02,
     +  .418581E-02, .312737E-02, .232554E-02, .172156E-02,
     +  .126756E-02, .928426E-03, .675744E-03, .488965E-03,
     +  .351347E-03, .250789E-03, .177622E-03, .125435E-03,
     +  .877605E-04, .610547E-04, .421938E-04, .289764E-04,
     +  .197318E-04, .133014E-04, .883067E-05, .571705E-05,
     +  .357581E-05, .211923E-05, .115556E-05, .553415E-06,
     +  .212426E-06, .532440E-07, .452542E-08, .000000E+00 /
        DATA (UPDI(I),I=2185,2236) /
     +  .120875E+07, .912663E+06, .677019E+06, .501822E+06,
     +  .371688E+06, .275055E+06, .203384E+06, .150245E+06,
     +  .110895E+06, .817679E+05, .602356E+05, .443249E+05,
     +  .325845E+05, .239256E+05, .175488E+05, .128552E+05,
     +  .940599E+04, .687279E+04, .501551E+04, .365471E+04,
     +  .265953E+04, .193226E+04, .140182E+04, .101527E+04,
     +  .734165E+03, .529919E+03, .382003E+03, .273578E+03,
     +  .196550E+03, .140965E+03, .100958E+03, .721970E+02,
     +  .515667E+02, .368291E+02, .262686E+02, .187320E+02,
     +  .133643E+02, .954132E+01, .682293E+01, .488741E+01,
     +  .351198E+01, .253064E+01, .183008E+01, .132839E+01,
     +  .968416E+00, .708722E+00, .521616E+00, .384587E+00,
     +  .285329E+00, .211980E+00, .158200E+00, .118371E+00 /
        DATA (UPDI(I),I=2237,2288) /
     +  .888065E-01, .667443E-01, .502456E-01, .378469E-01,
     +  .285221E-01, .214881E-01, .161835E-01, .121714E-01,
     +  .914213E-02, .685143E-02, .512169E-02, .382163E-02,
     +  .283641E-02, .209574E-02, .154187E-02, .112864E-02,
     +  .822147E-03, .595463E-03, .429029E-03, .307236E-03,
     +  .218797E-03, .154822E-03, .109375E-03, .766878E-04,
     +  .535490E-04, .372038E-04, .257121E-04, .176317E-04,
     +  .119619E-04, .798211E-05, .518048E-05, .323726E-05,
     +  .190796E-05, .102927E-05, .484332E-06, .181183E-06,
     +  .440931E-07, .383020E-08, .000000E+00, .157905E+07,
     +  .118778E+07, .877197E+06, .647299E+06, .477283E+06,
     +  .351595E+06, .258790E+06, .190293E+06, .139800E+06,
     +  .102596E+06, .752204E+05, .550868E+05, .403000E+05 /
        DATA (UPDI(I),I=2289,2340) /
     +  .294465E+05, .214917E+05, .156653E+05, .114044E+05,
     +  .829073E+04, .601920E+04, .436335E+04, .315855E+04,
     +  .228265E+04, .164713E+04, .118646E+04, .853238E+03,
     +  .612426E+03, .438984E+03, .312564E+03, .223257E+03,
     +  .159181E+03, .113324E+03, .805516E+02, .571806E+02,
     +  .405854E+02, .287647E+02, .203807E+02, .144459E+02,
     +  .102459E+02, .727801E+01, .517846E+01, .369590E+01,
     +  .264504E+01, .189970E+01, .136947E+01, .991475E+00,
     +  .720600E+00, .526710E+00, .385672E+00, .284164E+00,
     +  .209667E+00, .155403E+00, .115488E+00, .860539E-01,
     +  .642376E-01, .480296E-01, .359337E-01, .268974E-01,
     +  .201283E-01, .150575E-01, .112492E-01, .839330E-02,
     +  .624904E-02, .464081E-02, .344055E-02, .253740E-02 /
        DATA (UPDI(I),I=2341,2392) /
     +  .186341E-02, .136294E-02, .992224E-03, .719134E-03,
     +  .518554E-03, .372217E-03, .265803E-03, .188968E-03,
     +  .133663E-03, .945051E-04, .664157E-04, .465400E-04,
     +  .324829E-04, .225616E-04, .155468E-04, .105857E-04,
     +  .707646E-05, .458765E-05, .285391E-05, .166726E-05,
     +  .887294E-06, .409348E-06, .149063E-06, .352247E-07,
     +  .311860E-08, .000000E+00, .202668E+07, .151888E+07,
     +  .111682E+07, .820502E+06, .602309E+06, .441715E+06,
     +  .323655E+06, .236906E+06, .173245E+06, .126552E+06,
     +  .923499E+05, .673122E+05, .490089E+05, .356376E+05,
     +  .258838E+05, .187740E+05, .135998E+05, .983716E+04,
     +  .710573E+04, .512461E+04, .369039E+04, .265304E+04,
     +  .190426E+04, .136432E+04, .975820E+03, .696548E+03 /
        DATA (UPDI(I),I=2393,2444) /
     +  .496496E+03, .351492E+03, .249627E+03, .176953E+03,
     +  .125236E+03, .884890E+02, .624350E+02, .440441E+02,
     +  .310215E+02, .218413E+02, .153821E+02, .108394E+02,
     +  .764923E+01, .540673E+01, .383311E+01, .272488E+01,
     +  .194386E+01, .139187E+01, .100087E+01, .722505E+00,
     +  .524539E+00, .381485E+00, .279182E+00, .204604E+00,
     +  .150632E+00, .111197E+00, .823027E-01, .610293E-01,
     +  .453266E-01, .336873E-01, .250494E-01, .186225E-01,
     +  .138396E-01, .102723E-01, .761481E-02, .563338E-02,
     +  .415711E-02, .306289E-02, .224519E-02, .163930E-02,
     +  .119245E-02, .863712E-03, .623121E-03, .447560E-03,
     +  .320231E-03, .228169E-03, .162030E-03, .114621E-03,
     +  .811373E-04, .571588E-04, .401838E-04, .281536E-04 /
        DATA (UPDI(I),I=2445,2496) /
     +  .196266E-04, .135648E-04, .924828E-05, .617745E-05,
     +  .398977E-05, .246451E-05, .142393E-05, .746157E-06,
     +  .337038E-06, .119406E-06, .274144E-07, .246943E-08,
     +  .000000E+00, .256061E+07, .191209E+07, .139990E+07,
     +  .102403E+07, .748432E+06, .546462E+06, .398625E+06,
     +  .290476E+06, .211458E+06, .153761E+06, .111688E+06,
     +  .810286E+05, .587182E+05, .424954E+05, .307166E+05,
     +  .221716E+05, .159823E+05, .115034E+05, .826779E+04,
     +  .593259E+04, .425041E+04, .303987E+04, .217051E+04,
     +  .154685E+04, .110045E+04, .781239E+03, .553802E+03,
     +  .389850E+03, .275309E+03, .194047E+03, .136538E+03,
     +  .959100E+02, .672679E+02, .471681E+02, .330182E+02,
     +  .231030E+02, .161683E+02, .113211E+02, .793779E+01 /
        DATA (UPDI(I),I=2497,2548) /
     +  .557435E+01, .392609E+01, .277264E+01, .196486E+01,
     +  .139759E+01, .998303E+00, .715865E+00, .516276E+00,
     +  .372982E+00, .271151E+00, .197406E+00, .144374E+00,
     +  .105880E+00, .778543E-01, .573544E-01, .423192E-01,
     +  .312484E-01, .230857E-01, .170527E-01, .125917E-01,
     +  .928700E-02, .684117E-02, .502985E-02, .368907E-02,
     +  .270191E-02, .196915E-02, .142990E-02, .103480E-02,
     +  .746037E-03, .536004E-03, .383670E-03, .273788E-03,
     +  .194750E-03, .138215E-03, .978225E-04, .693450E-04,
     +  .489669E-04, .345227E-04, .242588E-04, .169518E-04,
     +  .117310E-04, .799286E-05, .532337E-05, .341818E-05,
     +  .209256E-05, .119380E-05, .615137E-06, .271811E-06,
     +  .936716E-07, .209121E-07, .191425E-08, .000000E+00 /
        DATA (UPDI(I),I=2549,2600) /
     +  .580167E+05, .199745E+05, .155596E+05, .121206E+05,
     +  .944179E+04, .735512E+04, .572970E+04, .446356E+04,
     +  .347730E+04, .270903E+04, .211058E+04, .164440E+04,
     +  .128126E+04, .998383E+03, .778021E+03, .606358E+03,
     +  .472629E+03, .368450E+03, .287288E+03, .224057E+03,
     +  .174792E+03, .136407E+03, .106497E+03, .831887E+02,
     +  .650232E+02, .508637E+02, .398251E+02, .311100E+02,
     +  .244222E+02, .192033E+02, .151287E+02, .119456E+02,
     +  .945698E+01, .751455E+01, .598826E+01, .479069E+01,
     +  .384895E+01, .310630E+01, .251861E+01, .205138E+01,
     +  .167863E+01, .137908E+01, .113700E+01, .940092E+00,
     +  .778909E+00, .646178E+00, .536659E+00, .444986E+00,
     +  .368918E+00, .304867E+00, .251406E+00, .206601E+00 /
        DATA (UPDI(I),I=2601,2652) /
     +  .169085E+00, .137730E+00, .111599E+00, .898991E-01,
     +  .719588E-01, .572027E-01, .451362E-01, .353324E-01,
     +  .274229E-01, .210902E-01, .160613E-01, .121193E-01,
     +  .902632E-02, .664104E-02, .482192E-02, .345126E-02,
     +  .243198E-02, .168478E-02, .114556E-02, .763060E-03,
     +  .496699E-03, .314967E-03, .194880E-03, .116413E-03,
     +  .670690E-04, .370664E-04, .195200E-04, .971332E-05,
     +  .451812E-05, .193976E-05, .749503E-06, .255767E-06,
     +  .738096E-07, .169449E-07, .279329E-08, .272819E-09,
     +  .102534E-10, .372859E-13, .000000E+00, .547753E+05,
     +  .353983E+05, .275786E+05, .214768E+05, .167269E+05,
     +  .130216E+05, .101379E+05, .788904E+04, .613947E+04,
     +  .477549E+04, .371473E+04, .288807E+04, .224545E+04 /
        DATA (UPDI(I),I=2653,2704) /
     +  .174487E+04, .135591E+04, .105307E+04, .817887E+03,
     +  .634866E+03, .492816E+03, .382341E+03, .296658E+03,
     +  .230064E+03, .178447E+03, .138357E+03, .107304E+03,
     +  .832079E+02, .645586E+02, .499175E+02, .387726E+02,
     +  .301302E+02, .234485E+02, .182682E+02, .142624E+02,
     +  .111634E+02, .875896E+01, .689159E+01, .544397E+01,
     +  .431564E+01, .343701E+01, .274784E+01, .220785E+01,
     +  .178055E+01, .144195E+01, .117120E+01, .954247E+00,
     +  .778770E+00, .637094E+00, .520594E+00, .426008E+00,
     +  .347698E+00, .283604E+00, .230711E+00, .187193E+00,
     +  .151315E+00, .121861E+00, .976662E-01, .779010E-01,
     +  .617820E-01, .487272E-01, .381778E-01, .297209E-01,
     +  .229675E-01, .176169E-01, .134205E-01, .101206E-01 /
        DATA (UPDI(I),I=2705,2756) /
     +  .755846E-02, .558959E-02, .408756E-02, .295449E-02,
     +  .210624E-02, .147944E-02, .101991E-02, .688585E-03,
     +  .450785E-03, .285938E-03, .171153E-03, .937781E-04,
     +  .432256E-04, .114545E-04, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .738626E+05, .579448E+05,
     +  .449326E+05, .348261E+05, .269914E+05, .209087E+05,
     +  .161955E+05, .125381E+05, .970569E+04, .750892E+04,
     +  .580863E+04, .449070E+04, .347127E+04, .268160E+04,
     +  .207122E+04, .159874E+04, .123381E+04, .951542E+03,
     +  .733712E+03, .565369E+03, .435587E+03, .335382E+03,
     +  .258202E+03, .198668E+03, .152860E+03, .117569E+03 /
        DATA (UPDI(I),I=2757,2808) /
     +  .904533E+02, .693223E+02, .533566E+02, .410743E+02,
     +  .316529E+02, .244102E+02, .188559E+02, .145975E+02,
     +  .113231E+02, .880432E+01, .687047E+01, .537863E+01,
     +  .422901E+01, .333736E+01, .264669E+01, .210677E+01,
     +  .168416E+01, .135065E+01, .108692E+01, .876493E+00,
     +  .708902E+00, .572942E+00, .464067E+00, .375094E+00,
     +  .303197E+00, .244587E+00, .196927E+00, .158068E+00,
     +  .126495E+00, .100806E+00, .800029E-01, .631747E-01,
     +  .496464E-01, .387848E-01, .301284E-01, .232498E-01,
     +  .178215E-01, .135786E-01, .102485E-01, .766563E-02,
     +  .568121E-02, .416620E-02, .302134E-02, .216177E-02,
     +  .152413E-02, .105450E-02, .713964E-03, .468057E-03,
     +  .296759E-03, .176799E-03, .958395E-04, .429822E-04 /
        DATA (UPDI(I),I=2809,2860) /
     +  .107520E-04, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .115955E+06, .905136E+05, .697908E+05,
     +  .537862E+05, .414450E+05, .319187E+05, .245775E+05,
     +  .189142E+05, .145528E+05, .111905E+05, .860298E+04,
     +  .660963E+04, .507680E+04, .389688E+04, .299033E+04,
     +  .229308E+04, .175786E+04, .134659E+04, .103120E+04,
     +  .789098E+03, .603660E+03, .461465E+03, .352669E+03,
     +  .269340E+03, .205659E+03, .156953E+03, .119799E+03,
     +  .910573E+02, .695002E+02, .530442E+02, .405163E+02,
     +  .309624E+02, .236926E+02, .181658E+02, .139505E+02,
     +  .107365E+02, .829010E+01, .642027E+01, .499254E+01 /
        DATA (UPDI(I),I=2861,2912) /
     +  .389610E+01, .305513E+01, .240463E+01, .190076E+01,
     +  .150756E+01, .120008E+01, .957563E+00, .766612E+00,
     +  .613498E+00, .492285E+00, .394351E+00, .316072E+00,
     +  .252947E+00, .202138E+00, .161124E+00, .128105E+00,
     +  .101480E+00, .800955E-01, .629335E-01, .492365E-01,
     +  .383141E-01, .296632E-01, .228282E-01, .174613E-01,
     +  .132855E-01, .100204E-01, .749640E-02, .556246E-02,
     +  .408912E-02, .297732E-02, .214305E-02, .152403E-02,
     +  .106770E-02, .735769E-03, .495298E-03, .326713E-03,
     +  .207535E-03, .126090E-03, .716964E-04, .376408E-04,
     +  .205066E-04, .126079E-04, .743667E-05, .416325E-05,
     +  .219400E-05, .107695E-05, .479832E-06, .191625E-06,
     +  .655868E-07, .156337E-07, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=2913,2964) /
     +  .173917E+06, .135092E+06, .103578E+06, .793755E+05,
     +  .608132E+05, .465660E+05, .356470E+05, .272725E+05,
     +  .208591E+05, .159441E+05, .121832E+05, .930339E+04,
     +  .710175E+04, .541738E+04, .413092E+04, .314764E+04,
     +  .239744E+04, .182463E+04, .138809E+04, .105515E+04,
     +  .801743E+03, .608714E+03, .461975E+03, .350343E+03,
     +  .265594E+03, .201221E+03, .152451E+03, .114989E+03,
     +  .870870E+02, .659429E+02, .499602E+02, .378633E+02,
     +  .287258E+02, .218331E+02, .166160E+02, .126704E+02,
     +  .969090E+01, .743293E+01, .572320E+01, .442195E+01,
     +  .343267E+01, .267467E+01, .209298E+01, .164357E+01,
     +  .129555E+01, .102387E+01, .812096E+00, .644038E+00,
     +  .512323E+00, .406985E+00, .323602E+00, .257016E+00 /
        DATA (UPDI(I),I=2965,3016) /
     +  .203911E+00, .161433E+00, .127525E+00, .100410E+00,
     +  .788000E-01, .615883E-01, .479464E-01, .371414E-01,
     +  .286362E-01, .219560E-01, .167383E-01, .126988E-01,
     +  .955453E-02, .713426E-02, .528684E-02, .388428E-02,
     +  .282896E-02, .203913E-02, .145421E-02, .102374E-02,
     +  .710754E-03, .484175E-03, .325045E-03, .212276E-03,
     +  .134846E-03, .826821E-04, .495766E-04, .312534E-04,
     +  .210325E-04, .139058E-04, .899122E-05, .564894E-05,
     +  .340972E-05, .192638E-05, .983655E-06, .420479E-06,
     +  .121780E-06, .907329E-08, .000000E+00, .197196E+06,
     +  .194110E+06, .148031E+06, .112830E+06, .859727E+05,
     +  .654702E+05, .498402E+05, .379183E+05, .288375E+05,
     +  .219171E+05, .166508E+05, .126412E+05, .959299E+04 /
        DATA (UPDI(I),I=3017,3068) /
     +  .727448E+04, .551379E+04, .417601E+04, .316126E+04,
     +  .239113E+04, .180768E+04, .136545E+04, .103088E+04,
     +  .777627E+03, .586293E+03, .441669E+03, .332564E+03,
     +  .250232E+03, .188260E+03, .140978E+03, .105995E+03,
     +  .796685E+02, .599026E+02, .450484E+02, .339061E+02,
     +  .255627E+02, .192928E+02, .145871E+02, .110599E+02,
     +  .840814E+01, .641578E+01, .491198E+01, .377802E+01,
     +  .291668E+01, .226133E+01, .175959E+01, .137449E+01,
     +  .107666E+01, .846592E+00, .665742E+00, .525281E+00,
     +  .413993E+00, .326679E+00, .257579E+00, .202934E+00,
     +  .159594E+00, .125270E+00, .980387E-01, .764949E-01,
     +  .594608E-01, .460501E-01, .354988E-01, .272439E-01,
     +  .207992E-01, .157929E-01, .119372E-01, .895082E-02 /
        DATA (UPDI(I),I=3069,3120) /
     +  .666315E-02, .492463E-02, .361034E-02, .262517E-02,
     +  .189054E-02, .134823E-02, .950349E-03, .661709E-03,
     +  .453310E-03, .307026E-03, .203440E-03, .132222E-03,
     +  .841038E-04, .532912E-04, .352483E-04, .242656E-04,
     +  .164449E-04, .109024E-04, .701138E-05, .431079E-05,
     +  .246494E-05, .126102E-05, .532499E-06, .150526E-06,
     +  .119086E-07, .000000E+00, .364402E+06, .280363E+06,
     +  .212609E+06, .161139E+06, .122082E+06, .924348E+05,
     +  .699576E+05, .529123E+05, .400016E+05, .302208E+05,
     +  .228202E+05, .172195E+05, .129865E+05, .978667E+04,
     +  .737109E+04, .554726E+04, .417221E+04, .313533E+04,
     +  .235465E+04, .176680E+04, .132487E+04, .992590E+03,
     +  .743170E+03, .555931E+03, .415611E+03, .310458E+03 /
        DATA (UPDI(I),I=3121,3172) /
     +  .231852E+03, .172305E+03, .128559E+03, .958800E+02,
     +  .715188E+02, .533503E+02, .398212E+02, .297700E+02,
     +  .222733E+02, .166924E+02, .125418E+02, .944756E+01,
     +  .714154E+01, .541623E+01, .412617E+01, .315517E+01,
     +  .242284E+01, .186747E+01, .144507E+01, .112153E+01,
     +  .873920E+00, .681173E+00, .532851E+00, .416469E+00,
     +  .325984E+00, .255045E+00, .199432E+00, .155714E+00,
     +  .121375E+00, .943576E-01, .731480E-01, .565084E-01,
     +  .435007E-01, .333403E-01, .254430E-01, .193183E-01,
     +  .145888E-01, .109678E-01, .817874E-02, .605447E-02,
     +  .444861E-02, .324119E-02, .234073E-02, .167298E-02,
     +  .118267E-02, .825148E-03, .567450E-03, .382946E-03,
     +  .254545E-03, .164702E-03, .103820E-03, .635377E-04 /
        DATA (UPDI(I),I=3173,3224) /
     +  .384018E-04, .239716E-04, .154427E-04, .975056E-05,
     +  .601039E-05, .359965E-05, .207405E-05, .112164E-05,
     +  .550405E-06, .225896E-06, .626799E-07, .467676E-08,
     +  .000000E+00, .513249E+06, .393052E+06, .296462E+06,
     +  .223479E+06, .168384E+06, .126791E+06, .954237E+05,
     +  .717680E+05, .539478E+05, .405234E+05, .304221E+05,
     +  .228215E+05, .171093E+05, .128166E+05, .959473E+04,
     +  .717665E+04, .536429E+04, .400600E+04, .298949E+04,
     +  .222882E+04, .166048E+04, .123588E+04, .919170E+03,
     +  .682962E+03, .507084E+03, .376159E+03, .278935E+03,
     +  .205791E+03, .152422E+03, .112836E+03, .835289E+02,
     +  .618301E+02, .457868E+02, .339564E+02, .251969E+02,
     +  .187261E+02, .139499E+02, .104175E+02, .780541E+01 /
        DATA (UPDI(I),I=3225,3276) /
     +  .586724E+01, .442966E+01, .335682E+01, .255445E+01,
     +  .195131E+01, .149650E+01, .115127E+01, .889362E+00,
     +  .687342E+00, .533231E+00, .413403E+00, .321042E+00,
     +  .249271E+00, .193474E+00, .149982E+00, .116092E+00,
     +  .896436E-01, .690387E-01, .529973E-01, .405464E-01,
     +  .308915E-01, .234377E-01, .176963E-01, .132906E-01,
     +  .993873E-02, .737265E-02, .543033E-02, .397059E-02,
     +  .287952E-02, .207036E-02, .147376E-02, .103807E-02,
     +  .722167E-03, .495640E-03, .334415E-03, .222707E-03,
     +  .144939E-03, .924256E-04, .577890E-04, .360850E-04,
     +  .232202E-04, .152686E-04, .987761E-05, .624775E-05,
     +  .383764E-05, .225567E-05, .123423E-05, .603598E-06,
     +  .241678E-06, .640925E-07, .510405E-08, .000000E+00 /
        DATA (UPDI(I),I=3277,3328) /
     +  .704746E+06, .537316E+06, .403184E+06, .302349E+06,
     +  .226613E+06, .169732E+06, .127058E+06, .950435E+05,
     +  .710533E+05, .530780E+05, .396248E+05, .295576E+05,
     +  .220331E+05, .164100E+05, .122132E+05, .908146E+04,
     +  .674761E+04, .500872E+04, .371496E+04, .275262E+04,
     +  .203790E+04, .150720E+04, .111376E+04, .822174E+03,
     +  .606418E+03, .446830E+03, .329086E+03, .241092E+03,
     +  .177313E+03, .130327E+03, .957746E+02, .703707E+02,
     +  .517175E+02, .380610E+02, .280210E+02, .206590E+02,
     +  .152645E+02, .113053E+02, .839967E+01, .626061E+01,
     +  .468628E+01, .352090E+01, .265628E+01, .201178E+01,
     +  .152974E+01, .116695E+01, .894013E+00, .685294E+00,
     +  .527390E+00, .405670E+00, .312623E+00, .240928E+00 /
        DATA (UPDI(I),I=3329,3380) /
     +  .185637E+00, .142889E+00, .109836E+00, .842429E-01,
     +  .644534E-01, .491619E-01, .373769E-01, .283040E-01,
     +  .213467E-01, .160244E-01, .119663E-01, .889858E-02,
     +  .656481E-02, .480961E-02, .349855E-02, .252463E-02,
     +  .180659E-02, .128040E-02, .898328E-03, .622944E-03,
     +  .426582E-03, .287667E-03, .191868E-03, .125513E-03,
     +  .808622E-04, .514819E-04, .329678E-04, .216881E-04,
     +  .144754E-04, .951830E-05, .611563E-05, .380790E-05,
     +  .225768E-05, .123847E-05, .601422E-06, .236297E-06,
     +  .609493E-07, .504320E-08, .000000E+00, .946948E+06,
     +  .718905E+06, .536754E+06, .400493E+06, .298650E+06,
     +  .222542E+06, .165727E+06, .123322E+06, .917065E+05,
     +  .681407E+05, .505951E+05, .375349E+05, .278253E+05 /
        DATA (UPDI(I),I=3381,3432) /
     +  .206085E+05, .152514E+05, .112759E+05, .832975E+04,
     +  .614706E+04, .453231E+04, .333817E+04, .245643E+04,
     +  .180559E+04, .132596E+04, .972649E+03, .712817E+03,
     +  .521814E+03, .381776E+03, .277796E+03, .202918E+03,
     +  .148118E+03, .108083E+03, .788476E+02, .575250E+02,
     +  .420224E+02, .307036E+02, .224633E+02, .164679E+02,
     +  .121001E+02, .891798E+01, .659307E+01, .489475E+01,
     +  .364734E+01, .272899E+01, .204989E+01, .154597E+01,
     +  .116977E+01, .889010E+00, .676068E+00, .516250E+00,
     +  .394067E+00, .301410E+00, .230591E+00, .176400E+00,
     +  .134830E+00, .102929E+00, .784173E-01, .596028E-01,
     +  .451712E-01, .341268E-01, .256842E-01, .192539E-01,
     +  .143682E-01, .106670E-01, .788712E-02, .578584E-02 /
        DATA (UPDI(I),I=3433,3484) /
     +  .421574E-02, .305028E-02, .218994E-02, .155949E-02,
     +  .110034E-02, .768926E-03, .531488E-03, .363160E-03,
     +  .244775E-03, .163513E-03, .107491E-03, .699051E-04,
     +  .452025E-04, .295225E-04, .197323E-04, .133014E-04,
     +  .883067E-05, .571705E-05, .357581E-05, .211923E-05,
     +  .115556E-05, .553415E-06, .212426E-06, .532440E-07,
     +  .452542E-08, .000000E+00, .124845E+07, .943902E+06,
     +  .701335E+06, .520745E+06, .386412E+06, .286508E+06,
     +  .212290E+06, .157169E+06, .116277E+06, .859497E+05,
     +  .634839E+05, .468474E+05, .345426E+05, .254451E+05,
     +  .187275E+05, .137692E+05, .101145E+05, .742177E+04,
     +  .544072E+04, .398393E+04, .291433E+04, .212939E+04,
     +  .155429E+04, .113315E+04, .825274E+03, .600316E+03 /
        DATA (UPDI(I),I=3485,3536) /
     +  .436395E+03, .315446E+03, .228898E+03, .165963E+03,
     +  .120279E+03, .871369E+02, .631239E+02, .457829E+02,
     +  .332069E+02, .241148E+02, .175453E+02, .127934E+02,
     +  .935597E+01, .686289E+01, .505491E+01, .373689E+01,
     +  .277379E+01, .206705E+01, .154659E+01, .116106E+01,
     +  .875554E+00, .660718E+00, .500714E+00, .379357E+00,
     +  .288035E+00, .218780E+00, .166184E+00, .126145E+00,
     +  .956448E-01, .723833E-01, .546573E-01, .411583E-01,
     +  .308991E-01, .231117E-01, .172202E-01, .127742E-01,
     +  .942780E-02, .693064E-02, .505528E-02, .366311E-02,
     +  .263625E-02, .188302E-02, .133446E-02, .937420E-03,
     +  .652548E-03, .449674E-03, .306674E-03, .206659E-03,
     +  .138306E-03, .913769E-04, .599596E-04, .393046E-04 /
        DATA (UPDI(I),I=3537,3588) /
     +  .260775E-04, .176321E-04, .119619E-04, .798211E-05,
     +  .518048E-05, .323726E-05, .190796E-05, .102927E-05,
     +  .484332E-06, .181183E-06, .440931E-07, .383020E-08,
     +  .000000E+00, .161819E+07, .121858E+07, .901169E+06,
     +  .665953E+06, .491794E+06, .362882E+06, .267566E+06,
     +  .197115E+06, .145101E+06, .106715E+06, .784192E+05,
     +  .575704E+05, .422276E+05, .309420E+05, .226516E+05,
     +  .165645E+05, .121013E+05, .883055E+04, .643719E+04,
     +  .468688E+04, .340886E+04, .247624E+04, .179680E+04,
     +  .130212E+04, .942594E+03, .681430E+03, .492267E+03,
     +  .353549E+03, .254899E+03, .183611E+03, .132186E+03,
     +  .951194E+02, .684346E+02, .492906E+02, .354980E+02,
     +  .255935E+02, .184853E+02, .133794E+02, .971131E+01 /
        DATA (UPDI(I),I=3589,3640) /
     +  .706980E+01, .516765E+01, .379101E+01, .279236E+01,
     +  .206493E+01, .153318E+01, .114223E+01, .854874E+00,
     +  .640282E+00, .481649E+00, .362252E+00, .273075E+00,
     +  .205957E+00, .155359E+00, .117124E+00, .882084E-01,
     +  .663155E-01, .497507E-01, .372251E-01, .277708E-01,
     +  .206439E-01, .152881E-01, .112734E-01, .827114E-02,
     +  .604525E-02, .438443E-02, .315955E-02, .226180E-02,
     +  .160743E-02, .113379E-02, .793095E-03, .550089E-03,
     +  .378038E-03, .257437E-03, .173518E-03, .116392E-03,
     +  .773012E-04, .511616E-04, .339439E-04, .228054E-04,
     +  .155471E-04, .105857E-04, .707646E-05, .458765E-05,
     +  .285391E-05, .166726E-05, .887294E-06, .409348E-06,
     +  .149063E-06, .352247E-07, .311860E-08, .000000E+00 /
        DATA (UPDI(I),I=3641,3692) /
     +  .206527E+07, .154925E+07, .114045E+07, .838888E+06,
     +  .616611E+06, .452837E+06, .332302E+06, .243627E+06,
     +  .178467E+06, .130609E+06, .954998E+05, .697574E+05,
     +  .509063E+05, .371094E+05, .270250E+05, .196586E+05,
     +  .142851E+05, .103679E+05, .751657E+04, .544251E+04,
     +  .393626E+04, .284312E+04, .205115E+04, .147778E+04,
     +  .106343E+04, .764164E+03, .548673E+03, .391596E+03,
     +  .280563E+03, .200815E+03, .143639E+03, .102684E+03,
     +  .733854E+02, .525003E+02, .375498E+02, .268843E+02,
     +  .192802E+02, .138549E+02, .998358E+01, .721487E+01,
     +  .523479E+01, .381180E+01, .278677E+01, .204547E+01,
     +  .150744E+01, .111474E+01, .828185E+00, .615762E+00,
     +  .459868E+00, .343401E+00, .257044E+00, .192526E+00 /
        DATA (UPDI(I),I=3693,3744) /
     +  .144235E+00, .108007E+00, .808022E-01, .603512E-01,
     +  .449852E-01, .334466E-01, .247963E-01, .183198E-01,
     +  .134850E-01, .988483E-02, .720987E-02, .523938E-02,
     +  .377860E-02, .270822E-02, .192864E-02, .136396E-02,
     +  .957727E-03, .667284E-03, .461311E-03, .316298E-03,
     +  .215180E-03, .145142E-03, .976255E-04, .651888E-04,
     +  .435003E-04, .291656E-04, .197888E-04, .135650E-04,
     +  .924828E-05, .617745E-05, .398977E-05, .246451E-05,
     +  .142393E-05, .746157E-06, .337038E-06, .119406E-06,
     +  .274144E-07, .246943E-08, .000000E+00, .259865E+07,
     +  .194203E+07, .142320E+07, .104215E+07, .762526E+06,
     +  .557421E+06, .407145E+06, .297097E+06, .216601E+06,
     +  .157756E+06, .114789E+06, .834357E+05, .605856E+05 /
        DATA (UPDI(I),I=3745,3796) /
     +  .439436E+05, .318393E+05, .230415E+05, .166562E+05,
     +  .120251E+05, .867151E+04, .624487E+04, .449185E+04,
     +  .322645E+04, .231463E+04, .165813E+04, .118632E+04,
     +  .847471E+03, .604876E+03, .429076E+03, .305540E+03,
     +  .217341E+03, .154483E+03, .109733E+03, .779147E+02,
     +  .553754E+02, .393416E+02, .279766E+02, .199257E+02,
     +  .142193E+02, .101741E+02, .730039E+01, .525892E+01,
     +  .380181E+01, .275937E+01, .201072E+01, .147111E+01,
     +  .108003E+01, .796662E+00, .588097E+00, .436113E+00,
     +  .323384E+00, .240391E+00, .178828E+00, .133072E+00,
     +  .989873E-01, .735692E-01, .545944E-01, .404353E-01,
     +  .298754E-01, .220117E-01, .161636E-01, .118266E-01,
     +  .861824E-02, .624957E-02, .451585E-02, .323881E-02 /
        DATA (UPDI(I),I=3797,3848) /
     +  .230904E-02, .163609E-02, .115164E-02, .805206E-03,
     +  .558973E-03, .385319E-03, .263710E-03, .179321E-03,
     +  .121103E-03, .817135E-04, .548641E-04, .368921E-04,
     +  .249572E-04, .170595E-04, .117312E-04, .799286E-05,
     +  .532337E-05, .341818E-05, .209256E-05, .119380E-05,
     +  .615137E-06, .271811E-06, .936716E-07, .209121E-07,
     +  .191425E-08, .000000E+00, .477313E+05, .503573E+05,
     +  .392281E+05, .305589E+05, .238059E+05, .185455E+05,
     +  .144479E+05, .112559E+05, .876943E+04, .683250E+04,
     +  .532365E+04, .414824E+04, .323259E+04, .251927E+04,
     +  .196356E+04, .153063E+04, .119334E+04, .930558E+03,
     +  .725810E+03, .566272E+03, .441956E+03, .345076E+03,
     +  .269571E+03, .210718E+03, .164839E+03, .129067E+03 /
        DATA (UPDI(I),I=3849,3900) /
     +  .101169E+03, .791358E+02, .622206E+02, .490143E+02,
     +  .386984E+02, .306351E+02, .243272E+02, .194007E+02,
     +  .155269E+02, .124852E+02, .100914E+02, .820175E+01,
     +  .670462E+01, .551247E+01, .455929E+01, .379096E+01,
     +  .316738E+01, .265725E+01, .223651E+01, .188669E+01,
     +  .159465E+01, .134676E+01, .113776E+01, .958607E+00,
     +  .806136E+00, .675670E+00, .564028E+00, .468604E+00,
     +  .387229E+00, .318070E+00, .259547E+00, .210283E+00,
     +  .169061E+00, .134801E+00, .106536E+00, .834026E-01,
     +  .646330E-01, .496070E-01, .375725E-01, .281023E-01,
     +  .207363E-01, .150783E-01, .107910E-01, .758992E-02,
     +  .523808E-02, .354036E-02, .233775E-02, .150340E-02,
     +  .943015E-03, .570981E-03, .333347E-03, .186639E-03 /
        DATA (UPDI(I),I=3901,3952) /
     +  .995507E-04, .501620E-04, .236217E-04, .102646E-04,
     +  .401368E-05, .138574E-05, .404513E-06, .939202E-07,
     +  .156552E-07, .154582E-08, .587245E-10, .215820E-12,
     +  .000000E+00, .446682E+05, .652284E+05, .508163E+05,
     +  .395799E+05, .308298E+05, .240087E+05, .186976E+05,
     +  .145581E+05, .113356E+05, .882425E+04, .686959E+04,
     +  .534665E+04, .416152E+04, .323835E+04, .252012E+04,
     +  .196077E+04, .152570E+04, .118696E+04, .923548E+03,
     +  .718513E+03, .559126E+03, .435093E+03, .338696E+03,
     +  .263698E+03, .205422E+03, .160094E+03, .124882E+03,
     +  .971539E+02, .759567E+02, .594627E+02, .466431E+02,
     +  .366622E+02, .288974E+02, .228598E+02, .181421E+02,
     +  .144561E+02, .115749E+02, .931329E+01, .753498E+01 /
        DATA (UPDI(I),I=3953,4004) /
     +  .612791E+01, .501251E+01, .412013E+01, .340287E+01,
     +  .282133E+01, .234709E+01, .195686E+01, .163517E+01,
     +  .136527E+01, .114082E+01, .950798E+00, .791292E+00,
     +  .656525E+00, .542756E+00, .446718E+00, .365870E+00,
     +  .297960E+00, .241171E+00, .193888E+00, .154760E+00,
     +  .122563E+00, .962632E-01, .749364E-01, .577781E-01,
     +  .441539E-01, .333207E-01, .248498E-01, .182992E-01,
     +  .132916E-01, .951234E-02, .669730E-02, .463189E-02,
     +  .313932E-02, .208023E-02, .134035E-02, .840369E-03,
     +  .504586E-03, .287007E-03, .150583E-03, .682328E-04,
     +  .214575E-04, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=4005,4056) /
     +  .111201E+06, .873478E+05, .678376E+05, .526703E+05,
     +  .408924E+05, .317388E+05, .246329E+05, .191120E+05,
     +  .148276E+05, .115000E+05, .891856E+04, .691433E+04,
     +  .536014E+04, .415393E+04, .321897E+04, .249364E+04,
     +  .193168E+04, .149591E+04, .115844E+04, .896882E+03,
     +  .694437E+03, .537605E+03, .416273E+03, .322321E+03,
     +  .249668E+03, .193438E+03, .149986E+03, .115946E+03,
     +  .900628E+02, .700327E+02, .545529E+02, .425705E+02,
     +  .333032E+02, .261413E+02, .205797E+02, .162620E+02,
     +  .129092E+02, .102948E+02, .825340E+01, .664968E+01,
     +  .538794E+01, .438635E+01, .358788E+01, .294606E+01,
     +  .242742E+01, .200465E+01, .165958E+01, .137291E+01,
     +  .113704E+01, .939395E+00, .775221E+00, .637939E+00 /
        DATA (UPDI(I),I=4057,4108) /
     +  .523232E+00, .427373E+00, .347461E+00, .280972E+00,
     +  .225876E+00, .180409E+00, .143107E+00, .112661E+00,
     +  .879894E-01, .681344E-01, .522711E-01, .397623E-01,
     +  .298777E-01, .221943E-01, .162853E-01, .117913E-01,
     +  .841528E-02, .591062E-02, .407914E-02, .275926E-02,
     +  .182471E-02, .117234E-02, .732023E-03, .436175E-03,
     +  .244559E-03, .124526E-03, .524931E-04, .123383E-04,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .152789E+06,
     +  .119519E+06, .923864E+05, .713894E+05, .551584E+05,
     +  .426028E+05, .329011E+05, .253996E+05, .196058E+05,
     +  .151279E+05, .116712E+05, .900079E+04, .694040E+04 /
        DATA (UPDI(I),I=4109,4160) /
     +  .534956E+04, .412279E+04, .317610E+04, .244650E+04,
     +  .188378E+04, .145036E+04, .111629E+04, .859152E+03,
     +  .661082E+03, .508719E+03, .391424E+03, .301249E+03,
     +  .231876E+03, .178595E+03, .137109E+03, .105759E+03,
     +  .816509E+02, .631379E+02, .489006E+02, .379606E+02,
     +  .295625E+02, .230846E+02, .180900E+02, .142383E+02,
     +  .112561E+02, .894423E+01, .714152E+01, .573395E+01,
     +  .462538E+01, .374872E+01, .305002E+01, .249032E+01,
     +  .203818E+01, .167253E+01, .137163E+01, .112643E+01,
     +  .922947E+00, .755547E+00, .616911E+00, .502164E+00,
     +  .407168E+00, .328690E+00, .263973E+00, .210804E+00,
     +  .167296E+00, .131890E+00, .103220E+00, .801626E-01,
     +  .617444E-01, .471305E-01, .356854E-01, .266989E-01 /
        DATA (UPDI(I),I=4161,4212) /
     +  .197565E-01, .144487E-01, .104340E-01, .743346E-02,
     +  .521755E-02, .360373E-02, .244466E-02, .162586E-02,
     +  .105499E-02, .669593E-03, .409895E-03, .240804E-03,
     +  .133671E-03, .682683E-04, .305668E-04, .126098E-04,
     +  .743667E-05, .416325E-05, .219400E-05, .107695E-05,
     +  .479832E-06, .191625E-06, .655868E-07, .156337E-07,
     +  .000000E+00, .000000E+00, .210275E+06, .163723E+06,
     +  .125882E+06, .967511E+05, .743493E+05, .571120E+05,
     +  .438632E+05, .336742E+05, .258470E+05, .198309E+05,
     +  .152120E+05, .116639E+05, .894149E+04, .685151E+04,
     +  .524896E+04, .401946E+04, .307737E+04, .235506E+04,
     +  .180199E+04, .137826E+04, .105407E+04, .805874E+03,
     +  .616116E+03, .470946E+03, .360033E+03, .275247E+03 /
        DATA (UPDI(I),I=4213,4264) /
     +  .210548E+03, .160497E+03, .122919E+03, .942131E+02,
     +  .723144E+02, .555869E+02, .428193E+02, .330859E+02,
     +  .256293E+02, .199206E+02, .155489E+02, .121885E+02,
     +  .960216E+01, .760048E+01, .604925E+01, .483705E+01,
     +  .388595E+01, .313416E+01, .253693E+01, .205863E+01,
     +  .167520E+01, .136248E+01, .110995E+01, .902280E+00,
     +  .732971E+00, .594019E+00, .480025E+00, .386478E+00,
     +  .309854E+00, .247194E+00, .196132E+00, .154682E+00,
     +  .121210E+00, .943091E-01, .728326E-01, .557986E-01,
     +  .423735E-01, .319285E-01, .237788E-01, .175214E-01,
     +  .127650E-01, .918769E-02, .652792E-02, .457325E-02,
     +  .315599E-02, .214214E-02, .142819E-02, .931666E-03,
     +  .596853E-03, .371170E-03, .223906E-03, .130046E-03 /
        DATA (UPDI(I),I=4265,4316) /
     +  .721768E-04, .381899E-04, .210346E-04, .139058E-04,
     +  .899121E-05, .564894E-05, .340972E-05, .192638E-05,
     +  .983655E-06, .420479E-06, .121780E-06, .907329E-08,
     +  .000000E+00, .187582E+06, .222381E+06, .170055E+06,
     +  .129988E+06, .993395E+05, .758844E+05, .579538E+05,
     +  .442401E+05, .337632E+05, .257555E+05, .196419E+05,
     +  .149724E+05, .114100E+05, .869090E+04, .661806E+04,
     +  .503712E+04, .383287E+04, .291510E+04, .221657E+04,
     +  .168466E+04, .128018E+04, .972439E+03, .738612E+03,
     +  .560855E+03, .425901E+03, .323399E+03, .245688E+03,
     +  .185962E+03, .141415E+03, .107613E+03, .819964E+02,
     +  .625619E+02, .478280E+02, .366730E+02, .281858E+02,
     +  .217338E+02, .168273E+02, .130829E+02, .102214E+02 /
        DATA (UPDI(I),I=4317,4368) /
     +  .802322E+01, .633218E+01, .502080E+01, .399972E+01,
     +  .319905E+01, .256806E+01, .206690E+01, .166847E+01,
     +  .134627E+01, .108830E+01, .877979E+00, .707970E+00,
     +  .569633E+00, .457091E+00, .365503E+00, .291088E+00,
     +  .230720E+00, .181907E+00, .142585E+00, .111065E+00,
     +  .859181E-01, .659823E-01, .502789E-01, .379834E-01,
     +  .284787E-01, .211087E-01, .154842E-01, .112340E-01,
     +  .805528E-02, .570454E-02, .398574E-02, .274535E-02,
     +  .186189E-02, .124210E-02, .812461E-03, .523345E-03,
     +  .328704E-03, .201637E-03, .120414E-03, .700215E-04,
     +  .400781E-04, .242675E-04, .164449E-04, .109024E-04,
     +  .701138E-05, .431079E-05, .246494E-05, .126102E-05,
     +  .532499E-06, .150526E-06, .119086E-07, .000000E+00 /
        DATA (UPDI(I),I=4369,4420) /
     +  .399815E+06, .308250E+06, .234333E+06, .178065E+06,
     +  .135267E+06, .102708E+06, .779613E+05, .591486E+05,
     +  .448608E+05, .340074E+05, .257710E+05, .195194E+05,
     +  .147791E+05, .111841E+05, .846063E+04, .639693E+04,
     +  .483492E+04, .365239E+04, .275817E+04, .208184E+04,
     +  .157094E+04, .118489E+04, .893536E+03, .673597E+03,
     +  .507764E+03, .382701E+03, .288556E+03, .216724E+03,
     +  .163532E+03, .123468E+03, .933273E+02, .706323E+02,
     +  .535528E+02, .407213E+02, .310314E+02, .237225E+02,
     +  .182068E+02, .140308E+02, .108644E+02, .845156E+01,
     +  .661022E+01, .519418E+01, .410067E+01, .325060E+01,
     +  .258638E+01, .206350E+01, .165147E+01, .132129E+01,
     +  .105930E+01, .847660E+00, .678115E+00, .541407E+00 /
        DATA (UPDI(I),I=4421,4472) /
     +  .431169E+00, .342245E+00, .270611E+00, .212991E+00,
     +  .166782E+00, .129861E+00, .100496E+00, .772492E-01,
     +  .589575E-01, .446548E-01, .335340E-01, .249964E-01,
     +  .184204E-01, .134350E-01, .969156E-02, .690935E-02,
     +  .486417E-02, .337769E-02, .231113E-02, .155591E-02,
     +  .102917E-02, .666340E-03, .423757E-03, .261729E-03,
     +  .156949E-03, .908320E-04, .505545E-04, .273095E-04,
     +  .154443E-04, .975056E-05, .601039E-05, .359965E-05,
     +  .207405E-05, .112164E-05, .550405E-06, .225896E-06,
     +  .626799E-07, .467676E-08, .000000E+00, .548182E+06,
     +  .420562E+06, .317893E+06, .240175E+06, .181392E+06,
     +  .136925E+06, .103320E+06, .779204E+05, .587417E+05,
     +  .442591E+05, .333334E+05, .250906E+05, .188780E+05 /
        DATA (UPDI(I),I=4473,4524) /
     +  .141955E+05, .106698E+05, .801509E+04, .601829E+04,
     +  .451628E+04, .338774E+04, .253977E+04, .190337E+04,
     +  .142571E+04, .106761E+04, .799132E+03, .598071E+03,
     +  .447489E+03, .334923E+03, .249647E+03, .186949E+03,
     +  .140068E+03, .105050E+03, .788778E+02, .593246E+02,
     +  .447451E+02, .338163E+02, .256360E+02, .195089E+02,
     +  .149061E+02, .114427E+02, .882444E+01, .684187E+01,
     +  .532953E+01, .417098E+01, .327785E+01, .258575E+01,
     +  .204554E+01, .162346E+01, .128818E+01, .102443E+01,
     +  .813241E+00, .645519E+00, .511462E+00, .404281E+00,
     +  .318562E+00, .250082E+00, .195455E+00, .152000E+00,
     +  .117557E+00, .903756E-01, .690235E-01, .523479E-01,
     +  .394052E-01, .294132E-01, .217959E-01, .159693E-01 /
        DATA (UPDI(I),I=4525,4576) /
     +  .115821E-01, .830980E-02, .589361E-02, .412871E-02,
     +  .285391E-02, .194469E-02, .130463E-02, .860654E-03,
     +  .556500E-03, .354068E-03, .219455E-03, .132687E-03,
     +  .780574E-04, .447696E-04, .254692E-04, .152699E-04,
     +  .987761E-05, .624775E-05, .383764E-05, .225567E-05,
     +  .123423E-05, .603598E-06, .241678E-06, .640925E-07,
     +  .510405E-08, .000000E+00, .739208E+06, .564455E+06,
     +  .424326E+06, .318820E+06, .239446E+06, .179730E+06,
     +  .134847E+06, .101113E+06, .757830E+05, .567637E+05,
     +  .424972E+05, .317964E+05, .237783E+05, .177706E+05,
     +  .132741E+05, .990887E+04, .739303E+04, .551234E+04,
     +  .410804E+04, .305955E+04, .227766E+04, .169460E+04,
     +  .126031E+04, .936866E+03, .696250E+03, .517255E+03 /
        DATA (UPDI(I),I=4577,4628) /
     +  .384362E+03, .284387E+03, .211394E+03, .157201E+03,
     +  .117006E+03, .871804E+02, .650576E+02, .486829E+02,
     +  .364976E+02, .274448E+02, .207141E+02, .156962E+02,
     +  .119487E+02, .913748E+01, .702498E+01, .542614E+01,
     +  .421088E+01, .328156E+01, .256716E+01, .201413E+01,
     +  .158557E+01, .124800E+01, .984646E+00, .775569E+00,
     +  .610913E+00, .480417E+00, .376946E+00, .294878E+00,
     +  .229846E+00, .178389E+00, .137779E+00, .105844E+00,
     +  .808343E-01, .613374E-01, .462236E-01, .345788E-01,
     +  .256525E-01, .188953E-01, .137624E-01, .992416E-02,
     +  .708059E-02, .499486E-02, .348118E-02, .239480E-02,
     +  .162474E-02, .108593E-02, .714324E-03, .461188E-03,
     +  .293520E-03, .182539E-03, .111245E-03, .664532E-04 /
        DATA (UPDI(I),I=4629,4680) /
     +  .391401E-04, .231973E-04, .144765E-04, .951830E-05,
     +  .611563E-05, .380790E-05, .225768E-05, .123847E-05,
     +  .601421E-06, .236297E-06, .609493E-07, .504320E-08,
     +  .000000E+00, .980945E+06, .745679E+06, .557611E+06,
     +  .416742E+06, .311310E+06, .232406E+06, .173413E+06,
     +  .129310E+06, .963729E+05, .717773E+05, .534293E+05,
     +  .397441E+05, .295473E+05, .219511E+05, .162983E+05,
     +  .120925E+05, .896673E+04, .664411E+04, .492029E+04,
     +  .364113E+04, .269310E+04, .199059E+04, .147064E+04,
     +  .108588E+04, .801504E+03, .591339E+03, .436342E+03,
     +  .320530E+03, .236551E+03, .174631E+03, .129020E+03,
     +  .954149E+02, .706628E+02, .524729E+02, .390330E+02,
     +  .291208E+02, .218044E+02, .163901E+02, .123761E+02 /
        DATA (UPDI(I),I=4681,4732) /
     +  .938754E+01, .715841E+01, .548414E+01, .422119E+01,
     +  .326290E+01, .253195E+01, .197059E+01, .153903E+01,
     +  .120184E+01, .940910E+00, .735455E+00, .574964E+00,
     +  .448810E+00, .349586E+00, .271520E+00, .210150E+00,
     +  .161974E+00, .124249E+00, .948108E-01, .719306E-01,
     +  .542277E-01, .406052E-01, .301856E-01, .222548E-01,
     +  .162932E-01, .117962E-01, .845668E-02, .599936E-02,
     +  .420898E-02, .291814E-02, .199768E-02, .134932E-02,
     +  .898442E-03, .589316E-03, .379932E-03, .241916E-03,
     +  .150973E-03, .927360E-04, .562031E-04, .338866E-04,
     +  .207423E-04, .133022E-04, .883067E-05, .571705E-05,
     +  .357581E-05, .211923E-05, .115556E-05, .553415E-06,
     +  .212426E-06, .532440E-07, .452542E-08, .000000E+00 /
        DATA (UPDI(I),I=4733,4784) /
     +  .128199E+07, .970315E+06, .721913E+06, .536777E+06,
     +  .398902E+06, .296239E+06, .219873E+06, .163078E+06,
     +  .120881E+06, .895378E+05, .662804E+05, .490272E+05,
     +  .362418E+05, .267700E+05, .197606E+05, .145750E+05,
     +  .107431E+05, .791236E+04, .582367E+04, .428298E+04,
     +  .314797E+04, .231201E+04, .169711E+04, .124493E+04,
     +  .912824E+03, .668946E+03, .490252E+03, .357617E+03,
     +  .262080E+03, .192110E+03, .140917E+03, .103457E+03,
     +  .760544E+02, .560573E+02, .413846E+02, .306400E+02,
     +  .227650E+02, .169793E+02, .127207E+02, .957304E+01,
     +  .724220E+01, .550445E+01, .420329E+01, .322345E+01,
     +  .248168E+01, .191637E+01, .148513E+01, .115084E+01,
     +  .894162E+00, .693668E+00, .538290E+00, .417125E+00 /
        DATA (UPDI(I),I=4785,4836) /
     +  .322573E+00, .248767E+00, .191196E+00, .146352E+00,
     +  .111505E+00, .845182E-01, .636997E-01, .477112E-01,
     +  .354975E-01, .262227E-01, .192129E-01, .139803E-01,
     +  .100607E-01, .717009E-02, .505756E-02, .352870E-02,
     +  .243368E-02, .165792E-02, .111493E-02, .739656E-03,
     +  .483882E-03, .311598E-03, .198572E-03, .124407E-03,
     +  .770402E-04, .473452E-04, .291476E-04, .183062E-04,
     +  .119626E-04, .798211E-05, .518048E-05, .323726E-05,
     +  .190796E-05, .102927E-05, .484332E-06, .181183E-06,
     +  .440931E-07, .383020E-08, .000000E+00, .165128E+07,
     +  .124464E+07, .921470E+06, .681769E+06, .504117E+06,
     +  .372483E+06, .275047E+06, .202944E+06, .149644E+06,
     +  .110255E+06, .811786E+05, .597213E+05, .439044E+05 /
        DATA (UPDI(I),I=4837,4888) /
     +  .322495E+05, .236712E+05, .173598E+05, .127217E+05,
     +  .931475E+04, .681518E+04, .498207E+04, .363948E+04,
     +  .265651E+04, .193779E+04, .141246E+04, .102901E+04,
     +  .749165E+03, .545414E+03, .395155E+03, .287625E+03,
     +  .209388E+03, .152520E+03, .111187E+03, .811525E+02,
     +  .593836E+02, .435194E+02, .319824E+02, .235848E+02,
     +  .174584E+02, .129803E+02, .969392E+01, .727746E+01,
     +  .548877E+01, .415909E+01, .316508E+01, .241809E+01,
     +  .185303E+01, .142521E+01, .109609E+01, .845305E+00,
     +  .650928E+00, .501449E+00, .385788E+00, .296223E+00,
     +  .226847E+00, .173142E+00, .131628E+00, .996112E-01,
     +  .750013E-01, .561559E-01, .417887E-01, .308926E-01,
     +  .226774E-01, .165118E-01, .119414E-01, .854162E-02 /
        DATA (UPDI(I),I=4889,4940) /
     +  .605163E-02, .424428E-02, .294504E-02, .202061E-02,
     +  .136994E-02, .917381E-03, .606506E-03, .395861E-03,
     +  .254730E-03, .162556E-03, .102296E-03, .638832E-04,
     +  .397905E-04, .249546E-04, .159958E-04, .105862E-04,
     +  .707646E-05, .458765E-05, .285391E-05, .166726E-05,
     +  .887294E-06, .409348E-06, .149063E-06, .352247E-07,
     +  .311860E-08, .000000E+00, .209792E+07, .157495E+07,
     +  .116048E+07, .854492E+06, .628768E+06, .462309E+06,
     +  .339682E+06, .249379E+06, .182949E+06, .134102E+06,
     +  .982225E+05, .718798E+05, .525609E+05, .383996E+05,
     +  .280312E+05, .204434E+05, .148974E+05, .108458E+05,
     +  .788964E+04, .573387E+04, .416390E+04, .302106E+04,
     +  .219031E+04, .158669E+04, .114872E+04, .831003E+03 /
        DATA (UPDI(I),I=4941,4992) /
     +  .601108E+03, .432632E+03, .312828E+03, .226216E+03,
     +  .163663E+03, .118493E+03, .858851E+02, .624070E+02,
     +  .454102E+02, .331326E+02, .242560E+02, .178241E+02,
     +  .131547E+02, .975149E+01, .726623E+01, .543942E+01,
     +  .409088E+01, .308991E+01, .234304E+01, .178215E+01,
     +  .136058E+01, .103866E+01, .795178E+00, .607884E+00,
     +  .464936E+00, .355163E+00, .270796E+00, .205938E+00,
     +  .156105E+00, .117872E+00, .886041E-01, .662725E-01,
     +  .492960E-01, .364472E-01, .267722E-01, .195293E-01,
     +  .141312E-01, .101574E-01, .722190E-02, .508667E-02,
     +  .354733E-02, .244812E-02, .167115E-02, .112779E-02,
     +  .752211E-03, .495760E-03, .322972E-03, .207787E-03,
     +  .132862E-03, .840292E-04, .529330E-04, .333952E-04 /
        DATA (UPDI(I),I=4993,5044) /
     +  .212864E-04, .138628E-04, .924864E-05, .617745E-05,
     +  .398977E-05, .246451E-05, .142393E-05, .746157E-06,
     +  .337038E-06, .119406E-06, .274144E-07, .246943E-08,
     +  .000000E+00, .263086E+07, .196739E+07, .144295E+07,
     +  .105755E+07, .774520E+06, .566766E+06, .414427E+06,
     +  .302771E+06, .221024E+06, .161202E+06, .117476E+06,
     +  .855299E+05, .622183E+05, .452168E+05, .328322E+05,
     +  .238161E+05, .172605E+05, .124968E+05, .903973E+04,
     +  .653244E+04, .471653E+04, .340207E+04, .245197E+04,
     +  .176560E+04, .127048E+04, .913413E+03, .656594E+03,
     +  .469537E+03, .337338E+03, .242359E+03, .174190E+03,
     +  .125277E+03, .901904E+02, .650904E+02, .470364E+02,
     +  .340805E+02, .247745E+02, .180763E+02, .132456E+02 /
        DATA (UPDI(I),I=5045,5096) /
     +  .974831E+01, .721138E+01, .535920E+01, .400121E+01,
     +  .300017E+01, .225842E+01, .170528E+01, .129249E+01,
     +  .979533E+00, .744545E+00, .565112E+00, .429170E+00,
     +  .325550E+00, .246497E+00, .186172E+00, .140164E+00,
     +  .105123E+00, .784958E-01, .583259E-01, .431029E-01,
     +  .316637E-01, .231110E-01, .167532E-01, .120474E-01,
     +  .860706E-02, .608311E-02, .425976E-02, .295411E-02,
     +  .202794E-02, .137752E-02, .925550E-03, .615045E-03,
     +  .404257E-03, .262999E-03, .169269E-03, .108517E-03,
     +  .690108E-04, .438552E-04, .280019E-04, .180983E-04,
     +  .119283E-04, .799313E-05, .532337E-05, .341818E-05,
     +  .209256E-05, .119380E-05, .615137E-06, .271811E-06,
     +  .936716E-07, .209121E-07, .191425E-08, .000000E+00 /
        DATA (UPDI(I),I=5097,5148) /
     +  .476990E+05, .503394E+05, .392119E+05, .305442E+05,
     +  .237926E+05, .185335E+05, .144370E+05, .112461E+05,
     +  .876052E+04, .682443E+04, .531633E+04, .414162E+04,
     +  .322659E+04, .251384E+04, .195864E+04, .152617E+04,
     +  .118930E+04, .926893E+03, .722486E+03, .563256E+03,
     +  .439216E+03, .342587E+03, .267307E+03, .208657E+03,
     +  .162960E+03, .127351E+03, .995991E+02, .776976E+02,
     +  .608981E+02, .477945E+02, .375693E+02, .295857E+02,
     +  .233478E+02, .184821E+02, .146614E+02, .116659E+02,
     +  .931217E+01, .745791E+01, .599234E+01, .482909E+01,
     +  .390313E+01, .316136E+01, .256452E+01, .208199E+01,
     +  .169017E+01, .137086E+01, .111079E+01, .896529E+00,
     +  .722050E+00, .578306E+00, .461269E+00, .365858E+00 /
        DATA (UPDI(I),I=5149,5200) /
     +  .288371E+00, .225731E+00, .175370E+00, .135135E+00,
     +  .103216E+00, .780908E-01, .584817E-01, .433188E-01,
     +  .317104E-01, .229184E-01, .163363E-01, .114894E-01,
     +  .793155E-02, .537687E-02, .357229E-02, .232042E-02,
     +  .146927E-02, .903514E-03, .536978E-03, .306416E-03,
     +  .166239E-03, .844287E-04, .394257E-04, .158883E-04,
     +  .476517E-05, .222282E-06, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .446321E+05,
     +  .652070E+05, .507969E+05, .395624E+05, .308139E+05,
     +  .239944E+05, .186847E+05, .145464E+05, .113249E+05,
     +  .881464E+04, .686089E+04, .533878E+04, .415440E+04 /
        DATA (UPDI(I),I=5201,5252) /
     +  .323190E+04, .251428E+04, .195548E+04, .152091E+04,
     +  .118261E+04, .919613E+03, .714945E+03, .555888E+03,
     +  .432154E+03, .336026E+03, .261270E+03, .203212E+03,
     +  .158079E+03, .123041E+03, .954720E+02, .744142E+02,
     +  .580446E+02, .453353E+02, .354524E+02, .277740E+02,
     +  .218128E+02, .171624E+02, .135361E+02, .107078E+02,
     +  .849368E+01, .675846E+01, .539136E+01, .431365E+01,
     +  .345783E+01, .277665E+01, .223137E+01, .179390E+01,
     +  .144116E+01, .115746E+01, .926214E+00, .740297E+00,
     +  .588721E+00, .466729E+00, .368232E+00, .289064E+00,
     +  .225600E+00, .175017E+00, .134859E+00, .103200E+00,
     +  .783787E-01, .590827E-01, .441709E-01, .327567E-01,
     +  .240817E-01, .175514E-01, .126978E-01, .908734E-02 /
        DATA (UPDI(I),I=5253,5304) /
     +  .644171E-02, .452525E-02, .314837E-02, .217048E-02,
     +  .148046E-02, .999140E-03, .664407E-03, .434600E-03,
     +  .275801E-03, .169373E-03, .966860E-04, .481884E-04,
     +  .165952E-04, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .111174E+06, .873234E+05,
     +  .678155E+05, .526503E+05, .408743E+05, .317225E+05,
     +  .246181E+05, .190987E+05, .148155E+05, .114891E+05,
     +  .890867E+04, .690538E+04, .535204E+04, .414661E+04,
     +  .321234E+04, .248765E+04, .192625E+04, .149099E+04,
     +  .115399E+04, .892848E+03, .690781E+03, .534289E+03,
     +  .413264E+03, .319588E+03, .247183E+03, .191176E+03 /
        DATA (UPDI(I),I=5305,5356) /
     +  .147924E+03, .114066E+03, .883420E+02, .684550E+02,
     +  .531023E+02, .412334E+02, .320667E+02, .249942E+02,
     +  .195121E+02, .152654E+02, .119761E+02, .941915E+01,
     +  .743024E+01, .587541E+01, .465973E+01, .370251E+01,
     +  .294730E+01, .234831E+01, .187227E+01, .149205E+01,
     +  .118921E+01, .944668E+00, .749963E+00, .592650E+00,
     +  .467160E+00, .366685E+00, .286570E+00, .222822E+00,
     +  .172358E+00, .132535E+00, .101306E+00, .769334E-01,
     +  .580567E-01, .435066E-01, .323874E-01, .239393E-01,
     +  .175718E-01, .128272E-01, .928046E-02, .666342E-02,
     +  .475030E-02, .335983E-02, .235816E-02, .163917E-02,
     +  .112766E-02, .764217E-03, .508742E-03, .328150E-03,
     +  .204576E-03, .118626E-03, .607740E-04, .232025E-04 /
        DATA (UPDI(I),I=5357,5408) /
     +  .286001E-05, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .000000E+00, .000000E+00, .000000E+00,
     +  .000000E+00, .152758E+06, .119492E+06, .923615E+05,
     +  .713669E+05, .551381E+05, .425844E+05, .328845E+05,
     +  .253846E+05, .195922E+05, .151157E+05, .116601E+05,
     +  .899075E+04, .693133E+04, .534136E+04, .411538E+04,
     +  .316940E+04, .244043E+04, .187829E+04, .144539E+04,
     +  .111179E+04, .855082E+03, .657395E+03, .505376E+03,
     +  .388392E+03, .298496E+03, .229373E+03, .176317E+03,
     +  .135036E+03, .103866E+03, .799202E+02, .615514E+02,
     +  .474430E+02, .366178E+02, .283220E+02, .219356E+02,
     +  .170232E+02, .132454E+02, .103304E+02, .808016E+01 /
        DATA (UPDI(I),I=5409,5460) /
     +  .633486E+01, .498125E+01, .392436E+01, .309760E+01,
     +  .244768E+01, .193578E+01, .153062E+01, .121083E+01,
     +  .954917E+00, .752989E+00, .591247E+00, .463299E+00,
     +  .361683E+00, .281275E+00, .217758E+00, .167811E+00,
     +  .128639E+00, .980900E-01, .743682E-01, .560748E-01,
     +  .420251E-01, .313186E-01, .232002E-01, .170865E-01,
     +  .125309E-01, .912095E-02, .659839E-02, .474737E-02,
     +  .339512E-02, .241456E-02, .170506E-02, .119552E-02,
     +  .829760E-03, .569319E-03, .383035E-03, .253580E-03,
     +  .161977E-03, .990946E-04, .570229E-04, .322613E-04,
     +  .205056E-04, .126079E-04, .743666E-05, .416325E-05,
     +  .219400E-05, .107695E-05, .479831E-06, .191625E-06,
     +  .655867E-07, .156336E-07, .000000E+00, .000000E+00 /
        DATA (UPDI(I),I=5461,5512) /
     +  .210241E+06, .163692E+06, .125854E+06, .967260E+05,
     +  .743267E+05, .570916E+05, .438447E+05, .336575E+05,
     +  .258319E+05, .198173E+05, .151997E+05, .116527E+05,
     +  .893143E+04, .684241E+04, .524074E+04, .401204E+04,
     +  .307066E+04, .234899E+04, .179651E+04, .137330E+04,
     +  .104958E+04, .801814E+03, .612441E+03, .467616E+03,
     +  .357013E+03, .272507E+03, .208059E+03, .158236E+03,
     +  .120859E+03, .923338E+02, .705965E+02, .540136E+02,
     +  .413751E+02, .317571E+02, .244041E+02, .187887E+02,
     +  .145012E+02, .112177E+02, .870187E+01, .676585E+01,
     +  .527616E+01, .412254E+01, .322753E+01, .252996E+01,
     +  .198523E+01, .155781E+01, .122335E+01, .957995E+00,
     +  .750384E+00, .585463E+00, .456036E+00, .354042E+00 /
        DATA (UPDI(I),I=5513,5564) /
     +  .273924E+00, .211081E+00, .161984E+00, .123716E+00,
     +  .940371E-01, .711111E-01, .535116E-01, .400500E-01,
     +  .298264E-01, .220957E-01, .162854E-01, .119613E-01,
     +  .872596E-02, .633196E-02, .457331E-02, .328618E-02,
     +  .235027E-02, .167086E-02, .118095E-02, .827859E-03,
     +  .575106E-03, .393636E-03, .266716E-03, .176407E-03,
     +  .113967E-03, .717500E-04, .458632E-04, .312523E-04,
     +  .210325E-04, .139058E-04, .899121E-05, .564894E-05,
     +  .340971E-05, .192638E-05, .983654E-06, .420479E-06,
     +  .121780E-06, .907329E-08, .000000E+00, .187532E+06,
     +  .222347E+06, .170024E+06, .129960E+06, .993144E+05,
     +  .758618E+05, .579333E+05, .442216E+05, .337465E+05,
     +  .257404E+05, .196283E+05, .149601E+05, .113989E+05 /
        DATA (UPDI(I),I=5565,5616) /
     +  .868090E+04, .660903E+04, .502897E+04, .382550E+04,
     +  .290844E+04, .221056E+04, .167923E+04, .127527E+04,
     +  .968004E+03, .734601E+03, .557227E+03, .422616E+03,
     +  .320422E+03, .242988E+03, .183515E+03, .139191E+03,
     +  .105588E+03, .801506E+02, .608767E+02, .462864E+02,
     +  .352601E+02, .268886E+02, .205411E+02, .157292E+02,
     +  .120711E+02, .928899E+01, .716445E+01, .554224E+01,
     +  .429599E+01, .333680E+01, .259536E+01, .202110E+01,
     +  .157424E+01, .122745E+01, .954569E+00, .742784E+00,
     +  .575883E+00, .445901E+00, .344234E+00, .264938E+00,
     +  .203163E+00, .155208E+00, .118058E+00, .894072E-01,
     +  .673928E-01, .505728E-01, .377639E-01, .280728E-01,
     +  .207696E-01, .152951E-01, .112298E-01, .819290E-02 /
        DATA (UPDI(I),I=5617,5668) /
     +  .594845E-02, .430060E-02, .309475E-02, .221756E-02,
     +  .158040E-02, .112046E-02, .788687E-03, .550857E-03,
     +  .380074E-03, .260361E-03, .175115E-03, .116037E-03,
     +  .759423E-04, .507022E-04, .352472E-04, .242656E-04,
     +  .164449E-04, .109024E-04, .701137E-05, .431079E-05,
     +  .246493E-05, .126102E-05, .532499E-06, .150526E-06,
     +  .119086E-07, .000000E+00, .399773E+06, .308212E+06,
     +  .234299E+06, .178034E+06, .135239E+06, .102683E+06,
     +  .779386E+05, .591281E+05, .448423E+05, .339907E+05,
     +  .257559E+05, .195058E+05, .147669E+05, .111731E+05,
     +  .845066E+04, .638793E+04, .482681E+04, .364506E+04,
     +  .275156E+04, .207588E+04, .156555E+04, .118003E+04,
     +  .889146E+03, .669632E+03, .504180E+03, .379459E+03 /
        DATA (UPDI(I),I=5669,5720) /
     +  .285622E+03, .214070E+03, .161126E+03, .121284E+03,
     +  .913422E+02, .688261E+02, .519068E+02, .392190E+02,
     +  .296586E+02, .224669E+02, .170572E+02, .129781E+02,
     +  .990053E+01, .757012E+01, .580540E+01, .446140E+01,
     +  .343578E+01, .265004E+01, .204675E+01, .158151E+01,
     +  .122358E+01, .944424E+00, .729612E+00, .561771E+00,
     +  .432115E+00, .331520E+00, .253650E+00, .193436E+00,
     +  .147012E+00, .111287E+00, .839039E-01, .629873E-01,
     +  .470894E-01, .350438E-01, .259696E-01, .191594E-01,
     +  .140714E-01, .103045E-01, .749762E-02, .542814E-02,
     +  .391153E-02, .280381E-02, .199923E-02, .141604E-02,
     +  .995958E-03, .693974E-03, .478411E-03, .324742E-03,
     +  .217881E-03, .142753E-03, .915290E-04, .575676E-04 /
        DATA (UPDI(I),I=5721,5772) /
     +  .366100E-04, .239707E-04, .154427E-04, .975055E-05,
     +  .601039E-05, .359965E-05, .207405E-05, .112164E-05,
     +  .550405E-06, .225896E-06, .626798E-07, .467675E-08,
     +  .000000E+00, .548136E+06, .420520E+06, .317856E+06,
     +  .240141E+06, .181361E+06, .136897E+06, .103294E+06,
     +  .778977E+05, .587213E+05, .442407E+05, .333168E+05,
     +  .250756E+05, .188645E+05, .141833E+05, .106589E+05,
     +  .800521E+04, .600938E+04, .450826E+04, .338051E+04,
     +  .253325E+04, .189749E+04, .142041E+04, .106283E+04,
     +  .794821E+03, .594180E+03, .443976E+03, .331750E+03,
     +  .246784E+03, .184360E+03, .137724E+03, .102927E+03,
     +  .769523E+02, .575766E+02, .431563E+02, .323712E+02,
     +  .243210E+02, .183116E+02, .138163E+02, .104513E+02 /
        DATA (UPDI(I),I=5773,5824) /
     +  .792397E+01, .602559E+01, .459188E+01, .350687E+01,
     +  .268276E+01, .205534E+01, .157565E+01, .120972E+01,
     +  .926767E+00, .710826E+00, .543504E+00, .415276E+00,
     +  .316574E+00, .240740E+00, .182530E+00, .137960E+00,
     +  .103893E+00, .779461E-01, .582474E-01, .433586E-01,
     +  .321390E-01, .237284E-01, .174460E-01, .127716E-01,
     +  .932441E-02, .676483E-02, .488437E-02, .351052E-02,
     +  .251017E-02, .178555E-02, .126193E-02, .885804E-03,
     +  .616322E-03, .424559E-03, .288472E-03, .194125E-03,
     +  .128087E-03, .831981E-04, .534891E-04, .348755E-04,
     +  .232194E-04, .152686E-04, .987760E-05, .624774E-05,
     +  .383764E-05, .225567E-05, .123423E-05, .603598E-06,
     +  .241678E-06, .640925E-07, .510405E-08, .000000E+00 /
        DATA (UPDI(I),I=5825,5876) /
     +  .739157E+06, .564409E+06, .424284E+06, .318782E+06,
     +  .239412E+06, .179700E+06, .134820E+06, .101088E+06,
     +  .757605E+05, .567435E+05, .424790E+05, .317800E+05,
     +  .237634E+05, .177573E+05, .132621E+05, .989806E+04,
     +  .738330E+04, .550357E+04, .410015E+04, .305245E+04,
     +  .227127E+04, .168884E+04, .125513E+04, .932199E+03,
     +  .692046E+03, .513466E+03, .380947E+03, .281313E+03,
     +  .208621E+03, .154698E+03, .114745E+03, .851376E+02,
     +  .632100E+02, .470107E+02, .349836E+02, .260739E+02,
     +  .194728E+02, .145730E+02, .109334E+02, .822157E+01,
     +  .620058E+01, .468665E+01, .355019E+01, .269415E+01,
     +  .204777E+01, .155769E+01, .118690E+01, .902568E+00,
     +  .687317E+00, .521880E+00, .396084E+00, .300003E+00 /
        DATA (UPDI(I),I=5877,5928) /
     +  .226726E+00, .170887E+00, .128425E+00, .961887E-01,
     +  .717926E-01, .533861E-01, .395539E-01, .291894E-01,
     +  .214600E-01, .157155E-01, .114606E-01, .833651E-02,
     +  .602645E-02, .433632E-02, .310622E-02, .221396E-02,
     +  .156994E-02, .110635E-02, .774564E-03, .537823E-03,
     +  .370030E-03, .251533E-03, .169673E-03, .112634E-03,
     +  .739744E-04, .484029E-04, .321546E-04, .216875E-04,
     +  .144754E-04, .951830E-05, .611563E-05, .380790E-05,
     +  .225768E-05, .123847E-05, .601421E-06, .236296E-06,
     +  .609493E-07, .504320E-08, .000000E+00, .980888E+06,
     +  .745628E+06, .557565E+06, .416701E+06, .311273E+06,
     +  .232372E+06, .173382E+06, .129283E+06, .963483E+05,
     +  .717551E+05, .534093E+05, .397261E+05, .295311E+05 /
        DATA (UPDI(I),I=5929,5980) /
     +  .219366E+05, .162852E+05, .120807E+05, .895613E+04,
     +  .663458E+04, .491172E+04, .363343E+04, .268617E+04,
     +  .198436E+04, .146504E+04, .108085E+04, .796979E+03,
     +  .587269E+03, .432683E+03, .317243E+03, .233594E+03,
     +  .171969E+03, .126624E+03, .932570E+02, .687186E+02,
     +  .507206E+02, .374539E+02, .276981E+02, .205231E+02,
     +  .152375E+02, .113408E+02, .845975E+01, .632916E+01,
     +  .474569E+01, .356640E+01, .268523E+01, .202517E+01,
     +  .152876E+01, .115619E+01, .872784E+00, .659921E+00,
     +  .497611E+00, .375136E+00, .282299E+00, .212012E+00,
     +  .158834E+00, .118672E+00, .883882E-01, .656164E-01,
     +  .485427E-01, .357875E-01, .262852E-01, .192369E-01,
     +  .140261E-01, .101852E-01, .737831E-02, .531231E-02 /
        DATA (UPDI(I),I=5981,6032) /
     +  .380764E-02, .271721E-02, .192967E-02, .136358E-02,
     +  .957847E-03, .668679E-03, .463269E-03, .318326E-03,
     +  .216461E-03, .146348E-03, .976938E-04, .647932E-04,
     +  .430101E-04, .289771E-04, .197318E-04, .133014E-04,
     +  .883067E-05, .571705E-05, .357581E-05, .211923E-05,
     +  .115556E-05, .553415E-06, .212426E-06, .532439E-07,
     +  .452542E-08, .000000E+00, .128192E+07, .970259E+06,
     +  .721862E+06, .536731E+06, .398860E+06, .296202E+06,
     +  .219839E+06, .163048E+06, .120854E+06, .895136E+05,
     +  .662586E+05, .490075E+05, .362242E+05, .267541E+05,
     +  .197464E+05, .145622E+05, .107316E+05, .790202E+04,
     +  .581439E+04, .427465E+04, .314048E+04, .230530E+04,
     +  .169108E+04, .123952E+04, .907970E+03, .664590E+03 /
        DATA (UPDI(I),I=6033,6084) /
     +  .486344E+03, .354116E+03, .258938E+03, .189291E+03,
     +  .138387E+03, .101186E+03, .740167E+02, .542284E+02,
     +  .397441E+02, .291694E+02, .214479E+02, .158014E+02,
     +  .116692E+02, .863690E+01, .641127E+01, .476983E+01,
     +  .355674E+01, .265739E+01, .198893E+01, .149015E+01,
     +  .111872E+01, .838400E+00, .629464E+00, .471378E+00,
     +  .352985E+00, .263911E+00, .196955E+00, .146656E+00,
     +  .108927E+00, .806673E-01, .595551E-01, .438249E-01,
     +  .321435E-01, .234921E-01, .171104E-01, .124181E-01,
     +  .897683E-02, .647437E-02, .464144E-02, .331299E-02,
     +  .235474E-02, .166584E-02, .117287E-02, .821179E-03,
     +  .571635E-03, .395194E-03, .271259E-03, .184557E-03,
     +  .125086E-03, .839603E-04, .561873E-04, .377519E-04 /
        DATA (UPDI(I),I=6085,6136) /
     +  .257126E-04, .176317E-04, .119619E-04, .798211E-05,
     +  .518048E-05, .323726E-05, .190796E-05, .102927E-05,
     +  .484332E-06, .181183E-06, .440931E-07, .383020E-08,
     +  .000000E+00, .165121E+07, .124458E+07, .921414E+06,
     +  .681719E+06, .504072E+06, .372442E+06, .275010E+06,
     +  .202911E+06, .149614E+06, .110229E+06, .811548E+05,
     +  .597000E+05, .438852E+05, .322322E+05, .236557E+05,
     +  .173459E+05, .127093E+05, .930358E+04, .680516E+04,
     +  .497308E+04, .363143E+04, .264929E+04, .193132E+04,
     +  .140667E+04, .102382E+04, .744519E+03, .541255E+03,
     +  .391439E+03, .284299E+03, .206412E+03, .149859E+03,
     +  .108807E+03, .790249E+02, .574822E+02, .418216E+02,
     +  .304681E+02, .222359E+02, .162590E+02, .119163E+02 /
        DATA (UPDI(I),I=6137,6188) /
     +  .875288E+01, .644791E+01, .476061E+01, .352294E+01,
     +  .261233E+01, .194063E+01, .144324E+01, .107568E+01,
     +  .800386E+00, .596739E+00, .443818E+00, .330137E+00,
     +  .245232E+00, .181862E+00, .134588E+00, .993686E-01,
     +  .731645E-01, .537137E-01, .393125E-01, .286821E-01,
     +  .208557E-01, .151152E-01, .109175E-01, .785510E-02,
     +  .563952E-02, .402495E-02, .286065E-02, .202487E-02,
     +  .142691E-02, .100101E-02, .698608E-03, .485012E-03,
     +  .334685E-03, .229565E-03, .156333E-03, .106255E-03,
     +  .717142E-04, .483935E-04, .328500E-04, .225620E-04,
     +  .155468E-04, .105857E-04, .707646E-05, .458765E-05,
     +  .285391E-05, .166726E-05, .887294E-06, .409348E-06,
     +  .149063E-06, .352247E-07, .311860E-08, .000000E+00 /
        DATA (UPDI(I),I=6189,6240) /
     +  .209784E+07, .157489E+07, .116042E+07, .854437E+06,
     +  .628719E+06, .462265E+06, .339643E+06, .249343E+06,
     +  .182917E+06, .134073E+06, .981966E+05, .718566E+05,
     +  .525401E+05, .383809E+05, .280144E+05, .204284E+05,
     +  .148840E+05, .108337E+05, .787885E+04, .572421E+04,
     +  .415525E+04, .301332E+04, .218339E+04, .158051E+04,
     +  .114319E+04, .826063E+03, .596696E+03, .428700E+03,
     +  .309319E+03, .223086E+03, .160873E+03, .116007E+03,
     +  .836716E+02, .604372E+02, .436596E+02, .315791E+02,
     +  .228796E+02, .166075E+02, .120821E+02, .880894E+01,
     +  .644101E+01, .472018E+01, .346713E+01, .255199E+01,
     +  .188193E+01, .138945E+01, .102821E+01, .759676E+00,
     +  .562487E+00, .415508E+00, .307036E+00, .226603E+00 /
        DATA (UPDI(I),I=6241,6292) /
     +  .166989E+00, .122824E+00, .901408E-01, .659846E-01,
     +  .481691E-01, .350611E-01, .254438E-01, .184053E-01,
     +  .132720E-01, .953941E-02, .683074E-02, .488133E-02,
     +  .346810E-02, .245425E-02, .173007E-02, .121450E-02,
     +  .849019E-03, .590753E-03, .409155E-03, .281922E-03,
     +  .193325E-03, .131831E-03, .898842E-04, .610005E-04,
     +  .414801E-04, .283988E-04, .196269E-04, .135648E-04,
     +  .924827E-05, .617745E-05, .398977E-05, .246451E-05,
     +  .142393E-05, .746156E-06, .337038E-06, .119406E-06,
     +  .274144E-07, .246943E-08, .000000E+00, .263077E+07,
     +  .196732E+07, .144289E+07, .105749E+07, .774467E+06,
     +  .566718E+06, .414383E+06, .302732E+06, .220989E+06,
     +  .161171E+06, .117448E+06, .855048E+05, .621958E+05 /
        DATA (UPDI(I),I=6293,6344) /
     +  .451966E+05, .328142E+05, .237999E+05, .172460E+05,
     +  .124838E+05, .902814E+04, .652208E+04, .470727E+04,
     +  .339380E+04, .244459E+04, .175902E+04, .126461E+04,
     +  .908176E+03, .651928E+03, .465390E+03, .333648E+03,
     +  .239079E+03, .171275E+03, .122689E+03, .878955E+02,
     +  .630569E+02, .452377E+02, .324923E+02, .233751E+02,
     +  .168464E+02, .121680E+02, .880752E+01, .639330E+01,
     +  .465121E+01, .339168E+01, .247842E+01, .181456E+01,
     +  .133016E+01, .977444E+00, .717144E+00, .527381E+00,
     +  .386961E+00, .284067E+00, .208307E+00, .152544E+00,
     +  .111513E+00, .813498E-01, .592027E-01, .429732E-01,
     +  .311066E-01, .224526E-01, .161567E-01, .115914E-01,
     +  .829035E-02, .590773E-02, .420208E-02, .297205E-02 /
        DATA (UPDI(I),I=6345,6396) /
     +  .209422E-02, .147033E-02, .102835E-02, .716522E-03,
     +  .497202E-03, .343664E-03, .236549E-03, .162246E-03,
     +  .110834E-03, .758274E-04, .517394E-04, .354256E-04,
     +  .244221E-04, .169520E-04, .117310E-04, .799286E-05,
     +  .532336E-05, .341818E-05, .209256E-05, .119380E-05,
     +  .615137E-06, .271811E-06, .936716E-07, .209121E-07,
     +  .191425E-08, .000000E+00, .471228E+05, .391821E+05,
     +  .324138E+05, .268179E+05, .221907E+05, .183640E+05,
     +  .151988E+05, .125804E+05, .104142E+05, .862180E+04,
     +  .713859E+04, .591111E+04, .489515E+04, .405419E+04,
     +  .335803E+04, .278170E+04, .230452E+04, .190941E+04,
     +  .158224E+04, .131131E+04, .108693E+04, .901101E+03,
     +  .747188E+03, .619705E+03, .514108E+03, .426637E+03 /
        DATA (UPDI(I),I=6397,6448) /
     +  .354178E+03, .293379E+03, .243803E+03, .202727E+03,
     +  .168693E+03, .140491E+03, .117120E+03, .978036E+02,
     +  .817509E+02, .684482E+02, .574206E+02, .482740E+02,
     +  .406819E+02, .343709E+02, .291251E+02, .247500E+02,
     +  .210948E+02, .180330E+02, .154610E+02, .132935E+02,
     +  .114670E+02, .990698E+01, .858600E+01, .744948E+01,
     +  .647786E+01, .564101E+01, .491784E+01, .429092E+01,
     +  .374586E+01, .327070E+01, .285553E+01, .249206E+01,
     +  .217332E+01, .189342E+01, .164738E+01, .143095E+01,
     +  .124046E+01, .107351E+01, .925686E+00, .795710E+00,
     +  .681532E+00, .581362E+00, .493631E+00, .416962E+00,
     +  .350137E+00, .292079E+00, .241799E+00, .198411E+00,
     +  .161505E+00, .129844E+00, .103080E+00, .806418E-01 /
        DATA (UPDI(I),I=6449,6500) /
     +  .620136E-01, .467294E-01, .343655E-01, .245499E-01,
     +  .168748E-01, .110849E-01, .684701E-02, .388790E-02,
     +  .195386E-02, .809346E-03, .235530E-03, .288874E-04,
     +  .000000E+00, .560350E+06, .443625E+06, .347628E+06,
     +  .272359E+06, .213455E+06, .167264E+06, .131112E+06,
     +  .102757E+06, .805628E+05, .631528E+05, .495232E+05,
     +  .388298E+05, .304570E+05, .238867E+05, .187415E+05,
     +  .147029E+05, .115398E+05, .905645E+04, .711102E+04,
     +  .558322E+04, .438604E+04, .344558E+04, .270846E+04,
     +  .212924E+04, .167509E+04, .131811E+04, .103807E+04,
     +  .815194E+03, .643061E+03, .507598E+03, .401246E+03,
     +  .317492E+03, .251693E+03, .199960E+03, .159167E+03,
     +  .126985E+03, .101641E+03, .816017E+02, .657757E+02 /
        DATA (UPDI(I),I=6501,6552) /
     +  .532128E+02, .432556E+02, .353077E+02, .289608E+02,
     +  .238598E+02, .197517E+02, .164206E+02, .137211E+02,
     +  .114967E+02, .967927E+01, .816678E+01, .691568E+01,
     +  .587056E+01, .499431E+01, .425590E+01, .363157E+01,
     +  .310154E+01, .265031E+01, .226500E+01, .193521E+01,
     +  .165241E+01, .140950E+01, .120068E+01, .102085E+01,
     +  .866683E+00, .733083E+00, .618156E+00, .519322E+00,
     +  .434477E+00, .361733E+00, .299536E+00, .246477E+00,
     +  .201404E+00, .163251E+00, .131067E+00, .104325E+00,
     +  .819395E-01, .634806E-01, .484111E-01, .362342E-01,
     +  .265341E-01, .189180E-01, .130740E-01, .866179E-02,
     +  .546400E-02, .322257E-02, .173502E-02, .817631E-03,
     +  .312795E-03, .831643E-04, .103461E-04, .000000E+00 /
        DATA (UPDI(I),I=6553,6604) /
     +  .130665E+07, .102522E+07, .795165E+06, .616469E+06,
     +  .477967E+06, .370421E+06, .287095E+06, .222414E+06,
     +  .172318E+06, .133444E+06, .103348E+06, .800018E+05,
     +  .619340E+05, .479243E+05, .370864E+05, .286860E+05,
     +  .221904E+05, .171577E+05, .132680E+05, .102554E+05,
     +  .792808E+04, .612635E+04, .473509E+04, .365856E+04,
     +  .282761E+04, .218485E+04, .168894E+04, .130095E+04,
     +  .100645E+04, .778795E+03, .603249E+03, .467568E+03,
     +  .362950E+03, .282280E+03, .219892E+03, .171652E+03,
     +  .134414E+03, .105570E+03, .832492E+02, .658954E+02,
     +  .524203E+02, .418858E+02, .336430E+02, .271532E+02,
     +  .220305E+02, .179588E+02, .147232E+02, .121079E+02,
     +  .100114E+02, .829897E+01, .690799E+01, .576676E+01 /
        DATA (UPDI(I),I=6605,6656) /
     +  .482647E+01, .404771E+01, .340025E+01, .285972E+01,
     +  .240698E+01, .202660E+01, .170617E+01, .143572E+01,
     +  .120702E+01, .101348E+01, .849319E+00, .710752E+00,
     +  .592505E+00, .492363E+00, .407573E+00, .335926E+00,
     +  .275467E+00, .224603E+00, .181918E+00, .146266E+00,
     +  .116607E+00, .920219E-01, .719609E-01, .554835E-01,
     +  .421597E-01, .315047E-01, .230783E-01, .165183E-01,
     +  .114904E-01, .773344E-02, .497595E-02, .303942E-02,
     +  .172839E-02, .892434E-03, .400170E-03, .144323E-03,
     +  .361156E-04, .453573E-05, .000000E+00, .245749E+07,
     +  .191444E+07, .147269E+07, .113222E+07, .870385E+06,
     +  .668711E+06, .513709E+06, .394397E+06, .302758E+06,
     +  .232265E+06, .178161E+06, .136571E+06, .104674E+06 /
        DATA (UPDI(I),I=6657,6708) /
     +  .801724E+05, .613961E+05, .469849E+05, .359502E+05,
     +  .274880E+05, .210142E+05, .160538E+05, .122625E+05,
     +  .936012E+04, .714399E+04, .544914E+04, .415623E+04,
     +  .316823E+04, .241540E+04, .183396E+04, .139833E+04,
     +  .106609E+04, .813328E+03, .620710E+03, .474254E+03,
     +  .362974E+03, .278156E+03, .213564E+03, .164448E+03,
     +  .126995E+03, .984561E+02, .766179E+02, .599233E+02,
     +  .470796E+02, .371858E+02, .295197E+02, .235620E+02,
     +  .189007E+02, .152529E+02, .123496E+02, .100570E+02,
     +  .821262E+01, .673631E+01, .554286E+01, .457357E+01,
     +  .378232E+01, .313368E+01, .259979E+01, .215877E+01,
     +  .179337E+01, .148978E+01, .123706E+01, .102627E+01,
     +  .850341E+00, .703129E+00, .580586E+00, .477458E+00 /
        DATA (UPDI(I),I=6709,6760) /
     +  .391348E+00, .319470E+00, .259609E+00, .209832E+00,
     +  .168581E+00, .134490E+00, .106464E+00, .835247E-01,
     +  .648235E-01, .498257E-01, .377276E-01, .281279E-01,
     +  .206021E-01, .147739E-01, .103366E-01, .701565E-02,
     +  .459774E-02, .287228E-02, .169786E-02, .930096E-03,
     +  .459919E-03, .195843E-03, .664304E-04, .156177E-04,
     +  .197969E-05, .000000E+00, .411016E+07, .318210E+07,
     +  .243038E+07, .185501E+07, .141553E+07, .107942E+07,
     +  .822908E+06, .626903E+06, .477449E+06, .363352E+06,
     +  .276435E+06, .210145E+06, .159698E+06, .121263E+06,
     +  .920442E+05, .698070E+05, .529220E+05, .400864E+05,
     +  .303520E+05, .229611E+05, .173631E+05, .131183E+05,
     +  .990766E+04, .747647E+04, .564010E+04, .425115E+04 /
        DATA (UPDI(I),I=6761,6812) /
     +  .320386E+04, .240371E+04, .181073E+04, .136361E+04,
     +  .102724E+04, .773942E+03, .583588E+03, .440729E+03,
     +  .333158E+03, .252279E+03, .191548E+03, .145842E+03,
     +  .111461E+03, .855018E+02, .659153E+02, .510491E+02,
     +  .397469E+02, .311075E+02, .244812E+02, .193657E+02,
     +  .154145E+02, .123109E+02, .989182E+01, .797089E+01,
     +  .645281E+01, .524130E+01, .426966E+01, .348651E+01,
     +  .285246E+01, .233712E+01, .191667E+01, .157265E+01,
     +  .129035E+01, .105829E+01, .867138E+00, .709596E+00,
     +  .579416E+00, .472432E+00, .383552E+00, .310308E+00,
     +  .249979E+00, .200415E+00, .159767E+00, .126555E+00,
     +  .995050E-01, .775986E-01, .599444E-01, .457785E-01,
     +  .346051E-01, .257467E-01, .188445E-01, .135362E-01 /
        DATA (UPDI(I),I=6813,6864) /
     +  .950787E-02, .650646E-02, .431153E-02, .275319E-02,
     +  .167122E-02, .956873E-03, .505539E-03, .239769E-03,
     +  .972080E-04, .311662E-04, .694681E-05, .886314E-06,
     +  .000000E+00, .637213E+07, .490577E+07, .372264E+07,
     +  .282276E+07, .213966E+07, .162062E+07, .122702E+07,
     +  .928263E+06, .701955E+06, .530372E+06, .400548E+06,
     +  .302234E+06, .227939E+06, .171747E+06, .129340E+06,
     +  .973089E+05, .731695E+05, .549630E+05, .412626E+05,
     +  .309451E+05, .231936E+05, .173655E+05, .129943E+05,
     +  .971341E+04, .725692E+04, .541585E+04, .404049E+04,
     +  .299975E+04, .223591E+04, .166570E+04, .124099E+04,
     +  .924506E+03, .689114E+03, .514367E+03, .384191E+03,
     +  .287412E+03, .215546E+03, .162082E+03, .122320E+03 /
        DATA (UPDI(I),I=6865,6916) /
     +  .926507E+02, .705224E+02, .539263E+02, .414550E+02,
     +  .320356E+02, .248950E+02, .194476E+02, .152888E+02,
     +  .120604E+02, .957309E+01, .762100E+01, .609594E+01,
     +  .489291E+01, .393903E+01, .317902E+01, .257067E+01,
     +  .208188E+01, .168762E+01, .136873E+01, .111003E+01,
     +  .899843E+00, .728707E+00, .589314E+00, .475481E+00,
     +  .383049E+00, .307188E+00, .245444E+00, .195226E+00,
     +  .154498E+00, .121535E+00, .949642E-01, .736229E-01,
     +  .565867E-01, .430606E-01, .323723E-01, .240763E-01,
     +  .176087E-01, .126576E-01, .892021E-02, .613961E-02,
     +  .411106E-02, .266089E-02, .165635E-02, .977441E-03,
     +  .542388E-03, .276583E-03, .125961E-03, .487198E-04,
     +  .148210E-04, .315147E-05, .403422E-06, .000000E+00 /
        DATA (UPDI(I),I=6917,6968) /
     +  .954068E+07, .730421E+07, .550675E+07, .414829E+07,
     +  .312346E+07, .234985E+07, .176694E+07, .132746E+07,
     +  .996734E+06, .747714E+06, .560569E+06, .419855E+06,
     +  .314258E+06, .234979E+06, .175577E+06, .131050E+06,
     +  .977429E+05, .728189E+05, .542082E+05, .403066E+05,
     +  .299460E+05, .222218E+05, .164768E+05, .122025E+05,
     +  .902986E+04, .667355E+04, .492943E+04, .362216E+04,
     +  .267185E+04, .196946E+04, .145143E+04, .106938E+04,
     +  .788111E+03, .581542E+03, .429282E+03, .317337E+03,
     +  .235116E+03, .174643E+03, .130172E+03, .973736E+02,
     +  .731898E+02, .552646E+02, .419493E+02, .320109E+02,
     +  .245641E+02, .189496E+02, .147130E+02, .114623E+02,
     +  .898704E+01, .706699E+01, .558423E+01, .442818E+01 /
        DATA (UPDI(I),I=6969,7020) /
     +  .352207E+01, .280852E+01, .224395E+01, .179561E+01,
     +  .143818E+01, .115247E+01, .923420E+00, .739529E+00,
     +  .591598E+00, .472563E+00, .376539E+00, .299535E+00,
     +  .237134E+00, .186999E+00, .146760E+00, .114562E+00,
     +  .888617E-01, .684386E-01, .522744E-01, .395648E-01,
     +  .296315E-01, .219088E-01, .160156E-01, .115022E-01,
     +  .811138E-02, .560187E-02, .377364E-02, .246938E-02,
     +  .155917E-02, .944878E-03, .541381E-03, .290806E-03,
     +  .142995E-03, .625059E-04, .230856E-04, .668396E-05,
     +  .136266E-05, .174149E-06, .000000E+00, .137637E+08,
     +  .104808E+08, .785221E+07, .587778E+07, .439725E+07,
     +  .328669E+07, .245507E+07, .183213E+07, .136633E+07,
     +  .101793E+07, .757815E+06, .563571E+06, .418784E+06 /
        DATA (UPDI(I),I=7021,7072) /
     +  .310847E+06, .230534E+06, .170770E+06, .126385E+06,
     +  .934208E+05, .689888E+05, .508803E+05, .374881E+05,
     +  .275839E+05, .202762E+05, .148844E+05, .109155E+05,
     +  .799310E+04, .584885E+04, .425615E+04, .310886E+04,
     +  .226881E+04, .165502E+04, .120676E+04, .879931E+03,
     +  .642326E+03, .468942E+03, .342794E+03, .251099E+03,
     +  .184381E+03, .135836E+03, .100424E+03, .745948E+02,
     +  .556609E+02, .417494E+02, .314814E+02, .238718E+02,
     +  .181982E+02, .139638E+02, .107508E+02, .833103E+01,
     +  .647481E+01, .505707E+01, .396391E+01, .311651E+01,
     +  .245658E+01, .194020E+01, .153469E+01, .121501E+01,
     +  .962353E+00, .762100E+00, .603168E+00, .476793E+00,
     +  .376293E+00, .296180E+00, .232709E+00, .181907E+00 /
        DATA (UPDI(I),I=7073,7124) /
     +  .141602E+00, .109669E+00, .844537E-01, .645996E-01,
     +  .490416E-01, .369053E-01, .275046E-01, .202714E-01,
     +  .147381E-01, .105869E-01, .746378E-02, .516142E-02,
     +  .349119E-02, .230009E-02, .146956E-02, .904115E-03,
     +  .532628E-03, .295755E-03, .153421E-03, .725244E-04,
     +  .303080E-04, .106349E-04, .291166E-05, .565014E-06,
     +  .716435E-07, .000000E+00, .192192E+08, .145605E+08,
     +  .108433E+08, .806763E+07, .599839E+07, .445561E+07,
     +  .330720E+07, .245230E+07, .181695E+07, .134476E+07,
     +  .994437E+06, .734539E+06, .542070E+06, .399550E+06,
     +  .294212E+06, .216369E+06, .158955E+06, .116619E+06,
     +  .854646E+05, .625441E+05, .457180E+05, .333695E+05,
     +  .243279E+05, .177095E+05, .128764E+05, .934676E+04 /
        DATA (UPDI(I),I=7125,7176) /
     +  .677860E+04, .488738E+04, .353686E+04, .255681E+04,
     +  .184711E+04, .133360E+04, .962648E+03, .695553E+03,
     +  .502513E+03, .363456E+03, .263375E+03, .191295E+03,
     +  .139380E+03, .101902E+03, .748472E+02, .552232E+02,
     +  .409545E+02, .305343E+02, .228928E+02, .172554E+02,
     +  .130923E+02, .996660E+01, .763744E+01, .586957E+01,
     +  .453351E+01, .351424E+01, .273244E+01, .213006E+01,
     +  .166371E+01, .130141E+01, .101886E+01, .797966E+00,
     +  .624804E+00, .488889E+00, .382022E+00, .297996E+00,
     +  .231782E+00, .179935E+00, .138930E+00, .106794E+00,
     +  .816508E-01, .620504E-01, .468206E-01, .350479E-01,
     +  .259934E-01, .190815E-01, .138437E-01, .989996E-02,
     +  .699006E-02, .483884E-02, .328213E-02, .217483E-02 /
        DATA (UPDI(I),I=7177,7228) /
     +  .140163E-02, .874514E-03, .524329E-03, .300315E-03,
     +  .161625E-03, .809747E-04, .368032E-04, .147077E-04,
     +  .490617E-05, .127128E-05, .234696E-06, .291826E-07,
     +  .000000E+00, .260859E+08, .196664E+08, .145614E+08,
     +  .107711E+08, .796118E+07, .587833E+07, .433680E+07,
     +  .319607E+07, .235328E+07, .173075E+07, .127168E+07,
     +  .933236E+06, .684160E+06, .500912E+06, .366341E+06,
     +  .267554E+06, .195177E+06, .142171E+06, .103432E+06,
     +  .751333E+05, .545060E+05, .394786E+05, .285562E+05,
     +  .206217E+05, .148716E+05, .107051E+05, .769788E+04,
     +  .550149E+04, .394610E+04, .282697E+04, .202349E+04,
     +  .144726E+04, .103469E+04, .740348E+03, .529566E+03,
     +  .379165E+03, .271945E+03, .195474E+03, .140931E+03 /
        DATA (UPDI(I),I=7229,7280) /
     +  .101946E+03, .740817E+02, .540734E+02, .396704E+02,
     +  .292587E+02, .217002E+02, .161804E+02, .121452E+02,
     +  .914624E+01, .693411E+01, .527209E+01, .402873E+01,
     +  .308981E+01, .237695E+01, .183329E+01, .141670E+01,
     +  .109639E+01, .849165E+00, .657910E+00, .509557E+00,
     +  .394352E+00, .304743E+00, .235053E+00, .180743E+00,
     +  .138694E+00, .105821E+00, .803605E-01, .606804E-01,
     +  .455277E-01, .339036E-01, .250357E-01, .183079E-01,
     +  .132441E-01, .946305E-02, .665950E-02, .462406E-02,
     +  .314462E-02, .209318E-02, .135945E-02, .857500E-03,
     +  .522748E-03, .305612E-03, .170279E-03, .888753E-04,
     +  .430322E-04, .188190E-04, .719864E-05, .228547E-05,
     +  .560941E-06, .982629E-07, .117621E-07, .000000E+00 /
        DATA (UPDI(I),I=7281,7332) /
     +  .345308E+08, .259116E+08, .190793E+08, .140340E+08,
     +  .103141E+08, .757198E+07, .555378E+07, .406885E+07,
     +  .297799E+07, .217695E+07, .158969E+07, .115934E+07,
     +  .844535E+06, .614362E+06, .446376E+06, .323847E+06,
     +  .234646E+06, .169751E+06, .122634E+06, .884496E+05,
     +  .637020E+05, .457998E+05, .328796E+05, .235623E+05,
     +  .168594E+05, .120391E+05, .858679E+04, .608520E+04,
     +  .432783E+04, .307372E+04, .218072E+04, .154573E+04,
     +  .109495E+04, .776185E+03, .549923E+03, .389943E+03,
     +  .276934E+03, .197086E+03, .140667E+03, .100725E+03,
     +  .724471E+02, .523381E+02, .380018E+02, .277392E+02,
     +  .203609E+02, .150252E+02, .111625E+02, .831953E+01,
     +  .624296E+01, .469797E+01, .355343E+01, .269757E+01 /
        DATA (UPDI(I),I=7333,7384) /
     +  .205412E+01, .156820E+01, .119951E+01, .918835E+00,
     +  .704354E+00, .540093E+00, .413965E+00, .317017E+00,
     +  .242388E+00, .184955E+00, .140671E+00, .106753E+00,
     +  .805296E-01, .604472E-01, .451036E-01, .334292E-01,
     +  .245826E-01, .179181E-01, .129276E-01, .922183E-02,
     +  .649362E-02, .450024E-02, .307518E-02, .205607E-02,
     +  .134419E-02, .856410E-03, .529197E-03, .315524E-03,
     +  .180062E-03, .977111E-04, .495251E-04, .232089E-04,
     +  .978310E-05, .358909E-05, .108684E-05, .252942E-06,
     +  .418331E-07, .468433E-08, .000000E+00, .447017E+08,
     +  .333935E+08, .244572E+08, .178928E+08, .130780E+08,
     +  .954801E+07, .696381E+07, .507292E+07, .369147E+07,
     +  .268277E+07, .194744E+07, .141173E+07, .102211E+07 /
        DATA (UPDI(I),I=7385,7436) /
     +  .738940E+06, .533511E+06, .384594E+06, .276850E+06,
     +  .198961E+06, .142770E+06, .102270E+06, .731426E+05,
     +  .522148E+05, .372142E+05, .264723E+05, .187993E+05,
     +  .133213E+05, .942710E+04, .662673E+04, .467464E+04,
     +  .329253E+04, .231618E+04, .162761E+04, .114280E+04,
     +  .802870E+03, .563639E+03, .395969E+03, .278567E+03,
     +  .196361E+03, .138799E+03, .984213E+02, .700974E+02,
     +  .501426E+02, .360481E+02, .260529E+02, .189341E+02,
     +  .138342E+02, .101767E+02, .750992E+01, .558035E+01,
     +  .415818E+01, .311450E+01, .234138E+01, .176557E+01,
     +  .133483E+01, .101110E+01, .766972E+00, .582200E+00,
     +  .442046E+00, .335470E+00, .254347E+00, .192516E+00,
     +  .145405E+00, .109447E+00, .821901E-01, .613362E-01 /
        DATA (UPDI(I),I=7437,7488) /
     +  .455367E-01, .335979E-01, .246157E-01, .178878E-01,
     +  .128794E-01, .917518E-02, .645937E-02, .448645E-02,
     +  .306477E-02, .206310E-02, .135762E-02, .872740E-03,
     +  .546159E-03, .331069E-03, .193352E-03, .107892E-03,
     +  .571298E-04, .281808E-04, .128141E-04, .522160E-05,
     +  .184344E-05, .534329E-06, .118160E-06, .183292E-07,
     +  .183902E-08, .000000E+00, .567199E+08, .421888E+08,
     +  .307393E+08, .223715E+08, .162651E+08, .118114E+08,
     +  .856785E+07, .620717E+07, .449169E+07, .324593E+07,
     +  .234275E+07, .168845E+07, .121525E+07, .873327E+06,
     +  .626707E+06, .448993E+06, .321180E+06, .229350E+06,
     +  .163510E+06, .116354E+06, .826568E+05, .586039E+05,
     +  .414768E+05, .292952E+05, .206533E+05, .145268E+05 /
        DATA (UPDI(I),I=7489,7540) /
     +  .102028E+05, .711620E+04, .498061E+04, .348005E+04,
     +  .242815E+04, .169213E+04, .117804E+04, .820515E+03,
     +  .570971E+03, .397547E+03, .277148E+03, .193573E+03,
     +  .135561E+03, .952277E+02, .671854E+02, .476058E+02,
     +  .339001E+02, .242683E+02, .174700E+02, .126435E+02,
     +  .921339E+01, .673490E+01, .495774E+01, .365967E+01,
     +  .271564E+01, .202263E+01, .151112E+01, .113192E+01,
     +  .849491E+00, .638437E+00, .480148E+00, .361177E+00,
     +  .271541E+00, .203943E+00, .152902E+00, .114380E+00,
     +  .852587E-01, .633974E-01, .468371E-01, .344168E-01,
     +  .251283E-01, .182134E-01, .130900E-01, .931832E-02,
     +  .656073E-02, .456284E-02, .312933E-02, .210955E-02,
     +  .140066E-02, .908367E-03, .575028E-03, .354024E-03 /
        DATA (UPDI(I),I=7541,7592) /
     +  .210897E-03, .120887E-03, .661070E-04, .342439E-04,
     +  .164883E-04, .729995E-05, .288740E-05, .985610E-06,
     +  .274858E-06, .579686E-07, .838443E-08, .708646E-09,
     +  .000000E+00, .706738E+08, .523494E+08, .379518E+08,
     +  .274811E+08, .198776E+08, .143600E+08, .103619E+08,
     +  .746703E+07, .537422E+07, .386251E+07, .277231E+07,
     +  .198683E+07, .142185E+07, .101590E+07, .724731E+06,
     +  .516126E+06, .366963E+06, .260430E+06, .184504E+06,
     +  .130457E+06, .920742E+05, .648500E+05, .455886E+05,
     +  .319788E+05, .223875E+05, .156340E+05, .109008E+05,
     +  .754588E+04, .524144E+04, .363411E+04, .251572E+04,
     +  .173914E+04, .120088E+04, .829496E+03, .572341E+03,
     +  .395083E+03, .273032E+03, .189019E+03, .131194E+03 /
        DATA (UPDI(I),I=7593,7644) /
     +  .913331E+02, .638562E+02, .448368E+02, .316382E+02,
     +  .224434E+02, .160098E+02, .114818E+02, .829175E+01,
     +  .600661E+01, .438229E+01, .320608E+01, .235806E+01,
     +  .174086E+01, .128923E+01, .957281E+00, .712170E+00,
     +  .530575E+00, .395555E+00, .294949E+00, .219808E+00,
     +  .163636E+00, .121596E+00, .901486E-01, .665895E-01,
     +  .490640E-01, .359108E-01, .261383E-01, .189001E-01,
     +  .135642E-01, .965030E-02, .679856E-02, .473559E-02,
     +  .325718E-02, .220836E-02, .147098E-02, .964647E-03,
     +  .617475E-03, .385553E-03, .233952E-03, .137240E-03,
     +  .773849E-04, .415794E-04, .211328E-04, .996660E-05,
     +  .431365E-05, .166404E-05, .552244E-06, .149080E-06,
     +  .301532E-07, .405800E-08, .265796E-09, .000000E+00 /
        DATA (UPDI(I),I=7645,7696) /
     +  .476990E+05, .505925E+05, .394410E+05, .307516E+05,
     +  .239804E+05, .187035E+05, .145909E+05, .113854E+05,
     +  .888663E+04, .693861E+04, .541972E+04, .423524E+04,
     +  .331137E+04, .259061E+04, .202818E+04, .158917E+04,
     +  .124637E+04, .978610E+03, .769360E+03, .605754E+03,
     +  .477759E+03, .377557E+03, .299051E+03, .237489E+03,
     +  .189165E+03, .151189E+03, .121305E+03, .974597E+02,
     +  .789397E+02, .642918E+02, .526825E+02, .434607E+02,
     +  .361168E+02, .302679E+02, .255703E+02, .217960E+02,
     +  .187518E+02, .162855E+02, .142771E+02, .126312E+02,
     +  .112749E+02, .101465E+02, .919940E+01, .839627E+01,
     +  .770742E+01, .710939E+01, .658546E+01, .611595E+01,
     +  .569512E+01, .530875E+01, .495372E+01, .462312E+01 /
        DATA (UPDI(I),I=7697,7748) /
     +  .431275E+01, .401943E+01, .374075E+01, .347495E+01,
     +  .322076E+01, .297733E+01, .274410E+01, .252074E+01,
     +  .230710E+01, .210313E+01, .190886E+01, .172522E+01,
     +  .155036E+01, .138558E+01, .123094E+01, .108652E+01,
     +  .952344E+00, .828387E+00, .714579E+00, .610792E+00,
     +  .516784E+00, .432241E+00, .357584E+00, .291343E+00,
     +  .233651E+00, .184023E+00, .141935E+00, .106822E+00,
     +  .780895E-01, .551478E-01, .372249E-01, .238214E-01,
     +  .141877E-01, .766205E-02, .359148E-02, .134608E-02,
     +  .335536E-03, .308585E-04, .000000E+00, .446321E+05,
     +  .655025E+05, .510643E+05, .398044E+05, .310329E+05,
     +  .241925E+05, .188640E+05, .147087E+05, .114718E+05,
     +  .894752E+04, .698115E+04, .544760E+04, .425289E+04 /
        DATA (UPDI(I),I=7749,7800) /
     +  .332104E+04, .259496E+04, .202851E+04, .158703E+04,
     +  .124248E+04, .973834E+03, .764056E+03, .600389E+03,
     +  .472485E+03, .372598E+03, .294446E+03, .233327E+03,
     +  .185436E+03, .147914E+03, .118077E+03, .950123E+02,
     +  .768379E+02, .625112E+02, .511766E+02, .422010E+02,
     +  .350817E+02, .293962E+02, .248457E+02, .211949E+02,
     +  .182465E+02, .158568E+02, .139029E+02, .122993E+02,
     +  .109674E+02, .985344E+01, .891036E+01, .810447E+01,
     +  .740680E+01, .679851E+01, .625597E+01, .577302E+01,
     +  .533266E+01, .493168E+01, .456167E+01, .421806E+01,
     +  .389683E+01, .359527E+01, .331103E+01, .304259E+01,
     +  .278866E+01, .254842E+01, .232119E+01, .210653E+01,
     +  .190413E+01, .171365E+01, .153574E+01, .136834E+01 /
        DATA (UPDI(I),I=7801,7852) /
     +  .121242E+01, .106780E+01, .934299E+00, .811679E+00,
     +  .699698E+00, .598047E+00, .506415E+00, .424396E+00,
     +  .351473E+00, .287844E+00, .232065E+00, .184082E+00,
     +  .143334E+00, .109230E+00, .811835E-01, .585524E-01,
     +  .407627E-01, .270857E-01, .170391E-01, .995569E-02,
     +  .526160E-02, .240471E-02, .874907E-03, .211667E-03,
     +  .196945E-04, .000000E+00, .111541E+06, .876559E+05,
     +  .681163E+05, .529224E+05, .411205E+05, .319451E+05,
     +  .248195E+05, .192808E+05, .149803E+05, .116381E+05,
     +  .904349E+04, .702732E+04, .546234E+04, .424637E+04,
     +  .330259E+04, .256928E+04, .200011E+04, .155782E+04,
     +  .121446E+04, .947575E+03, .740326E+03, .579149E+03,
     +  .453901E+03, .356411E+03, .280569E+03, .221467E+03 /
        DATA (UPDI(I),I=7853,7904) /
     +  .175425E+03, .139020E+03, .111043E+03, .891274E+02,
     +  .719565E+02, .584535E+02, .478256E+02, .394463E+02,
     +  .327944E+02, .275005E+02, .232771E+02, .198837E+02,
     +  .171469E+02, .149193E+02, .130990E+02, .115930E+02,
     +  .103383E+02, .928000E+01, .837917E+01, .760245E+01,
     +  .692828E+01, .632994E+01, .580031E+01, .532030E+01,
     +  .488620E+01, .448854E+01, .412215E+01, .378243E+01,
     +  .346624E+01, .317084E+01, .289435E+01, .263518E+01,
     +  .239222E+01, .216452E+01, .195138E+01, .175225E+01,
     +  .156651E+01, .139459E+01, .123424E+01, .108623E+01,
     +  .950143E+00, .825623E+00, .712254E+00, .609631E+00,
     +  .517289E+00, .434791E+00, .361620E+00, .297142E+00,
     +  .241402E+00, .192999E+00, .151762E+00, .117096E+00 /
        DATA (UPDI(I),I=7905,7956) /
     +  .883817E-01, .650267E-01, .463933E-01, .319262E-01,
     +  .209460E-01, .129948E-01, .747501E-02, .388118E-02,
     +  .173735E-02, .616783E-03, .145536E-03, .136772E-04,
     +  .000000E+00, .153167E+06, .119862E+06, .926964E+05,
     +  .716697E+05, .554119E+05, .428320E+05, .331084E+05,
     +  .255870E+05, .197752E+05, .152811E+05, .118096E+05,
     +  .912596E+04, .705356E+04, .545185E+04, .421526E+04,
     +  .325969E+04, .252206E+04, .195209E+04, .151212E+04,
     +  .117213E+04, .909657E+03, .706761E+03, .550049E+03,
     +  .428826E+03, .335113E+03, .262554E+03, .206399E+03,
     +  .162290E+03, .128617E+03, .102417E+03, .820278E+02,
     +  .661023E+02, .536512E+02, .438998E+02, .362090E+02,
     +  .301270E+02, .253043E+02, .214518E+02, .183618E+02 /
        DATA (UPDI(I),I=7957,8008) /
     +  .158597E+02, .138249E+02, .121491E+02, .107590E+02,
     +  .959134E+01, .860163E+01, .775200E+01, .701788E+01,
     +  .636954E+01, .579868E+01, .528429E+01, .482196E+01,
     +  .440125E+01, .401634E+01, .366208E+01, .333485E+01,
     +  .303153E+01, .274989E+01, .248803E+01, .224455E+01,
     +  .201823E+01, .180813E+01, .161345E+01, .143333E+01,
     +  .126798E+01, .111501E+01, .974961E+00, .847237E+00,
     +  .731325E+00, .626653E+00, .532682E+00, .448820E+00,
     +  .374528E+00, .309202E+00, .252126E+00, .203220E+00,
     +  .161135E+00, .125615E+00, .960458E-01, .718005E-01,
     +  .522876E-01, .368915E-01, .250851E-01, .162408E-01,
     +  .992887E-02, .561686E-02, .286074E-02, .125139E-02,
     +  .431990E-03, .989425E-04, .941019E-05, .000000E+00 /
        DATA (UPDI(I),I=8009,8060) /
     +  .210693E+06, .164102E+06, .126224E+06, .970605E+05,
     +  .746290E+05, .573649E+05, .440917E+05, .338807E+05,
     +  .260337E+05, .199995E+05, .153644E+05, .118015E+05,
     +  .906586E+04, .696385E+04, .535045E+04, .411114E+04,
     +  .316019E+04, .242987E+04, .186958E+04, .143931E+04,
     +  .110924E+04, .855720E+03, .661170E+03, .511672E+03,
     +  .396863E+03, .308570E+03, .240708E+03, .187768E+03,
     +  .147634E+03, .116626E+03, .926618E+02, .740758E+02,
     +  .596443E+02, .484202E+02, .396267E+02, .327186E+02,
     +  .272750E+02, .229530E+02, .195060E+02, .167301E+02,
     +  .144839E+02, .126430E+02, .111227E+02, .985136E+01,
     +  .877838E+01, .786138E+01, .707259E+01, .637934E+01,
     +  .577201E+01, .522777E+01, .474142E+01, .430160E+01 /
        DATA (UPDI(I),I=8061,8112) /
     +  .390179E+01, .353631E+01, .320107E+01, .289256E+01,
     +  .260819E+01, .234578E+01, .210360E+01, .188021E+01,
     +  .167441E+01, .148517E+01, .131140E+01, .115310E+01,
     +  .100776E+01, .875711E+00, .756207E+00, .648589E+00,
     +  .552156E+00, .466254E+00, .390193E+00, .323350E+00,
     +  .265055E+00, .214533E+00, .171608E+00, .134990E+00,
     +  .104360E+00, .790983E-01, .585858E-01, .422452E-01,
     +  .294901E-01, .198235E-01, .126724E-01, .763926E-02,
     +  .425326E-02, .212680E-02, .910209E-03, .306066E-03,
     +  .682147E-04, .656182E-05, .000000E+00, .187532E+06,
     +  .222797E+06, .170430E+06, .130327E+06, .996464E+05,
     +  .761617E+05, .582043E+05, .444664E+05, .339676E+05,
     +  .259401E+05, .198086E+05, .151229E+05, .115459E+05 /
        DATA (UPDI(I),I=8113,8164) /
     +  .881358E+04, .672882E+04, .513710E+04, .392312E+04,
     +  .299656E+04, .229010E+04, .175103E+04, .134009E+04,
     +  .102652E+04, .787439E+03, .604943E+03, .465723E+03,
     +  .359383E+03, .278209E+03, .215323E+03, .167980E+03,
     +  .131659E+03, .103784E+03, .823167E+02, .657627E+02,
     +  .529772E+02, .430269E+02, .352623E+02, .291819E+02,
     +  .243840E+02, .205792E+02, .175323E+02, .150791E+02,
     +  .130786E+02, .114337E+02, .100646E+02, .891394E+01,
     +  .793491E+01, .709646E+01, .636303E+01, .572360E+01,
     +  .515361E+01, .464702E+01, .419158E+01, .378006E+01,
     +  .340626E+01, .306562E+01, .275426E+01, .246922E+01,
     +  .220803E+01, .196868E+01, .174947E+01, .154896E+01,
     +  .136593E+01, .119906E+01, .104813E+01, .910556E+00 /
        DATA (UPDI(I),I=8165,8216) /
     +  .786479E+00, .675007E+00, .575359E+00, .486727E+00,
     +  .408362E+00, .339497E+00, .279443E+00, .227478E+00,
     +  .182797E+00, .145142E+00, .113289E+00, .868743E-01,
     +  .652861E-01, .479212E-01, .342244E-01, .236446E-01,
     +  .157175E-01, .992428E-02, .590154E-02, .323538E-02,
     +  .158932E-02, .666037E-03, .218460E-03, .474875E-04,
     +  .461739E-05, .000000E+00, .400324E+06, .308710E+06,
     +  .234749E+06, .178440E+06, .135606E+06, .103014E+06,
     +  .782375E+05, .593979E+05, .450859E+05, .342106E+05,
     +  .259544E+05, .196848E+05, .149284E+05, .113188E+05,
     +  .858212E+04, .650650E+04, .493375E+04, .374150E+04,
     +  .283854E+04, .215430E+04, .163627E+04, .124380E+04,
     +  .946660E+03, .721502E+03, .550973E+03, .421687E+03 /
        DATA (UPDI(I),I=8217,8268) /
     +  .323733E+03, .248426E+03, .192160E+03, .149330E+03,
     +  .116707E+03, .917792E+02, .727007E+02, .580789E+02,
     +  .467823E+02, .380323E+02, .312273E+02, .258947E+02,
     +  .216923E+02, .183479E+02, .156702E+02, .134986E+02,
     +  .117221E+02, .102508E+02, .902006E+01, .797804E+01,
     +  .708992E+01, .631701E+01, .564669E+01, .505253E+01,
     +  .452752E+01, .405846E+01, .363733E+01, .325738E+01,
     +  .291351E+01, .260143E+01, .231779E+01, .205980E+01,
     +  .182515E+01, .161186E+01, .141824E+01, .124285E+01,
     +  .108415E+01, .941707E+00, .812872E+00, .697569E+00,
     +  .594785E+00, .503620E+00, .423169E+00, .352602E+00,
     +  .291087E+00, .237879E+00, .192222E+00, .153292E+00,
     +  .120766E+00, .934951E-01, .710881E-01, .529489E-01 /
        DATA (UPDI(I),I=8269,8320) /
     +  .385024E-01, .272254E-01, .186099E-01, .122304E-01,
     +  .762674E-02, .447378E-02, .241558E-02, .116637E-02,
     +  .479238E-03, .153726E-03, .327344E-04, .321256E-05,
     +  .000000E+00, .548743E+06, .421069E+06, .318351E+06,
     +  .240588E+06, .181765E+06, .137262E+06, .103623E+06,
     +  .781944E+05, .589889E+05, .444821E+05, .335345E+05,
     +  .252719E+05, .190415E+05, .143429E+05, .108027E+05,
     +  .813479E+04, .612615E+04, .461346E+04, .347528E+04,
     +  .261862E+04, .197439E+04, .148967E+04, .112521E+04,
     +  .850998E+03, .644783E+03, .489571E+03, .372829E+03,
     +  .283746E+03, .217681E+03, .167771E+03, .130036E+03,
     +  .101422E+03, .796830E+02, .631465E+02, .504619E+02,
     +  .407073E+02, .331722E+02, .273070E+02, .227132E+02 /
        DATA (UPDI(I),I=8321,8372) /
     +  .190794E+02, .161859E+02, .138518E+02, .119516E+02,
     +  .103857E+02, .908173E+01, .798296E+01, .705083E+01,
     +  .624365E+01, .554712E+01, .493311E+01, .439358E+01,
     +  .391443E+01, .348688E+01, .310364E+01, .275906E+01,
     +  .244849E+01, .216818E+01, .191503E+01, .168643E+01,
     +  .148016E+01, .129428E+01, .112715E+01, .977038E+00,
     +  .843307E+00, .723260E+00, .616635E+00, .522312E+00,
     +  .439295E+00, .366604E+00, .303343E+00, .248638E+00,
     +  .201705E+00, .161768E+00, .127999E+00, .100032E+00,
     +  .767916E-01, .578744E-01, .427086E-01, .307526E-01,
     +  .215188E-01, .145441E-01, .944275E-02, .580997E-02,
     +  .335792E-02, .178302E-02, .844597E-03, .339358E-03,
     +  .106083E-03, .220418E-04, .218749E-05, .000000E+00 /
        DATA (UPDI(I),I=8373,8424) /
     +  .739825E+06, .565012E+06, .424829E+06, .319274E+06,
     +  .239855E+06, .180100E+06, .135181E+06, .101414E+06,
     +  .760537E+05, .570078E+05, .427172E+05, .319946E+05,
     +  .239568E+05, .179314E+05, .134189E+05, .100393E+05,
     +  .751042E+04, .561799E+04, .420312E+04, .314509E+04,
     +  .235461E+04, .176381E+04, .132256E+04, .992842E+03,
     +  .746587E+03, .562529E+03, .425071E+03, .320938E+03,
     +  .244268E+03, .186770E+03, .143613E+03, .111126E+03,
     +  .866222E+02, .681173E+02, .540213E+02, .432568E+02,
     +  .349960E+02, .286075E+02, .236335E+02, .197220E+02,
     +  .166237E+02, .141374E+02, .121227E+02, .104703E+02,
     +  .910045E+01, .795142E+01, .698108E+01, .614482E+01,
     +  .542676E+01, .479711E+01, .424684E+01, .376100E+01 /
        DATA (UPDI(I),I=8425,8476) /
     +  .333005E+01, .294620E+01, .260328E+01, .229626E+01,
     +  .202103E+01, .177419E+01, .155284E+01, .135454E+01,
     +  .117712E+01, .101875E+01, .877533E+00, .752647E+00,
     +  .641367E+00, .543265E+00, .457135E+00, .381904E+00,
     +  .316537E+00, .260092E+00, .211666E+00, .170455E+00,
     +  .135677E+00, .106516E+00, .825722E-01, .628537E-01,
     +  .469521E-01, .343269E-01, .244745E-01, .169464E-01,
     +  .113246E-01, .726299E-02, .440890E-02, .251040E-02,
     +  .131075E-02, .609027E-03, .239277E-03, .728955E-04,
     +  .147847E-04, .148394E-05, .000000E+00, .981623E+06,
     +  .746290E+06, .558163E+06, .417240E+06, .311759E+06,
     +  .232810E+06, .173777E+06, .129639E+06, .966688E+05,
     +  .720438E+05, .536693E+05, .399602E+05, .297418E+05 /
        DATA (UPDI(I),I=8477,8528) /
     +  .221262E+05, .164558E+05, .122342E+05, .909415E+04,
     +  .675868E+04, .502327E+04, .373368E+04, .277625E+04,
     +  .206528E+04, .153772E+04, .114611E+04, .855585E+03,
     +  .639899E+03, .479927E+03, .359586E+03, .271604E+03,
     +  .206090E+03, .157259E+03, .120763E+03, .934262E+02,
     +  .729261E+02, .574155E+02, .456501E+02, .366783E+02,
     +  .297831E+02, .244455E+02, .202713E+02, .169818E+02,
     +  .143550E+02, .122362E+02, .105061E+02, .907813E+01,
     +  .788558E+01, .688295E+01, .602286E+01, .528788E+01,
     +  .464672E+01, .408938E+01, .360007E+01, .316858E+01,
     +  .278660E+01, .244749E+01, .214586E+01, .187725E+01,
     +  .163798E+01, .142489E+01, .123532E+01, .106690E+01,
     +  .917637E+00, .785483E+00, .669453E+00, .566817E+00 /
        DATA (UPDI(I),I=8529,8580) /
     +  .477002E+00, .398734E+00, .330882E+00, .272375E+00,
     +  .222244E+00, .179572E+00, .143549E+00, .113398E+00,
     +  .883274E-01, .679196E-01, .512624E-01, .379541E-01,
     +  .274898E-01, .194064E-01, .132957E-01, .878434E-02,
     +  .556490E-02, .333262E-02, .186934E-02, .959695E-03,
     +  .437391E-03, .168051E-03, .499149E-04, .989190E-05,
     +  .100397E-05, .000000E+00, .128273E+07, .970985E+06,
     +  .722516E+06, .537321E+06, .399392E+06, .296681E+06,
     +  .220271E+06, .163436E+06, .121204E+06, .898283E+05,
     +  .665417E+05, .492623E+05, .364533E+05, .269601E+05,
     +  .199315E+05, .147286E+05, .108811E+05, .803629E+04,
     +  .593494E+04, .438286E+04, .323759E+04, .239241E+04,
     +  .176921E+04, .130957E+04, .970766E+03, .720882E+03 /
        DATA (UPDI(I),I=8581,8632) /
     +  .536781E+03, .399226E+03, .299344E+03, .225476E+03,
     +  .170793E+03, .130204E+03, .100005E+03, .775113E+02,
     +  .606030E+02, .478600E+02, .382020E+02, .308234E+02,
     +  .251432E+02, .207246E+02, .172594E+02, .145053E+02,
     +  .122934E+02, .104952E+02, .901703E+01, .778784E+01,
     +  .675886E+01, .588016E+01, .513280E+01, .448413E+01,
     +  .392321E+01, .343349E+01, .300412E+01, .262628E+01,
     +  .229294E+01, .199832E+01, .173766E+01, .150702E+01,
     +  .130300E+01, .112274E+01, .963713E+00, .823750E+00,
     +  .700701E+00, .593433E+00, .499231E+00, .417396E+00,
     +  .346607E+00, .285696E+00, .233570E+00, .189248E+00,
     +  .151817E+00, .120468E+00, .944451E-01, .729854E-01,
     +  .556674E-01, .416578E-01, .305685E-01, .219331E-01 /
        DATA (UPDI(I),I=8633,8684) /
     +  .153301E-01, .103919E-01, .678762E-02, .424712E-02,
     +  .250905E-02, .138635E-02, .699789E-03, .312837E-03,
     +  .117557E-03, .340580E-04, .660152E-05, .677406E-06,
     +  .000000E+00, .165209E+07, .124537E+07, .922130E+06,
     +  .682364E+06, .504652E+06, .372965E+06, .275480E+06,
     +  .203334E+06, .149995E+06, .110571E+06, .814626E+05,
     +  .599766E+05, .441338E+05, .324555E+05, .238562E+05,
     +  .175259E+05, .128708E+05, .944851E+04, .693514E+04,
     +  .508960E+04, .373585E+04, .274283E+04, .201509E+04,
     +  .148166E+04, .109093E+04, .804565E+03, .594949E+03,
     +  .439359E+03, .327126E+03, .244673E+03, .184035E+03,
     +  .139324E+03, .106274E+03, .818166E+02, .635471E+02,
     +  .498634E+02, .395529E+02, .317206E+02, .257228E+02 /
        DATA (UPDI(I),I=8685,8736) /
     +  .210807E+02, .174569E+02, .145896E+02, .122964E+02,
     +  .104397E+02, .891968E+01, .766079E+01, .661137E+01,
     +  .571915E+01, .496383E+01, .431148E+01, .375029E+01,
     +  .326301E+01, .283820E+01, .246659E+01, .214073E+01,
     +  .185454E+01, .160296E+01, .138181E+01, .118750E+01,
     +  .101697E+01, .867563E+00, .736973E+00, .622960E+00,
     +  .524269E+00, .438217E+00, .364000E+00, .300271E+00,
     +  .245839E+00, .199607E+00, .160596E+00, .127906E+00,
     +  .100746E+00, .783829E-01, .600942E-01, .454619E-01,
     +  .337302E-01, .245299E-01, .174347E-01, .120645E-01,
     +  .809123E-02, .522445E-02, .322864E-02, .188144E-02,
     +  .102398E-02, .508176E-03, .222834E-03, .819089E-04,
     +  .231563E-04, .439428E-05, .455803E-06, .000000E+00 /
        DATA (UPDI(I),I=8737,8788) /
     +  .209880E+07, .157575E+07, .116120E+07, .855140E+06,
     +  .629351E+06, .462834E+06, .340154E+06, .249803E+06,
     +  .183331E+06, .134445E+06, .985305E+05, .721564E+05,
     +  .528093E+05, .386225E+05, .282312E+05, .206228E+05,
     +  .150582E+05, .109898E+05, .801868E+04, .584939E+04,
     +  .426728E+04, .311353E+04, .227299E+04, .166057E+04,
     +  .121472E+04, .889947E+03, .653707E+03, .479469E+03,
     +  .354586E+03, .263427E+03, .196811E+03, .148006E+03,
     +  .112157E+03, .857924E+02, .662170E+02, .516417E+02,
     +  .407209E+02, .324697E+02, .261827E+02, .213399E+02,
     +  .175760E+02, .146104E+02, .122479E+02, .103427E+02,
     +  .878889E+01, .750716E+01, .644308E+01, .554232E+01,
     +  .478325E+01, .413086E+01, .357250E+01, .309030E+01 /
        DATA (UPDI(I),I=8789,8840) /
     +  .267227E+01, .230873E+01, .199187E+01, .171531E+01,
     +  .147374E+01, .126277E+01, .107862E+01, .918098E+00,
     +  .778403E+00, .657139E+00, .551996E+00, .461616E+00,
     +  .383370E+00, .316368E+00, .259251E+00, .210825E+00,
     +  .170002E+00, .135815E+00, .107390E+00, .839601E-01,
     +  .648249E-01, .493054E-01, .369952E-01, .272129E-01,
     +  .196125E-01, .138078E-01, .945906E-02, .627604E-02,
     +  .400580E-02, .244479E-02, .140522E-02, .753276E-03,
     +  .367528E-03, .158080E-03, .568474E-04, .156894E-04,
     +  .291756E-05, .305854E-06, .000000E+00, .263182E+07,
     +  .196826E+07, .144374E+07, .105825E+07, .775154E+06,
     +  .567337E+06, .414939E+06, .303232E+06, .221437E+06,
     +  .161574E+06, .117809E+06, .858292E+05, .624868E+05 /
        DATA (UPDI(I),I=8841,8892) /
     +  .454575E+05, .330479E+05, .240093E+05, .174335E+05,
     +  .126516E+05, .917824E+04, .665628E+04, .482719E+04,
     +  .350091E+04, .254020E+04, .184431E+04, .134067E+04,
     +  .975974E+03, .712305E+03, .519035E+03, .381367E+03,
     +  .281496E+03, .208960E+03, .156147E+03, .117586E+03,
     +  .893973E+02, .685881E+02, .531815E+02, .416992E+02,
     +  .330682E+02, .265230E+02, .215039E+02, .176191E+02,
     +  .145705E+02, .121509E+02, .102071E+02, .862764E+01,
     +  .732978E+01, .625667E+01, .535211E+01, .459329E+01,
     +  .394428E+01, .339161E+01, .291690E+01, .250763E+01,
     +  .215379E+01, .184722E+01, .158130E+01, .135048E+01,
     +  .115019E+01, .976511E+00, .826114E+00, .696112E+00,
     +  .584026E+00, .487505E+00, .405110E+00, .334278E+00 /
        DATA (UPDI(I),I=8893,8944) /
     +  .274056E+00, .223089E+00, .180194E+00, .144300E+00,
     +  .114470E+00, .898582E-01, .697311E-01, .534267E-01,
     +  .403124E-01, .299993E-01, .218768E-01, .156245E-01,
     +  .108956E-01, .738891E-02, .484985E-02, .305974E-02,
     +  .184411E-02, .104543E-02, .551938E-03, .264744E-03,
     +  .111697E-03, .393035E-04, .105944E-04, .193229E-05,
     +  .204687E-06, .000000E+00, .477313E+05, .504825E+05,
     +  .393419E+05, .306623E+05, .239000E+05, .186312E+05,
     +  .145258E+05, .113269E+05, .883409E+04, .689143E+04,
     +  .537739E+04, .419728E+04, .327736E+04, .256017E+04,
     +  .200096E+04, .156485E+04, .122467E+04, .959266E+03,
     +  .752139E+03, .590443E+03, .464164E+03, .365503E+03,
     +  .288379E+03, .228053E+03, .180834E+03, .143842E+03 /
        DATA (UPDI(I),I=8945,8996) /
     +  .114834E+03, .917740E+02, .739361E+02, .598866E+02,
     +  .487992E+02, .400287E+02, .330715E+02, .275490E+02,
     +  .231240E+02, .195724E+02, .167053E+02, .143752E+02,
     +  .124665E+02, .108882E+02, .957221E+01, .846125E+01,
     +  .751344E+01, .669586E+01, .598315E+01, .535591E+01,
     +  .480122E+01, .430234E+01, .385665E+01, .345194E+01,
     +  .308702E+01, .275617E+01, .245600E+01, .218367E+01,
     +  .193677E+01, .171319E+01, .151106E+01, .132869E+01,
     +  .116451E+01, .101708E+01, .885037E+00, .767106E+00,
     +  .662085E+00, .569253E+00, .486599E+00, .413743E+00,
     +  .349766E+00, .293816E+00, .245106E+00, .202910E+00,
     +  .166558E+00, .135433E+00, .108954E+00, .865833E-01,
     +  .680211E-01, .525483E-01, .398984E-01, .296934E-01 /
        DATA (UPDI(I),I=8997,9048) /
     +  .215885E-01, .152696E-01, .104507E-01, .687776E-02,
     +  .429848E-02, .252758E-02, .136873E-02, .662328E-03,
     +  .272301E-03, .865249E-04, .171815E-04, .108055E-05,
     +  .000000E+00, .446682E+05, .653775E+05, .509518E+05,
     +  .397031E+05, .309418E+05, .241107E+05, .187905E+05,
     +  .146426E+05, .114125E+05, .889437E+04, .693350E+04,
     +  .540493E+04, .421470E+04, .328689E+04, .256445E+04,
     +  .200128E+04, .156274E+04, .122085E+04, .954579E+03,
     +  .746942E+03, .585191E+03, .459006E+03, .360654E+03,
     +  .283874E+03, .223977E+03, .177173E+03, .140613E+03,
     +  .111638E+03, .893203E+02, .718000E+02, .580424E+02,
     +  .471999E+02, .386454E+02, .318824E+02, .264955E+02,
     +  .221908E+02, .187382E+02, .159459E+02, .136748E+02 /
        DATA (UPDI(I),I=9049,9100) /
     +  .118079E+02, .102640E+02, .897014E+01, .787696E+01,
     +  .694242E+01, .613687E+01, .543544E+01, .482272E+01,
     +  .427806E+01, .379773E+01, .336677E+01, .298312E+01,
     +  .263941E+01, .233135E+01, .205508E+01, .180746E+01,
     +  .158567E+01, .138729E+01, .121014E+01, .105228E+01,
     +  .911907E+00, .787385E+00, .677236E+00, .580016E+00,
     +  .494872E+00, .419730E+00, .354092E+00, .296961E+00,
     +  .247450E+00, .204732E+00, .168067E+00, .136768E+00,
     +  .110226E+00, .878699E-01, .691645E-01, .538050E-01,
     +  .411381E-01, .308961E-01, .227309E-01, .163247E-01,
     +  .113964E-01, .769192E-02, .499639E-02, .307706E-02,
     +  .178035E-02, .946586E-03, .448711E-03, .180080E-03,
     +  .556752E-04, .107788E-04, .690135E-06, .000000E+00 /
        DATA (UPDI(I),I=9101,9152) /
     +  .111388E+06, .875180E+05, .679923E+05, .528109E+05,
     +  .410203E+05, .318551E+05, .247387E+05, .192083E+05,
     +  .149153E+05, .115798E+05, .899129E+04, .698061E+04,
     +  .542057E+04, .420904E+04, .326926E+04, .253955E+04,
     +  .197361E+04, .153421E+04, .119346E+04, .928909E+03,
     +  .723748E+03, .564441E+03, .440860E+03, .344858E+03,
     +  .270339E+03, .212411E+03, .167407E+03, .131932E+03,
     +  .104758E+03, .835460E+02, .669865E+02, .540126E+02,
     +  .438379E+02, .358429E+02, .295145E+02, .244891E+02,
     +  .204845E+02, .172667E+02, .146675E+02, .125457E+02,
     +  .108040E+02, .935546E+01, .814147E+01, .711236E+01,
     +  .623316E+01, .547455E+01, .481810E+01, .424006E+01,
     +  .373521E+01, .328654E+01, .289088E+01, .253970E+01 /
        DATA (UPDI(I),I=9153,9204) /
     +  .222780E+01, .195055E+01, .170420E+01, .148539E+01,
     +  .129127E+01, .111930E+01, .967231E+00, .833037E+00,
     +  .714878E+00, .611130E+00, .520197E+00, .441129E+00,
     +  .371834E+00, .311730E+00, .259781E+00, .215082E+00,
     +  .176788E+00, .144159E+00, .116508E+00, .932371E-01,
     +  .737897E-01, .576435E-01, .444943E-01, .337419E-01,
     +  .251243E-01, .183182E-01, .130299E-01, .900447E-02,
     +  .601671E-02, .386450E-02, .235064E-02, .134178E-02,
     +  .702649E-03, .327429E-03, .128812E-03, .389251E-04,
     +  .737574E-05, .479597E-06, .000000E+00, .152999E+06,
     +  .119711E+06, .925607E+05, .715478E+05, .553024E+05,
     +  .427337E+05, .330202E+05, .255079E+05, .197044E+05,
     +  .152177E+05, .117528E+05, .907518E+04, .700817E+04 /
        DATA (UPDI(I),I=9205,9256) /
     +  .541131E+04, .417908E+04, .322743E+04, .249332E+04,
     +  .192650E+04, .148936E+04, .115190E+04, .891684E+03,
     +  .690811E+03, .535899E+03, .416281E+03, .323992E+03,
     +  .252695E+03, .197657E+03, .154545E+03, .121734E+03,
     +  .962887E+02, .765549E+02, .611972E+02, .492332E+02,
     +  .398963E+02, .325559E+02, .267671E+02, .221860E+02,
     +  .185308E+02, .155991E+02, .132234E+02, .112876E+02,
     +  .968996E+01, .836146E+01, .724441E+01, .629799E+01,
     +  .548831E+01, .479369E+01, .418732E+01, .366236E+01,
     +  .319984E+01, .279546E+01, .243955E+01, .212605E+01,
     +  .184963E+01, .160594E+01, .139117E+01, .120204E+01,
     +  .103573E+01, .889719E+00, .761777E+00, .649901E+00,
     +  .552347E+00, .467405E+00, .394043E+00, .330171E+00 /
        DATA (UPDI(I),I=9257,9308) /
     +  .275142E+00, .227895E+00, .187517E+00, .153160E+00,
     +  .124088E+00, .996237E-01, .791836E-01, .622304E-01,
     +  .482600E-01, .369724E-01, .278176E-01, .205427E-01,
     +  .148485E-01, .104657E-01, .716304E-02, .473321E-02,
     +  .300408E-02, .180328E-02, .101446E-02, .522537E-03,
     +  .238943E-03, .919245E-04, .270606E-04, .499968E-05,
     +  .330242E-06, .000000E+00, .210510E+06, .163937E+06,
     +  .126076E+06, .969279E+05, .745101E+05, .572581E+05,
     +  .439960E+05, .337949E+05, .259569E+05, .199308E+05,
     +  .153029E+05, .117466E+05, .901677E+04, .692004E+04,
     +  .531137E+04, .407630E+04, .312916E+04, .240225E+04,
     +  .184501E+04, .141748E+04, .108984E+04, .838499E+03,
     +  .645885E+03, .498111E+03, .384830E+03, .297891E+03 /
        DATA (UPDI(I),I=9309,9360) /
     +  .231225E+03, .179353E+03, .140141E+03, .109941E+03,
     +  .866787E+02, .687016E+02, .547934E+02, .440162E+02,
     +  .356022E+02, .290142E+02, .238371E+02, .197361E+02,
     +  .164703E+02, .138430E+02, .117178E+02, .997708E+01,
     +  .854042E+01, .734185E+01, .633429E+01, .547919E+01,
     +  .475146E+01, .412133E+01, .358019E+01, .310724E+01,
     +  .269699E+01, .233874E+01, .202559E+01, .175156E+01,
     +  .151173E+01, .130188E+01, .111838E+01, .958131E+00,
     +  .818386E+00, .696751E+00, .591085E+00, .499545E+00,
     +  .420340E+00, .352367E+00, .293561E+00, .243219E+00,
     +  .200272E+00, .163806E+00, .132980E+00, .107069E+00,
     +  .854113E-01, .674421E-01, .526456E-01, .405402E-01,
     +  .308335E-01, .230227E-01, .168667E-01, .120899E-01 /
        DATA (UPDI(I),I=9361,9412) /
     +  .844638E-02, .572730E-02, .374697E-02, .235249E-02,
     +  .139549E-02, .774994E-03, .393523E-03, .177124E-03,
     +  .669499E-04, .193505E-04, .353265E-05, .239217E-06,
     +  .000000E+00, .187582E+06, .222619E+06, .170270E+06,
     +  .130184E+06, .995176E+05, .760462E+05, .581009E+05,
     +  .443738E+05, .338847E+05, .258659E+05, .197423E+05,
     +  .150637E+05, .114930E+05, .876641E+04, .668675E+04,
     +  .509962E+04, .388974E+04, .296685E+04, .226368E+04,
     +  .172754E+04, .131922E+04, .100799E+04, .770985E+03,
     +  .590336E+03, .452752E+03, .347859E+03, .267964E+03,
     +  .206220E+03, .159862E+03, .124405E+03, .972806E+02,
     +  .764661E+02, .604741E+02, .481701E+02, .386312E+02,
     +  .312156E+02, .254289E+02, .208778E+02, .172789E+02 /
        DATA (UPDI(I),I=9413,9464) /
     +  .144045E+02, .120960E+02, .102188E+02, .868075E+01,
     +  .740714E+01, .634442E+01, .544932E+01, .469327E+01,
     +  .404359E+01, .348985E+01, .300954E+01, .259598E+01,
     +  .223749E+01, .192637E+01, .165604E+01, .142108E+01,
     +  .121689E+01, .103952E+01, .885639E+00, .752310E+00,
     +  .636995E+00, .537446E+00, .451741E+00, .378033E+00,
     +  .315164E+00, .261104E+00, .215110E+00, .176116E+00,
     +  .143211E+00, .115573E+00, .924892E-01, .733219E-01,
     +  .575262E-01, .446101E-01, .341172E-01, .257653E-01,
     +  .190960E-01, .138815E-01, .986924E-02, .683586E-02,
     +  .459328E-02, .297593E-02, .184875E-02, .108406E-02,
     +  .594512E-03, .297703E-03, .131943E-03, .490229E-04,
     +  .139168E-04, .250861E-05, .173782E-06, .000000E+00 /
        DATA (UPDI(I),I=9465,9516) /
     +  .400107E+06, .308516E+06, .234574E+06, .178283E+06,
     +  .135466E+06, .102888E+06, .781251E+05, .592973E+05,
     +  .449959E+05, .341301E+05, .258825E+05, .196206E+05,
     +  .148711E+05, .112677E+05, .853658E+04, .646594E+04,
     +  .489763E+04, .370937E+04, .280996E+04, .212890E+04,
     +  .161370E+04, .122375E+04, .928850E+03, .705682E+03,
     +  .536914E+03, .409186E+03, .312608E+03, .238529E+03,
     +  .183324E+03, .141423E+03, .109609E+03, .853865E+02,
     +  .669167E+02, .528184E+02, .419715E+02, .336059E+02,
     +  .271276E+02, .220730E+02, .181063E+02, .149633E+02,
     +  .124583E+02, .104375E+02, .879447E+01, .744487E+01,
     +  .632754E+01, .539402E+01, .461175E+01, .394492E+01,
     +  .338105E+01, .289584E+01, .248130E+01, .212475E+01 /
        DATA (UPDI(I),I=9517,9568) /
     +  .181763E+01, .155278E+01, .132425E+01, .112708E+01,
     +  .957009E+00, .810491E+00, .684405E+00, .576092E+00,
     +  .483211E+00, .403776E+00, .335903E+00, .278388E+00,
     +  .229255E+00, .187728E+00, .152753E+00, .123438E+00,
     +  .989815E-01, .786961E-01, .619705E-01, .482864E-01,
     +  .371804E-01, .282258E-01, .211544E-01, .155537E-01,
     +  .112122E-01, .790154E-02, .542222E-02, .360756E-02,
     +  .231250E-02, .142000E-02, .822048E-03, .444475E-03,
     +  .219035E-03, .953068E-04, .346518E-04, .958774E-05,
     +  .168260E-05, .117500E-06, .000000E+00, .548507E+06,
     +  .420858E+06, .318161E+06, .240418E+06, .181612E+06,
     +  .137125E+06, .103501E+06, .780852E+05, .588913E+05,
     +  .443949E+05, .334567E+05, .252024E+05, .189795E+05 /
        DATA (UPDI(I),I=9569,9620) /
     +  .142876E+05, .107534E+05, .809096E+04, .608713E+04,
     +  .457875E+04, .344442E+04, .259118E+04, .195001E+04,
     +  .146800E+04, .110596E+04, .833893E+03, .629574E+03,
     +  .476037E+03, .360775E+03, .273013E+03, .208090E+03,
     +  .159181E+03, .122320E+03, .944672E+02, .733877E+02,
     +  .574210E+02, .452283E+02, .358973E+02, .287253E+02,
     +  .231723E+02, .188468E+02, .154457E+02, .127549E+02,
     +  .106008E+02, .886225E+01, .744509E+01, .628058E+01,
     +  .531505E+01, .451205E+01, .383276E+01, .326268E+01,
     +  .277582E+01, .236296E+01, .201049E+01, .170908E+01,
     +  .145101E+01, .122991E+01, .104047E+01, .878196E+00,
     +  .739337E+00, .620639E+00, .519349E+00, .433060E+00,
     +  .359744E+00, .297501E+00, .245097E+00, .200623E+00 /
        DATA (UPDI(I),I=9621,9672) /
     +  .163279E+00, .132035E+00, .106023E+00, .844694E-01,
     +  .667153E-01, .521802E-01, .403749E-01, .308657E-01,
     +  .232569E-01, .172960E-01, .126141E-01, .901618E-02,
     +  .629743E-02, .428092E-02, .281994E-02, .178835E-02,
     +  .108545E-02, .620441E-03, .330847E-03, .160555E-03,
     +  .686767E-04, .244992E-04, .664275E-05, .114739E-05,
     +  .819206E-07, .000000E+00, .739569E+06, .564783E+06,
     +  .424623E+06, .319089E+06, .239690E+06, .179952E+06,
     +  .135048E+06, .101295E+06, .759481E+05, .569135E+05,
     +  .426330E+05, .319195E+05, .238899E+05, .178718E+05,
     +  .133658E+05, .999196E+04, .746832E+04, .558055E+04,
     +  .416983E+04, .311550E+04, .232831E+04, .174044E+04,
     +  .130179E+04, .974376E+03, .730161E+03, .547904E+03 /
        DATA (UPDI(I),I=9673,9724) /
     +  .412039E+03, .309327E+03, .233886E+03, .177467E+03,
     +  .135252E+03, .103589E+03, .798007E+02, .619160E+02,
     +  .483583E+02, .380600E+02, .302021E+02, .241631E+02,
     +  .194928E+02, .158476E+02, .129841E+02, .107084E+02,
     +  .888472E+01, .740900E+01, .620503E+01, .521403E+01,
     +  .439578E+01, .370862E+01, .313608E+01, .265068E+01,
     +  .224199E+01, .189556E+01, .160139E+01, .135128E+01,
     +  .113846E+01, .957354E+00, .803251E+00, .672261E+00,
     +  .561022E+00, .466715E+00, .386895E+00, .319511E+00,
     +  .262667E+00, .215115E+00, .175019E+00, .141571E+00,
     +  .113771E+00, .907801E-01, .718583E-01, .563798E-01,
     +  .437974E-01, .336521E-01, .255413E-01, .191008E-01,
     +  .140954E-01, .101965E-01, .722633E-02, .500230E-02 /
        DATA (UPDI(I),I=9725,9776) /
     +  .336854E-02, .219683E-02, .137829E-02, .826871E-03,
     +  .466672E-03, .245428E-03, .117297E-03, .493315E-04,
     +  .172740E-04, .459384E-05, .782297E-06, .571396E-07,
     +  .000000E+00, .981344E+06, .746041E+06, .557939E+06,
     +  .417040E+06, .311580E+06, .232650E+06, .173634E+06,
     +  .129511E+06, .965547E+05, .719419E+05, .535784E+05,
     +  .398791E+05, .296696E+05, .220618E+05, .163985E+05,
     +  .121832E+05, .904879E+04, .671834E+04, .498741E+04,
     +  .370180E+04, .274792E+04, .204010E+04, .151534E+04,
     +  .112621E+04, .837875E+03, .624125E+03, .465866E+03,
     +  .347054E+03, .260396E+03, .196044E+03, .148230E+03,
     +  .112625E+03, .860646E+02, .662397E+02, .513178E+02,
     +  .400651E+02, .315393E+02, .250338E+02, .200379E+02 /
        DATA (UPDI(I),I=9777,9828) /
     +  .161658E+02, .131450E+02, .107608E+02, .886331E+01,
     +  .733848E+01, .610295E+01, .509302E+01, .426491E+01,
     +  .357431E+01, .300288E+01, .252181E+01, .211955E+01,
     +  .178093E+01, .149534E+01, .125417E+01, .105032E+01,
     +  .877995E+00, .732327E+00, .609313E+00, .505521E+00,
     +  .418091E+00, .344564E+00, .282886E+00, .231184E+00,
     +  .188208E+00, .152203E+00, .122362E+00, .977232E-01,
     +  .774814E-01, .609350E-01, .474926E-01, .366426E-01,
     +  .279576E-01, .210662E-01, .156358E-01, .114490E-01,
     +  .821468E-02, .577226E-02, .396002E-02, .264154E-02,
     +  .170550E-02, .105854E-02, .627686E-03, .349783E-03,
     +  .181428E-03, .854005E-04, .353190E-04, .121430E-04,
     +  .316885E-05, .532325E-06, .397604E-07, .000000E+00 /
        DATA (UPDI(I),I=9829,9880) /
     +  .128243E+07, .970715E+06, .722274E+06, .537104E+06,
     +  .399198E+06, .296508E+06, .220116E+06, .163298E+06,
     +  .121081E+06, .897183E+05, .664437E+05, .491749E+05,
     +  .363754E+05, .268908E+05, .198698E+05, .146737E+05,
     +  .108323E+05, .799287E+04, .589634E+04, .434855E+04,
     +  .320710E+04, .236531E+04, .174512E+04, .128814E+04,
     +  .951702E+03, .703899E+03, .521640E+03, .385730E+03,
     +  .287273E+03, .214659E+03, .161074E+03, .121448E+03,
     +  .920913E+02, .703323E+02, .540672E+02, .418870E+02,
     +  .327214E+02, .257759E+02, .204776E+02, .163990E+02,
     +  .132379E+02, .107596E+02, .880006E+01, .723583E+01,
     +  .597669E+01, .495428E+01, .412151E+01, .343166E+01,
     +  .286468E+01, .239056E+01, .199677E+01, .166749E+01 /
        DATA (UPDI(I),I=9881,9932) /
     +  .139162E+01, .116018E+01, .965840E+00, .802621E+00,
     +  .665537E+00, .550512E+00, .454077E+00, .373358E+00,
     +  .305904E+00, .249677E+00, .202838E+00, .164150E+00,
     +  .131945E+00, .105426E+00, .836730E-01, .659203E-01,
     +  .515065E-01, .398773E-01, .305571E-01, .231507E-01,
     +  .173180E-01, .127568E-01, .926823E-02, .659570E-02,
     +  .459507E-02, .312415E-02, .206427E-02, .131942E-02,
     +  .810102E-03, .474792E-03, .261242E-03, .133644E-03,
     +  .619626E-04, .252027E-04, .851013E-05, .218018E-05,
     +  .361448E-06, .275951E-07, .000000E+00, .165177E+07,
     +  .124508E+07, .921868E+06, .682129E+06, .504442E+06,
     +  .372778E+06, .275313E+06, .203185E+06, .149862E+06,
     +  .110453E+06, .813569E+05, .598824E+05, .440499E+05 /
        DATA (UPDI(I),I=9933,9984) /
     +  .323809E+05, .237898E+05, .174668E+05, .128183E+05,
     +  .940182E+04, .689364E+04, .505273E+04, .370308E+04,
     +  .271371E+04, .198920E+04, .145863E+04, .107044E+04,
     +  .786314E+03, .578679E+03, .424858E+03, .314159E+03,
     +  .233057E+03, .173604E+03, .129935E+03, .977983E+02,
     +  .741396E+02, .565720E+02, .435049E+02, .337365E+02,
     +  .263831E+02, .208099E+02, .165472E+02, .132644E+02,
     +  .107070E+02, .869756E+01, .710369E+01, .582877E+01,
     +  .480015E+01, .396767E+01, .328251E+01, .272302E+01,
     +  .225823E+01, .187469E+01, .155606E+01, .129084E+01,
     +  .106977E+01, .885321E+00, .731398E+00, .602941E+00,
     +  .495835E+00, .406602E+00, .332380E+00, .270743E+00,
     +  .219684E+00, .177416E+00, .142723E+00, .114027E+00 /
        DATA (UPDI(I),I=9985,10036) /
     +  .905494E-01, .714173E-01, .559066E-01, .433982E-01,
     +  .333757E-01, .254000E-01, .191079E-01, .141899E-01,
     +  .103734E-01, .747779E-02, .527794E-02, .364552E-02,
     +  .245626E-02, .160758E-02, .101718E-02, .617788E-03,
     +  .357871E-03, .194423E-03, .980998E-04, .448026E-04,
     +  .179247E-04, .594612E-05, .149606E-05, .244896E-06,
     +  .191022E-07, .000000E+00, .209845E+07, .157544E+07,
     +  .116091E+07, .854887E+06, .629125E+06, .462632E+06,
     +  .339974E+06, .249642E+06, .183188E+06, .134317E+06,
     +  .984167E+05, .720551E+05, .527191E+05, .385422E+05,
     +  .281597E+05, .205593E+05, .150018E+05, .109397E+05,
     +  .797411E+04, .580979E+04, .423209E+04, .308227E+04,
     +  .224520E+04, .163587E+04, .119273E+04, .870368E+03 /
        DATA (UPDI(I),I=10037,10088) /
     +  .636257E+03, .463923E+03, .340691E+03, .250988E+03,
     +  .185650E+03, .137972E+03, .103111E+03, .776144E+02,
     +  .588037E+02, .449024E+02, .345762E+02, .268522E+02,
     +  .210344E+02, .166122E+02, .132270E+02, .106059E+02,
     +  .855887E+01, .694500E+01, .566190E+01, .463302E+01,
     +  .380547E+01, .312862E+01, .257938E+01, .212600E+01,
     +  .175423E+01, .144736E+01, .119353E+01, .983291E+00,
     +  .808982E+00, .664433E+00, .544555E+00, .445223E+00,
     +  .362981E+00, .294998E+00, .238893E+00, .192705E+00,
     +  .154707E+00, .123712E+00, .982394E-01, .775317E-01,
     +  .607672E-01, .472657E-01, .364511E-01, .278454E-01,
     +  .210457E-01, .157202E-01, .115890E-01, .840766E-02,
     +  .601326E-02, .420936E-02, .288245E-02, .192460E-02 /
        DATA (UPDI(I),I=10089,10140) /
     +  .124764E-02, .781464E-03, .469489E-03, .268800E-03,
     +  .144191E-03, .717603E-04, .322856E-04, .127073E-04,
     +  .414235E-05, .102400E-05, .165580E-06, .131895E-07,
     +  .000000E+00, .263144E+07, .196792E+07, .144343E+07,
     +  .105798E+07, .774910E+06, .567119E+06, .414745E+06,
     +  .303059E+06, .221283E+06, .161436E+06, .117687E+06,
     +  .857202E+05, .623898E+05, .453712E+05, .329712E+05,
     +  .239411E+05, .173729E+05, .125978E+05, .913042E+04,
     +  .661381E+04, .478947E+04, .346739E+04, .251042E+04,
     +  .181784E+04, .131712E+04, .955008E+03, .693628E+03,
     +  .502405E+03, .366513E+03, .268210E+03, .197054E+03,
     +  .145457E+03, .107966E+03, .807180E+02, .607401E+02,
     +  .460680E+02, .352358E+02, .271827E+02, .211530E+02 /
        DATA (UPDI(I),I=10141,10192) /
     +  .165968E+02, .131293E+02, .104600E+02, .838737E+01,
     +  .676286E+01, .547883E+01, .445528E+01, .363695E+01,
     +  .297168E+01, .243512E+01, .199495E+01, .163625E+01,
     +  .134200E+01, .110012E+01, .901026E+00, .736976E+00,
     +  .601777E+00, .490346E+00, .398581E+00, .323073E+00,
     +  .261041E+00, .210162E+00, .168534E+00, .134499E+00,
     +  .106911E+00, .843814E-01, .661836E-01, .515471E-01,
     +  .398373E-01, .305212E-01, .231589E-01, .173829E-01,
     +  .128921E-01, .943452E-02, .679242E-02, .481983E-02,
     +  .334611E-02, .227157E-02, .150299E-02, .965036E-03,
     +  .598336E-03, .355571E-03, .201209E-03, .106573E-03,
     +  .523162E-04, .231892E-04, .898043E-05, .287753E-05,
     +  .699158E-06, .111727E-06, .908438E-08, .000000E+00 /
C-----------------------------------------------------------------------
C
      Dr = DrI
      Fl = FlI
      Al = AlI
      DO I=1,6
         Amass(I) = AmassI(I)
      ENDDO
      Iorder = Nint(Dr)
      Nfl = Nint(Fl)
      Alambda = Al
C
      NX = NxI
      NT = NTI
      NfMx = NfMxI
C
      QINI = QINII
      QMAX = QMAXI
      DO I=0,NT
         QL(I) = QLI(I)
      ENDDO
C
      XMIN = XMINI
      DO I=0,NX
         XV(I) = XVI(I)
      ENDDO
C
      Do 11 Iq = 0, NT
         QL(Iq) = Log (QL(Iq) /Al)
   11 Continue
C
C                  Since quark = anti-quark for nfl>2 at this stage, 
C                  we Read  out only the non-redundent data points
C     No of flavors = NfMx (sea) + 1 (gluon) + 2 (valence) 

      Nblk = (NX+1) * (NT+1)
      Npts =  Nblk  * (NfMx+3)
      DO I=1,Npts
         UPD(I) = UPDI(I)
      ENDDO
C
      Return
C                        ****************************
      End
