/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

#include <Xm/Xm.h>
#include <Xm/ScrolledW.h>
#include <X11/IntrinsicP.h>
#include "xec.h"

void *xec_GetUserData(Widget w)
{
	char	*p;
	ARG_DEF(1);

	SetArg(XmNuserData,&p);
	GetValues(w);

	return (void*)p;
}

/*-------------------------------------------------

	Attach a pointer to a widget

-------------------------------------------------*/

void xec_SetUserData(Widget w, void* p)
{
	ARG_DEF(1);

	SetArg(XmNuserData,p);
	SetValues(w);

}

/*-------------------------------------------------

	Sets a color

--------------------------------------------------*/


void xec_SetColor(Widget w, Pixel p, const char* which)
{
	ARG_DEF(1);

	SetArg(which,p);
	SetValues(w);

}

/*-------------------------------------------------

	Scroll a window to make a widget visible

--------------------------------------------------*/


void xec_ShowWidget(Widget w)
{
	ARG_DEF(5);

	Widget v_scroll,h_scroll;


	Position 	x_parent,y_parent;
	Position 	x_widget,y_widget;
	Dimension 	h_widget,w_widget;
	Position 	x_clip,y_clip;
	Dimension 	h_clip,w_clip;
	Position 	dv=0,dh=0;
	int min,max;
	int	v_val,v_size,v_inc,v_page;
	int	h_val,h_size,h_inc,h_page;
	Widget clip;
	Widget parent;
	Widget scroll_window;

	Position x,y;


	if(!XtIsManaged(w)) return;

	if(!(parent          = XtParent(w)))      return;
	if(!(clip   		 = XtParent(parent))) return;
	if(!(scroll_window   = XtParent(clip)))   return;

	if(!XmIsScrolledWindow(scroll_window)) return;

	SetArg(XmNhorizontalScrollBar, &h_scroll );
	SetArg(XmNverticalScrollBar, &v_scroll );
	GetValues(scroll_window);


	SetArg(XmNx,&x_parent);
	SetArg(XmNy,&y_parent);
	GetValues(parent);


	SetArg(XmNheight,&h_widget);
	SetArg(XmNwidth,&w_widget);
	GetValues(w);


	SetArg(XmNclipWindow,&clip);
	GetValues(scroll_window);

	SetArg(XmNheight,&h_clip);
	SetArg(XmNwidth,&w_clip);
	GetValues(clip);


	XtTranslateCoords(w,0,0,	&x_widget,&y_widget);
	XtTranslateCoords(clip,0,0,&x_clip,&y_clip);


	x = x_widget - x_clip;
	y = y_widget - y_clip;


	if( y < 0 || (Dimension) (y + h_widget) > h_clip)
	{
		dv = (y + h_widget / 2)  - h_clip / 2;

		SetArg(XmNminimum,&min);
		SetArg(XmNmaximum,&max);
		GetValues(v_scroll);

		XmScrollBarGetValues(v_scroll,&v_val,&v_size,&v_inc,&v_page);

		max -= v_size;

		if( dv + v_val > max ) dv = max - v_val;
		if( dv + v_val < min ) dv = min - v_val;


	}

	if( x < 0 || (Dimension) (x + w_widget) > w_clip)
	{
		dh = (x + w_widget / 2)  - w_clip / 2;

		SetArg(XmNminimum,&min);
		SetArg(XmNmaximum,&max);
		GetValues(h_scroll);

		XmScrollBarGetValues(h_scroll,&h_val,&h_size,&h_inc,&h_page);

		max -= h_size;

		if( dh + h_val > max ) dh = max - h_val;
		if( dh + h_val < min ) dh = min - h_val;

	}


	if(dv || dh)
	{
		Position x = x_parent-dh;
		Position y = y_parent-dv;

		SetArg(XmNx,x);
		SetArg(XmNy,y);
		SetValues(parent);

		/*
		XtMoveWidget(parent,x_parent-dh,y_parent-dv);
		*/

		if(dv) XmScrollBarSetValues(v_scroll,v_val+dv,v_size,v_inc,v_page,TRUE);
		if(dh) XmScrollBarSetValues(h_scroll,h_val+dh,h_size,h_inc,h_page,TRUE);


		/* force redraw */
		/*

		XtUnmanageChild(parent);
		XtManageChild(parent);
		*/
	}


}

void xec_Invert(Widget w)
{
	ARG_DEF(2);
	Pixel fg,bg;

	SetArg(XmNbackground,&bg);
	SetArg(XmNforeground,&fg);
	GetValues(w);

	SetArg(XmNbackground,fg);
	SetArg(XmNforeground,bg);
	SetValues(w);
}

void xec_ManageAll(Widget w)
{
	CompositeWidget c = (CompositeWidget)w;
	XtManageChildren(c->composite.children,
	    c->composite.num_children);
}
void xec_UnmanageAll(Widget w)
{
	CompositeWidget c = (CompositeWidget)w;
	XtUnmanageChildren(c->composite.children,
	    c->composite.num_children);
}

