/***************************** LICENSE START ***********************************

 Copyright 2012 ECMWF and INPE. This software is distributed under the terms
 of the Apache License version 2.0. In applying this license, ECMWF does not
 waive the privileges and immunities granted to it by virtue of its status as
 an Intergovernmental Organization or submit itself to any jurisdiction.

 ***************************** LICENSE END *************************************/

// File EditorDrawerFactory.h
// Baudouin Raoult - ECMWF Jul 99

#ifndef EditorDrawerFactory_H
#define EditorDrawerFactory_H

#include "inc_stl.h"
using std::string;


//UKMO/HP/aCC:
#ifdef hp
#include <InternalEditor.h>
#endif

class EditorDrawer;
class InternalEditor;

class EditorDrawerFactory {
public:

// -- Exceptions
	// None

// -- Contructors

	EditorDrawerFactory(int);

// -- Destructor

	virtual ~EditorDrawerFactory(); // Change to virtual if base class

// -- Convertors
	// None

// -- Operators
	// None

// -- Methods

	virtual EditorDrawer* make(InternalEditor*) = 0;

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods

	static map<string,EditorDrawer*> create(InternalEditor*);

protected:

// -- Members
	// None

// -- Methods
	
	// void print(ostream&) const; // Change to virtual if base class	

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

private:

// No copy allowed

	EditorDrawerFactory(const EditorDrawerFactory&);
	EditorDrawerFactory& operator=(const EditorDrawerFactory&);

// -- Members
	// None

// -- Methods
	// None

// -- Overridden methods
	// None

// -- Class members
	// None

// -- Class methods
	// None

// -- Friends

	//friend ostream& operator<<(ostream& s,const EditorDrawerFactory& p)
	//	{ p.print(s); return s; }

};

template<class T,class E>
class EditorDrawerMaker : public EditorDrawerFactory {
	EditorDrawer* make(InternalEditor* e) 
	{ 
		E* a = dynamic_cast<E*>(e);
		return a ? new T(*a) : 0;
	}
public:
	EditorDrawerMaker(int n) : EditorDrawerFactory(n) {}
};


#endif
